/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.extension.datatype.finder;

import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.extension.datatype.finder.DecompilerFieldAccess;
import ghidra.app.extension.datatype.finder.DecompilerReference;
import ghidra.app.extension.datatype.finder.DecompilerVariable;
import ghidra.app.extension.datatype.finder.DecompilerVariableType;
import ghidra.app.services.DataTypeReference;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighGlobal;
import ghidra.program.model.pcode.HighVariable;
import ghidra.util.StringUtilities;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.List;

public class VariableAccessDR
extends DecompilerReference {
    private List<DecompilerFieldAccess> fields = new ArrayList<DecompilerFieldAccess>();

    protected VariableAccessDR(ClangLine line) {
        super(line, null);
    }

    protected VariableAccessDR(ClangLine line, ClangFieldToken token) {
        super(line, (ClangToken)token);
    }

    void setVariable(ClangVariableToken token, List<DecompilerVariable> casts) {
        if (this.variable != null) {
            throw new AssertException("Decompiler variable is already set for this access");
        }
        this.variable = new DecompilerVariableType(token, casts);
    }

    void addField(ClangFieldToken token, List<DecompilerVariable> fieldCasts) {
        DecompilerFieldAccess field = new DecompilerFieldAccess(token, fieldCasts);
        this.fields.add(field);
    }

    @Override
    public void accumulateMatches(DataType dt, String fieldName, List<DataTypeReference> results) {
        if (this.fields.isEmpty()) {
            DecompilerVariable var = this.getMatch(dt, fieldName, this.variable, null);
            if (var != null) {
                DataTypeReference ref = this.createReference(var);
                results.add(ref);
            }
            return;
        }
        DecompilerVariable start = this.variable;
        for (DecompilerVariable decompilerVariable : this.fields) {
            DecompilerVariable next = decompilerVariable;
            DecompilerVariable var = this.getMatch(dt, fieldName, start, next);
            if (var != null) {
                DataTypeReference ref = this.createReference(var, next);
                results.add(ref);
            }
            start = next;
        }
        if (fieldName != null) {
            return;
        }
        DecompilerVariable var = this.getMatch(dt, null, start, null);
        if (var != null) {
            DataTypeReference dataTypeReference = this.createReference(var);
            results.add(dataTypeReference);
        }
    }

    private DecompilerVariable getMatch(DataType dt, String fieldName, DecompilerVariable var, DecompilerVariable potentialField) {
        boolean searchForField = fieldName != null;
        DecompilerVariable fieldVar = searchForField ? potentialField : null;
        DecompilerVariable match = this.getMatchingVarialbe(dt, var, fieldVar);
        if (match == null) {
            return null;
        }
        if (fieldName == null) {
            return match;
        }
        if (potentialField == null) {
            return null;
        }
        String name = potentialField.getName();
        if (fieldName.equals(name)) {
            return match;
        }
        return null;
    }

    private DecompilerVariable getMatchingVarialbe(DataType dt, DecompilerVariable var, DecompilerVariable potentialField) {
        List<DecompilerVariable> castVariables = var.getCasts();
        for (DecompilerVariable cast : castVariables) {
            if (!this.matchesType(cast, dt)) continue;
            return cast;
        }
        if (this.matchesType(var, dt)) {
            return var;
        }
        HighVariable highVariable = var.variable.getHighVariable();
        if (highVariable instanceof HighGlobal && this.matchesParentType(potentialField, dt)) {
            return potentialField;
        }
        return null;
    }

    private boolean matchesParentType(DecompilerVariable var, DataType dt) {
        if (var == null) {
            return false;
        }
        DataType varType = var.getParentDataType();
        boolean matches = VariableAccessDR.isEqual(varType, dt);
        return matches;
    }

    private boolean matchesType(DecompilerVariable var, DataType dt) {
        if (var == null) {
            return false;
        }
        DataType varType = var.getDataType();
        if (varType == null) {
            return false;
        }
        boolean matches = VariableAccessDR.isEqual(varType, dt);
        return matches;
    }

    protected DataTypeReference createReference(DecompilerVariable var) {
        DataType dataType = var.getDataType();
        String context = this.getContext(var);
        Function function = var.getFunction();
        Address address = this.getAddress(var);
        return new DataTypeReference(dataType, null, function, address, context);
    }

    private DataTypeReference createReference(DecompilerVariable var, DecompilerVariable field) {
        DataType dataType = var.getDataType();
        String context = this.getContext(var);
        Function function = var.getFunction();
        Address address = this.getAddress(var);
        return new DataTypeReference(dataType, field.getName(), function, address, context);
    }

    @Override
    protected String getContext(DecompilerVariable var) {
        DecompilerVariable field = this.findFieldFor(var);
        String context = super.getContext(field);
        return context;
    }

    private DecompilerVariable findFieldFor(DecompilerVariable var) {
        List<DecompilerVariable> allVars = this.getAllVariablesInOrder();
        int varIndex = allVars.indexOf(var);
        if (varIndex == -1) {
            throw new AssertException("Cannot find a field for variable " + var);
        }
        int fieldIndex = varIndex + 1;
        if (fieldIndex == allVars.size()) {
            fieldIndex = allVars.size() - 1;
        }
        DecompilerVariable field = allVars.get(fieldIndex);
        return field;
    }

    private List<DecompilerVariable> getAllVariablesInOrder() {
        ArrayList<DecompilerVariable> allVars = new ArrayList<DecompilerVariable>();
        this.getAllVariableTypes(this.variable, allVars);
        for (DecompilerVariable decompilerVariable : this.fields) {
            this.getAllVariableTypes(decompilerVariable, allVars);
        }
        return allVars;
    }

    private void getAllVariableTypes(DecompilerVariable var, List<DecompilerVariable> result) {
        List<DecompilerVariable> casts = var.getCasts();
        result.addAll(casts);
        result.add(var);
    }

    @Override
    public String toString() {
        String subFieldsString = this.fields.isEmpty() ? "" : "\tsub fields: " + StringUtilities.toStringWithIndent(this.fields) + ",\n";
        return "{\n\tline " + this.getContext() + ",\n\tfunction: " + this.getFunction() + "\n\tvariable: " + StringUtilities.toStringWithIndent((Object)this.variable) + ",\n\tdata type: " + this.getDataType() + ",\n" + subFieldsString + "}";
    }
}

