/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AbstractDemanglerAnalyzer;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.gnu.GnuDemangler;
import ghidra.app.util.demangler.gnu.GnuDemanglerNativeProcess;
import ghidra.app.util.demangler.gnu.GnuDemanglerOptions;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class GnuDemanglerAnalyzer
extends AbstractDemanglerAnalyzer {
    private static final String NAME = "Demangler GNU";
    private static final String DESCRIPTION = "After a function is created, this analyzer will attempt to demangle the name and apply datatypes to parameters.";
    private static final String OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS = "Demangle Only Known Mangled Symbols";
    private static final String OPTION_DESCRIPTION_USE_KNOWN_PATTERNS = "Only demangle symbols that follow known compiler mangling patterns. Leaving this option off may cause non-mangled symbols to get demangled.";
    private static final String OPTION_NAME_APPLY_SIGNATURE = "Apply Function Signatures";
    private static final String OPTION_DESCRIPTION_APPLY_SIGNATURE = "Apply any recovered function signature, in addition to the function name";
    static final String OPTION_NAME_USE_DEPRECATED_DEMANGLER = "Use Deprecated Demangler";
    private static final String OPTION_DESCRIPTION_DEPRECATED_DEMANGLER = "Signals to use the deprecated demangler when the modern demangler cannot demangle a given string";
    static final String OPTION_NAME_DEMANGLER_PARAMETERS = "Use External Demangler Options";
    private static final String OPTION_DESCRIPTION_DEMANGLER_PARAMETERS = "Signals to use pass the given parameters to the demangler program";
    private boolean doSignatureEnabled = true;
    private boolean demangleOnlyKnownPatterns = false;
    private boolean useDeprecatedDemangler = false;
    private String demanglerParameters = "";
    private GnuDemangler demangler = new GnuDemangler();

    public GnuDemanglerAnalyzer() {
        super(NAME, DESCRIPTION);
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        return this.demangler.canDemangle(program);
    }

    public void registerOptions(Options options, Program program) {
        HelpLocation help = new HelpLocation("AutoAnalysisPlugin", "Demangler_Analyzer");
        options.registerOption(OPTION_NAME_APPLY_SIGNATURE, (Object)this.doSignatureEnabled, help, OPTION_DESCRIPTION_APPLY_SIGNATURE);
        options.registerOption(OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS, (Object)this.demangleOnlyKnownPatterns, help, OPTION_DESCRIPTION_USE_KNOWN_PATTERNS);
        options.registerOption(OPTION_NAME_USE_DEPRECATED_DEMANGLER, (Object)this.useDeprecatedDemangler, help, OPTION_DESCRIPTION_DEPRECATED_DEMANGLER);
        options.registerOption(OPTION_NAME_DEMANGLER_PARAMETERS, (Object)this.demanglerParameters, help, OPTION_DESCRIPTION_DEMANGLER_PARAMETERS);
    }

    public void optionsChanged(Options options, Program program) {
        this.doSignatureEnabled = options.getBoolean(OPTION_NAME_APPLY_SIGNATURE, this.doSignatureEnabled);
        this.demangleOnlyKnownPatterns = options.getBoolean(OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS, this.demangleOnlyKnownPatterns);
        this.useDeprecatedDemangler = options.getBoolean(OPTION_NAME_USE_DEPRECATED_DEMANGLER, this.useDeprecatedDemangler);
        this.demanglerParameters = options.getString(OPTION_NAME_DEMANGLER_PARAMETERS, this.demanglerParameters);
    }

    protected DemanglerOptions getOptions() {
        GnuDemanglerOptions options = new GnuDemanglerOptions();
        options.setDoDisassembly(true);
        options.setApplySignature(this.doSignatureEnabled);
        options.setDemangleOnlyKnownPatterns(this.demangleOnlyKnownPatterns);
        options.setDemanglerApplicationArguments(this.demanglerParameters);
        return options;
    }

    protected boolean validateOptions(DemanglerOptions demanglerOtions, MessageLog log) {
        GnuDemanglerOptions options = (GnuDemanglerOptions)demanglerOtions;
        String applicationArguments = options.getDemanglerApplicationArguments();
        if (StringUtils.isBlank((CharSequence)applicationArguments)) {
            return true;
        }
        String demanglerName = options.getDemanglerName();
        try {
            GnuDemanglerNativeProcess.getDemanglerNativeProcess(demanglerName, applicationArguments);
            return true;
        }
        catch (IOException e) {
            log.appendMsg(this.getName(), "Invalid options for GNU dangler '" + demanglerName + "': " + applicationArguments);
            log.appendException((Throwable)e);
            if (this.useDeprecatedDemangler) {
                GnuDemanglerOptions deprecatedOptions = options.withDeprecatedDemangler();
                String deprecatedName = deprecatedOptions.getDemanglerName();
                try {
                    GnuDemanglerNativeProcess.getDemanglerNativeProcess(deprecatedName, applicationArguments);
                    return true;
                }
                catch (IOException e2) {
                    log.appendMsg(this.getName(), "Invalid options for GNU dangler '" + deprecatedName + "': " + applicationArguments);
                    log.appendException((Throwable)e2);
                }
            }
            return false;
        }
    }

    protected DemangledObject doDemangle(String mangled, DemanglerOptions demanglerOtions, MessageLog log) throws DemangledException {
        DemangledObject demangled;
        GnuDemanglerOptions options;
        block4: {
            options = (GnuDemanglerOptions)demanglerOtions;
            demangled = null;
            try {
                demangled = this.demangler.demangle(mangled, options);
            }
            catch (DemangledException e) {
                if (this.useDeprecatedDemangler) break block4;
                throw e;
            }
        }
        if (demangled != null) {
            return demangled;
        }
        if (this.useDeprecatedDemangler) {
            GnuDemanglerOptions newOptions = options.withDeprecatedDemangler();
            demangled = this.demangler.demangle(mangled, newOptions);
        }
        return demangled;
    }
}

