/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.gnu;

import ghidra.app.util.demangler.DemanglerOptions;

public class GnuDemanglerOptions
extends DemanglerOptions {
    public static final String GNU_DEMANGLER_V2_24 = "demangler_gnu_v2_24";
    public static final String GNU_DEMANGLER_V2_33_1 = "demangler_gnu_v2_33_1";
    public static final String GNU_DEMANGLER_DEFAULT = "demangler_gnu_v2_33_1";
    private String demanglerName = "demangler_gnu_v2_33_1";
    private String demanglerApplicationArguments;

    public GnuDemanglerOptions() {
    }

    public GnuDemanglerOptions(DemanglerOptions copy) {
        super(copy);
        if (copy instanceof GnuDemanglerOptions) {
            GnuDemanglerOptions gCopy = (GnuDemanglerOptions)copy;
            this.demanglerName = gCopy.demanglerName;
            this.demanglerApplicationArguments = gCopy.demanglerApplicationArguments;
        }
    }

    public String getDemanglerName() {
        return this.demanglerName;
    }

    public void setDemanglerName(String name) {
        this.demanglerName = name;
    }

    public String getDemanglerApplicationArguments() {
        return this.demanglerApplicationArguments;
    }

    public void setDemanglerApplicationArguments(String args) {
        this.demanglerApplicationArguments = args;
    }

    public GnuDemanglerOptions withDeprecatedDemangler() {
        GnuDemanglerOptions newOptions = new GnuDemanglerOptions(this);
        newOptions.setDemanglerName(GNU_DEMANGLER_V2_24);
        return newOptions;
    }

    public String toString() {
        return "{\n\tdoDisassembly: " + this.doDisassembly() + ",\n\tapplySignature: " + this.applySignature() + ",\n\tdemangleOnlyKnownPatterns: " + this.demangleOnlyKnownPatterns() + ",\n\tdemanglerName: " + this.demanglerName + ",\n\tdemanglerApplicationArguments: " + this.demanglerApplicationArguments + ",\n}";
    }
}

