/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.app.merge.MergeResolver;
import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.listing.AbstractListingMerger;
import ghidra.app.merge.listing.BookmarkMerger;
import ghidra.app.merge.listing.CodeUnitMerger;
import ghidra.app.merge.listing.CommentMerger;
import ghidra.app.merge.listing.ConflictInfoPanel;
import ghidra.app.merge.listing.EquateMerger;
import ghidra.app.merge.listing.ExternalFunctionMerger;
import ghidra.app.merge.listing.FunctionMerger;
import ghidra.app.merge.listing.FunctionTagListingMerger;
import ghidra.app.merge.listing.ListingMergeConstants;
import ghidra.app.merge.listing.ListingMerger;
import ghidra.app.merge.listing.ReferenceMerger;
import ghidra.app.merge.listing.SymbolMerger;
import ghidra.app.merge.listing.UserDefinedPropertyMerger;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramDiff;
import ghidra.program.util.ProgramMerge;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class ListingMergeManager
implements MergeResolver,
ListingMergeConstants {
    private static String[] LISTING_PHASE = new String[]{"Listing"};
    private static String[] CODE_UNITS_PHASE = new String[]{"Listing", "Bytes & Code Units"};
    private static String[] EXTERNALS_PHASE = new String[]{"Listing", "Externals"};
    private static String[] FUNCTIONS_PHASE = new String[]{"Listing", "Functions"};
    private static String[] SYMBOLS_PHASE = new String[]{"Listing", "Symbols"};
    private static String[] ADDRESS_BASED_PHASE = new String[]{"Listing", "Equates, User Defined Properties, References, Bookmarks & Comments"};
    private static final int RESULT = 0;
    private static final int LATEST = 1;
    private static final int MY = 2;
    private static final int ORIGINAL = 3;
    private int conflictOption = 0;
    ProgramMultiUserMergeManager mergeManager;
    private ListingMerger currentMerger;
    private ExternalFunctionMerger externalFunctionMerger;
    private CodeUnitMerger cuMerge;
    private EquateMerger equateMerger;
    private UserDefinedPropertyMerger userPropertyMerger;
    private FunctionMerger functionMerger;
    private ReferenceMerger referenceMerger;
    private CommentMerger commentMerger;
    private BookmarkMerger bookmarkMerger;
    private SymbolMerger symbolMerger;
    private FunctionTagListingMerger functionTagMerger;
    private ConflictInfoPanel conflictInfoPanel;
    private ListingMergePanel mergePanel;
    private TaskMonitor currentStatusMonitor;
    Program[] programs = new Program[4];
    ProgramDiff diffOriginalLatest;
    ProgramDiff diffOriginalMy;
    ProgramDiff diffResultLatest;
    ProgramDiff diffResultMy;
    ProgramDiff diffLatestMy;
    ProgramChangeSet latestChanges;
    ProgramChangeSet myChanges;
    AddressSetView latestSet;
    AddressSetView mySet;
    ProgramMerge mergeMy;
    ProgramMerge mergeLatest;
    ProgramMerge mergeOriginal;
    private int totalConflictsInPhase;
    private int conflictNum;
    private boolean showListingPanel = true;

    public ListingMergeManager(ProgramMultiUserMergeManager mergeManager, Program resultPgm, Program originalPgm, Program latestPgm, Program myPgm, ProgramChangeSet latestChanges, ProgramChangeSet myChanges) {
        this.mergeManager = mergeManager;
        this.programs[0] = resultPgm;
        this.programs[3] = originalPgm;
        this.programs[1] = latestPgm;
        this.programs[2] = myPgm;
        this.latestChanges = latestChanges;
        this.myChanges = myChanges;
    }

    public FunctionTagListingMerger getFunctionTagListingMerger() {
        return this.functionTagMerger;
    }

    public void setShowListingPanel(boolean showListingPanel) {
        this.showListingPanel = showListingPanel;
    }

    @Override
    public void apply() {
        if (this.mergeManager == null) {
            return;
        }
        if (this.currentMerger != null) {
            boolean resolvedAll = this.currentMerger.apply();
            if (resolvedAll) {
                this.conflictNum += this.currentMerger.getNumConflictsResolved();
                if (this.conflictNum <= this.totalConflictsInPhase) {
                    this.conflictInfoPanel.setConflictInfo(this.conflictNum, this.totalConflictsInPhase);
                }
                this.mergeManager.setApplyEnabled(false);
            } else {
                this.mergeManager.setStatusText("Please select an option to resolve each conflict.");
            }
        }
    }

    @Override
    public void cancel() {
        if (this.mergeManager != null) {
            this.mergeManager.setStatusText("User cancelled merge.");
        }
        if (this.currentMerger != null) {
            this.currentMerger.cancel();
        }
        this.conflictOption = -1;
        if (this.currentStatusMonitor != null) {
            this.currentStatusMonitor.cancel();
        }
    }

    @Override
    public String getDescription() {
        return "Merge Listing";
    }

    @Override
    public String getName() {
        return "Listing Merger";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException {
        this.mergeManager.setInProgress(LISTING_PHASE);
        this.initMergeInfo();
        if (this.mergeManager != null) {
            this.mergePanel = this.mergeManager.getListingMergePanel();
            if (this.conflictInfoPanel == null) {
                this.conflictInfoPanel = new ConflictInfoPanel();
            }
            this.mergePanel.setTopComponent(this.conflictInfoPanel);
        }
        try {
            this.currentStatusMonitor = monitor;
            int transactionID = this.programs[0].startTransaction("Merge Listing");
            boolean commit = false;
            try {
                this.mergeManager.showProgressIcon(true);
                monitor.setMessage("Initializing Listing Merge Managers...");
                this.initializeMergers();
                this.removeBottomComponent();
                this.mergeCodeUnits(monitor);
                this.mergeExternalFunctions(monitor);
                this.mergeFunctions(monitor);
                this.mergeSymbols(monitor);
                this.mergeAddressBasedProgramItems(monitor);
                this.currentMerger = null;
                commit = true;
            }
            catch (CancelledException e1) {
                this.mergeManager.setStatusText("User cancelled merge.");
                this.cancel();
            }
            finally {
                this.programs[0].endTransaction(transactionID, commit);
            }
        }
        finally {
            monitor = null;
        }
        this.mergeManager.setCompleted(LISTING_PHASE);
    }

    private void mergeExternalFunctions(TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        this.emptyListingViewForPrograms();
        this.displayInitialPhaseMessage(EXTERNALS_PHASE, "Merge of External Function and Label changes");
        this.conflictInfoPanel.setConflictType(this.externalFunctionMerger.getConflictType());
        this.currentMerger = this.externalFunctionMerger;
        int progressMin = 0;
        int progressMax = 100;
        this.externalFunctionMerger.autoMerge(progressMin, progressMax, monitor);
        progressMin = progressMax;
        this.mergeManager.showProgressIcon(false);
        this.externalFunctionMerger.mergeConflicts(this.conflictOption, this.conflictInfoPanel, monitor);
        this.mergeManager.showProgressIcon(true);
        this.removeBottomComponent();
        this.mergeManager.setCompleted(EXTERNALS_PHASE);
        this.setListingViewsToEntireProgram();
        this.externalFunctionMerger.dispose();
    }

    private void setListingViewsToEntireProgram() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListingMergeManager.this.mergePanel.setViewToProgram(0);
                ListingMergeManager.this.mergePanel.setViewToProgram(1);
                ListingMergeManager.this.mergePanel.setViewToProgram(2);
                ListingMergeManager.this.mergePanel.setViewToProgram(3);
            }
        });
    }

    private void emptyListingViewForPrograms() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListingMergeManager.this.mergePanel.emptyViewForProgram(0);
                ListingMergeManager.this.mergePanel.emptyViewForProgram(1);
                ListingMergeManager.this.mergePanel.emptyViewForProgram(2);
                ListingMergeManager.this.mergePanel.emptyViewForProgram(3);
            }
        });
    }

    private void mergeCodeUnits(TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        this.displayInitialPhaseMessage(CODE_UNITS_PHASE, "Merge of Byte & Code Unit changes");
        ListingMerger[] mergers = new AbstractListingMerger[]{this.cuMerge};
        this.autoMerge(mergers, monitor);
        this.currentMerger = this.cuMerge;
        this.mergeManager.showProgressIcon(false);
        this.cuMerge.mergeConflicts(this.mergePanel, this.conflictOption, monitor);
        this.mergeManager.showProgressIcon(true);
        this.removeBottomComponent();
        this.mergeManager.setCompleted(CODE_UNITS_PHASE);
    }

    private void mergeFunctions(TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        this.displayInitialPhaseMessage(FUNCTIONS_PHASE, "Merge of Function changes");
        ListingMerger[] mergers = new ListingMerger[]{this.functionMerger};
        this.autoMerge(mergers, monitor);
        this.mergeManager.showProgressIcon(false);
        this.mergeConflicts(mergers, monitor);
        this.functionMerger.mergeThunks(this.mergePanel, this.conflictOption, monitor);
        this.mergeManager.showProgressIcon(true);
        this.removeBottomComponent();
        this.mergeManager.setCompleted(FUNCTIONS_PHASE);
        this.functionMerger.dispose();
    }

    private void mergeSymbols(TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        this.displayInitialPhaseMessage(SYMBOLS_PHASE, "Merge of Symbol changes");
        this.conflictInfoPanel.setConflictType(this.symbolMerger.getConflictType());
        this.currentMerger = this.symbolMerger;
        this.symbolMerger.merge(0, 100, monitor);
        this.removeBottomComponent();
        this.mergeManager.setCompleted(SYMBOLS_PHASE);
    }

    private void mergeAddressBasedProgramItems(TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        this.displayInitialPhaseMessage(ADDRESS_BASED_PHASE, "Merge of Equate, User Defined Property, Reference,Function Tags, Bookmark & Comment changes");
        ListingMerger[] mergers = new AbstractListingMerger[]{this.equateMerger, this.userPropertyMerger, this.referenceMerger, this.bookmarkMerger, this.commentMerger, this.functionTagMerger};
        this.autoMerge(mergers, monitor);
        this.mergeManager.showProgressIcon(false);
        this.mergeConflicts(mergers, monitor);
        this.mergeManager.showProgressIcon(true);
        this.removeBottomComponent();
        this.mergeManager.setCompleted(ADDRESS_BASED_PHASE);
    }

    private void displayInitialPhaseMessage(String[] phaseIndicator, String phaseMessage) {
        this.mergeManager.setInProgress(phaseIndicator);
        this.mergeManager.showDefaultMergePanel(phaseMessage);
        this.mergeManager.updateProgress(0, phaseMessage);
    }

    private void removeBottomComponent() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (ListingMergeManager.this.mergePanel != null) {
                        ListingMergeManager.this.mergePanel.setBottomComponent(null);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    public void initMergeInfo() {
        Memory resultSet = this.programs[0].getMemory();
        this.latestSet = this.latestChanges.getAddressSet().intersect((AddressSetView)resultSet);
        this.mySet = this.myChanges.getAddressSet().intersect((AddressSetView)resultSet);
        this.currentMerger = null;
        try {
            AddressSet possibleLatestInConflict = this.latestSet.intersect(this.mySet);
            this.diffOriginalLatest = new ProgramDiff(this.programs[3], this.programs[1], (AddressSetView)possibleLatestInConflict);
            this.diffOriginalMy = new ProgramDiff(this.programs[3], this.programs[2], this.mySet);
            this.diffLatestMy = new ProgramDiff(this.programs[1], this.programs[2], (AddressSetView)possibleLatestInConflict);
            this.mergeMy = new ProgramMerge(this.programs[0], this.programs[2]);
            this.mergeLatest = new ProgramMerge(this.programs[0], this.programs[1]);
            this.mergeOriginal = new ProgramMerge(this.programs[0], this.programs[3]);
        }
        catch (ProgramConflictException e) {
            throw new AssertException((Throwable)((Object)e));
        }
        catch (IllegalArgumentException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private void initializeMergers() {
        this.externalFunctionMerger = new ExternalFunctionMerger(this, this.showListingPanel);
        this.cuMerge = new CodeUnitMerger(this);
        this.functionMerger = new FunctionMerger(this);
        this.symbolMerger = new SymbolMerger(this);
        this.equateMerger = new EquateMerger(this);
        this.userPropertyMerger = new UserDefinedPropertyMerger(this);
        this.referenceMerger = new ReferenceMerger(this);
        this.commentMerger = new CommentMerger(this);
        this.bookmarkMerger = new BookmarkMerger(this);
        this.functionTagMerger = new FunctionTagListingMerger(this);
    }

    private void autoMerge(ListingMerger[] mergers, TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        float progressRangeSize = 100 / mergers.length;
        int progressMin = 0;
        for (int mergerIndex = 0; mergerIndex < mergers.length; ++mergerIndex) {
            this.conflictInfoPanel.setConflictType(mergers[mergerIndex].getConflictType());
            this.currentMerger = mergers[mergerIndex];
            int progressMax = (int)progressRangeSize * (mergerIndex + 1);
            mergers[mergerIndex].autoMerge(progressMin, progressMax, monitor);
            progressMin = progressMax;
        }
    }

    void setConflictDecision(int decision) {
        if (decision < -1 || decision > 7) {
            throw new IllegalArgumentException();
        }
        this.conflictOption = decision;
    }

    private void mergeConflicts(ListingMerger[] mergers, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        int originalConflictOption = this.conflictOption;
        AddressSet listingConflictSet = this.getListingConflicts(mergers);
        long totalAddresses = listingConflictSet.getNumAddresses();
        AddressIterator iter = listingConflictSet.getAddresses(true);
        long addressNum = 1L;
        while (iter.hasNext()) {
            Address addr = iter.next();
            this.conflictNum = 1;
            this.totalConflictsInPhase = this.getTotalNumConflicts(mergers, addr);
            if (this.mergePanel != null) {
                this.conflictInfoPanel.setAddressInfo(addr, addressNum, totalAddresses);
                this.conflictInfoPanel.setConflictInfo(this.conflictNum, this.totalConflictsInPhase);
            }
            ListingMerger[] listingMergerArray = mergers;
            int n = listingMergerArray.length;
            for (int i = 0; i < n; ++i) {
                ListingMerger merger;
                this.currentMerger = merger = listingMergerArray[i];
                this.conflictInfoPanel.setConflictType(this.currentMerger.getConflictType());
                this.currentMerger.mergeConflicts(this.mergePanel, addr, originalConflictOption, monitor);
            }
            ++addressNum;
        }
    }

    private int getTotalNumConflicts(ListingMerger[] mergers, Address addr) {
        int totalConflicts = 0;
        for (ListingMerger merger : mergers) {
            totalConflicts += merger.getConflictCount(addr);
        }
        return totalConflicts;
    }

    private AddressSet getListingConflicts(ListingMerger[] mergers) {
        AddressSet conflicts = new AddressSet();
        for (ListingMerger merger : mergers) {
            conflicts.add(merger.getConflicts());
        }
        return conflicts;
    }

    public AddressSet getMergedCodeUnits() {
        if (this.mergeManager != null) {
            return (AddressSet)this.mergeManager.getResolveInformation("ResolvedCodeUnits");
        }
        return new AddressSet();
    }

    ListingMergePanel getListingMergePanel() {
        return this.mergePanel;
    }

    ConflictInfoPanel getConflictInfoPanel() {
        return this.conflictInfoPanel;
    }

    Namespace resolveNamespace(Program srcProgram, Namespace srcNamespace) throws DuplicateNameException, InvalidInputException {
        return this.symbolMerger.resolveNamespace(srcProgram, srcNamespace);
    }

    @Override
    public String[][] getPhases() {
        return new String[][]{LISTING_PHASE, CODE_UNITS_PHASE, EXTERNALS_PHASE, FUNCTIONS_PHASE, SYMBOLS_PHASE, ADDRESS_BASED_PHASE};
    }
}

