/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.help.Help;
import docking.help.HelpService;
import docking.options.editor.GenericOptionsComponent;
import docking.widgets.OptionDialog;
import docking.widgets.label.GLabel;
import docking.widgets.table.GBooleanCellRenderer;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.Analyzer;
import ghidra.framework.options.EditorState;
import ghidra.framework.options.EditorStateFactory;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import ghidra.util.ColorUtils;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections4.CollectionUtils;

class AnalysisPanel
extends JPanel
implements PropertyChangeListener {
    public static final String PROTOTYPE = " (Prototype)";
    private static final int COLUMN_ANALYZER_IS_ENABLED = 0;
    private static final int COLUMN_ANALYZER_NAME = 1;
    private List<Program> programs;
    private PropertyChangeListener propertyChangeListener;
    private Options analysisOptions;
    private JTable table;
    private AbstractTableModel model;
    private JTextArea descriptionComponent;
    private JPanel analyzerOptionsPanel;
    private List<EditorState> editorList = new ArrayList<EditorState>();
    private List<String> analyzerNames = new ArrayList<String>();
    private List<Boolean> analyzerEnablement = new ArrayList<Boolean>();
    private Set<String> prototypeAnalyzers = new HashSet<String>();
    private Map<String, Component> analyzerToOptionsPanelMap = new HashMap<String, Component>();
    private Map<String, List<Component>> analyzerManagedComponentsMap = new HashMap<String, List<Component>>();
    private EditorStateFactory editorStateFactory;
    private JPanel noOptionsPanel;

    AnalysisPanel(Program program, EditorStateFactory editorStateFactory, PropertyChangeListener propertyChangeListener) {
        this(List.of(program), editorStateFactory, propertyChangeListener);
    }

    AnalysisPanel(List<Program> programs, EditorStateFactory editorStateFactory, PropertyChangeListener propertyChangeListener) {
        if (CollectionUtils.isEmpty(programs)) {
            throw new AssertException("Must provide a program to run analysis");
        }
        this.programs = programs;
        this.propertyChangeListener = propertyChangeListener;
        this.editorStateFactory = editorStateFactory;
        this.analysisOptions = programs.get(0).getOptions("Analyzers");
        this.setName("Analysis Panel");
        this.build();
        this.load();
    }

    private void load() {
        this.editorList.clear();
        this.analyzerNames.clear();
        this.analyzerEnablement.clear();
        this.prototypeAnalyzers.clear();
        this.analyzerToOptionsPanelMap.clear();
        this.analyzerManagedComponentsMap.clear();
        int selectedAnalyzerRow = this.table.getSelectedRow();
        this.loadAnalyzers();
        this.loadAnalyzerOptionsPanels();
        this.model.fireTableDataChanged();
        if (selectedAnalyzerRow >= 0) {
            this.table.setRowSelectionInterval(selectedAnalyzerRow, selectedAnalyzerRow);
        }
    }

    private void loadAnalyzers() {
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager(this.programs.get(0));
        List propertyNames = this.analysisOptions.getOptionNames();
        Collections.sort(propertyNames, (o1, o2) -> o1.compareToIgnoreCase((String)o2));
        for (String analyzerName : propertyNames) {
            if (analyzerName.indexOf(46) != -1) continue;
            if (this.analysisOptions.getType(analyzerName) != OptionType.BOOLEAN_TYPE) {
                throw new AssertException("Analyzer enable property that is not boolean - " + analyzerName);
            }
            Analyzer analyzer = manager.getAnalyzer(analyzerName);
            if (analyzer == null) continue;
            this.analyzerNames.add(analyzerName);
            if (analyzer.isPrototype()) {
                this.prototypeAnalyzers.add(analyzerName);
            }
            this.analyzerEnablement.add(this.analysisOptions.getBoolean(analyzerName, false));
        }
    }

    private void build() {
        this.buildTableModel();
        this.buildTable();
        this.configureTableColumns();
        this.buildAnalyzerOptionsPanel();
        JSplitPane splitpane = new JSplitPane(1, this.buildLeftPanel(), this.buildRightPanel());
        splitpane.setBorder(null);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)splitpane, "Center");
    }

    private void buildAnalyzerOptionsPanel() {
        this.analyzerOptionsPanel = new JPanel(new BorderLayout());
        this.configureBorder(this.analyzerOptionsPanel, "Options");
    }

    private Component buildRightPanel() {
        JSplitPane splitpane = new JSplitPane(0, this.buildDescriptionPanel(), this.analyzerOptionsPanel);
        splitpane.setBorder(null);
        splitpane.setDividerLocation(0.5);
        return splitpane;
    }

    private JPanel buildDescriptionPanel() {
        this.descriptionComponent = this.buildTextArea();
        JScrollPane descriptionScrollPane = new JScrollPane(this.descriptionComponent);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        this.configureBorder(descriptionScrollPane, "Description");
        descriptionPanel.add((Component)descriptionScrollPane, "Center");
        return descriptionPanel;
    }

    private JTextArea buildTextArea() {
        JTextArea textarea = new JTextArea(3, 20);
        textarea.setEditable(false);
        textarea.setOpaque(false);
        textarea.setWrapStyleWord(true);
        textarea.setLineWrap(true);
        return textarea;
    }

    private JPanel buildLeftPanel() {
        JPanel buttonPanel = this.buildButtonPanel();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setPreferredSize(new Dimension(350, 300));
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        this.configureBorder(panel, "Analyzers");
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)buttonPanel, "South");
        return panel;
    }

    private JPanel buildButtonPanel() {
        JButton selectAllButton = new JButton("Select All");
        selectAllButton.addActionListener(e -> this.selectAll());
        JButton deselectAllButton = new JButton("Deselect All");
        deselectAllButton.addActionListener(e -> this.deselectAll());
        JButton restoreDefaultsButton = new JButton("Restore Defaults");
        restoreDefaultsButton.addActionListener(e -> this.restoreDefaults());
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(selectAllButton);
        buttonPanel.add(deselectAllButton);
        buttonPanel.add(restoreDefaultsButton);
        return buttonPanel;
    }

    private void selectAll() {
        int rowCount = this.model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.model.setValueAt(true, i, 0);
        }
    }

    private void deselectAll() {
        int rowCount = this.model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.model.setValueAt(false, i, 0);
        }
    }

    private void restoreDefaults() {
        int answer = OptionDialog.showYesNoDialog((Component)this, (String)"Restore Default Analysis Options", (String)"Do you really want to restore the analysis options to the default values?");
        if (answer == 1) {
            AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager(this.programs.get(0));
            manager.restoreDefaultOptions();
            this.editorStateFactory.clearAll();
            this.load();
        }
    }

    private void buildTableModel() {
        this.model = new AbstractTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return AnalysisPanel.this.analyzerEnablement.get(rowIndex);
                    }
                    case 1: {
                        String analyzerName = AnalysisPanel.this.analyzerNames.get(rowIndex);
                        if (AnalysisPanel.this.prototypeAnalyzers.contains(analyzerName)) {
                            return analyzerName + AnalysisPanel.PROTOTYPE;
                        }
                        return analyzerName;
                    }
                }
                return null;
            }

            @Override
            public int getRowCount() {
                return AnalysisPanel.this.analyzerEnablement.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return "Enabled";
                    }
                    case 1: {
                        return "Analyzer Name";
                    }
                }
                return super.getColumnName(columnIndex);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                }
                return super.getColumnClass(columnIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    Boolean enabled = (Boolean)value;
                    AnalysisPanel.this.analyzerEnablement.set(rowIndex, enabled);
                    String analyzerName = AnalysisPanel.this.analyzerNames.get(rowIndex);
                    AnalysisPanel.this.setAnalyzerEnabled(analyzerName, enabled);
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                }
            }
        };
    }

    private void buildTable() {
        this.table = new GTable((TableModel)this.model);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int selectedRow = lsm.getMinSelectionIndex();
            if (selectedRow == -1) {
                this.analyzerOptionsPanel.removeAll();
                this.analyzerOptionsPanel.validate();
                this.analyzerOptionsPanel.repaint();
                this.descriptionComponent.setText("");
                return;
            }
            String analyzerName = this.analyzerNames.get(selectedRow);
            this.setAnalyzerSelected(analyzerName);
        });
    }

    private void setAnalyzerSelected(String analyzerName) {
        Component component = this.analyzerToOptionsPanelMap.get(analyzerName);
        if (component == null) {
            component = this.noOptionsPanel;
        }
        this.analyzerOptionsPanel.removeAll();
        this.analyzerOptionsPanel.add(component, "Center");
        this.analyzerOptionsPanel.validate();
        this.analyzerOptionsPanel.repaint();
        this.analyzerOptionsPanel.getParent().validate();
        String description = this.analysisOptions.getDescription(analyzerName);
        this.descriptionComponent.setText(description);
        this.descriptionComponent.setCaretPosition(0);
    }

    private void configureTableColumns() {
        TableColumnModel columnModel = this.table.getColumnModel();
        block4: for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            int modelIndex = column.getModelIndex();
            switch (modelIndex) {
                case 0: {
                    this.configureTableColumn_IsEnabled(column, 75);
                    continue block4;
                }
                case 1: {
                    this.configureTableColumn_Name(column);
                }
            }
        }
    }

    private void configureTableColumn_Name(TableColumn column) {
        column.setCellRenderer((TableCellRenderer)((Object)new AnalyzerNameTableCellRenderer()));
    }

    private void configureTableColumn_IsEnabled(TableColumn column, int width) {
        column.setPreferredWidth(width);
        column.setMinWidth(width);
        column.setMaxWidth(width);
        column.setResizable(false);
        column.setCellRenderer((TableCellRenderer)new GBooleanCellRenderer());
    }

    private void configureBorder(JComponent component, String title) {
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(titleBorder, emptyBorder);
        component.setBorder(compoundBorder);
    }

    private void setAnalyzerEnabled(String analyzerName, boolean enabled) {
        List<Component> list = this.analyzerManagedComponentsMap.get(analyzerName);
        if (list != null) {
            for (Component next : list) {
                next.setEnabled(enabled);
            }
        }
        this.propertyChange(null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.checkForDifferences()) {
            this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "apply.enabled", null, Boolean.TRUE));
        }
    }

    private boolean checkForDifferences() {
        boolean changes = false;
        for (int i = 0; i < this.analyzerNames.size(); ++i) {
            boolean origEnabled;
            String analyzerName = this.analyzerNames.get(i);
            boolean currEnabled = this.analyzerEnablement.get(i);
            if (currEnabled == (origEnabled = this.analysisOptions.getBoolean(analyzerName, false))) continue;
            changes = true;
            this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, analyzerName, origEnabled, currEnabled));
        }
        if (changes) {
            return true;
        }
        for (EditorState info : this.editorList) {
            if (!info.isValueChanged()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyChanges() {
        for (int i = 0; i < this.analyzerNames.size(); ++i) {
            String analyzerName = this.analyzerNames.get(i);
            boolean enabled = this.analyzerEnablement.get(i);
            int id = this.programs.get(0).startTransaction("setting analysis options");
            boolean commit = false;
            try {
                this.analysisOptions.setBoolean(analyzerName, enabled);
                commit = true;
            }
            finally {
                this.programs.get(0).endTransaction(id, commit);
            }
            this.updateOptionForAllPrograms(analyzerName, enabled);
        }
        for (EditorState info : this.editorList) {
            info.applyValue();
        }
    }

    private void loadAnalyzerOptionsPanels() {
        List optionGroups = this.analysisOptions.getChildOptions();
        this.noOptionsPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        this.noOptionsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.noOptionsPanel.add((Component)new GLabel("No options available."));
        HelpService help = Help.getHelpService();
        for (Options optionsGroup : optionGroups) {
            String analyzerName = optionsGroup.getName();
            JPanel optionsContainer = new JPanel((LayoutManager)new VerticalLayout(5));
            optionsContainer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            JScrollPane scrollPane = new JScrollPane(optionsContainer);
            scrollPane.setBorder(null);
            this.analyzerToOptionsPanelMap.put(analyzerName, scrollPane);
            this.analyzerManagedComponentsMap.put(analyzerName, new ArrayList());
            List<String> optionNames = this.getOptionNames(optionsGroup);
            Collections.sort(optionNames);
            ArrayList<GenericOptionsComponent> optionComponents = new ArrayList<GenericOptionsComponent>();
            for (String childOptionName : optionNames) {
                EditorState childState = this.editorStateFactory.getEditorState(optionsGroup, childOptionName, (PropertyChangeListener)this);
                GenericOptionsComponent comp = GenericOptionsComponent.createOptionComponent((EditorState)childState);
                HelpLocation helpLoc = this.analysisOptions.getHelpLocation(analyzerName + Options.DELIMITER_STRING + childOptionName);
                if (helpLoc != null) {
                    help.registerHelp((Object)comp, helpLoc);
                }
                optionsContainer.add((Component)comp);
                optionComponents.add(comp);
                this.analyzerManagedComponentsMap.get(analyzerName).add((Component)comp);
                this.editorList.add(childState);
            }
            GenericOptionsComponent.alignLabels(optionComponents);
            Object value = this.analysisOptions.getObject(analyzerName, null);
            boolean enabled = true;
            if (value instanceof Boolean) {
                enabled = (Boolean)value;
            }
            this.setAnalyzerEnabled(analyzerName, enabled);
        }
    }

    private List<String> getOptionNames(Options optionsGroup) {
        List subOptions = optionsGroup.getLeafOptionNames();
        Iterator it = subOptions.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (this.isEditable(optionsGroup, next)) continue;
            it.remove();
        }
        return subOptions;
    }

    private boolean isEditable(Options options, String optionName) {
        PropertyEditor editor = options.getPropertyEditor(optionName);
        return options.getObject(optionName, null) != null || editor != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOptionForAllPrograms(String analyzerName, boolean enabled) {
        for (Program program : this.programs) {
            Options options = program.getOptions("Analyzers");
            if (!options.getOptionNames().contains(analyzerName)) continue;
            boolean commit = false;
            int id = program.startTransaction("Setting analysis property " + analyzerName);
            try {
                options.setBoolean(analyzerName, enabled);
                commit = true;
            }
            finally {
                program.endTransaction(id, commit);
            }
        }
    }

    private static class AnalyzerNameTableCellRenderer
    extends GTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private AnalyzerNameTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Component component = super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            if (value == null) {
                return component;
            }
            String analyzerName = (String)value;
            if (analyzerName.endsWith(AnalysisPanel.PROTOTYPE)) {
                component.setForeground(ColorUtils.deriveForeground((Color)component.getBackground(), (float)0.0f));
            }
            return component;
        }
    }
}

