/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.hover.AbstractTruncatedTextHover;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import javax.swing.JComponent;
import javax.swing.JToolTip;

public class TruncatedTextListingHover
extends AbstractTruncatedTextHover
implements ListingHoverService {
    private static final String NAME = "Truncated Text Display";
    private static final int POPUP_PRIORITY = 10;

    public TruncatedTextListingHover(PluginTool tool) {
        super(tool, 10);
    }

    @Override
    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled || programLocation == null || !(field instanceof ListingTextField)) {
            return null;
        }
        if (((ListingTextField)field).isClipped()) {
            String text = field.getTextWithLineSeparators();
            String convertToHtml = HTMLUtilities.toLiteralHTMLForTooltip((String)text);
            JToolTip toolTip = new JToolTip();
            toolTip.setTipText(convertToHtml);
            return toolTip;
        }
        return null;
    }

    @Override
    public void initializeOptions() {
        this.options = this.tool.getOptions("Listing Popups");
        this.options.setOptionsHelpLocation(new HelpLocation("CodeBrowserPlugin", "MouseHover"));
        this.options.registerOption(NAME, (Object)true, new HelpLocation("CodeBrowserPlugin", "TruncatedTextPopup"), "Toggle whether truncated text is displayed in a tooltip when the mouse hovers over a field that is truncated.");
        this.setOptions((Options)this.options, NAME);
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    @Override
    public void setOptions(Options options, String name) {
        this.enabled = options.getBoolean(NAME, true);
    }
}

