/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.colorizer;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.colorizer.ClearColorCommand;
import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.app.plugin.core.colorizer.ColorizingServiceProvider;
import ghidra.app.plugin.core.colorizer.NextColorRangeAction;
import ghidra.app.plugin.core.colorizer.PreviousColorRangeAction;
import ghidra.app.plugin.core.colorizer.SetColorCommand;
import ghidra.app.plugin.core.navigation.NavigationOptions;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Colorizer Plugin", description="Provides actions to set, clear and navigate colors in the Code Browser Listing.", servicesProvided={ColorizingService.class})
public class ColorizingPlugin
extends ProgramPlugin
implements DomainObjectListener {
    private static final String MARKER_DESCRIPTION = "Shows the location of user-applied colors";
    private static final int PRIORITY = -51;
    private static final Color MARKER_COLOR = Color.PINK;
    private static final String COLOR_HISTORY_XML_NAME = "COLOR_HISTORY";
    private static final String COLOR_HISTORY_LIST_XML_NAME = "COLOR_HISTORY";
    static final String MARKER_NAME = "Applied Color";
    static final String NAVIGATION_TOOLBAR_GROUP = "Navigation";
    static final String MENU_PULLRIGHT = "Colors";
    static final String POPUP_MENU_GROUP = "ZColors";
    static final String NAVIGATION_TOOLBAR_SUBGROUP = "Colors";
    private ColorizingServiceProvider service;
    private MarkerService markerService;
    private MarkerSet markerSet;
    private NavigationOptions navOptions;
    private NextColorRangeAction nextAction;
    private PreviousColorRangeAction previousAction;
    private SwingUpdateManager updateManager = new SwingUpdateManager(1000, new Runnable(){

        @Override
        public void run() {
            ColorizingPlugin.this.doUpdate();
        }
    });

    public ColorizingPlugin(PluginTool tool) {
        super(tool, true, true);
        this.service = new ColorizingServiceProvider(tool);
        this.registerServiceProvided(ColorizingService.class, this.service);
        tool.setMenuGroup(new String[]{"Colors"}, POPUP_MENU_GROUP);
    }

    protected void init() {
        this.navOptions = new NavigationOptions(this.tool);
        this.createActions();
    }

    public void readConfigState(SaveState saveState) {
        Element xmlElement = saveState.getXmlElement("COLOR_HISTORY");
        if (xmlElement != null) {
            ArrayList<Color> savedColorHistory = new ArrayList<Color>();
            List colorElements = xmlElement.getChildren("COLOR");
            for (Element element : colorElements) {
                String rgbString = element.getAttributeValue("RGB");
                int rgb = Integer.parseInt(rgbString);
                savedColorHistory.add(new Color(rgb, true));
            }
            this.service.setColorHistory(savedColorHistory);
        }
    }

    public void writeConfigState(SaveState saveState) {
        List<Color> colorHistory = this.service.getColorHistory();
        if (colorHistory != null) {
            Element colorsElement = new Element("COLOR_HISTORY");
            for (Color color : colorHistory) {
                Element element = new Element("COLOR");
                element.setAttribute("RGB", Integer.toString(color.getRGB()));
                colorsElement.addContent((Content)element);
            }
            saveState.putXmlElement("COLOR_HISTORY", colorsElement);
        }
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
        this.service.setProgram(program);
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
        this.service.setProgram(null);
    }

    @Override
    protected void programClosed(Program program) {
        this.removeMarkerSet(program);
        this.service.setProgram(null);
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        if (interfaceClass.equals(MarkerService.class)) {
            this.markerService = (MarkerService)service;
        }
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        if (interfaceClass.equals(MarkerService.class)) {
            this.markerService = null;
        } else if (interfaceClass.equals(GoToService.class)) {
            this.nextAction.remove();
            this.previousAction.remove();
        }
    }

    private void createActions() {
        String group = "ZClear";
        int subgroup = 1;
        HelpLocation helpLocation = new HelpLocation("CodeBrowserPlugin", "Listing_Background");
        DockingAction setColorAction = new DockingAction("Set Color", this.getName()){

            public void actionPerformed(ActionContext context) {
                ListingActionContext listingContext = (ListingActionContext)context;
                Color currentColor = ColorizingPlugin.this.service.getBackgroundColor(listingContext.getAddress());
                Color color = ColorizingPlugin.this.service.getColorFromUser(currentColor);
                if (color == null) {
                    return;
                }
                SetColorCommand command = null;
                ProgramSelection selection = listingContext.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    command = new SetColorCommand(color, ColorizingPlugin.this.service, selection);
                } else {
                    Address address = listingContext.getAddress();
                    command = new SetColorCommand(color, ColorizingPlugin.this.service, ColorizingPlugin.this.currentProgram, address);
                }
                ColorizingPlugin.this.tool.execute((Command)command, (DomainObject)ColorizingPlugin.this.currentProgram);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context instanceof ListingActionContext;
            }
        };
        setColorAction.setPopupMenuData(new MenuData(new String[]{"Colors", "Set Color"}, null, group, -1, Integer.toString(subgroup++)));
        setColorAction.setHelpLocation(helpLocation);
        DockingAction clearAction = new DockingAction("Clear Color", this.getName()){

            public void actionPerformed(ActionContext context) {
                ListingActionContext listingContext = (ListingActionContext)context;
                ProgramSelection selection = listingContext.getSelection();
                if (selection == null || selection.isEmpty()) {
                    AddressSet set = new AddressSet();
                    set.add(listingContext.getAddress());
                    selection = set;
                }
                ClearColorCommand command = new ClearColorCommand(ColorizingPlugin.this.service, selection);
                ColorizingPlugin.this.tool.execute((Command)command, (DomainObject)ColorizingPlugin.this.currentProgram);
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ListingActionContext)) {
                    return false;
                }
                ListingActionContext listingContext = (ListingActionContext)context;
                ProgramSelection selection = listingContext.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    return ColorizingPlugin.this.isColored(selection);
                }
                return ColorizingPlugin.this.isColored(listingContext.getAddress());
            }
        };
        clearAction.setPopupMenuData(new MenuData(new String[]{"Colors", "Clear Color"}, null, group, -1, Integer.toString(subgroup++)));
        clearAction.setHelpLocation(helpLocation);
        DockingAction clearAllAction = new DockingAction("Clear All Colors", this.getName()){

            public void actionPerformed(ActionContext context) {
                ClearColorCommand command = new ClearColorCommand(ColorizingPlugin.this.service);
                ColorizingPlugin.this.tool.execute((Command)command, (DomainObject)ColorizingPlugin.this.currentProgram);
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ListingActionContext)) {
                    return false;
                }
                AddressSetView set = ColorizingPlugin.this.service.getAllBackgroundColorAddresses();
                return !set.isEmpty();
            }
        };
        clearAllAction.setPopupMenuData(new MenuData(new String[]{"Colors", "Clear All Colors"}, null, group, -1, Integer.toString(subgroup++)));
        clearAllAction.setHelpLocation(helpLocation);
        this.nextAction = new NextColorRangeAction(this, this.tool, this.navOptions);
        this.previousAction = new PreviousColorRangeAction(this, this.tool, this.navOptions);
        this.tool.addAction((DockingActionIf)clearAction);
        this.tool.addAction((DockingActionIf)clearAllAction);
        this.tool.addAction((DockingActionIf)setColorAction);
        this.tool.addAction((DockingActionIf)this.nextAction);
        this.tool.addAction((DockingActionIf)this.previousAction);
    }

    private boolean isColored(ProgramSelection selection) {
        AddressSetView appliedColorAddresses = this.service.getAllBackgroundColorAddresses();
        return selection.intersects(appliedColorAddresses);
    }

    private boolean isColored(Address address) {
        Color color = this.service.getBackgroundColor(address);
        return color != null;
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(170) || ev.containsEvent(171) || ev.containsEvent(172)) {
            this.updateManager.update();
        }
    }

    protected void dispose() {
        this.updateManager.dispose();
        this.navOptions.dispose();
        super.dispose();
    }

    private void removeMarkerSet(Program program) {
        if (this.markerService != null && this.markerSet != null) {
            this.markerService.removeMarker(this.markerSet, program);
        }
    }

    private void doUpdate() {
        AddressSetView set = this.service.getAllBackgroundColorAddresses();
        this.updateMarkers(set);
    }

    private void updateMarkers(AddressSetView set) {
        if (this.markerService == null) {
            return;
        }
        if (this.markerSet == null) {
            Address minAddress = set.getMinAddress();
            Color color = this.service.getBackgroundColor(minAddress);
            if (color == null) {
                color = MARKER_COLOR;
            }
            this.markerSet = this.markerService.createPointMarker(MARKER_NAME, MARKER_DESCRIPTION, this.currentProgram, -51, false, true, false, color, null);
        } else {
            this.markerSet.clearAll();
        }
        AddressRangeIterator iterator = set.getAddressRanges();
        while (iterator.hasNext()) {
            AddressRange range = (AddressRange)iterator.next();
            this.markerSet.add(range);
        }
    }

    ColorizingService getColorizingService() {
        return this.service;
    }

    GoToService getGoToService() {
        return (GoToService)this.tool.getService(GoToService.class);
    }
}

