/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.commentwindow;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.commentwindow.CommentRowObject;
import ghidra.app.plugin.core.commentwindow.CommentWindowPlugin;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.task.TaskMonitor;

class CommentTableModel
extends AddressBasedTableModel<CommentRowObject> {
    static final int TYPE_COL_WIDTH = 150;
    static final int COMMENT_COL_WIDTH = 350;
    static final int LOCATION_COL = 0;
    static final int TYPE_COL = 1;
    static final int COMMENT_COL = 2;
    private Listing listing;

    CommentTableModel(CommentWindowPlugin plugin) {
        super("Comment Window", (ServiceProvider)plugin.getTool(), null, null);
    }

    @Override
    protected TableColumnDescriptor<CommentRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new TypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new CommentTableColumn());
        return descriptor;
    }

    void reload(Program newProgram) {
        this.setProgram(newProgram);
        this.listing = newProgram != null ? newProgram.getListing() : null;
        this.reload();
    }

    protected void doLoad(Accumulator<CommentRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.listing == null) {
            return;
        }
        AddressIterator commentIterator = this.listing.getCommentAddressIterator((AddressSetView)this.getProgram().getMemory(), true);
        while (commentIterator.hasNext()) {
            Address commentAddr = commentIterator.next();
            CodeUnit cu = this.listing.getCodeUnitAt(commentAddr);
            if (cu == null) continue;
            if (cu.getComment(1) != null) {
                accumulator.add((Object)new CommentRowObject(commentAddr, 1));
            }
            if (cu.getComment(2) != null) {
                accumulator.add((Object)new CommentRowObject(commentAddr, 2));
            }
            if (cu.getComment(0) != null) {
                accumulator.add((Object)new CommentRowObject(commentAddr, 0));
            }
            if (cu.getComment(3) != null) {
                accumulator.add((Object)new CommentRowObject(commentAddr, 3));
            }
            if (cu.getComment(4) == null) continue;
            accumulator.add((Object)new CommentRowObject(commentAddr, 4));
        }
    }

    void commentAdded(Address addr, int commentType) {
        String comment = this.listing.getComment(commentType, addr);
        if (comment == null) {
            Msg.debug((Object)this, (Object)"Received a commentAdded() with a null comment");
            return;
        }
        this.addObject(new CommentRowObject(addr, commentType));
    }

    void commentRemoved(Address addr, int commentType) {
        this.removeObject(new CommentRowObject(addr, commentType));
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet set = new AddressSet();
        for (int element : rows) {
            CommentRowObject rowObject = (CommentRowObject)this.getRowObject(element);
            set.addRange(rowObject.getAddress(), rowObject.getAddress());
        }
        return new ProgramSelection((AddressSetView)set);
    }

    @Override
    public Address getAddress(int row) {
        return ((CommentRowObject)this.getRowObject(row)).getAddress();
    }

    private String getCommentForRowObject(CommentRowObject t) {
        return this.listing.getComment(t.getCommentType(), t.getAddress());
    }

    private class CommentTableColumn
    extends AbstractProgramBasedDynamicTableColumn<CommentRowObject, String> {
        private CommentTableColumn() {
        }

        public String getColumnName() {
            return "Comment";
        }

        public String getValue(CommentRowObject rowObject, Settings settings, Program program, ServiceProvider provider) throws IllegalArgumentException {
            String comment = CommentTableModel.this.getCommentForRowObject(rowObject);
            return comment;
        }

        public int getColumnPreferredWidth() {
            return 350;
        }
    }

    private class TypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<CommentRowObject, String> {
        private TypeTableColumn() {
        }

        public String getColumnName() {
            return "Type";
        }

        public String getValue(CommentRowObject rowObject, Settings settings, Program program, ServiceProvider provider) throws IllegalArgumentException {
            String returnString = "";
            if (rowObject.getCommentType() == 0) {
                return "EOL Comment";
            }
            if (rowObject.getCommentType() == 3) {
                return "Plate Comment";
            }
            if (rowObject.getCommentType() == 1) {
                return "Pre Comment";
            }
            if (rowObject.getCommentType() == 2) {
                return "Post Comment";
            }
            if (rowObject.getCommentType() == 4) {
                return "Repeatable Comment";
            }
            return returnString;
        }

        public int getColumnPreferredWidth() {
            return 150;
        }
    }
}

