/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class DeleteAction
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Delete Components";
    private static final String GROUP_NAME = "3_COMPONENT_EDITOR_ACTION";
    private static final ImageIcon ICON = ResourceManager.loadImage((String)"images/edit-delete.png");
    private static final String[] popupPath = new String[]{"Delete"};
    private static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(127, 0);

    public DeleteAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Delete Components", GROUP_NAME, popupPath, null, ICON);
        this.setKeyBindingData(new KeyBindingData(KEY_STROKE));
        this.setDescription("Delete the selected components");
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        TaskLauncher.launchModal((String)this.getName(), this::doDelete);
        this.requestTableFocus();
    }

    private void doDelete(TaskMonitor monitor) {
        try {
            this.model.deleteSelectedComponents(monitor);
        }
        catch (CancelledException cancelledException) {
        }
        catch (UsrException e) {
            this.model.setStatus(e.getMessage(), true);
        }
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.model.isDeleteAllowed());
    }
}

