/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.data.DataPlugin;
import ghidra.app.util.datatype.DataTypeSelectionDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.SystemUtilities;
import ghidra.util.data.DataTypeParser;
import javax.swing.KeyStroke;

public class ChooseDataTypeAction
extends DockingAction {
    private DataPlugin plugin;
    private static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(84, 0);
    private static final String ACTION_NAME = "Choose Data Type";

    public ChooseDataTypeAction(DataPlugin plugin) {
        super(ACTION_NAME, plugin.getName(), KeyBindingType.SHARED);
        this.plugin = plugin;
        this.initKeyStroke(KEY_BINDING);
    }

    private void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setKeyBindingData(new KeyBindingData(keyStroke));
    }

    public void actionPerformed(ActionContext context) {
        int[] compPath;
        InteriorSelection interiorSel;
        ListingActionContext programActionContext = (ListingActionContext)context.getContextObject();
        int maxSize = Integer.MAX_VALUE;
        Program program = programActionContext.getProgram();
        ProgramLocation loc = programActionContext.getLocation();
        ProgramSelection sel = programActionContext.getSelection();
        maxSize = sel != null && !sel.isEmpty() ? ((interiorSel = sel.getInteriorSelection()) != null ? this.getSizeInsideStructure(program, interiorSel) : this.getSizeForSelection(program, sel)) : ((compPath = loc.getComponentPath()) != null && compPath.length > 0 ? this.getSizeInsideStructure(program, loc) : this.getSizeForAddress(program, loc));
        if (maxSize < 0) {
            return;
        }
        Pointer pointer = program.getDataTypeManager().getPointer(null);
        DataType dataType = this.getDataType(programActionContext, maxSize, pointer.getLength());
        if (dataType != null) {
            this.plugin.doCreateData(program, loc, sel, dataType, false);
        }
    }

    private int getSizeInsideStructure(Program program, InteriorSelection selection) {
        ProgramLocation location = selection.getFrom();
        Data dataComponent = this.getParentDataType(program, location);
        if (dataComponent == null) {
            return -1;
        }
        return selection.getByteLength();
    }

    private int getSizeInsideStructure(Program program, ProgramLocation location) {
        Data dataComponent = this.getParentDataType(program, location);
        if (dataComponent == null) {
            return -1;
        }
        return this.getMaxSizeInStructure((Structure)dataComponent.getParent().getBaseDataType(), dataComponent.getComponentIndex());
    }

    private int getSizeForAddress(Program program, ProgramLocation location) {
        Address address = location.getAddress();
        Data data = program.getListing().getDataAt(address);
        if (data == null) {
            this.plugin.getTool().setStatusInfo("Create Data Failed! No data at " + address);
            return -1;
        }
        return this.getMaxSize(program, address);
    }

    private Data getParentDataType(Program program, ProgramLocation location) {
        int[] path = location.getComponentPath();
        Address address = location.getAddress();
        Data data = program.getListing().getDataContaining(address);
        Data dataComponent = null;
        if (data != null) {
            dataComponent = data.getComponent(path);
        }
        if (dataComponent == null) {
            this.plugin.getTool().setStatusInfo("Create data type failed! No data at " + address);
            return null;
        }
        DataType parentDataType = dataComponent.getParent().getBaseDataType();
        if (!(parentDataType instanceof Structure)) {
            this.plugin.getTool().setStatusInfo("Cannot set data type here.");
            return null;
        }
        return dataComponent;
    }

    private int getSizeForSelection(Program program, ProgramSelection selection) {
        PluginTool tool = this.plugin.getTool();
        AddressRange range = selection.getFirstRange();
        Address address = selection.getMinAddress();
        Data data = program.getListing().getDataAt(address);
        if (data == null) {
            tool.setStatusInfo("Cannot set data type! No data at " + address);
            return -1;
        }
        return (int)range.getLength();
    }

    private DataType getDataType(ListingActionContext context, int maxElements, int defaultPointerSize) {
        PluginTool tool = this.plugin.getTool();
        Data data = this.plugin.getDataUnit(context);
        DataTypeSelectionDialog selectionDialog = new DataTypeSelectionDialog(tool, (DataTypeManager)data.getProgram().getDataTypeManager(), maxElements, DataTypeParser.AllowedDataTypes.ALL);
        DataType currentDataType = data.getBaseDataType();
        selectionDialog.setInitialDataType(currentDataType);
        tool.showDialog((DialogComponentProvider)selectionDialog);
        return selectionDialog.getUserChosenDataType();
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (contextObject instanceof ListingActionContext) {
            return this.plugin.isCreateDataAllowed((ListingActionContext)contextObject);
        }
        return false;
    }

    private int getMaxSizeInStructure(Structure struct, int index) {
        DataType dataType;
        int n = struct.getNumComponents();
        DataTypeComponent dtc = struct.getComponent(index++);
        int length = dtc.getLength();
        while (index < n && (dataType = (dtc = struct.getComponent(index++)).getDataType()) == DataType.DEFAULT) {
            length += dtc.getLength();
        }
        return length;
    }

    private int getMaxSize(Program program, Address addr) {
        long length;
        Address dataAddr;
        Data data;
        Address instrAddr;
        Address maxAddr = program.getMemory().getBlock(addr).getEnd();
        Instruction instr = program.getListing().getInstructionAfter(addr);
        if (instr != null && (instrAddr = instr.getMinAddress()).compareTo((Object)maxAddr) < 0) {
            maxAddr = instrAddr.subtract(1L);
        }
        if ((data = DataUtilities.getNextNonUndefinedDataAfter((Program)program, (Address)addr, (Address)maxAddr)) != null && (dataAddr = data.getMinAddress()).compareTo((Object)maxAddr) < 0) {
            maxAddr = dataAddr.subtract(1L);
        }
        SystemUtilities.assertTrue(((length = maxAddr.subtract(addr) + 1L) > 0L ? 1 : 0) != 0, (String)"Subtraction an address from the max address in its block should never be negative");
        return length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
    }
}

