/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.MissingBuiltInDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import javax.swing.tree.TreePath;

public class AlignDataTypeAction
extends DockingAction {
    public AlignDataTypeAction(DataTypeManagerPlugin plugin) {
        super("Align Data Type", plugin.getName());
        this.setPopupMenuData(new MenuData(new String[]{"Align"}, "Edit"));
        this.setHelpLocation(new HelpLocation(plugin.getName(), this.getName()));
    }

    public boolean isAddToPopup(ActionContext context) {
        DataTypeNode node = this.getSelectedDataTypeNode(context);
        if (node == null) {
            return false;
        }
        DataType dataType = node.getDataType();
        if (dataType instanceof BuiltInDataType || dataType instanceof Pointer || dataType instanceof MissingBuiltInDataType) {
            return false;
        }
        return node.isModifiable();
    }

    public boolean isEnabledForContext(ActionContext context) {
        DataTypeNode node = this.getSelectedDataTypeNode(context);
        if (node == null) {
            return false;
        }
        DataType dataType = node.getDataType();
        if (dataType instanceof Composite) {
            return !((Composite)dataType).isInternallyAligned();
        }
        return false;
    }

    private DataTypeNode getSelectedDataTypeNode(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (!(contextObject instanceof GTree)) {
            return null;
        }
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return null;
        }
        DataTypeTreeNode node = (DataTypeTreeNode)((Object)selectionPaths[0].getLastPathComponent());
        if (!(node instanceof DataTypeNode)) {
            return null;
        }
        return (DataTypeNode)node;
    }

    public void actionPerformed(ActionContext context) {
        TreePath[] selectionPaths;
        GTree gTree = (GTree)context.getContextObject();
        for (TreePath treePath : selectionPaths = gTree.getSelectionPaths()) {
            DataTypeNode dataTypeNode = (DataTypeNode)((Object)treePath.getLastPathComponent());
            DataType dataType = dataTypeNode.getDataType();
            DataTypeManager dataTypeManager = dataType.getDataTypeManager();
            DataOrganization dataOrganization = dataTypeManager.getDataOrganization();
            this.alignDataType(dataType, dataOrganization);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alignDataType(DataType dataType, DataOrganization dataOrganization) {
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        if (dataTypeManager == null) {
            Msg.error((Object)((Object)this), (Object)("Can't align data type " + dataType.getName() + " without a data type manager."));
            return;
        }
        if (!(dataType instanceof Structure)) {
            Msg.error((Object)((Object)this), (Object)("Can't align data type " + dataType.getName() + ". It's not a structure."));
            return;
        }
        int transactionID = -1;
        boolean commit = false;
        try {
            transactionID = dataTypeManager.startTransaction("align " + dataType.getName());
            ((Structure)dataType).setInternallyAligned(true);
            commit = true;
        }
        finally {
            dataTypeManager.endTransaction(transactionID, commit);
        }
    }
}

