/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.actions.AbstractTypeDefAction;
import ghidra.app.plugin.core.datamgr.actions.DerivativeDataTypeInfo;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.BuiltInArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Pointer;
import ghidra.util.StringUtilities;
import javax.swing.tree.TreePath;

public class CreateTypeDefAction
extends AbstractTypeDefAction {
    private static final int MAX_DISPLAY_CHAR_LENGTH = 20;

    public CreateTypeDefAction(DataTypeManagerPlugin plugin) {
        super("Create Typedef", plugin);
        this.setPopupMenuData(new MenuData(new String[]{"New", "Typedef"}, null, "Create"));
    }

    public boolean isAddToPopup(ActionContext context) {
        DataTypeManager manager;
        DataTypeNode node = this.getDataTypeNode(context);
        if (node == null) {
            return false;
        }
        DataType dataType = node.getDataType();
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        return !(dataTypeManager instanceof BuiltInDataTypeManager) || (manager = this.plugin.getProgramDataTypeManager()) != null;
    }

    public boolean isEnabledForContext(ActionContext context) {
        DataTypeNode node = this.getDataTypeNode(context);
        if (node == null) {
            return false;
        }
        ArchiveNode archiveNode = ((DataTypeTreeNode)node).getArchiveNode();
        if (archiveNode == null) {
            return false;
        }
        boolean enabled = archiveNode.isModifiable();
        if (archiveNode instanceof BuiltInArchiveNode) {
            enabled = true;
        }
        if (enabled) {
            String dtName = node.getName();
            dtName = StringUtilities.trim((String)dtName, (int)20);
            MenuData newMenuData = new MenuData(new String[]{"New", "Typedef on " + dtName}, null, "Create");
            this.setPopupMenuData(newMenuData);
        }
        return enabled;
    }

    private DataTypeNode getDataTypeNode(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return null;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return null;
        }
        DataTypeTreeNode node = (DataTypeTreeNode)((Object)selectionPaths[0].getLastPathComponent());
        if (!(node instanceof DataTypeNode)) {
            return null;
        }
        return (DataTypeNode)node;
    }

    public void actionPerformed(ActionContext context) {
        DataTypeArchiveGTree gTree = (DataTypeArchiveGTree)((Object)context.getContextObject());
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        DataTypeNode dataTypeNode = (DataTypeNode)((Object)selectionPaths[0].getLastPathComponent());
        DataType dataType = dataTypeNode.getDataType();
        String baseName = CreateTypeDefAction.getBaseName(dataType) + "Typedef";
        DerivativeDataTypeInfo info = new DerivativeDataTypeInfo(this.plugin, gTree, (GTreeNode)dataTypeNode, dataType);
        DataTypeManager dataTypeManager = info.getDataTypeManager();
        String name = dataTypeManager.getUniqueName(dataType.getCategoryPath(), baseName);
        CategoryPath categoryPath = info.getCategoryPath();
        DataType newTypeDef = this.createTypeDef(dataTypeManager, dataType, categoryPath, context, dataTypeNode.getParent(), name);
        if (newTypeDef == null) {
            return;
        }
        GTreeNode finalParentNode = info.getParentNode();
        String newNodeName = newTypeDef.getName();
        gTree.startEditing(finalParentNode, newNodeName);
    }

    private static String getBaseName(DataType dt) {
        if (dt instanceof Pointer) {
            DataType dataType = ((Pointer)dt).getDataType();
            if (dataType == null) {
                return dt.getName();
            }
            return CreateTypeDefAction.getBaseName(dataType) + "Ptr";
        }
        return dt.getDisplayName();
    }
}

