/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.ArchiveManagerListener;
import ghidra.app.plugin.core.datamgr.archive.BuiltInArchive;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.archive.InvalidFileArchive;
import ghidra.app.plugin.core.datamgr.archive.ProgramArchive;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ArrayPointerFilterState;
import ghidra.app.plugin.core.datamgr.tree.BuiltInArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.InvalidArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProgramArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class ArchiveRootNode
extends DataTypeTreeNode {
    private static final String NAME = "Data Types";
    private final DataTypeManagerHandler archiveManager;
    private RootNodeListener archiveListener;
    private ArrayPointerFilterState filterState = new ArrayPointerFilterState();

    ArchiveRootNode(DataTypeManagerHandler archiveManager) {
        this.archiveManager = archiveManager;
        this.archiveListener = new RootNodeListener();
        archiveManager.addArchiveManagerListener(this.archiveListener);
    }

    public DataTypeManagerHandler getArchiveHandler() {
        return this.archiveManager;
    }

    public void dispose() {
        this.archiveManager.removeArchiveManagerListener(this.archiveListener);
        super.dispose();
    }

    public Icon getIcon(boolean expanded) {
        return DataTypeUtils.getRootIcon(expanded);
    }

    public String getName() {
        return NAME;
    }

    public String getToolTip() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    private static final GTreeNode createArchiveNode(Archive archive, ArrayPointerFilterState filterState) {
        if (archive instanceof FileArchive) {
            return new FileArchiveNode((FileArchive)archive, filterState);
        }
        if (archive instanceof ProjectArchive) {
            return new ProjectArchiveNode((ProjectArchive)archive, filterState);
        }
        if (archive instanceof InvalidFileArchive) {
            return new InvalidArchiveNode((InvalidFileArchive)archive);
        }
        if (archive instanceof ProgramArchive) {
            return new ProgramArchiveNode((ProgramArchive)archive, filterState);
        }
        if (archive instanceof BuiltInArchive) {
            return new BuiltInArchiveNode((BuiltInArchive)archive, filterState);
        }
        return null;
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public boolean canPaste(List<GTreeNode> pastedNodes) {
        return false;
    }

    @Override
    public boolean isCut() {
        return false;
    }

    @Override
    public void setNodeCut(boolean isCut) {
        throw new AssertException("Cannot call setNodeCut() on ArchiveRootNode.");
    }

    @Override
    public ArchiveNode getArchiveNode() {
        return null;
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    public CategoryNode findCategoryNode(Category category) {
        for (GTreeNode node : this.getChildren()) {
            ArchiveNode archiveNode = (ArchiveNode)node;
            CategoryNode categoryNode = archiveNode.findCategoryNode(category);
            if (categoryNode == null) continue;
            return categoryNode;
        }
        return null;
    }

    public ArchiveNode getNodeForManager(DataTypeManager dtm) {
        for (GTreeNode node : this.getChildren()) {
            ArchiveNode archiveNode = (ArchiveNode)node;
            Archive archive = archiveNode.getArchive();
            DataTypeManager manager = archive.getDataTypeManager();
            if (!manager.equals(dtm)) continue;
            return archiveNode;
        }
        return null;
    }

    public List<GTreeNode> generateChildren() {
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        Iterator<Archive> iterator = this.archiveManager.getAllArchives().iterator();
        while (iterator.hasNext()) {
            list.add(ArchiveRootNode.createArchiveNode(iterator.next(), this.filterState));
        }
        Collections.sort(list);
        return list;
    }

    private ArchiveNode getArchiveNode(Archive archive) {
        List allChildrenList = this.getChildren();
        for (GTreeNode node : allChildrenList) {
            if (!(node instanceof ArchiveNode)) continue;
            ArchiveNode archiveNode = (ArchiveNode)node;
            if (archiveNode.archive != archive) continue;
            return archiveNode;
        }
        return null;
    }

    public void setFilterArray(boolean enabled) {
        this.filterState.setFilterArrays(enabled);
    }

    public void setFilterPointer(boolean enabled) {
        this.filterState.setFilterPointers(enabled);
    }

    class RootNodeListener
    implements ArchiveManagerListener {
        RootNodeListener() {
        }

        @Override
        public void archiveClosed(Archive archive) {
            if (!ArchiveRootNode.this.isLoaded()) {
                return;
            }
            List allChildrenList = ArchiveRootNode.this.getChildren();
            for (GTreeNode node : allChildrenList) {
                ArchiveNode archiveNode = (ArchiveNode)node;
                if (archive != archiveNode.getArchive()) continue;
                ArchiveRootNode.this.removeNode((GTreeNode)archiveNode);
                archiveNode.dispose();
                return;
            }
        }

        @Override
        public void archiveOpened(Archive archive) {
            if (ArchiveRootNode.this.isLoaded()) {
                GTreeNode node = ArchiveRootNode.createArchiveNode(archive, ArchiveRootNode.this.filterState);
                List allChildrenList = ArchiveRootNode.this.getChildren();
                int index = Collections.binarySearch(allChildrenList, node);
                if (index < 0) {
                    index = -index - 1;
                    ArchiveRootNode.this.addNode(index, node);
                }
            }
        }

        @Override
        public void archiveDataTypeManagerChanged(Archive archive) {
            ArchiveNode archiveNode = ArchiveRootNode.this.getArchiveNode(archive);
            if (archiveNode != null) {
                archiveNode.dataTypeManagerChanged();
            }
        }

        @Override
        public void archiveStateChanged(Archive archive) {
            ArchiveNode archiveNode = ArchiveRootNode.this.getArchiveNode(archive);
            if (archiveNode != null) {
                archiveNode.archiveStateChanged();
            }
        }
    }
}

