/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.util;

import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.services.DataService;
import ghidra.app.util.ProgramDropProvider;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;

public class DataDropOnBrowserHandler
implements ProgramDropProvider {
    private static final DataFlavor[] ACCEPTABLE_FLAVORS = new DataFlavor[]{DataTypeTransferable.localDataTypeFlavor, DataTypeTransferable.localBuiltinDataTypeFlavor};
    private DataService curService;
    private final DataTypeManagerPlugin plugin;

    public DataDropOnBrowserHandler(DataTypeManagerPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public int getPriority() {
        return 20;
    }

    @Override
    public DataFlavor[] getDataFlavors() {
        return ACCEPTABLE_FLAVORS;
    }

    @Override
    public boolean isDropOk(Object contextObj, DropTargetDragEvent evt) {
        this.curService = null;
        if (!evt.isDataFlavorSupported(DataTypeTransferable.localDataTypeFlavor) && !evt.isDataFlavorSupported(DataTypeTransferable.localBuiltinDataTypeFlavor)) {
            return false;
        }
        if (contextObj != null && contextObj instanceof ListingActionContext) {
            ListingActionContext pl = (ListingActionContext)contextObj;
            DataService[] services = (DataService[])this.plugin.getTool().getServices(DataService.class);
            for (int i = 0; i < services.length; ++i) {
                if (!services[i].isCreateDataAllowed(pl)) continue;
                this.curService = services[i];
                return true;
            }
        }
        return false;
    }

    @Override
    public void add(Object contextObj, Object data, DataFlavor flavor) {
        if (this.curService != null) {
            DataType dt = (DataType)data;
            this.curService.createData(dt, (ListingActionContext)contextObj, true);
        }
    }
}

