/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.util;

import docking.DialogComponentProvider;
import docking.widgets.filter.FilterOptions;
import docking.widgets.filter.TextFilterStrategy;
import docking.widgets.label.GLabel;
import docking.widgets.tree.DefaultGTreeFilterProvider;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeFilterProvider;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;

public class DataTypeChooserDialog
extends DialogComponentProvider {
    private DataTypeArchiveGTree tree;
    private DataType selectedDataType;
    private GLabel messageLabel;
    boolean isFilterEditable;

    public DataTypeChooserDialog(DataTypeManagerPlugin plugin) {
        super("Data Type Chooser", true, true, true, false);
        this.tree = new DataTypeArchiveGTree(plugin);
        this.tree.setEditable(this.isFilterEditable);
        this.tree.addGTreeSelectionListener(e -> this.setOkEnabled(this.getSelectedNode() != null));
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                DataTypeNode selectedNode = DataTypeChooserDialog.this.getSelectedNode();
                if (selectedNode == null) {
                    return;
                }
                DataTypeChooserDialog.this.selectedDataType = selectedNode.getDataType();
                DataTypeChooserDialog.this.close();
            }
        });
        this.setPreferredSize(400, 400);
        this.addWorkPanel(this.createWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setOkEnabled(false);
    }

    private DataTypeNode getSelectedNode() {
        TreePath[] selectionPath = this.tree.getSelectionPaths();
        if (selectionPath.length != 1) {
            return null;
        }
        GTreeNode node = (GTreeNode)selectionPath[0].getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return null;
        }
        return (DataTypeNode)node;
    }

    public void close() {
        this.tree.dispose();
        super.close();
    }

    private JComponent createWorkPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.messageLabel = new GLabel("Choose the data type you wish to use.");
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        panel.add((Component)this.messageLabel, "North");
        panel.add((Component)((Object)this.tree), "Center");
        return panel;
    }

    protected void okCallback() {
        DataTypeNode dataTypeNode = this.getSelectedNode();
        this.selectedDataType = dataTypeNode.getDataType();
        this.close();
    }

    public void setFilterText(String filterText) {
        boolean bl = this.isFilterEditable = filterText == null;
        if (!this.isFilterEditable) {
            this.tree.setFilterText(filterText);
        }
        this.setFilterFieldEditable(this.isFilterEditable);
        this.tree.runTask(new SelectNodeTask(this.tree));
    }

    public void setSelectedPath(TreePath selectedPath) {
        this.tree.setSelectedNodeByPathName(selectedPath);
    }

    public Component getFocusComponent() {
        if (this.isFilterEditable) {
            return this.tree.getFilterField();
        }
        return null;
    }

    private void setFilterFieldEditable(boolean editable) {
        GTreeFilterProvider filterProvider;
        this.tree.setFilterFieldEnabled(editable);
        if (!editable && (filterProvider = this.tree.getFilterProvider()) instanceof DefaultGTreeFilterProvider) {
            DefaultGTreeFilterProvider provider = (DefaultGTreeFilterProvider)filterProvider;
            provider.setFilterOptions(new FilterOptions(TextFilterStrategy.MATCHES_EXACTLY, false, false, false));
        }
    }

    public DataType getSelectedDataType() {
        return this.selectedDataType;
    }

    private class SelectNodeTask
    extends GTreeTask {
        protected SelectNodeTask(GTree tree) {
            super(tree);
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            GTreeNode root = this.tree.getViewRoot();
            ArrayList<GTreeNode> dtNodes = new ArrayList<GTreeNode>();
            this.getDataTypeNodes(root, dtNodes);
            if (dtNodes.isEmpty()) {
                return;
            }
            this.tree.setSelectedNode((GTreeNode)dtNodes.get(0));
        }

        private void getDataTypeNodes(GTreeNode node, List<GTreeNode> dtNodes) {
            if (node instanceof DataTypeNode) {
                dtNodes.add(node);
                return;
            }
            List children = node.getChildren();
            for (GTreeNode child : children) {
                this.getDataTypeNodes(child, dtNodes);
            }
        }
    }
}

