/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.services.DataTypeQueryService;
import ghidra.app.util.cparser.C.ParseException;
import ghidra.app.util.parser.FunctionSignatureParser;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EditFunctionSignatureDialog
extends DialogComponentProvider {
    private static final String NONE_CHOICE = "-NONE-";
    protected JLabel signatureLabel;
    protected JTextField signatureField;
    protected JComboBox<String> callingConventionComboBox;
    protected JComboBox<String> callFixupComboBox;
    protected JCheckBox inlineCheckBox;
    protected JCheckBox noReturnCheckBox;
    protected PluginTool tool;
    protected Function function;
    protected String oldFunctionName;
    protected String oldFunctionSignature;

    public EditFunctionSignatureDialog(PluginTool tool, String title, Function function) {
        super(title, true, true, true, false);
        this.tool = tool;
        this.function = function;
        this.oldFunctionName = function.getName();
        this.oldFunctionSignature = function.getSignature().getPrototypeString();
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        this.setFunctionInfo();
        this.setRememberSize(true);
    }

    protected void setFunctionInfo() {
        this.setSignature(this.function.getSignature().getPrototypeString());
        this.setCallingConvention(this.function.getCallingConventionName());
        this.setInlineSelected(this.function.isInline());
        this.inlineCheckBox.setEnabled(!this.getAffectiveFunction(this.function).isExternal());
        this.setNoReturnSelected(this.function.hasNoReturn());
    }

    protected Function getAffectiveFunction(Function f) {
        return f.isThunk() ? f.getThunkedFunction(true) : f;
    }

    private JPanel buildMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
        mainPanel.add(this.buildSignaturePanel());
        mainPanel.add(this.buildAttributePanel());
        this.installCallFixupWidget(mainPanel);
        return mainPanel;
    }

    protected void installCallFixupWidget(JPanel parentPanel) {
        JPanel callFixupPanel = this.buildCallFixupPanel();
        parentPanel.add(callFixupPanel != null ? callFixupPanel : this.buildSpacerPanel());
    }

    private JPanel buildSignaturePanel() {
        JPanel signaturePanel = new JPanel();
        signaturePanel.setLayout(new BoxLayout(signaturePanel, 0));
        String signature = this.function.getPrototypeString(false, false);
        this.signatureField = new JTextField(signature.length());
        this.signatureField.setText(signature);
        this.signatureLabel = new GDLabel("Signature:");
        signaturePanel.add(this.signatureLabel);
        signaturePanel.add(this.signatureField);
        signaturePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return signaturePanel;
    }

    private Component buildSpacerPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createVerticalStrut(20));
        return panel;
    }

    private JPanel buildAttributePanel() {
        JPanel attributePanel = new JPanel();
        attributePanel.setLayout(new BoxLayout(attributePanel, 0));
        attributePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.installCallingConventionWidget(attributePanel);
        this.installInlineWidget(attributePanel);
        this.installNoReturnWidget(attributePanel);
        attributePanel.add(Box.createGlue());
        return attributePanel;
    }

    protected void installCallingConventionWidget(JPanel parentPanel) {
        this.callingConventionComboBox = new GhidraComboBox();
        List callingConventions = this.function.getProgram().getFunctionManager().getCallingConventionNames();
        String[] choices = callingConventions.toArray(new String[callingConventions.size()]);
        this.setCallingConventionChoices(choices);
        parentPanel.add((Component)new GLabel("Calling Convention:"));
        parentPanel.add(this.callingConventionComboBox);
    }

    protected void installInlineWidget(JPanel parentPanel) {
        this.inlineCheckBox = new GCheckBox("Inline");
        this.inlineCheckBox.addChangeListener(e -> {
            if (this.inlineCheckBox.isSelected() && this.callFixupComboBox != null) {
                this.callFixupComboBox.setSelectedItem(NONE_CHOICE);
            }
        });
        parentPanel.add(this.inlineCheckBox);
    }

    protected void installNoReturnWidget(JPanel parentPanel) {
        this.noReturnCheckBox = new GCheckBox("No Return");
        parentPanel.add(this.noReturnCheckBox);
    }

    private JPanel buildCallFixupPanel() {
        String[] callFixupNames = this.function.getProgram().getCompilerSpec().getPcodeInjectLibrary().getCallFixupNames();
        if (callFixupNames.length == 0) {
            return null;
        }
        JPanel callFixupPanel = new JPanel();
        callFixupPanel.setLayout(new BoxLayout(callFixupPanel, 0));
        this.callFixupComboBox = new GhidraComboBox();
        this.callFixupComboBox.addItem(NONE_CHOICE);
        for (String element : callFixupNames) {
            this.callFixupComboBox.addItem(element);
        }
        this.callFixupComboBox.addItemListener(e -> {
            if (e.getStateChange() == 2) {
                return;
            }
            if (!NONE_CHOICE.equals(e.getItem())) {
                this.inlineCheckBox.setSelected(false);
            }
        });
        String callFixupName = this.function.getCallFixup();
        if (callFixupName != null) {
            this.callFixupComboBox.setSelectedItem(callFixupName);
        }
        callFixupPanel.add((Component)new GLabel("Call-Fixup:"));
        callFixupPanel.add(this.callFixupComboBox);
        callFixupPanel.add(Box.createGlue());
        callFixupPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return callFixupPanel;
    }

    protected PluginTool getTool() {
        return this.tool;
    }

    protected Program getProgram() {
        return this.function.getProgram();
    }

    protected Function getFunction() {
        return this.function;
    }

    public String getSignature() {
        return this.signatureField.getText();
    }

    protected void setSignature(String signature) {
        this.signatureField.setText(signature);
    }

    protected void setCallingConventionChoices(String[] callingConventions) {
        this.callingConventionComboBox.removeAllItems();
        for (String element : callingConventions) {
            this.callingConventionComboBox.addItem(element);
        }
    }

    protected String getCallingConvention() {
        return (String)this.callingConventionComboBox.getSelectedItem();
    }

    protected void setCallingConvention(String callingConvention) {
        this.callingConventionComboBox.setSelectedItem(callingConvention);
    }

    protected boolean isInlineSelected() {
        return this.inlineCheckBox.isSelected();
    }

    protected void setInlineSelected(boolean selected) {
        this.inlineCheckBox.setSelected(selected);
    }

    protected boolean hasNoReturnSelected() {
        return this.noReturnCheckBox.isSelected();
    }

    protected void setNoReturnSelected(boolean selected) {
        this.noReturnCheckBox.setSelected(selected);
    }

    protected String getCallFixupSelection() {
        String callFixup;
        if (this.callFixupComboBox != null && (callFixup = (String)this.callFixupComboBox.getSelectedItem()) != null && !NONE_CHOICE.equals(callFixup)) {
            return callFixup;
        }
        return null;
    }

    protected void okCallback() {
        try {
            if (this.applyChanges()) {
                this.close();
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    protected void cancelCallback() {
        this.setStatusText("");
        this.close();
    }

    protected boolean applyChanges() throws CancelledException {
        Command command = this.createCommand();
        if (command == null) {
            return false;
        }
        if (!this.getTool().execute(command, (DomainObject)this.getProgram())) {
            this.setStatusText(command.getStatusMsg());
            return false;
        }
        this.setStatusText("");
        return true;
    }

    protected FunctionDefinitionDataType parseSignature() throws CancelledException {
        FunctionSignatureParser parser = new FunctionSignatureParser((DataTypeManager)this.getProgram().getDataTypeManager(), (DataTypeQueryService)this.tool.getService(DataTypeManagerService.class));
        try {
            return parser.parse(this.getFunction().getSignature(), this.getSignature());
        }
        catch (ParseException e) {
            this.setStatusText("Invalid Signature: " + e.getMessage());
            return null;
        }
    }

    private Command createCommand() throws CancelledException {
        ApplyFunctionSignatureCmd cmd = null;
        if (!this.getSignature().equals(this.oldFunctionSignature) || !this.isSameCallingConvention() || this.function.getSignatureSource() == SourceType.DEFAULT) {
            FunctionDefinitionDataType definition = this.parseSignature();
            cmd = new ApplyFunctionSignatureCmd(this.function.getEntryPoint(), (FunctionSignature)definition, SourceType.USER_DEFINED, true, true);
        }
        CompoundCmd compoundCommand = new CompoundCmd("Update Function Signature");
        compoundCommand.add(new Command(){
            String errMsg = null;

            public boolean applyTo(DomainObject obj) {
                try {
                    String conventionName = EditFunctionSignatureDialog.this.getCallingConvention();
                    if ("unknown".equals(conventionName)) {
                        conventionName = null;
                    } else if ("default".equals(conventionName)) {
                        conventionName = EditFunctionSignatureDialog.this.function.getDefaultCallingConventionName();
                    }
                    EditFunctionSignatureDialog.this.function.setCallingConvention(conventionName);
                    return true;
                }
                catch (InvalidInputException e) {
                    this.errMsg = "Invalid calling convention. " + e.getMessage();
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    return false;
                }
            }

            public String getName() {
                return "Update Function Calling Convention";
            }

            public String getStatusMsg() {
                return this.errMsg;
            }
        });
        compoundCommand.add(new Command(){

            public boolean applyTo(DomainObject obj) {
                EditFunctionSignatureDialog.this.function.setInline(EditFunctionSignatureDialog.this.isInlineSelected());
                return true;
            }

            public String getName() {
                return "Update Function Inline Flag";
            }

            public String getStatusMsg() {
                return null;
            }
        });
        compoundCommand.add(new Command(){

            public boolean applyTo(DomainObject obj) {
                EditFunctionSignatureDialog.this.function.setNoReturn(EditFunctionSignatureDialog.this.hasNoReturnSelected());
                return true;
            }

            public String getName() {
                return "Update Function No Return Flag";
            }

            public String getStatusMsg() {
                return null;
            }
        });
        compoundCommand.add(new Command(){

            public boolean applyTo(DomainObject obj) {
                EditFunctionSignatureDialog.this.function.setCallFixup(EditFunctionSignatureDialog.this.getCallFixupSelection());
                return true;
            }

            public String getName() {
                return "Update Function Call-Fixup";
            }

            public String getStatusMsg() {
                return null;
            }
        });
        if (cmd != null) {
            compoundCommand.add((Command)cmd);
        }
        return compoundCommand;
    }

    private boolean isSameCallingConvention() {
        PrototypeModel conv = this.function.getCallingConvention();
        if (conv == null && this.getCallingConvention() == null) {
            return true;
        }
        if (conv == null && this.getCallingConvention().equals("default")) {
            return true;
        }
        if (conv == null && this.getCallingConvention().equals("unknown")) {
            return true;
        }
        if (conv == null) {
            return false;
        }
        return conv.getName().equals(this.getCallingConvention());
    }

    protected void dialogShown() {
        this.signatureField.selectAll();
    }
}

