/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.widgets.OptionDialog;
import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.cmd.function.SetReturnDataTypeCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.function.AnalyzeStackRefsAction;
import ghidra.app.plugin.core.function.ChooseDataTypeAction;
import ghidra.app.plugin.core.function.ClearFunctionAction;
import ghidra.app.plugin.core.function.CreateArrayAction;
import ghidra.app.plugin.core.function.CreateExternalFunctionAction;
import ghidra.app.plugin.core.function.CreateFunctionAction;
import ghidra.app.plugin.core.function.CreateFunctionDefinitionAction;
import ghidra.app.plugin.core.function.CreateMultipleFunctionsAction;
import ghidra.app.plugin.core.function.CycleGroupAction;
import ghidra.app.plugin.core.function.DataAction;
import ghidra.app.plugin.core.function.DeleteFunctionAction;
import ghidra.app.plugin.core.function.EditFunctionAction;
import ghidra.app.plugin.core.function.EditFunctionPurgeAction;
import ghidra.app.plugin.core.function.EditNameAction;
import ghidra.app.plugin.core.function.EditOperandNameAction;
import ghidra.app.plugin.core.function.EditStructureAction;
import ghidra.app.plugin.core.function.EditThunkFunctionAction;
import ghidra.app.plugin.core.function.PointerDataAction;
import ghidra.app.plugin.core.function.RecentlyUsedAction;
import ghidra.app.plugin.core.function.RemoveStackDepthChangeAction;
import ghidra.app.plugin.core.function.RevertThunkFunctionAction;
import ghidra.app.plugin.core.function.SetStackDepthChangeAction;
import ghidra.app.plugin.core.function.VariableCommentAction;
import ghidra.app.plugin.core.function.VariableCommentDeleteAction;
import ghidra.app.plugin.core.function.VariableCommentDialog;
import ghidra.app.plugin.core.function.VariableDeleteAction;
import ghidra.app.plugin.core.function.VoidDataAction;
import ghidra.app.services.DataService;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.AddEditDialog;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.CycleGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypeManagerChangeListenerAdapter;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableSizeException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.FunctionCallingConventionFieldLocation;
import ghidra.program.util.FunctionInlineFieldLocation;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.FunctionNameFieldLocation;
import ghidra.program.util.FunctionNoReturnFieldLocation;
import ghidra.program.util.FunctionParameterFieldLocation;
import ghidra.program.util.FunctionReturnTypeFieldLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.FunctionThunkFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.program.util.VariableLocation;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Add/Remove/Edit Functions", description="Provides the actions for creating, editing, and deleting functions and the variables in them.  Users can change the signature, return type,variable names, variable datatypes and comments.", servicesRequired={ProgramManager.class, DataTypeManagerService.class}, servicesProvided={DataService.class})
public class FunctionPlugin
extends Plugin
implements DataService {
    static final DataType POINTER_DATA_TYPE = new PointerDataType();
    public static final String FUNCTION_MENU_SUBGROUP = "Function";
    public static final String THUNK_FUNCTION_MENU_SUBGROUP = "FunctionThunk";
    public static final String FUNCTION_MENU_PULLRIGHT = "Function";
    public static final String VARIABLE_MENU_SUBGROUP = "FunctionVariable";
    public static final String VARIABLE_MENU_PULLRIGHT = "Function Variables";
    public static final String FUNCTION_SUBGROUP_BEGINNING = "A_Beginning";
    public static final String FUNCTION_SUBGROUP_MIDDLE = "M_Middle";
    public static final String SET_DATA_TYPE_PULLRIGHT = "Set Data Type";
    public static final String STACK_MENU_SUBGROUP = "Stack";
    private static final String SET_DATA_TYPE_MENU_PATH = "Set DataType";
    static final String SET_RETURN_TYPE_MENU_PATH = "Set Return Type";
    private static final String SET_PARAMETER_TYPE_MENU_PATH = "Set Parameter Type";
    private CreateFunctionAction createFunctionAction;
    private CreateExternalFunctionAction createExternalFunctionAction;
    private CreateMultipleFunctionsAction createMultipleFunctionsAction;
    private CreateFunctionAction recreateFunctionAction;
    private CreateFunctionAction thunkFunctionAction;
    private EditThunkFunctionAction editThunkFunctionAction;
    private RevertThunkFunctionAction revertThunkFunctionAction;
    private ClearFunctionAction clearFunctionReturnValueAction;
    private ClearFunctionAction clearVariableDataTypeAction;
    private ClearFunctionAction clearFunctionParamterDataTypeAction;
    private CreateFunctionDefinitionAction createFunctionDefAction;
    private DeleteFunctionAction deleteFunctionAction;
    private VariableCommentAction variableCommentAction;
    private VariableCommentDeleteAction variableCommentDeleteAction;
    private EditNameAction editFunctionNameAction;
    private EditNameAction editVariableNameAction;
    private EditOperandNameAction editOperandNameAction;
    private VariableDeleteAction variableDeleteAction;
    private EditStructureAction editStructureAction;
    private RecentlyUsedAction recentlyUsedAction;
    private DataAction voidAction;
    private DataAction pointerAction;
    private CreateArrayAction arrayAction;
    private AnalyzeStackRefsAction analyzeStackRefsAction;
    private EditFunctionPurgeAction editFunctionPurgeAction;
    private ChooseDataTypeAction chooseDataTypeAction;
    private SetStackDepthChangeAction setStackDepthChangeAction;
    private RemoveStackDepthChangeAction removeStackDepthChangeAction;
    private DataTypeManagerService dtmService;
    private List<DataAction> favoriteActions = new ArrayList<DataAction>();
    private List<CycleGroupAction> cgActions = new ArrayList<CycleGroupAction>();
    private AddEditDialog functionNameDialog;
    private AddEditDialog variableNameDialog;
    private VariableCommentDialog variableCommentDialog;
    private DataTypeManagerChangeListenerAdapter adapter;
    private EditFunctionAction editFunctionAction;
    private SwingUpdateManager favoritesUpdateManager;

    public FunctionPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
        this.favoritesUpdateManager = new SwingUpdateManager(1000, 30000, () -> this.updateFavoriteActions());
    }

    protected void init() {
        this.initializeServices();
        this.addCycleGroupActions();
        this.updateFavoriteActions();
    }

    public void dispose() {
        this.favoritesUpdateManager.dispose();
        if (this.dtmService != null) {
            this.dtmService.removeDataTypeManagerChangeListener((DataTypeManagerChangeListener)this.adapter);
        }
        super.dispose();
        if (this.functionNameDialog != null) {
            this.functionNameDialog.close();
            this.functionNameDialog = null;
        }
        if (this.variableNameDialog != null) {
            this.variableNameDialog.close();
            this.variableNameDialog = null;
        }
        if (this.variableCommentDialog != null) {
            this.variableCommentDialog.close();
            this.variableCommentDialog = null;
        }
    }

    private void addCycleGroupActions() {
        for (int i = 0; i < this.cgActions.size(); ++i) {
            DockingAction action = this.cgActions.get(i);
            this.tool.removeAction((DockingActionIf)action);
        }
        this.cgActions.clear();
        for (CycleGroup group : CycleGroup.ALL_CYCLE_GROUPS) {
            CycleGroupAction action = new CycleGroupAction(group, this);
            this.tool.addAction((DockingActionIf)action);
            this.cgActions.add(action);
        }
    }

    private void initializeServices() {
        this.dtmService = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        this.adapter = new DataTypeManagerChangeListenerAdapter(){

            public void favoritesChanged(DataTypeManager dtm, DataTypePath path, boolean isFavorite) {
                FunctionPlugin.this.favoritesUpdateManager.update();
            }
        };
        this.dtmService.addDataTypeManagerChangeListener((DataTypeManagerChangeListener)this.adapter);
    }

    private void createActions() {
        this.recentlyUsedAction = new RecentlyUsedAction(this);
        this.recentlyUsedAction.setEnabled(false);
        this.tool.addAction((DockingActionIf)this.recentlyUsedAction);
        this.tool.setMenuGroup(new String[]{"Function"}, "Function", FUNCTION_SUBGROUP_MIDDLE);
        this.tool.setMenuGroup(new String[]{VARIABLE_MENU_PULLRIGHT}, "Function");
        this.tool.setMenuGroup(new String[]{SET_DATA_TYPE_PULLRIGHT}, "Function");
        this.clearFunctionReturnValueAction = new ClearFunctionAction("Clear Function Return Type", this, FunctionReturnTypeFieldLocation.class);
        this.tool.addAction((DockingActionIf)this.clearFunctionReturnValueAction);
        this.editFunctionAction = new EditFunctionAction(this);
        this.tool.addAction((DockingActionIf)this.editFunctionAction);
        this.clearVariableDataTypeAction = new ClearFunctionAction("Clear Variable Data Type", this, VariableLocation.class);
        this.tool.addAction((DockingActionIf)this.clearVariableDataTypeAction);
        this.clearFunctionParamterDataTypeAction = new ClearFunctionAction("Clear Parameter Data Type", this, FunctionParameterFieldLocation.class);
        this.tool.addAction((DockingActionIf)this.clearFunctionParamterDataTypeAction);
        this.createFunctionAction = new CreateFunctionAction("Create Function", this);
        this.tool.addAction((DockingActionIf)this.createFunctionAction);
        this.createExternalFunctionAction = new CreateExternalFunctionAction("Create External Function", this);
        this.tool.addAction((DockingActionIf)this.createExternalFunctionAction);
        this.createMultipleFunctionsAction = new CreateMultipleFunctionsAction("Create Multiple Functions", this);
        this.tool.addAction((DockingActionIf)this.createMultipleFunctionsAction);
        this.recreateFunctionAction = new CreateFunctionAction("Re-create Function", this, true, false);
        this.tool.addAction((DockingActionIf)this.recreateFunctionAction);
        this.thunkFunctionAction = new CreateFunctionAction("Create Thunk Function", this, false, true);
        this.tool.addAction((DockingActionIf)this.thunkFunctionAction);
        this.editThunkFunctionAction = new EditThunkFunctionAction(this);
        this.tool.addAction((DockingActionIf)this.editThunkFunctionAction);
        this.revertThunkFunctionAction = new RevertThunkFunctionAction(this);
        this.tool.addAction((DockingActionIf)this.revertThunkFunctionAction);
        this.createFunctionDefAction = new CreateFunctionDefinitionAction(this);
        this.tool.addAction((DockingActionIf)this.createFunctionDefAction);
        this.deleteFunctionAction = new DeleteFunctionAction(this);
        this.tool.addAction((DockingActionIf)this.deleteFunctionAction);
        this.editOperandNameAction = new EditOperandNameAction(this);
        this.tool.addAction((DockingActionIf)this.editOperandNameAction);
        this.editFunctionNameAction = new EditNameAction(true, this);
        this.tool.addAction((DockingActionIf)this.editFunctionNameAction);
        this.analyzeStackRefsAction = new AnalyzeStackRefsAction(this);
        this.tool.addAction((DockingActionIf)this.analyzeStackRefsAction);
        this.editFunctionPurgeAction = new EditFunctionPurgeAction(this);
        this.tool.addAction((DockingActionIf)this.editFunctionPurgeAction);
        this.setStackDepthChangeAction = new SetStackDepthChangeAction(this);
        this.tool.addAction((DockingActionIf)this.setStackDepthChangeAction);
        this.removeStackDepthChangeAction = new RemoveStackDepthChangeAction(this);
        this.tool.addAction((DockingActionIf)this.removeStackDepthChangeAction);
        this.editVariableNameAction = new EditNameAction(false, this);
        this.tool.addAction((DockingActionIf)this.editVariableNameAction);
        this.variableDeleteAction = new VariableDeleteAction(this);
        this.tool.addAction((DockingActionIf)this.variableDeleteAction);
        this.variableCommentAction = new VariableCommentAction(this);
        this.tool.addAction((DockingActionIf)this.variableCommentAction);
        this.variableCommentDeleteAction = new VariableCommentDeleteAction(this);
        this.tool.addAction((DockingActionIf)this.variableCommentDeleteAction);
        this.voidAction = new VoidDataAction(this);
        this.tool.addAction((DockingActionIf)this.voidAction);
        this.pointerAction = new PointerDataAction(this);
        this.tool.addAction((DockingActionIf)this.pointerAction);
        this.arrayAction = new CreateArrayAction(this);
        this.tool.addAction((DockingActionIf)this.arrayAction);
        this.editStructureAction = new EditStructureAction(this);
        this.tool.addAction((DockingActionIf)this.editStructureAction);
        this.chooseDataTypeAction = new ChooseDataTypeAction(this);
        this.tool.addAction((DockingActionIf)this.chooseDataTypeAction);
    }

    int getMaxVariableSize(ListingActionContext context) {
        VariableLocation varLoc;
        Variable var;
        int maxSize = Integer.MAX_VALUE;
        ProgramLocation location = context.getLocation();
        if (location instanceof VariableLocation && (var = (varLoc = (VariableLocation)location).getVariable()).isStackVariable()) {
            Function fun = this.getFunction(context);
            int size = this.getMaxStackVariableSize(fun, var);
            maxSize = size < 0 ? Integer.MAX_VALUE : size;
        }
        return maxSize;
    }

    protected void execute(Program program, Command cmd) {
        if (!this.tool.execute(cmd, (DomainObject)program)) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)cmd.getName(), (Object)cmd.getStatusMsg());
        }
    }

    protected void execute(Program program, BackgroundCommand cmd) {
        this.tool.executeBackgroundCommand(cmd, (UndoableDomainObject)program);
    }

    boolean isValidDataLocation(ProgramLocation location) {
        if (!(location instanceof FunctionSignatureFieldLocation)) {
            return false;
        }
        return !(location instanceof FunctionThunkFieldLocation) && !(location instanceof FunctionCallingConventionFieldLocation) && !(location instanceof FunctionInlineFieldLocation) && !(location instanceof FunctionNameFieldLocation) && !(location instanceof FunctionNoReturnFieldLocation) && !(location instanceof FunctionInlineFieldLocation);
    }

    String getDataActionMenuName(ProgramLocation location) {
        if (location instanceof FunctionParameterFieldLocation) {
            return SET_PARAMETER_TYPE_MENU_PATH;
        }
        if (location instanceof FunctionReturnTypeFieldLocation) {
            return SET_RETURN_TYPE_MENU_PATH;
        }
        return SET_DATA_TYPE_MENU_PATH;
    }

    public Iterator<Function> getFunctions(ListingActionContext context) {
        ProgramSelection selection = context.getSelection();
        Program program = context.getProgram();
        ProgramLocation location = context.getLocation();
        if (selection != null && !selection.isEmpty()) {
            return program.getFunctionManager().getFunctionsOverlapping((AddressSetView)selection);
        }
        if (location != null) {
            Address loc = location.getAddress();
            return program.getFunctionManager().getFunctionsOverlapping((AddressSetView)new AddressSet(loc, loc));
        }
        return Collections.emptyIterator();
    }

    Function getFunction(ListingActionContext context) {
        ProgramLocation loc = context.getLocation();
        Address entry = loc instanceof FunctionLocation ? ((FunctionLocation)loc).getFunctionAddress() : context.getAddress();
        if (entry == null) {
            return null;
        }
        return context.getProgram().getListing().getFunctionAt(entry);
    }

    Function getFunctionInOperandField(Program program, OperandFieldLocation opLoc) {
        if (program == null) {
            return null;
        }
        Address refAddr = opLoc.getRefAddress();
        if (refAddr != null) {
            return program.getFunctionManager().getFunctionAt(refAddr);
        }
        return null;
    }

    @Override
    public boolean isCreateDataAllowed(ListingActionContext context) {
        return context.getLocation() instanceof FunctionLocation;
    }

    public boolean isCreateFunctionAllowed(ListingActionContext context, boolean allowExisting, boolean createThunk) {
        Function func;
        Program program = context.getProgram();
        if (program == null) {
            return false;
        }
        ProgramLocation location = context.getLocation();
        if (location == null) {
            return false;
        }
        Address addr = location.getAddress();
        if (addr == null) {
            return false;
        }
        boolean cursorIsInSelection = false;
        ProgramSelection selection = context.getSelection();
        if (selection != null && !selection.isEmpty()) {
            addr = selection.getMinAddress();
            cursorIsInSelection = true;
        }
        if ((func = program.getListing().getFunctionAt(addr)) == null && !allowExisting || func != null && allowExisting && !func.isThunk()) {
            if (cursorIsInSelection) {
                return true;
            }
            if (program.getListing().getInstructionContaining(addr) != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean createData(DataType dt, ListingActionContext programActionContext, boolean enableConflictHandling) {
        return this.createData(dt, programActionContext, true, enableConflictHandling);
    }

    public boolean createData(DataType dataType, ListingActionContext context, boolean convertPointers, boolean promptForConflictRemoval) {
        Function function;
        ProgramLocation location = context.getLocation();
        Program program = context.getProgram();
        if (!(location instanceof FunctionLocation)) {
            this.tool.setStatusInfo("Unsupported function location for data-type");
            return false;
        }
        if (dataType != DataType.DEFAULT && dataType != DataType.VOID) {
            this.dtmService.setRecentlyUsed(dataType);
        }
        if ((function = this.getFunction(context)) == null) {
            this.tool.setStatusInfo("Unsupported function location for data-type");
            return false;
        }
        if (location instanceof FunctionSignatureFieldLocation && dataType instanceof FunctionSignature) {
            return this.tool.execute((Command)new ApplyFunctionSignatureCmd(function.getEntryPoint(), (FunctionSignature)dataType, SourceType.USER_DEFINED), (DomainObject)program);
        }
        DataType existingDT = this.getCurrentDataType(context);
        dataType = DataUtilities.reconcileAppliedDataType((DataType)existingDT, (DataType)dataType, (boolean)convertPointers);
        if (dataType.getLength() < 0) {
            this.tool.setStatusInfo("Only fixed-length data-type permitted");
            return false;
        }
        if (location instanceof FunctionParameterFieldLocation) {
            FunctionParameterFieldLocation parameterLocation = (FunctionParameterFieldLocation)location;
            Parameter parameter = parameterLocation.getParameter();
            return this.setVariableDataType((Variable)parameter, dataType, promptForConflictRemoval);
        }
        if (location instanceof FunctionSignatureFieldLocation) {
            SourceType source = dataType == DataType.DEFAULT ? SourceType.DEFAULT : SourceType.USER_DEFINED;
            return this.tool.execute((Command)new SetReturnDataTypeCmd(function.getEntryPoint(), dataType, source), (DomainObject)program);
        }
        if (location instanceof VariableLocation) {
            Variable variable = ((VariableLocation)location).getVariable();
            return this.setVariableDataType(variable, dataType, promptForConflictRemoval);
        }
        this.tool.setStatusInfo("Unsupported function location for data-type");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setVariableDataType(Variable variable, DataType dataType, boolean promptForConflictRemoval) {
        String varType = variable instanceof Parameter ? "Parameter" : "Local Variable";
        Program program = variable.getFunction().getProgram();
        int txId = program.startTransaction("Set " + varType + " Data-type");
        try {
            variable.setDataType(dataType, true, false, SourceType.USER_DEFINED);
            this.tool.setStatusInfo("");
            boolean bl = true;
            return bl;
        }
        catch (VariableSizeException e) {
            this.tool.setStatusInfo(e.getMessage());
            if (e.canForce() && promptForConflictRemoval) {
                String msg = varType + " " + variable.getName() + " size change resulted in \n" + e.getMessage() + "\n \nDelete conflicting " + varType + "(s)";
                if (1 == OptionDialog.showYesNoDialog((Component)this.tool.getActiveWindow(), (String)(varType + " Conflict"), (String)msg)) {
                    this.tool.setStatusInfo("");
                    try {
                        variable.setDataType(dataType, true, true, SourceType.USER_DEFINED);
                        boolean bl = true;
                        return bl;
                    }
                    catch (InvalidInputException e1) {
                        this.tool.setStatusInfo(e.getMessage());
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            this.tool.setStatusInfo(e.getMessage());
        }
        finally {
            program.endTransaction(txId, true);
        }
        return false;
    }

    protected DataType getCurrentDataType(ListingActionContext context) {
        Program program = context.getProgram();
        ProgramLocation loc = context.getLocation();
        if (loc instanceof FunctionParameterFieldLocation) {
            Parameter parm = ((FunctionParameterFieldLocation)loc).getParameter();
            return parm.getFormalDataType();
        }
        if (loc instanceof FunctionSignatureFieldLocation) {
            Address funcEntry = ((FunctionSignatureFieldLocation)loc).getFunctionAddress();
            Function fun = program.getFunctionManager().getFunctionAt(funcEntry);
            return fun.getReturn().getFormalDataType();
        }
        if (loc instanceof VariableLocation) {
            Variable var = ((VariableLocation)loc).getVariable();
            if (var instanceof Parameter) {
                return ((Parameter)var).getFormalDataType();
            }
            return var.getDataType();
        }
        return null;
    }

    int getMaxStackVariableSize(Function fun, Variable var) {
        StackFrame frame = fun.getStackFrame();
        Variable[] vars = frame.getStackVariables();
        int offset = var.getStackOffset();
        int fuOffset = var.getFirstUseOffset();
        boolean isParam = var instanceof Parameter;
        if (frame.growsNegative() == !isParam) {
            Variable var2;
            Variable v;
            int voff;
            if (offset >= fun.getStackFrame().getParameterOffset()) {
                throw new IllegalArgumentException("invalid stack offset for variable type");
            }
            Variable[] variableArray = vars;
            int n = variableArray.length;
            for (int i = 0; i < n && (voff = (v = (var2 = variableArray[i])).getStackOffset()) < 0; ++i) {
                if (v.getFirstUseOffset() != fuOffset || voff <= offset || !isParam && Undefined.isUndefined((DataType)v.getDataType())) continue;
                return voff - offset;
            }
            return -offset;
        }
        if (offset < fun.getStackFrame().getParameterOffset()) {
            throw new IllegalArgumentException("invalid stack offset for variable type");
        }
        for (Variable var2 : vars) {
            Variable v = var2;
            int voff = v.getStackOffset();
            if (voff <= 0 || v.getFirstUseOffset() != fuOffset || voff <= offset || !isParam && Undefined.isUndefined((DataType)v.getDataType())) continue;
            return voff - offset;
        }
        return -1;
    }

    private void updateFavoriteActions() {
        this.clearActions(this.favoriteActions);
        DataAction action = new DataAction(DataType.DEFAULT, this);
        this.tool.addAction((DockingActionIf)action);
        this.favoriteActions.add(action);
        List<DataType> favorites = this.dtmService.getFavorites();
        for (DataType dataType : favorites) {
            if (dataType.isEquivalent(POINTER_DATA_TYPE) || dataType.isEquivalent(DataType.VOID)) continue;
            action = new DataAction(dataType, this);
            this.tool.addAction((DockingActionIf)action);
            this.favoriteActions.add(action);
        }
    }

    private void clearActions(List<? extends DockingAction> actions) {
        for (DockingAction dockingAction : actions) {
            this.tool.removeAction((DockingActionIf)dockingAction);
            dockingAction.dispose();
        }
        actions.clear();
    }

    public VariableCommentDialog getVariableCommentDialog() {
        if (this.variableCommentDialog == null) {
            this.variableCommentDialog = new VariableCommentDialog(this);
        }
        return this.variableCommentDialog;
    }

    public DataTypeManagerService getDataTypeManagerService() {
        return this.dtmService;
    }
}

