/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import ghidra.app.plugin.core.function.editor.ModelChangeListener;
import ghidra.app.plugin.core.function.editor.ParamInfo;
import ghidra.app.plugin.core.function.editor.VarnodeInfo;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.cparser.C.ParseException;
import ghidra.app.util.parser.FunctionSignatureParser;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.AutoParameterImpl;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class FunctionEditorModel {
    public static final String PARSING_MODE_STATUS_TEXT = "<TAB> or <RETURN> to commit edits, <ESC> to abort";
    static final String NONE_CHOICE = "-NONE-";
    private String name;
    private ModelChangeListener listener;
    private boolean hasVarArgs;
    private ParamInfo returnInfo;
    private List<ParamInfo> parameters = new ArrayList<ParamInfo>();
    private int autoParamCount = 0;
    private String statusText = "";
    private boolean isValid = true;
    private boolean signatureTransformed = false;
    private boolean isInLine;
    private boolean isNoReturn;
    private String callingConventionName;
    private Function function;
    private FunctionManager functionManager;
    private String callFixupName;
    private int[] selectedFunctionRows = new int[0];
    private Program program;
    private boolean allowCustomStorage;
    private boolean isInParsingMode;
    private String signatureFieldText;
    private DataTypeManagerService dataTypeManagerService;
    private boolean modelChanged = false;

    public FunctionEditorModel(DataTypeManagerService service, Function function) {
        this.dataTypeManagerService = service;
        this.function = function;
        this.program = function.getProgram();
        this.name = function.getName();
        this.functionManager = this.program.getFunctionManager();
        this.allowCustomStorage = function.hasCustomVariableStorage();
        this.hasVarArgs = function.hasVarArgs();
        this.isInLine = function.isInline();
        this.isNoReturn = function.hasNoReturn();
        this.callingConventionName = function.getCallingConventionName();
        this.callFixupName = function.getCallFixup();
        if (this.callFixupName == null) {
            this.callFixupName = NONE_CHOICE;
        }
        this.initializeParametersAndReturn();
        this.validate();
    }

    void setModelChangeListener(ModelChangeListener listener) {
        this.listener = listener;
    }

    private PrototypeModel getEffectiveCallingConvention() {
        PrototypeModel effectiveCallingConvention = this.functionManager.getCallingConvention(this.callingConventionName);
        if (effectiveCallingConvention == null) {
            effectiveCallingConvention = this.functionManager.getDefaultCallingConvention();
        }
        return effectiveCallingConvention;
    }

    private void initializeParametersAndReturn() {
        Parameter[] params;
        this.returnInfo = new ParamInfo(this, this.function.getReturn());
        this.autoParamCount = 0;
        for (Parameter parameter : params = this.function.getParameters()) {
            if (parameter.isAutoParameter()) {
                ++this.autoParamCount;
            }
            this.parameters.add(new ParamInfo(this, parameter));
        }
        this.fixupOrdinals();
    }

    private boolean hasModifiedParametersOrReturn() {
        if (this.returnInfo.isModified()) {
            return true;
        }
        if (this.function.getParameterCount() - this.function.getAutoParameterCount() != this.parameters.size() - this.autoParamCount) {
            return true;
        }
        for (ParamInfo info : this.parameters) {
            if (info.isAutoParameter() || !info.isModified()) continue;
            return true;
        }
        return false;
    }

    public List<String> getCallingConventionNames() {
        return this.functionManager.getCallingConventionNames();
    }

    public String[] getCallFixupNames() {
        return this.program.getCompilerSpec().getPcodeInjectLibrary().getCallFixupNames();
    }

    public void setName(String name) {
        if (this.name.equals(name)) {
            return;
        }
        this.name = name.trim();
        this.notifyDataChanged();
    }

    public void setCallingConventionName(String callingConventionName) {
        this.callingConventionName = callingConventionName;
        this.removeExplicitThisParameter();
        this.updateParameterAndReturnStorage();
        this.notifyDataChanged();
    }

    public String getCallingConventionName() {
        return this.callingConventionName;
    }

    public void setHasVarArgs(boolean b) {
        this.hasVarArgs = b;
        this.notifyDataChanged();
    }

    public String getName() {
        return this.name;
    }

    public void dispose() {
        this.listener = new ModelChangeListener(){

            @Override
            public void tableRowsChanged() {
            }

            @Override
            public void dataChanged() {
            }
        };
    }

    private void notifyDataChanged() {
        this.notifyDataChanged(true);
    }

    private void notifyDataChanged(boolean functionDataChanged) {
        this.modelChanged |= functionDataChanged;
        this.validate();
        SwingUtilities.invokeLater(() -> this.listener.dataChanged());
    }

    private void validate() {
        this.statusText = "";
        if (this.signatureTransformed) {
            this.statusText = "Signature transformed due to auto-params and/or forced-indirect storage";
            this.signatureTransformed = false;
        }
        boolean bl = this.isValid = this.hasValidName() && this.hasValidReturnType() && this.hasValidReturnStorage() && this.hasValidParams();
        if (this.isValid) {
            this.checkUnassignedStorage();
        }
    }

    private boolean hasValidReturnStorage() {
        if (!this.allowCustomStorage) {
            return true;
        }
        VariableStorage returnStorage = this.returnInfo.getStorage();
        DataType returnType = this.returnInfo.getDataType();
        if (returnStorage.isUnassignedStorage()) {
            return true;
        }
        int storageSize = returnStorage.size();
        if (returnType instanceof TypeDef) {
            returnType = ((TypeDef)returnType).getBaseDataType();
        }
        if (storageSize > 0 && returnType instanceof AbstractFloatDataType) {
            return true;
        }
        int returnDataTypeSize = returnType.getLength();
        if (storageSize < returnDataTypeSize) {
            this.statusText = "Insufficient Return Storage (" + storageSize + "-bytes) for datatype (" + returnDataTypeSize + "-bytes)";
            return false;
        }
        if (storageSize > returnDataTypeSize) {
            this.statusText = "Too much Return Storage (" + storageSize + "-bytes) for datatype (" + returnDataTypeSize + "-bytes)";
            return false;
        }
        return true;
    }

    private void checkUnassignedStorage() {
        boolean hasUnassignedStorage;
        VariableStorage returnStorage = this.returnInfo.getStorage();
        DataType returnType = this.returnInfo.getFormalDataType();
        boolean bl = hasUnassignedStorage = returnStorage != null && returnStorage.isUnassignedStorage();
        if (!hasUnassignedStorage) {
            for (ParamInfo param : this.parameters) {
                if (!param.getStorage().isUnassignedStorage()) continue;
                hasUnassignedStorage = true;
                break;
            }
        }
        if (hasUnassignedStorage) {
            this.statusText = "Warning: Return Storage and/or Parameter Storage is Unassigned";
        } else if (!(this.allowCustomStorage || !"unknown".equals(this.callingConventionName) || returnType instanceof VoidDataType && this.parameters.isEmpty())) {
            this.statusText = "Warning: No calling convention specified. Ghidra may automatically assign one later.";
        }
    }

    private boolean hasValidParams() {
        for (ParamInfo param : this.parameters) {
            if (this.isValidParamType(param) && this.isValidParamName(param) && this.isValidStorage(param)) continue;
            return false;
        }
        return this.checkForConflictingParameters();
    }

    private boolean checkForConflictingParameters() {
        return true;
    }

    private boolean isValidStorage(ParamInfo param) {
        if (!this.allowCustomStorage) {
            return true;
        }
        VariableStorage storage = param.getStorage();
        if (storage.isUnassignedStorage()) {
            return true;
        }
        int storageSize = storage.size();
        DataType datatype = param.getDataType();
        if (datatype instanceof TypeDef) {
            datatype = ((TypeDef)datatype).getBaseDataType();
        }
        if (storageSize > 0 && datatype instanceof AbstractFloatDataType) {
            return true;
        }
        int requiredSize = datatype.getLength();
        if (storageSize < requiredSize) {
            this.statusText = "Insufficient storage (" + storageSize + "-bytes) for datatype (" + requiredSize + "-bytes) assigned to parameter " + (param.getOrdinal() + 1);
            return false;
        }
        if (requiredSize != 0 && storageSize > requiredSize) {
            this.statusText = "Too much storage (" + storageSize + "-bytes) for datatype (" + requiredSize + "-bytes) assigned to parameter " + (param.getOrdinal() + 1);
            return false;
        }
        return true;
    }

    public boolean hasValidName() {
        if (this.name.length() == 0) {
            this.statusText = "Missing function name";
            return false;
        }
        if (SymbolUtilities.containsInvalidChars((String)this.name)) {
            this.statusText = "Invalid function name: \"" + this.name + "\"";
            return false;
        }
        return true;
    }

    private DataType getBaseDataType(DataType dataType) {
        if (dataType instanceof TypeDef) {
            return ((TypeDef)dataType).getBaseDataType();
        }
        return dataType;
    }

    private boolean hasValidReturnType() {
        DataType returnType = this.returnInfo.getDataType();
        DataType baseType = this.getBaseDataType(returnType);
        if (baseType instanceof VoidDataType) {
            return true;
        }
        if (returnType.getLength() <= 0) {
            this.statusText = "\"" + returnType.getName() + "\" is not allowed as a return type: Must be fixed size.";
            return false;
        }
        return true;
    }

    private boolean isValidParamName(ParamInfo param) {
        String paramName = param.getName();
        if (SymbolUtilities.containsInvalidChars((String)paramName)) {
            this.statusText = "Invalid name for parameter " + (param.getOrdinal() + 1) + ": " + paramName;
            return false;
        }
        for (ParamInfo info : this.parameters) {
            if (info == param || !info.getName().equals(paramName)) continue;
            this.statusText = "Duplicate parameter name: " + paramName;
            return false;
        }
        return true;
    }

    private boolean isValidParamType(ParamInfo param) {
        DataType dataType = param.getDataType();
        if (dataType.isEquivalent(DataType.VOID)) {
            this.statusText = "\"void\" is not allowed as a parameter datatype.";
            return false;
        }
        if (dataType.getLength() < 0) {
            this.statusText = "\"" + dataType.getName() + "\" is not allowed as a parameter datatype. Must be fixed size.";
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getFunctionSignatureTextFromModel() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.returnInfo.getFormalDataType().getName()).append(" ");
        buf.append(this.getNameString());
        buf.append(" (");
        int skipCount = this.autoParamCount;
        int ordinal = 0;
        for (ParamInfo param : this.parameters) {
            if (skipCount > 0) {
                --skipCount;
                continue;
            }
            if (ordinal++ != 0) {
                buf.append(", ");
            }
            buf.append(param.getFormalDataType().getName());
            buf.append(" ");
            buf.append(this.getParamNameString(param));
        }
        if (this.hasVarArgs()) {
            if (!this.parameters.isEmpty()) {
                buf.append(", ");
            }
            buf.append("...");
        } else if (this.parameters.size() == 0) {
            buf.append("void");
        }
        buf.append(')');
        return buf.toString();
    }

    public String getNameString() {
        return this.name.length() == 0 ? "?" : this.name;
    }

    private String getParamNameString(ParamInfo param) {
        return param.getName();
    }

    public boolean hasVarArgs() {
        return this.hasVarArgs;
    }

    public DataType getReturnType() {
        return this.returnInfo.getDataType();
    }

    public DataType getFormalReturnType() {
        return this.returnInfo.getFormalDataType();
    }

    public void setFormalReturnType(DataType formalReturnType) {
        this.setParameterFormalDataType(this.returnInfo, formalReturnType);
    }

    public String getStatusText() {
        if (this.isInParsingMode) {
            return PARSING_MODE_STATUS_TEXT;
        }
        return this.statusText;
    }

    public void setIsInLine(boolean isInLine) {
        if (isInLine == this.isInLine) {
            return;
        }
        this.isInLine = isInLine;
        if (isInLine) {
            this.callFixupName = NONE_CHOICE;
        }
        this.notifyDataChanged();
    }

    public void setNoReturn(boolean isNoReturn) {
        this.isNoReturn = isNoReturn;
        this.notifyDataChanged();
    }

    public boolean isInlineAllowed() {
        return !this.getAffectiveFunction().isExternal();
    }

    private Function getAffectiveFunction() {
        return this.function.isThunk() ? this.function.getThunkedFunction(true) : this.function;
    }

    public boolean isInLine() {
        return this.isInLine;
    }

    public boolean isNoReturn() {
        return this.isNoReturn;
    }

    public String getCallFixupName() {
        return this.callFixupName;
    }

    public void setCallFixupName(String callFixupName) {
        if (callFixupName.equals(this.callFixupName)) {
            return;
        }
        this.callFixupName = callFixupName;
        if (!callFixupName.equals(NONE_CHOICE)) {
            this.isInLine = false;
        }
        this.notifyDataChanged();
    }

    public void setSelectedParameterRow(int[] selectedRows) {
        this.selectedFunctionRows = selectedRows;
        this.notifyDataChanged();
    }

    private void setSelectedRow(int row) {
        this.selectedFunctionRows = new int[]{row};
    }

    private void adjustSelectionForRowRemoved(int row) {
        if (this.selectedFunctionRows.length == 0) {
            return;
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i : this.selectedFunctionRows) {
            if (i < row) {
                rows.add(i);
            }
            if (i <= row) continue;
            rows.add(i - 1);
        }
        this.selectedFunctionRows = new int[rows.size()];
        int index = 0;
        Iterator iterator = rows.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.selectedFunctionRows[index++] = i;
        }
    }

    private void adjustSelectionForRowAdded(int row) {
        if (this.selectedFunctionRows.length == 0) {
            return;
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i : this.selectedFunctionRows) {
            if (i < row) {
                rows.add(i);
            }
            if (i < row) continue;
            rows.add(i + 1);
        }
        this.selectedFunctionRows = new int[rows.size()];
        int index = 0;
        Iterator iterator = rows.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.selectedFunctionRows[index++] = i;
        }
    }

    public int[] getSelectedParameterRows() {
        return this.selectedFunctionRows;
    }

    public void addParameter() {
        this.listener.tableRowsChanged();
        ParamInfo param = new ParamInfo(this, null, DataType.DEFAULT, VariableStorage.UNASSIGNED_STORAGE, this.parameters.size());
        this.parameters.add(param);
        this.fixupOrdinals();
        this.updateParameterAndReturnStorage();
        this.setSelectedRow(this.parameters.size());
        this.notifyDataChanged();
    }

    private void switchToCustomStorage() {
        try {
            VariableStorage returnStorage = this.returnInfo.getStorage();
            if (returnStorage.isForcedIndirect()) {
                DataType returnType = this.returnInfo.getDataType();
                this.returnInfo.setFormalDataType(returnType);
                this.returnInfo.setStorage(returnStorage.clone(this.program));
                this.signatureTransformed = true;
            }
            this.autoParamCount = 0;
            int paramCnt = this.parameters.size();
            for (int i = 0; i < paramCnt; ++i) {
                ParamInfo paramInfo = this.parameters.get(i);
                DataType dt = paramInfo.getDataType();
                VariableStorage storage = paramInfo.getStorage();
                this.signatureTransformed |= storage.isAutoStorage();
                paramInfo.setFormalDataType(dt);
                paramInfo.setStorage(storage.clone(this.program));
            }
        }
        catch (InvalidInputException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private void updateParameterAndReturnStorage() {
        int i;
        if (this.allowCustomStorage) {
            return;
        }
        PrototypeModel effectiveCallingConvention = this.getEffectiveCallingConvention();
        if (effectiveCallingConvention == null) {
            for (ParamInfo info : this.parameters) {
                info.setStorage(VariableStorage.UNASSIGNED_STORAGE);
            }
            return;
        }
        DataType[] dataTypes = new DataType[this.parameters.size() - this.autoParamCount + 1];
        dataTypes[0] = this.returnInfo.getFormalDataType();
        int index = 1;
        for (int i2 = this.autoParamCount; i2 < this.parameters.size(); ++i2) {
            dataTypes[index++] = this.parameters.get(i2).getFormalDataType();
        }
        VariableStorage[] paramStorage = effectiveCallingConvention.getStorageLocations(this.program, dataTypes, true);
        this.returnInfo.setStorage(paramStorage[0]);
        List<ParamInfo> oldParams = this.parameters;
        int oldAutoCount = this.autoParamCount;
        this.parameters = new ArrayList<ParamInfo>();
        this.autoParamCount = 0;
        int ordinal = 0;
        for (i = 1; i < paramStorage.length; ++i) {
            ParamInfo info;
            VariableStorage storage = paramStorage[i];
            if (storage.isAutoStorage()) {
                DataType dt = VariableUtilities.getAutoDataType((Function)this.function, (DataType)this.returnInfo.getFormalDataType(), (VariableStorage)storage);
                try {
                    if (this.autoParamCount < oldAutoCount) {
                        if (oldParams.get(this.autoParamCount).getStorage().getAutoParameterType() != storage.getAutoParameterType()) {
                            this.adjustSelectionForRowRemoved(i);
                        }
                    } else {
                        this.adjustSelectionForRowAdded(i);
                    }
                    info = new ParamInfo(this, (Parameter)new AutoParameterImpl(dt, ++this.autoParamCount, storage, this.function));
                }
                catch (InvalidInputException e) {
                    throw new AssertException((Throwable)e);
                }
            } else {
                info = oldParams.get(oldAutoCount + ordinal);
                info.setStorage(storage);
                ++ordinal;
            }
            this.parameters.add(info);
        }
        for (i = oldAutoCount; i > this.autoParamCount; --i) {
            this.adjustSelectionForRowRemoved(i);
        }
        this.fixupOrdinals();
    }

    private void fixupOrdinals() {
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.parameters.get(i).setOrdinal(i);
        }
    }

    public void removeParameters() {
        if (!this.canRemoveParameters()) {
            throw new AssertException("Attempted to remove parameters when not allowed.");
        }
        this.listener.tableRowsChanged();
        Arrays.sort(this.selectedFunctionRows);
        for (int i = this.selectedFunctionRows.length - 1; i >= 0; --i) {
            int index = this.selectedFunctionRows[i];
            this.parameters.remove(index - 1);
        }
        if (this.parameters.isEmpty()) {
            this.selectedFunctionRows = new int[0];
        } else {
            int selectRow = Math.min(this.selectedFunctionRows[0], this.parameters.size());
            this.selectedFunctionRows = new int[]{selectRow};
        }
        this.fixupOrdinals();
        this.updateParameterAndReturnStorage();
        this.notifyDataChanged();
    }

    public void moveSelectedParameterUp() {
        if (!this.canMoveParameterUp()) {
            throw new AssertException("Attempted to move parameters up when not allowed.");
        }
        this.listener.tableRowsChanged();
        int paramIndex = this.selectedFunctionRows[0] - 1;
        ParamInfo param = this.parameters.remove(paramIndex);
        this.parameters.add(paramIndex - 1, param);
        this.fixupOrdinals();
        this.setSelectedRow(this.selectedFunctionRows[0] - 1);
        this.updateParameterAndReturnStorage();
        this.notifyDataChanged();
    }

    public void moveSelectedParameterDown() {
        if (!this.canMoveParameterDown()) {
            throw new AssertException("Attempted to move parameters down when not allowed.");
        }
        this.listener.tableRowsChanged();
        int paramIndex = this.selectedFunctionRows[0] - 1;
        ParamInfo param = this.parameters.remove(paramIndex);
        this.parameters.add(paramIndex + 1, param);
        this.fixupOrdinals();
        this.setSelectedRow(this.selectedFunctionRows[0] + 1);
        this.updateParameterAndReturnStorage();
        this.notifyDataChanged();
    }

    public List<ParamInfo> getParameters() {
        return this.parameters;
    }

    public boolean canRemoveParameters() {
        if (this.selectedFunctionRows.length == 0) {
            return false;
        }
        for (int row : this.selectedFunctionRows) {
            if (row > this.autoParamCount) continue;
            return false;
        }
        return true;
    }

    public boolean canMoveParameterUp() {
        int minRowToMoveUp = 2 + this.autoParamCount;
        if (this.parameters.size() > 0 && this.parameters.get(0).getName().equals("this")) {
            ++minRowToMoveUp;
        }
        return this.selectedFunctionRows.length == 1 && this.selectedFunctionRows[0] >= minRowToMoveUp;
    }

    public boolean canMoveParameterDown() {
        int selectedRow;
        if (this.selectedFunctionRows.length != 1) {
            return false;
        }
        int minRowToMoveDown = 1 + this.autoParamCount;
        if (this.parameters.size() > 0 && this.parameters.get(0).getName().equals("this")) {
            ++minRowToMoveDown;
        }
        return (selectedRow = this.selectedFunctionRows[0]) >= minRowToMoveDown && selectedRow < this.parameters.size();
    }

    public void setParameterName(ParamInfo param, String newName) {
        param.setName(newName);
        this.notifyDataChanged();
    }

    public void setParameterFormalDataType(ParamInfo param, DataType formalDataType) {
        boolean isReturn = param.getOrdinal() == -1;
        try {
            formalDataType = VariableUtilities.checkDataType((DataType)formalDataType, (boolean)isReturn, (int)0, (Program)this.program);
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)this, null, (String)"Invalid Data Type", (Object)e.getMessage());
            return;
        }
        if (formalDataType.equals(param.getFormalDataType())) {
            return;
        }
        param.setFormalDataType(formalDataType.clone((DataTypeManager)this.program.getDataTypeManager()));
        if (this.allowCustomStorage) {
            if (isReturn && formalDataType instanceof VoidDataType) {
                param.setStorage(VariableStorage.VOID_STORAGE);
            } else {
                VariableStorage curStorage = param.getStorage();
                int size = formalDataType.getLength();
                if (curStorage == VariableStorage.VOID_STORAGE) {
                    param.setStorage(VariableStorage.UNASSIGNED_STORAGE);
                } else if (size > 0 && size != curStorage.size() && curStorage.getVarnodeCount() == 1) {
                    this.adjustStorageSize(param, curStorage, size);
                }
            }
        } else {
            this.updateParameterAndReturnStorage();
        }
        this.notifyDataChanged();
    }

    private void adjustStorageSize(ParamInfo param, VariableStorage curStorage, int newSize) {
        Varnode varnode = curStorage.getVarnodes()[0];
        Address address = varnode.getAddress();
        if (address != null) {
            Register reg = VarnodeInfo.getRegister(this.program, varnode.getAddress(), varnode.getSize());
            if (reg != null) {
                Register baseReg = reg.getBaseRegister();
                if (newSize > baseReg.getMinimumByteSize()) {
                    address = baseReg.getAddress();
                    newSize = baseReg.getMinimumByteSize();
                } else if (baseReg.isBigEndian()) {
                    address = baseReg.getAddress().add((long)(baseReg.getMinimumByteSize() - newSize));
                }
            }
            try {
                param.setStorage(new VariableStorage(this.program, address, newSize));
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
    }

    public VariableStorage getReturnStorage() {
        return this.returnInfo.getStorage();
    }

    public Function getFunction() {
        return this.function;
    }

    public void setReturnStorage(VariableStorage storage) {
        if (storage == null) {
            storage = VariableStorage.UNASSIGNED_STORAGE;
        }
        this.returnInfo.setStorage(storage);
        this.notifyDataChanged();
    }

    public void setParameterStorage(ParamInfo param, VariableStorage storage) {
        param.setStorage(storage);
        this.notifyDataChanged();
    }

    private int findExplicitThisParameter() {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParamInfo p = this.parameters.get(i);
            if (p.isAutoParameter() || !Function.THIS_PARAM_NAME.equals(p.getName()) || !(p.getDataType() instanceof Pointer)) continue;
            return i;
        }
        return -1;
    }

    private void removeExplicitThisParameter() {
        int thisIndex;
        if (!this.allowCustomStorage && "__thiscall".equals(this.callingConventionName) && (thisIndex = this.findExplicitThisParameter()) >= 0) {
            this.parameters.remove(thisIndex);
            this.adjustSelectionForRowRemoved(thisIndex);
        }
    }

    private int findExplicitReturnStoragePtrParameter() {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParamInfo p = this.parameters.get(i);
            if (p.isAutoParameter() || !Function.RETURN_PTR_PARAM_NAME.equals(p.getName()) || !(p.getDataType() instanceof Pointer)) continue;
            return i;
        }
        return -1;
    }

    private boolean removeExplicitReturnStoragePtrParameter() {
        int index = this.findExplicitReturnStoragePtrParameter();
        if (index >= 0) {
            this.parameters.remove(index);
            this.adjustSelectionForRowRemoved(index);
            return true;
        }
        return false;
    }

    private void revertIndirectParameter(ParamInfo param) {
        if (this.allowCustomStorage) {
            throw new AssertException();
        }
        DataType dt = param.getDataType();
        if (dt instanceof Pointer) {
            param.setFormalDataType(((Pointer)dt).getDataType());
            param.setStorage(VariableStorage.UNASSIGNED_STORAGE);
        }
    }

    public void setUseCustomizeStorage(boolean b) {
        if (b == this.allowCustomStorage) {
            return;
        }
        this.allowCustomStorage = b;
        if (!this.allowCustomStorage) {
            this.removeExplicitThisParameter();
            if (this.removeExplicitReturnStoragePtrParameter()) {
                this.revertIndirectParameter(this.returnInfo);
            }
            this.updateParameterAndReturnStorage();
        } else {
            this.switchToCustomStorage();
        }
        this.notifyDataChanged();
    }

    public boolean canCustomizeStorage() {
        return this.allowCustomStorage;
    }

    public boolean apply() {
        if (!this.modelChanged) {
            return true;
        }
        int id = this.program.startTransaction("Edit Function");
        try {
            boolean bl = this.applyFunctionData();
            return bl;
        }
        finally {
            this.program.endTransaction(id, true);
        }
    }

    private boolean applyFunctionData() {
        String fixupName;
        block18: {
            try {
                boolean paramsOrReturnModified;
                if (!this.name.equals(this.function.getName())) {
                    this.function.setName(this.name, SourceType.USER_DEFINED);
                }
                if (!(paramsOrReturnModified = this.hasModifiedParametersOrReturn())) {
                    for (int i = 0; i < this.parameters.size(); ++i) {
                        Parameter param;
                        ParamInfo paramInfo = this.parameters.get(i);
                        if (paramInfo.isAutoParameter() || !paramInfo.isNameModified() || (param = paramInfo.getOriginalParameter()) == null) continue;
                        if (!param.getSymbol().checkIsValid()) {
                            paramsOrReturnModified = true;
                            break;
                        }
                        param.setName(paramInfo.getName(), SourceType.USER_DEFINED);
                    }
                }
                if (paramsOrReturnModified) {
                    ArrayList<Parameter> params = new ArrayList<Parameter>();
                    for (int i = 0; i < this.parameters.size(); ++i) {
                        ParamInfo paramInfo = this.parameters.get(i);
                        if (paramInfo.isAutoParameter()) continue;
                        params.add(paramInfo.getParameter(this.allowCustomStorage));
                    }
                    this.function.updateFunction(this.callingConventionName, (Variable)this.returnInfo.getParameter(this.allowCustomStorage), params, this.allowCustomStorage ? Function.FunctionUpdateType.CUSTOM_STORAGE : Function.FunctionUpdateType.DYNAMIC_STORAGE_FORMAL_PARAMS, true, SourceType.USER_DEFINED);
                    break block18;
                }
                boolean changed = false;
                if (this.allowCustomStorage != this.function.hasCustomVariableStorage()) {
                    this.function.setCustomVariableStorage(this.allowCustomStorage);
                    changed = true;
                }
                if (!this.function.getCallingConventionName().equals(this.callingConventionName)) {
                    try {
                        this.function.setCallingConvention(this.callingConventionName);
                    }
                    catch (InvalidInputException e) {
                        throw new AssertException("Unexpected exception", (Throwable)e);
                    }
                }
                if (changed && this.function.getSignatureSource() == SourceType.DEFAULT && this.parameters.size() == 0 && !"unknown".equals(this.callingConventionName)) {
                    this.function.setSignatureSource(SourceType.USER_DEFINED);
                }
            }
            catch (DuplicateNameException e) {
                Msg.showError((Object)this, null, (String)"Function Edit Error", (Object)e.getMessage());
                return false;
            }
            catch (InvalidInputException e) {
                Msg.showError((Object)this, null, (String)"Function Edit Error", (Object)e.getMessage());
                return false;
            }
        }
        if (this.function.isInline() != this.isInLine) {
            this.function.setInline(this.isInLine);
        }
        if (this.function.hasVarArgs() != this.hasVarArgs) {
            this.function.setVarArgs(this.hasVarArgs);
        }
        if (this.function.hasNoReturn() != this.isNoReturn) {
            this.function.setNoReturn(this.isNoReturn);
        }
        String string = fixupName = this.callFixupName.equals(NONE_CHOICE) ? null : this.callFixupName;
        if (!SystemUtilities.isEqual((Object)fixupName, (Object)this.function.getCallFixup())) {
            this.function.setCallFixup(fixupName);
        }
        return true;
    }

    Program getProgram() {
        return this.program;
    }

    DataTypeManagerService getDataTypeManagerService() {
        return this.dataTypeManagerService;
    }

    int getAutoParamCount() {
        return this.autoParamCount;
    }

    private boolean isSameSize(DataType dt1, DataType dt2) {
        if (dt1 == null || dt2 == null) {
            return false;
        }
        return dt1.getLength() == dt2.getLength();
    }

    public void setFunctionData(FunctionDefinitionDataType functionDefinition) {
        this.name = functionDefinition.getName();
        GenericCallingConvention genericCallingConvention = functionDefinition.getGenericCallingConvention();
        if (genericCallingConvention != null && genericCallingConvention != GenericCallingConvention.unknown) {
            PrototypeModel matchConvention = this.function.getProgram().getCompilerSpec().matchConvention(genericCallingConvention);
            this.setCallingConventionName(matchConvention.getName());
        }
        if (!this.isSameSize(this.returnInfo.getFormalDataType(), functionDefinition.getReturnType())) {
            this.returnInfo.setStorage(VariableStorage.UNASSIGNED_STORAGE);
        }
        this.returnInfo.setFormalDataType(functionDefinition.getReturnType());
        List<ParamInfo> oldParams = this.parameters;
        this.parameters = new ArrayList<ParamInfo>();
        this.autoParamCount = 0;
        this.selectedFunctionRows = new int[0];
        for (ParameterDefinition paramDefinition : functionDefinition.getArguments()) {
            this.parameters.add(new ParamInfo(this, paramDefinition));
        }
        this.hasVarArgs = functionDefinition.hasVarArgs();
        this.fixupOrdinals();
        if (this.allowCustomStorage) {
            this.reconcileCustomStorage(oldParams, this.parameters);
        } else {
            this.updateParameterAndReturnStorage();
        }
        this.notifyDataChanged();
    }

    private void reconcileCustomStorage(List<ParamInfo> oldParams, List<ParamInfo> newParams) {
        HashSet<ParamInfo> oldMatches = new HashSet<ParamInfo>();
        HashSet<ParamInfo> newMatches = new HashSet<ParamInfo>();
        for (ParamInfo paramInfo : newParams) {
            ParamInfo oldInfo = this.findOldCustomInfoByNameAndDataTypeSize(oldParams, paramInfo.getName(), paramInfo.getDataType().getLength());
            if (oldInfo == null) continue;
            oldMatches.add(oldInfo);
            newMatches.add(paramInfo);
            paramInfo.setStorage(oldInfo.getStorage());
        }
        for (int i = 0; i < newParams.size() && i < oldParams.size(); ++i) {
            ParamInfo oldInfo = oldParams.get(i);
            ParamInfo newInfo = newParams.get(i);
            if (oldMatches.contains(oldInfo) || newMatches.contains(newInfo) || !this.isSameSize(oldInfo.getDataType(), newInfo.getDataType())) break;
            newInfo.setStorage(oldInfo.getStorage());
        }
    }

    private ParamInfo findOldCustomInfoByNameAndDataTypeSize(List<ParamInfo> oldParams, String newParamName, int size) {
        for (ParamInfo paramInfo : oldParams) {
            if (!paramInfo.getName().equals(newParamName) || paramInfo.getDataType().getLength() != size) continue;
            return paramInfo;
        }
        return null;
    }

    public boolean isInParsingMode() {
        return this.isInParsingMode;
    }

    public void setSignatureFieldText(String text) {
        this.signatureFieldText = text;
        boolean signatureTextFieldInSync = this.signatureFieldText.equals(this.getFunctionSignatureTextFromModel());
        if (this.isInParsingMode == signatureTextFieldInSync) {
            this.isInParsingMode = !this.isInParsingMode;
            this.notifyDataChanged(false);
        }
    }

    public void resetSignatureTextField() {
        this.setSignatureFieldText(this.getFunctionSignatureTextFromModel());
    }

    public void parseSignatureFieldText() throws ParseException, CancelledException {
        FunctionSignatureParser parser = new FunctionSignatureParser((DataTypeManager)this.program.getDataTypeManager(), this.dataTypeManagerService);
        FunctionDefinitionDataType f = parser.parse(this.function.getSignature(), this.signatureFieldText);
        this.setFunctionData(f);
        this.isInParsingMode = false;
    }

    public int getFunctionNameStartPosition() {
        return this.returnInfo.getFormalDataType().getName().length() + 1;
    }

    public void setModelChanged(boolean b) {
        this.modelChanged = b;
    }
}

