/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableFilter;
import docking.widgets.table.columnfilter.ColumnBasedTableFilter;
import docking.widgets.table.columnfilter.LogicOperation;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnTypeMapper;
import docking.widgets.table.constraint.MappedColumnConstraint;
import docking.widgets.table.constraint.StringContainsColumnConstraint;
import ghidra.app.plugin.core.function.tags.FunctionTableModel;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Program;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.field.AddressBasedLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;

public class AllFunctionsPanel
extends JPanel {
    private FunctionTableModel model;
    private FunctionTableModel filteredModel;
    private JLabel titleLabel;
    private String filterText;
    private GhidraTable table;

    public AllFunctionsPanel(Program program, ComponentProviderAdapter provider, String title) {
        this.model = new FunctionTableModel(title, (ServiceProvider)provider.getTool(), program, null);
        this.filteredModel = new FunctionTableModel(title, (ServiceProvider)provider.getTool(), program, null);
        this.table = new GhidraTable((TableModel)((Object)this.filteredModel));
        this.setLayout(new BorderLayout());
        this.titleLabel = new JLabel(title);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 0, 0));
        this.add((Component)this.titleLabel, "North");
        this.add((Component)new JScrollPane((Component)((Object)this.table)), "Center");
        GoToService goToService = (GoToService)provider.getTool().getService(GoToService.class);
        if (goToService != null) {
            this.table.installNavigation(goToService, goToService.getDefaultNavigatable());
        }
    }

    public void setFilterText(String filter) {
        this.filterText = filter;
        this.applyFilter();
    }

    public void refresh() {
        this.applyFilter();
        this.filteredModel.refresh();
    }

    public void refresh(List<FunctionTag> selectedTags) {
        this.setSelectedTags(selectedTags);
    }

    public void setProgram(Program program) {
        this.model.setProgram(program);
        this.filteredModel.setProgram(program);
    }

    public void setSelectedTags(List<FunctionTag> tags) {
        String tagNames = tags.stream().map(t -> t.getName()).collect(Collectors.joining(" or ")).toString();
        this.titleLabel.setText("Functions With Tag: " + tagNames);
        this.model.setSelectedTags(tags);
        this.filteredModel.setSelectedTags(tags);
        this.applyFilter();
    }

    public List<Function> getFunctions() {
        return this.model.getFunctions();
    }

    public FunctionTableModel getTableModel() {
        return this.model;
    }

    private void applyFilter() {
        if (StringUtils.isEmpty((CharSequence)this.filterText)) {
            return;
        }
        ColumnBasedTableFilter tableFilter = new ColumnBasedTableFilter((RowObjectTableModel)this.filteredModel);
        tableFilter.addConstraintSet(LogicOperation.OR, 0, Arrays.asList(new StringContainsColumnConstraint(this.filterText)));
        tableFilter.addConstraintSet(LogicOperation.OR, 1, Arrays.asList(new ColumnConstraint[]{new LocationContainsColumnConstraint((ColumnConstraint<String>)new StringContainsColumnConstraint(this.filterText))}));
        tableFilter.addConstraintSet(LogicOperation.OR, 2, Arrays.asList(new StringContainsColumnConstraint(this.filterText)));
        this.filteredModel.setTableFilter((TableFilter)tableFilter);
        this.filteredModel.reFilter();
    }

    private class LocationContainsColumnConstraint
    extends MappedColumnConstraint<AddressBasedLocation, String> {
        public LocationContainsColumnConstraint(ColumnConstraint<String> delegate) {
            super((ColumnTypeMapper)new LocationToStringMapper(), delegate);
        }

        public ColumnConstraint<AddressBasedLocation> copy(ColumnConstraint<String> value) {
            return new LocationContainsColumnConstraint(value);
        }
    }

    private class LocationToStringMapper
    extends ColumnTypeMapper<AddressBasedLocation, String> {
        private LocationToStringMapper() {
        }

        public String convert(AddressBasedLocation value) {
            return value.toString();
        }
    }
}

