/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import ghidra.app.plugin.core.function.tags.FunctionTagTableModel;
import ghidra.app.plugin.core.function.tags.FunctionTagTemp;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import ghidra.util.HTMLUtilities;
import ghidra.util.table.GhidraTable;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class FunctionTagTable
extends GhidraTable {
    private boolean disable = false;
    private Function function = null;

    public FunctionTagTable(FunctionTagTableModel model) {
        super((TableModel)((Object)model));
    }

    protected void setDisabled(boolean disable) {
        this.disable = disable;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public String getToolTipText(MouseEvent evt) {
        FunctionTagTable table = (FunctionTagTable)((Object)evt.getSource());
        int row = this.rowAtPoint(evt.getPoint());
        int nameCol = table.getColumnModel().getColumnIndex("Name");
        String tagName = (String)table.getValueAt(row, nameCol);
        FunctionTagTableModel model = (FunctionTagTableModel)((Object)table.getModel());
        FunctionTag tag = model.getTag(tagName);
        if (tag.getComment().isEmpty()) {
            return "no tooltip set";
        }
        return "<html>" + HTMLUtilities.escapeHTML((String)tag.getComment());
    }

    public TableCellRenderer getCellRenderer(int row, int col) {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
                Component c = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                boolean enableRow = true;
                if (FunctionTagTable.this.disable && FunctionTagTable.this.function != null) {
                    int nameCol = table.getColumnModel().getColumnIndex("Name");
                    String nameVal = (String)table.getValueAt(row, nameCol);
                    Set tags = FunctionTagTable.this.function.getTags();
                    enableRow = !tags.stream().anyMatch(t -> t.getName().equals(nameVal));
                }
                c.setEnabled(enableRow);
                switch (table.getColumnName(column)) {
                    case "Count": {
                        break;
                    }
                    case "Name": {
                        FunctionTagTableModel model = (FunctionTagTableModel)((Object)table.getModel());
                        FunctionTag tag = model.getTag((String)value);
                        if (tag instanceof FunctionTagTemp) {
                            c.setFont(FunctionTagTable.this.getFont().deriveFont(2));
                            break;
                        }
                        c.setFont(FunctionTagTable.this.getFont().deriveFont(0));
                    }
                }
                return c;
            }
        };
    }
}

