/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.InputDialog;
import ghidra.app.cmd.function.ChangeFunctionTagCmd;
import ghidra.app.cmd.function.DeleteFunctionTagCmd;
import ghidra.app.plugin.core.function.tags.FunctionTagTable;
import ghidra.app.plugin.core.function.tags.FunctionTagTableModel;
import ghidra.app.plugin.core.function.tags.FunctionTagTemp;
import ghidra.app.plugin.core.function.tags.FunctionTagsComponentProvider;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class TagListPanel
extends JPanel {
    protected Program program;
    protected Function function;
    protected FunctionTagTable table;
    protected PluginTool tool;
    protected String filterString = "";
    protected FunctionTagTableModel model;
    protected FunctionTagTableModel filteredModel;
    private JLabel titleLabel;

    public TagListPanel(final FunctionTagsComponentProvider provider, final PluginTool tool, String title) {
        this.tool = tool;
        this.setLayout(new BorderLayout());
        this.model = new FunctionTagTableModel("", (ServiceProvider)provider.getTool());
        this.filteredModel = new FunctionTagTableModel("", (ServiceProvider)provider.getTool());
        this.table = new FunctionTagTable(this.filteredModel);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                provider.selectionChanged(TagListPanel.this);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                FunctionTagTable table = (FunctionTagTable)((Object)evt.getSource());
                if (evt.getClickCount() == 2) {
                    int row = table.getSelectedRow();
                    int nameCol = table.getColumnModel().getColumnIndex("Name");
                    String tagName = (String)table.getValueAt(row, nameCol);
                    FunctionTagTableModel model = (FunctionTagTableModel)((Object)table.getModel());
                    FunctionTag tag = model.getTag(tagName);
                    if (tag == null) {
                        return;
                    }
                    if (tag instanceof FunctionTagTemp) {
                        Msg.showWarn((Object)this, (Component)((Object)table), (String)"Tag Not Editable", (Object)("Tag \"" + tag.getName() + "\" must be added to the program before it can be modified/deleted"));
                        return;
                    }
                    String[] labels = new String[]{"Name:", "Comment:"};
                    String[] init = new String[]{tag.getName(), tag.getComment()};
                    InputDialog dialog = new InputDialog("Edit Tag", labels, init, true, d -> {
                        ChangeFunctionTagCmd cmd;
                        String[] results = d.getValues();
                        if (results == null || results.length != 2) {
                            Msg.error((Object)this, (Object)"Error retrieving data from edit dialog");
                            return false;
                        }
                        String newName = results[0].trim();
                        String newComment = results[1].trim();
                        if (newName.isEmpty()) {
                            Msg.showWarn((Object)this, (Component)((Object)table), (String)"Empty Tag Name?", (Object)"Tag name cannot be empty");
                            return false;
                        }
                        if (!newName.equals(tag.getName())) {
                            cmd = new ChangeFunctionTagCmd(tag.getName(), newName, 0);
                            tool.execute((Command)cmd, (DomainObject)TagListPanel.this.program);
                        }
                        if (!newComment.equals(tag.getComment())) {
                            cmd = new ChangeFunctionTagCmd(tag.getName(), newComment, 1);
                            tool.execute((Command)cmd, (DomainObject)TagListPanel.this.program);
                        }
                        return true;
                    });
                    DockingWindowManager.showDialog((Component)tool.getActiveWindow(), (DialogComponentProvider)dialog);
                    if (dialog.isCanceled()) {
                        return;
                    }
                }
            }
        });
        this.titleLabel = new JLabel(title);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 0, 0));
        this.add((Component)this.titleLabel, "North");
        this.add((Component)new JScrollPane((Component)((Object)this.table)), "Center");
    }

    public abstract void refresh(Function var1);

    public void clearSelection() {
        this.table.clearSelection();
    }

    public void setProgram(Program program) {
        this.program = program;
        this.model.setProgram(program);
        this.filteredModel.setProgram(program);
    }

    public void setFilterText(String text) {
        this.filterString = text;
        this.applyFilter();
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public boolean tagExists(String name) {
        return this.model.isTagInModel(name);
    }

    protected boolean hasSelection() {
        return this.table.getSelectedRowCount() != 0;
    }

    protected boolean isSelectionImmutable() {
        int[] selectedRows = this.table.getSelectedRows();
        int nameCol = this.table.getColumnModel().getColumnIndex("Name");
        for (int selectedRow : selectedRows) {
            String tagName = (String)this.table.getValueAt(selectedRow, nameCol);
            FunctionTag tag = this.filteredModel.getTag(tagName);
            if (!(tag instanceof FunctionTagTemp)) continue;
            return true;
        }
        return false;
    }

    protected void deleteSelectedTags() {
        List<FunctionTag> selectedTags = this.getSelectedTags();
        if (selectedTags.isEmpty()) {
            return;
        }
        int option = OptionDialog.showOptionDialog((Component)this, (String)"Function Tag Delete", (String)"Are you sure? \nThis will delete the tag from all functions in the program.", (String)"OK", (int)2);
        switch (option) {
            case 1: {
                for (FunctionTag tag : selectedTags) {
                    DeleteFunctionTagCmd cmd = new DeleteFunctionTagCmd(tag.getName());
                    this.tool.execute((Command)cmd, (DomainObject)this.program);
                }
                break;
            }
        }
    }

    protected void applyFilter() {
        this.filteredModel.clear();
        for (FunctionTag tag : this.model.getTags()) {
            if (this.filterString.isEmpty()) {
                this.filteredModel.addTag(tag);
                continue;
            }
            if (!tag.getName().toLowerCase().contains(this.filterString.toLowerCase())) continue;
            this.filteredModel.addTag(tag);
        }
        this.filteredModel.reload();
    }

    protected List<FunctionTag> getAssignedTags(Function func) {
        ArrayList<FunctionTag> assignedTags = new ArrayList<FunctionTag>();
        if (func != null) {
            assignedTags.addAll(func.getTags());
        }
        return assignedTags;
    }

    protected List<FunctionTag> getSelectedTags() {
        int[] selectedIndices;
        ArrayList<FunctionTag> tags = new ArrayList<FunctionTag>();
        for (int i : selectedIndices = this.table.getSelectedRows()) {
            String tagName = (String)this.filteredModel.getValueAt(i, 0);
            Optional<FunctionTag> tag = this.filteredModel.getTags().stream().filter(t -> t.getName().equals(tagName)).findAny();
            if (!tag.isPresent()) continue;
            tags.add(tag.get());
        }
        return tags;
    }
}

