/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import ghidra.app.context.ListingActionContext;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerSet;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.util.HelpLocation;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class NextPreviousMarkerAction
extends MultiStateDockingAction<String> {
    private boolean isForward = true;
    private PluginTool tool;
    private static ImageIcon markerIcon = ResourceManager.loadImage((String)"images/M.gif");
    private static ImageIcon markerAnalysisBookmarkIcon = ResourceManager.loadImage((String)"images/M.gif");
    private static ImageIcon markerConflictingChangesIcon = ResourceManager.loadImage((String)"images/edit-delete.png");
    private static ImageIcon markerLatestVersionChangesIcon = ResourceManager.loadImage((String)"images/information.png");
    private static ImageIcon markerNotCheckedInChangesIcon = ResourceManager.loadImage((String)"images/notes.gif");
    private static ImageIcon markerUnSavedChangesIcon = ResourceManager.loadImage((String)"images/warning.png");
    private static ImageIcon markerCursorIcon = ResourceManager.loadImage((String)"images/unknown.gif");
    private static ImageIcon markerErrorBookmarkIcon = ResourceManager.loadImage((String)"images/unknown.gif");
    private static ImageIcon markerHighlightIcon = ResourceManager.loadImage((String)"images/unknown.gif");
    private static ImageIcon markerInfoBookmarkIcon = ResourceManager.loadImage((String)"images/unknown.gif");
    private static ImageIcon markerNoteBookmarkIcon = ResourceManager.loadImage((String)"images/unknown.gif");
    private static ImageIcon markerSelectionIcon = ResourceManager.loadImage((String)"images/unknown.gif");
    private static ImageIcon markerWarningBookmarkIcon = ResourceManager.loadImage((String)"images/unknown.gif");

    public NextPreviousMarkerAction(PluginTool tool, String owner, String subGroup) {
        super("Next Marker", owner);
        this.tool = tool;
        ToolBarData toolBarData = new ToolBarData((Icon)markerIcon, "4_Toolbar_Navigation_Group");
        toolBarData.setToolBarSubGroup(subGroup);
        this.setToolBarData(toolBarData);
        MenuData menuData = new MenuData(new String[]{"&Navigation", this.getMenuName()}, (Icon)markerIcon, "NextPrevCodeUnit");
        menuData.setMenuSubGroup(subGroup);
        this.setMenuBarData(menuData);
        this.setKeyBindingData(new KeyBindingData(this.getKeyStroke()));
        this.setHelpLocation(new HelpLocation("Navigation", this.getName()));
        this.setDescription("Set marker options");
        ActionState allMarkers = new ActionState("All Types", (Icon)markerIcon, (Object)"All Types");
        ActionState analysis = new ActionState("Analysis Marker", (Icon)markerAnalysisBookmarkIcon, (Object)"Analysis");
        ActionState conflictingChanges = new ActionState("Conflicting Changes", (Icon)markerAnalysisBookmarkIcon, (Object)"Conflicting Changes");
        ActionState latestVersionChanges = new ActionState("Latest Version Changes", (Icon)markerAnalysisBookmarkIcon, (Object)"Latest Version Changes");
        ActionState notCheckedInChanges = new ActionState("Not Checked In Changes", (Icon)markerAnalysisBookmarkIcon, (Object)"Not Checked In Changes");
        ActionState unsavedChanges = new ActionState("Unsaved Changes", (Icon)markerIcon, (Object)"Unsaved Changes");
        ActionState cursor = new ActionState("Cursor", (Icon)markerIcon, (Object)"Cursor");
        ActionState error = new ActionState("Error Marker", (Icon)markerIcon, (Object)"Error");
        ActionState highlight = new ActionState("Highlight", (Icon)markerIcon, (Object)"Highlight");
        ActionState info = new ActionState("Info Marker", (Icon)markerIcon, (Object)"Info");
        ActionState note = new ActionState("Note Marker", (Icon)markerIcon, (Object)"Note");
        ActionState selection = new ActionState("Selection", (Icon)markerIcon, (Object)"Selection");
        ActionState warning = new ActionState("Warning Marker", (Icon)markerIcon, (Object)"Warning");
        ActionState custom = new ActionState("Custom Marker", (Icon)markerIcon, (Object)"Custom Marker");
        this.addActionState(allMarkers);
        this.addActionState(analysis);
        this.addActionState(conflictingChanges);
        this.addActionState(latestVersionChanges);
        this.addActionState(notCheckedInChanges);
        this.addActionState(unsavedChanges);
        this.addActionState(cursor);
        this.addActionState(error);
        this.addActionState(highlight);
        this.addActionState(info);
        this.addActionState(note);
        this.addActionState(selection);
        this.addActionState(warning);
        this.addActionState(custom);
        this.setCurrentActionState(allMarkers);
    }

    public void setMenuBarData(MenuData newMenuData) {
        this.superSetMenuBarData(newMenuData);
    }

    protected void doActionPerformed(ActionContext context) {
        this.gotoNextPrevious((ListingActionContext)context.getContextObject(), (String)this.getCurrentUserData());
    }

    public void actionStateChanged(ActionState<String> newActionState, EventTrigger trigger) {
    }

    private boolean isMarkerAddressEqualToCurrent(MarkerSet marker, Address address) {
        if (marker == null) {
            return false;
        }
        return !address.equals((Object)marker.getMinAddress());
    }

    private void gotoAddress(GoToService service, Navigatable navigatable, Address address) {
        service.goTo(navigatable, address);
    }

    void gotoNextPrevious(ListingActionContext context, String markerType) {
    }

    private void gotoAddress(ListingActionContext listingActionContext, Address address) {
        if (address == null) {
            this.tool.setStatusInfo("Unable to locate another " + this.getNavigationTypeName() + " past the current range, in the current direction.");
            return;
        }
        this.tool.clearStatusInfo();
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            Navigatable navigatable = listingActionContext.getNavigatable();
            this.gotoAddress(service, navigatable, address);
        }
    }

    public void setDirection(boolean isForward) {
        this.isForward = isForward;
        this.getMenuBarData().setMenuItemName(this.getMenuName());
        this.setDescription(this.getDescription());
    }

    private String getMenuName() {
        String prefix = this.isForward ? "Next " : "Previous ";
        return prefix + this.getNavigationTypeName();
    }

    private String getNavigationTypeName() {
        return "Marker";
    }

    private KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(66, 640);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof CodeViewerActionContext)) {
            return false;
        }
        return this.isEnabledForContext((CodeViewerActionContext)context);
    }

    public boolean isValidContext(ActionContext context) {
        if (!(context instanceof CodeViewerActionContext)) {
            return false;
        }
        return this.isValidContext((CodeViewerActionContext)context);
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof CodeViewerActionContext)) {
            return false;
        }
        return this.isAddToPopup((CodeViewerActionContext)context);
    }

    protected boolean isValidContext(CodeViewerActionContext context) {
        return true;
    }

    protected boolean isEnabledForContext(CodeViewerActionContext context) {
        return true;
    }

    protected boolean isAddToPopup(CodeViewerActionContext context) {
        return this.isEnabledForContext(context);
    }

    public boolean shouldAddToWindow(boolean isMainWindow, Set<Class<?>> contextTypes) {
        for (Class<?> class1 : contextTypes) {
            if (!CodeViewerActionContext.class.isAssignableFrom(class1)) continue;
            return true;
        }
        return false;
    }
}

