/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import ghidra.app.plugin.core.navigation.locationreferences.DataTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.GenericDataTypeProgramLocation;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.AssertException;

public class GenericDataTypeLocationDescriptor
extends DataTypeLocationDescriptor {
    GenericDataTypeLocationDescriptor(ProgramLocation location, Program program, DataType dataType) {
        super(location, program);
        if (!(location instanceof GenericDataTypeProgramLocation)) {
            throw new AssertException("Unexpected ProgramLocation type - Cannot create a LocationDescriptor for type: " + location);
        }
        this.originalDataType = dataType;
        this.label = this.generateLabel();
    }

    @Override
    protected DataType getDataType() {
        if (this.baseDataType == null) {
            return this.getBaseDataType();
        }
        return this.baseDataType;
    }

    @Override
    public ProgramLocation getHomeLocation() {
        return null;
    }

    @Override
    protected String generateLabel() {
        if (this.originalDataType == null) {
            return "<pending>";
        }
        return "\"" + this.originalDataType.getName() + "\" (DataType)";
    }

    @Override
    protected String getDataTypeName() {
        if (this.originalDataType == null) {
            return "<pending>";
        }
        return this.originalDataType.getName();
    }

    @Override
    protected DataType getSourceDataType() {
        return ((GenericDataTypeProgramLocation)this.getLocation()).getDataType();
    }

    @Override
    protected DataType getBaseDataType() {
        DataType type = ReferenceUtils.getBaseDataType(this.getSourceDataType());
        return type;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericDataTypeLocationDescriptor)) {
            return false;
        }
        GenericDataTypeLocationDescriptor otherDescriptor = (GenericDataTypeLocationDescriptor)obj;
        return this.getDataType().equals(otherDescriptor.getDataType());
    }
}

