/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.osgi;

import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;

public class OSGiUtils {
    private static Pattern JAR_FILENAME_EXTRACTOR = Pattern.compile("^.*:(.*)!.*$");
    private static Pattern PACKAGE_NAME_EXTRACTOR = Pattern.compile("\\(osgi\\.wiring\\.package=([^)]*)\\)(\\(version[^)]*\\))?");

    static List<String> extractPackageNamesFromFailedResolution(String osgiExceptionMessage) {
        try (Scanner s = new Scanner(osgiExceptionMessage);){
            List<String> list = s.findAll(PACKAGE_NAME_EXTRACTOR).map(m -> {
                if (m.group(2) != null) {
                    return m.group(1) + " " + m.group(2);
                }
                return m.group(1);
            }).collect(Collectors.toList());
            return list;
        }
    }

    static String getEventTypeString(BundleEvent e) {
        switch (e.getType()) {
            case 1: {
                return "INSTALLED";
            }
            case 32: {
                return "RESOLVED";
            }
            case 512: {
                return "LAZY_ACTIVATION";
            }
            case 128: {
                return "STARTING";
            }
            case 2: {
                return "STARTED";
            }
            case 256: {
                return "STOPPING";
            }
            case 4: {
                return "STOPPED";
            }
            case 8: {
                return "UPDATED";
            }
            case 64: {
                return "UNRESOLVED";
            }
            case 16: {
                return "UNINSTALLED";
            }
        }
        return "???";
    }

    static String getStateString(Bundle bundle) {
        switch (bundle.getState()) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return "unknown state";
    }

    static List<BundleRequirement> parseImportPackage(String importPackageString) throws BundleException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Import-Package", importPackageString);
        ManifestParser manifestParser = new ManifestParser(null, null, null, headerMap);
        return manifestParser.getRequirements();
    }

    static List<BundleCapability> parseExportPackage(String exportPackageString) throws BundleException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Export-Package", exportPackageString);
        ManifestParser manifestParser = new ManifestParser(null, null, null, headerMap);
        return manifestParser.getCapabilities();
    }

    static String findJarForClass(Class<?> c) {
        String classLocation = c.getName().replace('.', '/') + ".class";
        ClassLoader loader = c.getClassLoader();
        URL location = loader == null ? ClassLoader.getSystemResource(classLocation) : loader.getResource(classLocation);
        if (location != null) {
            Matcher matcher = JAR_FILENAME_EXTRACTOR.matcher(location.toString());
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }
        return null;
    }

    static void getPackagesFromClasspath(Set<String> s) {
        OSGiUtils.getClasspathElements().forEach(p -> {
            if (Files.isDirectory(p, new LinkOption[0])) {
                OSGiUtils.collectPackagesFromDirectory(p, s);
            } else if (p.toString().endsWith(".jar")) {
                OSGiUtils.collectPackagesFromJar(p, s);
            }
        });
    }

    static Stream<Path> getClasspathElements() {
        String classpathStr = System.getProperty("java.class.path");
        return Collections.list(new StringTokenizer(classpathStr, File.pathSeparator)).stream().map(String.class::cast).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::normalize);
    }

    static void collectPackagesFromDirectory(Path dirPath, Set<String> packages) {
        try (Stream<Path> walk = Files.walk(dirPath, new FileVisitOption[0]);){
            walk.filter(p -> p.toString().endsWith(".class")).forEach(path -> {
                String relativePath = dirPath.relativize((Path)path).toString();
                int lastSlash = relativePath.lastIndexOf(File.separatorChar);
                packages.add(lastSlash > 0 ? relativePath.substring(0, lastSlash).replace(File.separatorChar, '.') : "");
            });
        }
        catch (IOException e) {
            Msg.error(OSGiUtils.class, (Object)"Error while collecting packages from directory", (Throwable)e);
        }
    }

    static void collectPackagesFromJar(Path jarPath, Set<String> packages) {
        try (JarFile j = new JarFile(jarPath.toFile());){
            j.stream().filter(entry -> entry.getName().endsWith(".class")).forEach(jarEntry -> {
                String entryName = jarEntry.getName();
                int lastSlash = entryName.lastIndexOf(47);
                packages.add(lastSlash > 0 ? entryName.substring(0, lastSlash).replace('/', '.') : "");
            });
        }
        catch (IOException e) {
            Msg.error(OSGiUtils.class, (Object)"Error while collecting packages from jar", (Throwable)e);
        }
    }
}

