/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import ghidra.app.plugin.core.symtable.SymbolFilter;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;

public class NewSymbolFilter
implements SymbolFilter {
    private static final String XML_NAME = "SYMBOL_TABLE_FILTER";
    private Filter userDefinedFilter;
    private Filter analysisFilter;
    private Filter defaultFunctionFilter;
    private Filter defaultLabelFilter;
    private Filter importedFilter;
    private Filter[] labelFilters;
    private Filter[] nonLabelFilters;
    private Filter[] advancedFilters;
    private Filter[] activeOriginFilters = new Filter[0];
    private Filter[] activeTypeFilters = new Filter[0];
    private AdvancedFilter[] activeAdvancedFilters = new AdvancedFilter[0];
    private Map<String, Filter> filterMap = new HashMap<String, Filter>();
    private boolean acceptsAll;
    private boolean acceptsAllTypes;
    private boolean acceptsAllSources;

    public NewSymbolFilter() {
        this(null);
    }

    public NewSymbolFilter(SymbolFilter oldFilter) {
        this.createFilters();
        for (Filter labelFilter : this.labelFilters) {
            this.filterMap.put(labelFilter.getName(), labelFilter);
        }
        for (Filter nonLabelFilter : this.nonLabelFilters) {
            this.filterMap.put(nonLabelFilter.getName(), nonLabelFilter);
        }
        for (Filter advancedFilter : this.advancedFilters) {
            this.filterMap.put(advancedFilter.getName(), advancedFilter);
        }
        this.filterMap.put(this.userDefinedFilter.getName(), this.userDefinedFilter);
        this.filterMap.put(this.importedFilter.getName(), this.importedFilter);
        this.filterMap.put(this.analysisFilter.getName(), this.analysisFilter);
        this.filterMap.put(this.defaultLabelFilter.getName(), this.defaultLabelFilter);
        this.filterMap.put(this.defaultFunctionFilter.getName(), this.defaultFunctionFilter);
        if (oldFilter instanceof NewSymbolFilter) {
            int i;
            NewSymbolFilter filter = (NewSymbolFilter)oldFilter;
            this.userDefinedFilter.setActive(filter.userDefinedFilter.isActive());
            this.importedFilter.setActive(filter.importedFilter.isActive());
            this.analysisFilter.setActive(filter.analysisFilter.isActive());
            this.defaultLabelFilter.setActive(filter.defaultLabelFilter.isActive());
            this.defaultFunctionFilter.setActive(filter.defaultFunctionFilter.isActive());
            for (i = 0; i < this.labelFilters.length; ++i) {
                this.labelFilters[i].setActive(filter.labelFilters[i].isActive());
            }
            for (i = 0; i < this.nonLabelFilters.length; ++i) {
                this.nonLabelFilters[i].setActive(filter.nonLabelFilters[i].isActive());
            }
            for (i = 0; i < this.advancedFilters.length; ++i) {
                this.advancedFilters[i].setActive(filter.advancedFilters[i].isActive());
            }
            this.rebuildActiveFilters();
        } else {
            this.setFilterDefaults();
        }
    }

    @Override
    public boolean accepts(Symbol symbol, Program program) {
        if (this.acceptsAll) {
            return true;
        }
        if (!this.isAcceptableOrigin(program, symbol)) {
            return false;
        }
        if (!this.isAcceptableType(program, symbol)) {
            return false;
        }
        return this.passesAdvancedFilters(program, symbol);
    }

    private boolean isAcceptableOrigin(Program program, Symbol symbol) {
        if (this.acceptsAllSources) {
            return true;
        }
        for (Filter activeOriginFilter : this.activeOriginFilters) {
            if (!activeOriginFilter.matches(program, symbol)) continue;
            return true;
        }
        return false;
    }

    private boolean isAcceptableType(Program program, Symbol symbol) {
        if (this.acceptsAllTypes) {
            return true;
        }
        for (Filter activeTypeFilter : this.activeTypeFilters) {
            if (!activeTypeFilter.matches(program, symbol)) continue;
            return true;
        }
        return false;
    }

    private boolean passesAdvancedFilters(Program program, Symbol symbol) {
        boolean applicable = false;
        for (AdvancedFilter activeAdvancedFilter : this.activeAdvancedFilters) {
            if (!activeAdvancedFilter.isApplicable(symbol)) continue;
            applicable = true;
            if (!activeAdvancedFilter.matches(program, symbol)) continue;
            return true;
        }
        return !applicable;
    }

    @Override
    public boolean acceptsOnlyCodeSymbols() {
        for (int i = 0; i < this.activeTypeFilters.length; ++i) {
            if (this.activeTypeFilters[i].onlyCodeSymbols) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean acceptsDefaultLabelSymbols() {
        if (!this.defaultLabelFilter.isActive()) {
            return false;
        }
        for (Filter activeTypeFilter : this.activeTypeFilters) {
            if (!activeTypeFilter.includesDefaults) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsAll() {
        return this.acceptsAll;
    }

    String[] getSourceFilterNames() {
        return new String[]{this.userDefinedFilter.getName(), this.defaultFunctionFilter.getName(), this.importedFilter.getName(), this.defaultLabelFilter.getName(), this.analysisFilter.getName()};
    }

    String[] getLabelTypeFilterNames() {
        String[] names = new String[this.labelFilters.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.labelFilters[i].getName();
        }
        return names;
    }

    String[] getNonLabelTypeFilterNames() {
        String[] names = new String[this.nonLabelFilters.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.nonLabelFilters[i].getName();
        }
        return names;
    }

    String[] getAdvancedFilterNames() {
        String[] names = new String[this.advancedFilters.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.advancedFilters[i].getName();
        }
        return names;
    }

    void setFilter(String filterName, boolean active) {
        Filter filter = this.filterMap.get(filterName);
        if (filter != null) {
            filter.setActive(active);
            this.rebuildActiveFilters();
        } else {
            Msg.error((Object)this, (Object)("filter " + filterName + " not found"));
        }
    }

    String getFilterDescription(String filterName) {
        Filter filter = this.filterMap.get(filterName);
        return filter != null ? filter.getDescription() : "";
    }

    boolean isActive(String filterName) {
        Filter filter = this.filterMap.get(filterName);
        return filter != null && filter.active;
    }

    boolean isEnabled(String filterName) {
        Filter filter = this.filterMap.get(filterName);
        return filter != null && filter.isEnabled();
    }

    public int getActiveSourceFilterCount() {
        return this.activeOriginFilters.length;
    }

    public int getActiveTypeFilterCount() {
        return this.activeTypeFilters.length;
    }

    public int getActiveAdvancedFilterCount() {
        return this.activeAdvancedFilters.length;
    }

    Element saveToXml() {
        Element root = new Element(XML_NAME);
        this.filterMap.values().forEach(filter -> {
            Element filterElement = filter.saveToXml();
            root.addContent((Content)filterElement);
        });
        return root;
    }

    void restoreFromXml(Element element) {
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getAttributeValue("NAME");
            Filter f = this.filterMap.get(childName);
            f.restoreFromXml(child);
        }
        this.rebuildActiveFilters();
    }

    void setFilterDefaults() {
        for (Filter labelFilter : this.labelFilters) {
            labelFilter.setActive(true);
        }
        for (Filter nonLabelFilter : this.nonLabelFilters) {
            nonLabelFilter.setActive(false);
        }
        for (Filter advancedFilter : this.advancedFilters) {
            advancedFilter.setActive(false);
        }
        this.userDefinedFilter.setActive(true);
        this.importedFilter.setActive(true);
        this.analysisFilter.setActive(true);
        this.defaultFunctionFilter.setActive(true);
        this.defaultLabelFilter.setActive(false);
        this.rebuildActiveFilters();
    }

    private void rebuildActiveFilters() {
        ArrayList<Filter> originList = new ArrayList<Filter>(3);
        if (this.userDefinedFilter.isActive()) {
            originList.add(this.userDefinedFilter);
        }
        if (this.importedFilter.isActive()) {
            originList.add(this.importedFilter);
        }
        if (this.analysisFilter.isActive()) {
            originList.add(this.analysisFilter);
        }
        if (this.defaultLabelFilter.isActive()) {
            originList.add(this.defaultLabelFilter);
        }
        if (this.defaultFunctionFilter.isActive()) {
            originList.add(this.defaultFunctionFilter);
        }
        this.activeOriginFilters = new Filter[originList.size()];
        originList.toArray(this.activeOriginFilters);
        ArrayList<Filter> typeList = new ArrayList<Filter>(this.labelFilters.length);
        for (Filter labelFilter : this.labelFilters) {
            if (!labelFilter.isActive()) continue;
            typeList.add(labelFilter);
        }
        for (Filter nonLabelFilter : this.nonLabelFilters) {
            if (!nonLabelFilter.isActive()) continue;
            typeList.add(nonLabelFilter);
        }
        this.activeTypeFilters = new Filter[typeList.size()];
        typeList.toArray(this.activeTypeFilters);
        ArrayList<Filter> advancedList = new ArrayList<Filter>(this.advancedFilters.length);
        for (Filter advancedFilter : this.advancedFilters) {
            if (!advancedFilter.isActive() || !advancedFilter.isEnabled()) continue;
            advancedList.add(advancedFilter);
        }
        this.activeAdvancedFilters = new AdvancedFilter[advancedList.size()];
        advancedList.toArray(this.activeAdvancedFilters);
        this.acceptsAllTypes = this.activeTypeFilters.length == this.labelFilters.length + this.nonLabelFilters.length;
        this.acceptsAllSources = this.userDefinedFilter.isActive() && this.analysisFilter.isActive() && this.defaultLabelFilter.isActive() && this.defaultFunctionFilter.isActive() && this.importedFilter.isActive();
        this.acceptsAll = this.acceptsAllTypes && this.acceptsAllSources && this.activeAdvancedFilters.length == 0;
    }

    private void createFilters() {
        this.userDefinedFilter = new Filter("User Defined", false, false){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.getSource() == SourceType.USER_DEFINED;
            }

            @Override
            String getDescription() {
                return "Include Symbols named by the user.";
            }
        };
        this.importedFilter = new Filter("Imported", false, false){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.getSource() == SourceType.IMPORTED;
            }

            @Override
            String getDescription() {
                return "Include Symbols imported from external information.";
            }
        };
        this.analysisFilter = new Filter("Analysis", false, false){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.getSource() == SourceType.ANALYSIS;
            }

            @Override
            String getDescription() {
                return "Include Symbols named by auto-analysis.";
            }
        };
        this.defaultLabelFilter = new Filter("Default (Labels)", true, false){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.getSymbolType() != SymbolType.FUNCTION && symbol.getSource() == SourceType.DEFAULT;
            }

            @Override
            String getDescription() {
                return "Include Symbols that have default names.";
            }
        };
        this.defaultFunctionFilter = new Filter("Default (Functions)", true, false){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.getSymbolType() == SymbolType.FUNCTION && symbol.getSource() == SourceType.DEFAULT;
            }

            @Override
            String getDescription() {
                return "Include Symbols that have default names.";
            }
        };
        Filter instructionFilter = new Filter("Instruction Labels", true, true){

            @Override
            boolean matches(Program program, Symbol symbol) {
                if (symbol.getSymbolType() == SymbolType.LABEL && !symbol.isExternal()) {
                    Address addr;
                    Listing l = program.getListing();
                    CodeUnit cu = l.getCodeUnitContaining(addr = symbol.getAddress());
                    if (cu == null) {
                        return true;
                    }
                    if (cu instanceof Instruction) {
                        return program.getFunctionManager().getFunctionAt(addr) == null;
                    }
                }
                return false;
            }

            @Override
            String getDescription() {
                return "Include labels on instructions.";
            }
        };
        Filter dataFilter = new Filter("Data Labels", true, true){

            @Override
            boolean matches(Program program, Symbol symbol) {
                if (symbol.getSymbolType() == SymbolType.LABEL) {
                    Address addr;
                    if (symbol.isExternal()) {
                        return true;
                    }
                    Listing l = program.getListing();
                    CodeUnit cu = l.getCodeUnitContaining(addr = symbol.getAddress());
                    if (cu == null) {
                        return true;
                    }
                    if (cu instanceof Data) {
                        return program.getFunctionManager().getFunctionAt(addr) == null;
                    }
                }
                return false;
            }

            @Override
            String getDescription() {
                return "Include labels on Data.";
            }
        };
        Filter functionFilter = new Filter("Function Labels", false, true){

            @Override
            boolean matches(Program program, Symbol symbol) {
                if (symbol.getSymbolType() == SymbolType.LABEL && !symbol.isExternal()) {
                    return program.getFunctionManager().getFunctionAt(symbol.getAddress()) != null;
                }
                return symbol.getSymbolType() == SymbolType.FUNCTION;
            }

            @Override
            String getDescription() {
                return "Include Labels at function entry points";
            }
        };
        Filter parameterFilter = new Filter("Parameters", false, false){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.getSymbolType() == SymbolType.PARAMETER;
            }

            @Override
            String getDescription() {
                return "Include Symbols that are function parameters";
            }
        };
        Filter localVarsFilter = new Filter("Local Variables", false, false){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.getSymbolType() == SymbolType.LOCAL_VAR;
            }

            @Override
            String getDescription() {
                return "Include Symbols that are function local variables.";
            }
        };
        Filter externalLibraryFilter = new Filter("External Library", false, false){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.getSymbolType() == SymbolType.LIBRARY;
            }

            @Override
            String getDescription() {
                return "Include Symbols that are External library names (e.g. Use32.dll).";
            }
        };
        Filter namespaceFilter = new Filter("Namespaces", false, false){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.getSymbolType() == SymbolType.NAMESPACE;
            }

            @Override
            String getDescription() {
                return "Include Symbols that are namespaces.";
            }
        };
        Filter classFilter = new Filter("Classes", false, false){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.getSymbolType() == SymbolType.CLASS;
            }

            @Override
            String getDescription() {
                return "Include Symbols that are C++ classes";
            }
        };
        Filter globalRegisterFilter = new Filter("Global Register Variables", false, false){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.getSymbolType() == SymbolType.GLOBAL_VAR;
            }

            @Override
            String getDescription() {
                return "Include Symbols that are global register variables";
            }
        };
        AdvancedFilter registerFilter = new AdvancedFilter("Register Variables"){

            @Override
            boolean matches(Program program, Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                if (type == SymbolType.LOCAL_VAR || type == SymbolType.PARAMETER) {
                    Variable var = (Variable)symbol.getObject();
                    return var.isRegisterVariable() || var.isCompoundVariable();
                }
                return false;
            }

            @Override
            boolean isApplicable(Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                return type == SymbolType.PARAMETER || type == SymbolType.LOCAL_VAR;
            }

            @Override
            String getDescription() {
                return "Only include Function parameters or local variables that are register based.\nThis Filter only affects parameters or local variables.";
            }
        };
        registerFilter.addApplicableFilter(parameterFilter);
        registerFilter.addApplicableFilter(localVarsFilter);
        AdvancedFilter stackFilter = new AdvancedFilter("Stack Variables"){

            @Override
            boolean matches(Program program, Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                if (type == SymbolType.LOCAL_VAR || type == SymbolType.PARAMETER) {
                    Variable var = (Variable)symbol.getObject();
                    return var.isStackVariable();
                }
                return false;
            }

            @Override
            boolean isApplicable(Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                return type == SymbolType.PARAMETER || type == SymbolType.LOCAL_VAR;
            }

            @Override
            String getDescription() {
                return "Only include Function parameters or local variables that are stack based.\nThis Filter only affects parameter or local variable symbols.";
            }
        };
        stackFilter.addApplicableFilter(parameterFilter);
        stackFilter.addApplicableFilter(localVarsFilter);
        AdvancedFilter externalFilter = new AdvancedFilter("Externals"){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.isExternal();
            }

            @Override
            boolean isApplicable(Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                return type == SymbolType.LABEL || type == SymbolType.CLASS || type == SymbolType.FUNCTION || type == SymbolType.NAMESPACE || type == SymbolType.PARAMETER || type == SymbolType.LOCAL_VAR;
            }

            @Override
            String getDescription() {
                return "Only include symbols that are external";
            }
        };
        externalFilter.addApplicableFilter(dataFilter);
        externalFilter.addApplicableFilter(instructionFilter);
        externalFilter.addApplicableFilter(classFilter);
        externalFilter.addApplicableFilter(functionFilter);
        externalFilter.addApplicableFilter(localVarsFilter);
        externalFilter.addApplicableFilter(parameterFilter);
        externalFilter.addApplicableFilter(namespaceFilter);
        AdvancedFilter nonExternalFilter = new AdvancedFilter("Non-Externals"){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return !symbol.isExternal();
            }

            @Override
            boolean isApplicable(Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                return type == SymbolType.LABEL || type == SymbolType.CLASS || type == SymbolType.FUNCTION || type == SymbolType.NAMESPACE || type == SymbolType.PARAMETER || type == SymbolType.LOCAL_VAR;
            }

            @Override
            String getDescription() {
                return "Only include symbols that are not external";
            }
        };
        nonExternalFilter.addApplicableFilter(dataFilter);
        nonExternalFilter.addApplicableFilter(instructionFilter);
        nonExternalFilter.addApplicableFilter(classFilter);
        nonExternalFilter.addApplicableFilter(functionFilter);
        nonExternalFilter.addApplicableFilter(localVarsFilter);
        nonExternalFilter.addApplicableFilter(parameterFilter);
        nonExternalFilter.addApplicableFilter(namespaceFilter);
        AdvancedFilter globalFilter = new AdvancedFilter("Globals"){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.isGlobal();
            }

            @Override
            boolean isApplicable(Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                return type == SymbolType.LABEL || type == SymbolType.CLASS || type == SymbolType.FUNCTION || type == SymbolType.NAMESPACE;
            }

            @Override
            String getDescription() {
                return "Only include symbols that in the global namespace.\nThis Filter only affects label, function, class, and namespace symbols.";
            }
        };
        globalFilter.addApplicableFilter(dataFilter);
        globalFilter.addApplicableFilter(instructionFilter);
        globalFilter.addApplicableFilter(classFilter);
        globalFilter.addApplicableFilter(functionFilter);
        globalFilter.addApplicableFilter(namespaceFilter);
        AdvancedFilter localFilter = new AdvancedFilter("Locals"){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return !symbol.isGlobal() && !symbol.isExternal();
            }

            @Override
            boolean isApplicable(Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                return type == SymbolType.LABEL || type == SymbolType.CLASS || type == SymbolType.FUNCTION || type == SymbolType.NAMESPACE;
            }

            @Override
            String getDescription() {
                return "Only include symbols that in a local namespace (i.e. not the global namespace.)\nThis Filter only affects label, function, class, and namespace symbols.";
            }
        };
        localFilter.addApplicableFilter(instructionFilter);
        localFilter.addApplicableFilter(dataFilter);
        localFilter.addApplicableFilter(classFilter);
        localFilter.addApplicableFilter(functionFilter);
        localFilter.addApplicableFilter(namespaceFilter);
        AdvancedFilter notInMemoryFilter = new AdvancedFilter("Not In Memory"){

            @Override
            boolean matches(Program program, Symbol symbol) {
                Memory mem = program.getMemory();
                return !mem.contains(symbol.getAddress());
            }

            @Override
            boolean isApplicable(Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                return type == SymbolType.LABEL;
            }

            @Override
            String getDescription() {
                return "Only include labels that are at addresses not contained in memory.\nThis Filter only affects label symbols.";
            }
        };
        notInMemoryFilter.addApplicableFilter(instructionFilter);
        notInMemoryFilter.addApplicableFilter(dataFilter);
        AdvancedFilter notReferencedFilter = new AdvancedFilter("Unreferenced"){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return !program.getReferenceManager().hasReferencesTo(symbol.getAddress());
            }

            @Override
            boolean isApplicable(Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                return type == SymbolType.LABEL || type == SymbolType.FUNCTION;
            }

            @Override
            String getDescription() {
                return "Only include labels or functions that have no references to them (i.e. dead code.)\nThis Filter only affects label and function symbols";
            }
        };
        notReferencedFilter.addApplicableFilter(instructionFilter);
        notReferencedFilter.addApplicableFilter(dataFilter);
        notReferencedFilter.addApplicableFilter(functionFilter);
        AdvancedFilter offcutFilter = new AdvancedFilter("Offcut Labels"){

            @Override
            boolean matches(Program program, Symbol symbol) {
                Listing l = program.getListing();
                CodeUnit cu = l.getCodeUnitContaining(symbol.getAddress());
                if (cu != null) {
                    return !cu.getMinAddress().equals((Object)symbol.getAddress());
                }
                return false;
            }

            @Override
            boolean isApplicable(Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                return type == SymbolType.LABEL || type == SymbolType.FUNCTION;
            }

            @Override
            String getDescription() {
                return "Only include labels at addresses that are offcut (i.e. inside an instruction or data item.\nThis Filter only affects label and function symbols.";
            }
        };
        offcutFilter.addApplicableFilter(instructionFilter);
        offcutFilter.addApplicableFilter(dataFilter);
        offcutFilter.addApplicableFilter(functionFilter);
        AdvancedFilter entryFilter = new AdvancedFilter("Entry Points"){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.isExternalEntryPoint();
            }

            @Override
            boolean isApplicable(Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                return type == SymbolType.LABEL || type == SymbolType.FUNCTION;
            }

            @Override
            String getDescription() {
                return "Only include labels or functions that are at external entry points.\nThis Filter only affects label and function symbols";
            }
        };
        entryFilter.addApplicableFilter(instructionFilter);
        entryFilter.addApplicableFilter(dataFilter);
        entryFilter.addApplicableFilter(functionFilter);
        AdvancedFilter subroutineFilter = new AdvancedFilter("Subroutines"){

            @Override
            boolean matches(Program program, Symbol symbol) {
                Reference[] refs;
                for (Reference ref : refs = symbol.getReferences(null)) {
                    if (!ref.getReferenceType().isCall()) continue;
                    return true;
                }
                return false;
            }

            @Override
            boolean isApplicable(Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                return type == SymbolType.LABEL;
            }

            @Override
            String getDescription() {
                return "Include labels that are \"called\" by some instruction.\nThis Filter only affects label symbols.";
            }
        };
        subroutineFilter.addApplicableFilter(instructionFilter);
        AdvancedFilter primaryFilter = new AdvancedFilter("Primary Labels"){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return symbol.isPrimary();
            }

            @Override
            boolean isApplicable(Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                return type == SymbolType.LABEL || type == SymbolType.FUNCTION;
            }

            @Override
            String getDescription() {
                return "Only include labels or functions that are the primary symbol at an address";
            }
        };
        primaryFilter.addApplicableFilter(instructionFilter);
        primaryFilter.addApplicableFilter(dataFilter);
        primaryFilter.addApplicableFilter(functionFilter);
        AdvancedFilter nonPrimaryFilter = new AdvancedFilter("Non-Primary Labels"){

            @Override
            boolean matches(Program program, Symbol symbol) {
                return !symbol.isPrimary();
            }

            @Override
            boolean isApplicable(Symbol symbol) {
                SymbolType type = symbol.getSymbolType();
                return type == SymbolType.LABEL || type == SymbolType.FUNCTION;
            }

            @Override
            String getDescription() {
                return "Only include labels or functions that are not the primary symbol at an address";
            }
        };
        nonPrimaryFilter.addApplicableFilter(instructionFilter);
        nonPrimaryFilter.addApplicableFilter(dataFilter);
        nonPrimaryFilter.addApplicableFilter(functionFilter);
        this.labelFilters = new Filter[]{instructionFilter, dataFilter, functionFilter};
        this.nonLabelFilters = new Filter[]{namespaceFilter, classFilter, externalLibraryFilter, parameterFilter, localVarsFilter, globalRegisterFilter};
        this.advancedFilters = new Filter[]{externalFilter, nonExternalFilter, primaryFilter, nonPrimaryFilter, globalFilter, localFilter, registerFilter, stackFilter, entryFilter, subroutineFilter, notInMemoryFilter, notReferencedFilter, offcutFilter};
    }

    private static abstract class Filter {
        protected static final String ELEMENT_NAME = "FILTER";
        protected static final String NAME_ATTRIBUTE = "NAME";
        protected static final String ACTIVE_ATTRIBUTE = "ACTIVE";
        protected static final String INCLUDES_DEFAULTS_ATTRIBUTE = "INCLUDES_DEFAULTS";
        protected static final String ONLY_CODE_SYMBOLS_ATTRIBUTE = "ONLY_CODE_SYMBOLS";
        protected String name;
        protected boolean active;
        private boolean includesDefaults;
        private boolean onlyCodeSymbols;

        Filter(String name, boolean includesDefaults, boolean onlyCodeSymbols) {
            this.name = name;
            this.includesDefaults = includesDefaults;
            this.onlyCodeSymbols = onlyCodeSymbols;
        }

        abstract boolean matches(Program var1, Symbol var2);

        abstract String getDescription();

        Element saveToXml() {
            Element element = new Element(ELEMENT_NAME);
            element.setAttribute(NAME_ATTRIBUTE, this.name);
            element.setAttribute(ACTIVE_ATTRIBUTE, Boolean.toString(this.active));
            element.setAttribute(INCLUDES_DEFAULTS_ATTRIBUTE, Boolean.toString(this.includesDefaults));
            element.setAttribute(ONLY_CODE_SYMBOLS_ATTRIBUTE, Boolean.toString(this.onlyCodeSymbols));
            return element;
        }

        void restoreFromXml(Element element) {
            String nameValue = element.getAttributeValue(NAME_ATTRIBUTE);
            if (nameValue == null) {
                Msg.error((Object)this, (Object)("No name found for xml element: " + this.name));
                return;
            }
            this.name = nameValue;
            this.active = this.parseBooleanAttribute(element, ACTIVE_ATTRIBUTE);
            this.includesDefaults = this.parseBooleanAttribute(element, INCLUDES_DEFAULTS_ATTRIBUTE);
            this.onlyCodeSymbols = this.parseBooleanAttribute(element, ONLY_CODE_SYMBOLS_ATTRIBUTE);
        }

        protected boolean parseBooleanAttribute(Element element, String attributeName) {
            String value = element.getAttributeValue(attributeName, Boolean.FALSE.toString());
            return Boolean.parseBoolean(value);
        }

        boolean isEnabled() {
            return true;
        }

        String getName() {
            return this.name;
        }

        boolean isActive() {
            return this.active;
        }

        void setActive(boolean b) {
            this.active = b;
        }
    }

    private static abstract class AdvancedFilter
    extends Filter {
        private static final String ADVANCED_ELEMENT_NAME = "ADVANCED_FILTER";
        List<Filter> applicableFilters = new ArrayList<Filter>();

        AdvancedFilter(String name) {
            super(name, false, false);
        }

        abstract boolean isApplicable(Symbol var1);

        void addApplicableFilter(Filter filter) {
            this.applicableFilters.add(filter);
        }

        @Override
        boolean isEnabled() {
            for (Filter filter : this.applicableFilters) {
                if (!filter.isActive()) continue;
                return true;
            }
            return false;
        }

        @Override
        Element saveToXml() {
            Element element = new Element(ADVANCED_ELEMENT_NAME);
            element.setAttribute("NAME", this.name);
            element.setAttribute("ACTIVE", Boolean.toString(this.active));
            for (Filter subFilter : this.applicableFilters) {
                Element subElement = subFilter.saveToXml();
                element.addContent((Content)subElement);
            }
            return element;
        }

        @Override
        void restoreFromXml(Element element) {
            if (!ADVANCED_ELEMENT_NAME.equals(element.getName())) {
                Msg.error((Object)this, (Object)("Incorrect xml stored for filter: " + this.name));
                return;
            }
            String nameValue = element.getAttributeValue("NAME");
            if (nameValue == null) {
                Msg.error((Object)this, (Object)("No name found for xml element: " + this.name));
                return;
            }
            this.name = nameValue;
            this.active = this.parseBooleanAttribute(element, "ACTIVE");
            List children = element.getChildren();
            for (Element child : children) {
                String childName = child.getAttributeValue("NAME");
                Filter childFilter = this.getFilter(childName);
                if (childFilter == null) {
                    Msg.error((Object)this, (Object)("Unable to locate advanced sub-filter: " + childName));
                    continue;
                }
                childFilter.restoreFromXml(child);
            }
        }

        private Filter getFilter(String childName) {
            for (Filter filter : this.applicableFilters) {
                if (!filter.getName().equals(childName)) continue;
                return filter;
            }
            return null;
        }
    }
}

