/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.table;

import docking.ComponentProvider;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.table.MyTableChooserDialog;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerService;
import ghidra.app.tablechooser.TableChooserDialog;
import ghidra.app.tablechooser.TableChooserExecutor;
import ghidra.app.util.query.TableService;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.actions.DeleteTableRowAction;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Support", shortDescription="Results table service", description="Provides a generic results service that takes a list of information and displays the list to user in the form of a table", servicesProvided={TableService.class}, eventsConsumed={ProgramClosedPluginEvent.class})
public class TableServicePlugin
extends ProgramPlugin
implements TableService,
DomainObjectListener {
    private SwingUpdateManager updateMgr;
    private Map<Program, List<TableComponentProvider<?>>> programMap = new HashMap();
    private Map<Program, List<TableChooserDialog>> programToDialogMap = new HashMap<Program, List<TableChooserDialog>>();

    public TableServicePlugin(PluginTool tool) {
        super(tool, false, false);
        this.updateMgr = new SwingUpdateManager(1000, () -> this.updateProviders());
        this.createActions();
    }

    private void createActions() {
        DeleteTableRowAction.registerDummy(this.tool, this.getName());
    }

    protected void dispose() {
        this.programMap.clear();
        this.updateMgr.dispose();
        super.dispose();
    }

    @Override
    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            Program p = ((ProgramClosedPluginEvent)event).getProgram();
            this.closeAllQueries(p);
        } else {
            super.processEvent(event);
        }
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
    }

    private void closeAllQueries(Program program) {
        this.clearTableComponentProviders(program);
        this.clearTableDialogs(program);
    }

    private void clearTableComponentProviders(Program program) {
        List<TableComponentProvider<?>> plist = this.programMap.get(program);
        if (plist == null) {
            return;
        }
        ArrayList list = new ArrayList(plist);
        for (int i = 0; i < list.size(); ++i) {
            ComponentProvider provider = (ComponentProvider)list.get(i);
            provider.closeComponent();
        }
        this.programMap.remove(program);
    }

    private void clearTableDialogs(Program program) {
        List<TableChooserDialog> dlist = this.programToDialogMap.get(program);
        if (dlist == null) {
            return;
        }
        ArrayList<TableChooserDialog> list = new ArrayList<TableChooserDialog>(dlist);
        for (int i = 0; i < list.size(); ++i) {
            TableChooserDialog dialog = (TableChooserDialog)list.get(i);
            dialog.close();
        }
        this.programMap.remove(program);
    }

    @Override
    public <T> TableComponentProvider<T> showTable(String title, String tableTypeName, GhidraProgramTableModel<T> model, String windowSubMenu, Navigatable navigatable) {
        GoToService gotoService = (GoToService)this.tool.getService(GoToService.class);
        if (gotoService != null && navigatable == null) {
            navigatable = gotoService.getDefaultNavigatable();
        }
        Program program = model.getProgram();
        TableComponentProvider<T> cp = new TableComponentProvider<T>(this, title, tableTypeName, model, program.getDomainFile().getName(), gotoService, windowSubMenu, navigatable);
        this.addProvider(program, cp);
        return cp;
    }

    @Override
    public <T> TableComponentProvider<T> showTableWithMarkers(String title, String tableTypeName, GhidraProgramTableModel<T> model, Color markerColor, ImageIcon markerIcon, String windowSubMenu, Navigatable navigatable) {
        GoToService gotoService = (GoToService)this.tool.getService(GoToService.class);
        if (gotoService != null && navigatable == null) {
            navigatable = gotoService.getDefaultNavigatable();
        }
        MarkerService markerService = (MarkerService)this.tool.getService(MarkerService.class);
        Program program = model.getProgram();
        TableComponentProvider<T> cp = new TableComponentProvider<T>(this, title, tableTypeName, model, program.getDomainFile().getName(), gotoService, markerService, markerColor, markerIcon, windowSubMenu, navigatable);
        this.addProvider(program, cp);
        return cp;
    }

    private void addProvider(Program program, TableComponentProvider<?> provider) {
        List<TableComponentProvider<?>> list = this.programMap.get(program);
        if (list == null) {
            list = new ArrayList();
            this.programMap.put(program, list);
        }
        list.add(provider);
    }

    void remove(TableComponentProvider<?> provider) {
        for (Program p : this.programMap.keySet()) {
            List<TableComponentProvider<?>> list = this.programMap.get(p);
            if (!list.remove(provider) || list.size() != 0) continue;
            this.programMap.remove(p);
            return;
        }
    }

    void removeDialog(MyTableChooserDialog dialog) {
        for (Program p : this.programToDialogMap.keySet()) {
            List<TableChooserDialog> list = this.programToDialogMap.get(p);
            if (!list.remove(dialog) || list.size() != 0) continue;
            this.programToDialogMap.remove(p);
            return;
        }
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        this.updateMgr.update();
    }

    public TableComponentProvider<?>[] getManagedComponents() {
        List<TableComponentProvider<?>> clist = this.getProviders();
        return clist.toArray(new TableComponentProvider[clist.size()]);
    }

    Program getProgram() {
        return this.currentProgram;
    }

    private List<TableComponentProvider<?>> getProviders() {
        ArrayList clist = new ArrayList();
        for (List<TableComponentProvider<?>> list : this.programMap.values()) {
            clist.addAll(list);
        }
        return clist;
    }

    private void updateProviders() {
        List<TableComponentProvider<?>> list = this.getProviders();
        for (int i = 0; i < list.size(); ++i) {
            TableComponentProvider<?> provider = list.get(i);
            provider.refresh();
        }
    }

    @Override
    public TableChooserDialog createTableChooserDialog(TableChooserExecutor executor, Program program, String title, Navigatable navigatable) {
        return this.createTableChooserDialog(executor, program, title, navigatable, false);
    }

    @Override
    public TableChooserDialog createTableChooserDialog(TableChooserExecutor executor, Program program, String title, Navigatable navigatable, boolean isModal) {
        GoToService gotoService = (GoToService)this.tool.getService(GoToService.class);
        if (gotoService != null && navigatable == null) {
            navigatable = gotoService.getDefaultNavigatable();
        }
        MyTableChooserDialog dialog = new MyTableChooserDialog(this, executor, program, title, navigatable, isModal);
        List<TableChooserDialog> list = this.programToDialogMap.get(program);
        if (list == null) {
            list = new ArrayList<TableChooserDialog>();
            this.programToDialogMap.put(program, list);
        }
        list.add(dialog);
        return dialog;
    }
}

