/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.osgi.BundleHost;
import ghidra.app.plugin.core.osgi.GhidraBundleException;
import ghidra.app.plugin.core.osgi.GhidraSourceBundle;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import org.osgi.framework.Bundle;

public class JavaScriptProvider
extends GhidraScriptProvider {
    private final BundleHost bundleHost = GhidraScriptUtil.getBundleHost();

    public GhidraSourceBundle getBundleForSource(ResourceFile sourceFile) {
        ResourceFile sourceDir = GhidraScriptUtil.findSourceDirectoryContaining(sourceFile);
        if (sourceDir == null) {
            return null;
        }
        return (GhidraSourceBundle)this.bundleHost.getExistingGhidraBundle(sourceDir);
    }

    @Override
    public String getDescription() {
        return "Java";
    }

    @Override
    public String getExtension() {
        return ".java";
    }

    @Override
    public boolean deleteScript(ResourceFile sourceFile) {
        try {
            Bundle osgiBundle = this.getBundleForSource(sourceFile).getOSGiBundle();
            if (osgiBundle != null) {
                this.bundleHost.deactivateSynchronously(osgiBundle);
            }
        }
        catch (GhidraBundleException e) {
            Msg.error((Object)this, (Object)"Error while deactivating bundle for delete", (Throwable)((Object)e));
            return false;
        }
        return super.deleteScript(sourceFile);
    }

    @Override
    public GhidraScript getScriptInstance(ResourceFile sourceFile, PrintWriter writer) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            Class<?> clazz = this.loadClass(sourceFile, writer);
            Object object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (object instanceof GhidraScript) {
                GhidraScript script = (GhidraScript)object;
                script.setSourceFile(sourceFile);
                return script;
            }
            String message = "Not a valid Ghidra script: " + sourceFile.getName();
            writer.println(message);
            Msg.error((Object)this, (Object)message);
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassNotFoundException("", e);
        }
    }

    public Class<?> loadClass(ResourceFile sourceFile, PrintWriter writer) throws Exception {
        GhidraSourceBundle bundle = this.getBundleForSource(sourceFile);
        if (bundle == null) {
            throw new ClassNotFoundException("Failed to find source bundle containing script: " + sourceFile.toString());
        }
        this.bundleHost.activateAll(Collections.singletonList(bundle), TaskMonitor.DUMMY, writer);
        String classname = bundle.classNameForScript(sourceFile);
        Class clazz = bundle.getOSGiBundle().loadClass(classname);
        return clazz;
    }

    @Override
    public void createNewScript(ResourceFile newScript, String category) throws IOException {
        String scriptName;
        String className = scriptName = newScript.getName();
        int dotpos = scriptName.lastIndexOf(46);
        if (dotpos >= 0) {
            className = scriptName.substring(0, dotpos);
        }
        PrintWriter writer = new PrintWriter(new FileWriter(newScript.getFile(false)));
        this.writeHeader(writer, category);
        writer.println("import ghidra.app.script.GhidraScript;");
        for (Package pkg : Package.getPackages()) {
            if (!pkg.getName().startsWith("ghidra.program.model.")) continue;
            writer.println("import " + pkg.getName() + ".*;");
        }
        writer.println("");
        writer.println("public class " + className + " extends GhidraScript {");
        writer.println("");
        writer.println("    public void run() throws Exception {");
        this.writeBody(writer);
        writer.println("    }");
        writer.println("");
        writer.println("}");
        writer.close();
    }

    @Override
    public String getCommentCharacter() {
        return "//";
    }
}

