/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import ghidra.app.cmd.label.AddLabelCmd;
import ghidra.app.cmd.label.CreateNamespacesCmd;
import ghidra.app.cmd.label.ExternalEntryCmd;
import ghidra.app.cmd.label.PinSymbolCmd;
import ghidra.app.cmd.label.RenameLabelCmd;
import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringUtils;

public class AddEditDialog
extends DialogComponentProvider {
    private static final int MAX_RETENTION = 10;
    private PluginTool tool;
    private TitledBorder nameBorder;
    private JComboBox<String> labelNameChoices;
    private JComboBox<NamespaceWrapper> namespaceChoices;
    private JCheckBox entryPointCheckBox;
    private JCheckBox primaryCheckBox;
    private List<String> recentLabels = new ArrayList<String>();
    private Program program;
    private Symbol symbol;
    private Address addr;
    private JCheckBox pinnedCheckBox;

    public AddEditDialog(String title, PluginTool tool) {
        super(title, true, true, true, false);
        this.tool = tool;
        this.setHelpLocation(new HelpLocation("LabelMgrPlugin", "AddEditDialog"));
        this.addWorkPanel(this.create());
        this.setFocusComponent(this.labelNameChoices);
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
    }

    public void addLabel(Address address, Program prog) {
        this.addLabel(address, prog, this.tool.getActiveWindow());
    }

    public void addLabel(Address address, Program targetProgram, ComponentProvider provider) {
        this.initDialogForAdd(targetProgram, address);
        this.tool.showDialog((DialogComponentProvider)this, provider);
    }

    public void addLabel(Address address, Program targetProgram, Component centeredOverComponent) {
        this.initDialogForAdd(targetProgram, address);
        this.tool.showDialog((DialogComponentProvider)this, centeredOverComponent);
    }

    public void editLabel(Symbol targetSymbol, Program targetProgram) {
        ComponentProvider componentProvider = this.tool.getComponentProvider("Listing");
        JComponent component = componentProvider.getComponent();
        this.editLabel(targetSymbol, targetProgram, component);
    }

    public void editLabel(Symbol targetSymbol, Program targetProgram, Component centeredOverComponent) {
        this.initDialogForEdit(targetProgram, targetSymbol);
        this.tool.showDialog((DialogComponentProvider)this, centeredOverComponent);
    }

    public void editLabel(Symbol targetSymbol, Program targetProgram, ComponentProvider provider) {
        this.initDialogForEdit(targetProgram, targetSymbol);
        this.tool.showDialog((DialogComponentProvider)this, provider);
    }

    protected void okCallback() {
        String labelText = this.getText();
        Namespace namespace = this.getSelectedNamespace();
        SymbolPath symbolPath = this.getSymbolPath(labelText);
        if (symbolPath == null) {
            return;
        }
        String symbolName = symbolPath.getName();
        Namespace parent = this.getOrCreateNamespaces(symbolPath, namespace);
        if (parent == null) {
            return;
        }
        boolean isCurrentlyEntryPoint = false;
        boolean isCurrentlyPinned = false;
        CompoundCmd cmd = new CompoundCmd(this.symbol == null ? "Add Label" : "Edit Label");
        if (this.symbol == null) {
            cmd.add((Command)new AddLabelCmd(this.addr, symbolName, parent, SourceType.USER_DEFINED));
        } else {
            cmd.add((Command)new RenameLabelCmd(this.addr, this.symbol.getName(), symbolName, this.symbol.getParentNamespace(), parent, SourceType.USER_DEFINED));
            isCurrentlyEntryPoint = this.symbol.isExternalEntryPoint();
            isCurrentlyPinned = this.symbol.isPinned();
        }
        if (this.primaryCheckBox.isEnabled() && this.primaryCheckBox.isSelected()) {
            cmd.add((Command)new SetLabelPrimaryCmd(this.addr, symbolName, parent));
        }
        if (this.entryPointCheckBox.isEnabled() && this.entryPointCheckBox.isSelected() != isCurrentlyEntryPoint) {
            cmd.add((Command)new ExternalEntryCmd(this.addr, !isCurrentlyEntryPoint));
        }
        if (this.pinnedCheckBox.isEnabled() && this.pinnedCheckBox.isSelected() != isCurrentlyPinned) {
            cmd.add((Command)new PinSymbolCmd(this.addr, symbolName, !isCurrentlyPinned));
        }
        if (cmd.size() > 0) {
            if (!this.tool.execute((Command)cmd, (DomainObject)this.program)) {
                this.setStatusText(cmd.getStatusMsg());
                return;
            }
            this.updateRecentLabels(symbolName);
        }
        this.program = null;
        this.close();
    }

    private SymbolPath getSymbolPath(String symbolName) {
        if (StringUtils.isBlank((CharSequence)symbolName)) {
            this.setStatusText("Name cannot be blank");
            return null;
        }
        return new SymbolPath(symbolName);
    }

    private Namespace getSelectedNamespace() {
        Object selectedItem = this.namespaceChoices.getSelectedItem();
        if (selectedItem == null) {
            return null;
        }
        return ((NamespaceWrapper)selectedItem).getNamespace();
    }

    private Namespace getOrCreateNamespaces(SymbolPath symbolPath, Namespace rootNamespace) {
        Namespace functionNamespace;
        SymbolPath parentPath = symbolPath.getParent();
        if (parentPath == null) {
            return rootNamespace;
        }
        SymbolPath fullPath = new SymbolPath(rootNamespace.getSymbol()).append(parentPath);
        Namespace nonFunctionNs = NamespaceUtils.getNonFunctionNamespace((Program)this.program, (SymbolPath)fullPath);
        if (nonFunctionNs != null) {
            return nonFunctionNs;
        }
        String name = symbolPath.getName();
        if (!parentPath.containsPathEntry(name) && (functionNamespace = NamespaceUtils.getFunctionNamespaceContaining((Program)this.program, (SymbolPath)parentPath, (Address)this.addr)) != null) {
            return functionNamespace;
        }
        CreateNamespacesCmd cmd = new CreateNamespacesCmd(parentPath.getPath(), rootNamespace, SourceType.USER_DEFINED);
        if (this.tool.execute((Command)cmd, (DomainObject)this.program)) {
            return cmd.getNamespace();
        }
        this.setStatusText(cmd.getStatusMsg());
        return null;
    }

    private void initRecentChoices() {
        this.labelNameChoices.removeAllItems();
        Iterator<String> it = this.recentLabels.iterator();
        while (it.hasNext()) {
            this.labelNameChoices.addItem(it.next());
        }
        if (this.recentLabels.size() > 0) {
            this.labelNameChoices.setSelectedIndex(-1);
        }
    }

    private void initNamespaces() {
        Namespace symbolNamespace;
        this.namespaceChoices.removeAllItems();
        if (!this.namespaceChoices.isEnabled()) {
            this.namespaceChoices.addItem(new NamespaceWrapper(this.symbol.getParentNamespace()));
            this.selectNamespace();
            return;
        }
        HashSet<NamespaceWrapper> collection = new HashSet<NamespaceWrapper>();
        Namespace globalNamespace = this.program.getGlobalNamespace();
        NamespaceWrapper composite = new NamespaceWrapper(globalNamespace);
        this.namespaceChoices.addItem(composite);
        collection.add(composite);
        if (this.symbol == null || this.symbol != null && this.symbol.getSymbolType() != SymbolType.FUNCTION) {
            for (Namespace currentNamespace = this.program.getSymbolTable().getNamespace(this.addr); currentNamespace != globalNamespace; currentNamespace = currentNamespace.getParentNamespace()) {
                composite = new NamespaceWrapper(currentNamespace);
                if (collection.contains(composite)) continue;
                collection.add(composite);
                this.namespaceChoices.addItem(composite);
            }
        }
        if (this.symbol != null && !collection.contains(composite = new NamespaceWrapper(symbolNamespace = this.symbol.getParentNamespace()))) {
            collection.add(composite);
            this.namespaceChoices.insertItemAt(composite, 1);
        }
        this.selectNamespace();
    }

    private void selectNamespace() {
        if (this.symbol != null && this.symbol.getParentNamespace() != null) {
            this.namespaceChoices.setSelectedItem(new NamespaceWrapper(this.symbol.getParentNamespace()));
            return;
        }
        SymbolTable symbolTable = this.program.getSymbolTable();
        Namespace localNamespace = symbolTable.getNamespace(this.addr);
        FunctionSymbol functionSymbol = this.getFunctionSymbol(this.addr);
        if (functionSymbol != null) {
            if (this.symbol != null && this.symbol.equals(functionSymbol)) {
                this.namespaceChoices.setSelectedItem(new NamespaceWrapper(functionSymbol.getParentNamespace()));
            } else if (functionSymbol.getSource() == SourceType.DEFAULT) {
                this.namespaceChoices.setSelectedItem(new NamespaceWrapper(functionSymbol.getParentNamespace()));
            } else {
                this.namespaceChoices.setSelectedItem(new NamespaceWrapper(localNamespace));
            }
        } else {
            FunctionManager functionManager = this.program.getFunctionManager();
            Function function = functionManager.getFunctionContaining(this.addr);
            if (function != null) {
                this.namespaceChoices.setSelectedItem(new NamespaceWrapper(localNamespace));
            } else if (this.symbol != null) {
                this.namespaceChoices.setSelectedItem(new NamespaceWrapper(this.symbol.getParentNamespace()));
            } else {
                this.namespaceChoices.setSelectedIndex(0);
            }
        }
    }

    private FunctionSymbol getFunctionSymbol(Address address) {
        Symbol[] symbols;
        SymbolTable symbolTable = this.program.getSymbolTable();
        for (Symbol localSymbol : symbols = symbolTable.getSymbols(address)) {
            if (!(localSymbol instanceof FunctionSymbol)) continue;
            return (FunctionSymbol)localSymbol;
        }
        return null;
    }

    private void initDialogForAdd(Program p, Address address) {
        if (!address.isMemoryAddress()) {
            throw new IllegalArgumentException("AddEditDialog.addLabel only valid for memory address");
        }
        this.addr = address;
        this.program = p;
        SymbolTable symbolTable = p.getSymbolTable();
        this.symbol = null;
        this.setTitle("Add Label at " + address);
        this.initRecentChoices();
        this.entryPointCheckBox.setEnabled(true);
        this.entryPointCheckBox.setSelected(symbolTable.isExternalEntryPoint(address));
        this.pinnedCheckBox.setEnabled(true);
        this.pinnedCheckBox.setSelected(false);
        Symbol[] symbols = symbolTable.getSymbols(address);
        FunctionSymbol functionSymbol = this.getFunctionSymbol(address);
        if (functionSymbol == null && symbols.length == 0) {
            this.primaryCheckBox.setSelected(true);
            this.primaryCheckBox.setEnabled(false);
        } else {
            this.primaryCheckBox.setSelected(false);
            this.primaryCheckBox.setEnabled(true);
        }
        this.namespaceChoices.setEnabled(true);
        this.initNamespaces();
        this.clearStatusText();
    }

    private void initDialogForEdit(Program p, Symbol s) {
        this.symbol = s;
        this.program = p;
        this.addr = s.getAddress();
        SymbolTable symbolTable = this.program.getSymbolTable();
        this.initRecentChoices();
        this.labelNameChoices.setSelectedItem(this.symbol.getName());
        if (s.getSymbolType() == SymbolType.FUNCTION) {
            Object title;
            if (s.isExternal()) {
                ExternalLocation extLoc = this.program.getExternalManager().getExternalLocation(s);
                Address fnAddr = extLoc.getAddress();
                title = "Rename External Function";
                if (fnAddr != null) {
                    title = (String)title + " at " + fnAddr;
                }
            } else {
                title = "Rename Function at " + this.addr;
            }
            this.setTitle((String)title);
            this.nameBorder.setTitle("Enter Name:");
            this.entryPointCheckBox.setEnabled(true);
            this.entryPointCheckBox.setSelected(symbolTable.isExternalEntryPoint(this.addr));
            this.primaryCheckBox.setSelected(true);
            this.primaryCheckBox.setEnabled(false);
            this.pinnedCheckBox.setEnabled(true);
            this.pinnedCheckBox.setSelected(s.isPinned());
            this.namespaceChoices.setEnabled(true);
        } else if (this.addr.isVariableAddress()) {
            String type = s.getSymbolType() == SymbolType.PARAMETER ? "Parameter" : "Local Variable";
            this.setTitle("Rename " + type + ": " + this.symbol.getName());
            this.nameBorder.setTitle("Enter Name:");
            this.entryPointCheckBox.setEnabled(false);
            this.entryPointCheckBox.setSelected(false);
            this.pinnedCheckBox.setEnabled(false);
            this.pinnedCheckBox.setSelected(false);
            this.primaryCheckBox.setSelected(true);
            this.primaryCheckBox.setEnabled(false);
            this.namespaceChoices.setEnabled(false);
        } else {
            this.setTitle("Edit Label at " + this.addr);
            this.nameBorder.setTitle("Enter Label:");
            this.entryPointCheckBox.setEnabled(true);
            this.entryPointCheckBox.setSelected(symbolTable.isExternalEntryPoint(this.addr));
            Symbol[] symbols = symbolTable.getSymbols(this.addr);
            this.primaryCheckBox.setSelected(s.isPrimary());
            this.primaryCheckBox.setEnabled(!s.isPrimary() && symbols.length > 1);
            this.pinnedCheckBox.setEnabled(true);
            this.pinnedCheckBox.setSelected(s.isPinned());
            this.namespaceChoices.setEnabled(true);
        }
        this.initNamespaces();
        this.clearStatusText();
    }

    private JPanel create() {
        this.labelNameChoices = new GhidraComboBox();
        GhidraComboBox comboBox = new GhidraComboBox();
        comboBox.setEnterKeyForwarding(true);
        this.namespaceChoices = comboBox;
        this.primaryCheckBox = new GCheckBox("Primary");
        this.primaryCheckBox.setMnemonic('P');
        this.primaryCheckBox.setToolTipText("Make this label be the one that shows up in references to this location.");
        this.entryPointCheckBox = new GCheckBox("Entry Point  ");
        this.entryPointCheckBox.setMnemonic('E');
        this.entryPointCheckBox.setToolTipText("Mark this location as an external entry point.");
        this.pinnedCheckBox = new GCheckBox("Pinned");
        this.pinnedCheckBox.setMnemonic('A');
        this.pinnedCheckBox.setToolTipText("Do not allow this label to move when the image base changes or a memory block is moved.");
        this.labelNameChoices.setEditable(true);
        JPanel mainPanel = new JPanel((LayoutManager)new VerticalLayout(4));
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel midPanel = new JPanel(new BorderLayout());
        JPanel bottomPanel = new JPanel();
        this.nameBorder = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Enter Label");
        topPanel.setBorder(this.nameBorder);
        Border border = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Namespace");
        midPanel.setBorder(border);
        border = BorderFactory.createEmptyBorder(5, 0, 0, 5);
        bottomPanel.setBorder(border);
        mainPanel.add(topPanel);
        mainPanel.add(midPanel);
        mainPanel.add(bottomPanel);
        topPanel.add(this.labelNameChoices, "North");
        midPanel.add(this.namespaceChoices, "North");
        bottomPanel.add(this.entryPointCheckBox);
        bottomPanel.add(this.primaryCheckBox);
        bottomPanel.add(this.pinnedCheckBox);
        bottomPanel.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.addListeners();
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        return mainPanel;
    }

    private void addListeners() {
        this.labelNameChoices.addActionListener(e -> {
            if (this.program != null) {
                this.okCallback();
            }
        });
    }

    private void updateRecentLabels(String label) {
        if (!this.recentLabels.contains(label)) {
            this.recentLabels.add(0, label);
            int size = this.recentLabels.size();
            if (size > 10) {
                this.recentLabels.remove(size - 1);
            }
        }
    }

    private String getText() {
        Component comp = this.labelNameChoices.getEditor().getEditorComponent();
        if (comp instanceof JTextField) {
            JTextField textField = (JTextField)comp;
            return textField.getText().trim();
        }
        throw new AssertException("Using an uneditable JComboBox - this class must be updated.");
    }

    public class NamespaceWrapper {
        private Namespace namespace;

        public NamespaceWrapper(Namespace namespace) {
            this.namespace = namespace;
        }

        public Namespace getNamespace() {
            return this.namespace;
        }

        public String toString() {
            return this.namespace.getName(true);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() == this.getClass()) {
                NamespaceWrapper w = (NamespaceWrapper)object;
                return this.namespace.equals(w.namespace);
            }
            return false;
        }

        public int hashCode() {
            return this.namespace.hashCode();
        }
    }
}

