/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.util.InvalidNameException;

public class DataTypeNamingUtil {
    private DataTypeNamingUtil() {
    }

    public static String setMangledAnonymousFunctionName(FunctionDefinitionDataType functionDefinition, String namePrefix) throws IllegalArgumentException {
        DataType returnType = functionDefinition.getReturnType();
        ParameterDefinition[] parameters = functionDefinition.getArguments();
        if (namePrefix == null) {
            namePrefix = "_function";
        }
        StringBuilder sb = new StringBuilder(namePrefix);
        GenericCallingConvention convention = functionDefinition.getGenericCallingConvention();
        if (convention != null && convention != GenericCallingConvention.unknown) {
            sb.append(convention.getDeclarationName());
        }
        sb.append("_");
        sb.append(DataTypeNamingUtil.mangleDTName(returnType.getName()));
        for (ParameterDefinition p : parameters) {
            sb.append("_").append(DataTypeNamingUtil.mangleDTName(p.getDataType().getName()));
        }
        if (functionDefinition.hasVarArgs()) {
            sb.append("_").append("varargs");
        }
        String name = sb.toString();
        try {
            functionDefinition.setName(name);
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException(e);
        }
        return name;
    }

    private static String mangleDTName(String s) {
        return s.replaceAll(" ", "_").replaceAll("\\*", "ptr");
    }
}

