/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class MemBufferByteProvider
implements ByteProvider {
    private MemBuffer buffer;

    public MemBufferByteProvider(MemBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getAbsolutePath() {
        return null;
    }

    @Override
    public long length() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isValidIndex(long index) {
        if (index < 0L || index > Integer.MAX_VALUE) {
            return false;
        }
        try {
            this.buffer.getByte((int)index);
            return true;
        }
        catch (MemoryAccessException e) {
            return false;
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public byte readByte(long index) throws IOException {
        if (index < 0L || index > Integer.MAX_VALUE) {
            throw new IOException("index out of range");
        }
        try {
            return this.buffer.getByte((int)index);
        }
        catch (MemoryAccessException e) {
            throw new IOException("index out of range");
        }
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        if (index < 0L || index + length - 1L > Integer.MAX_VALUE) {
            throw new IOException("index/length of range");
        }
        int len = (int)length;
        byte[] bytes = new byte[len];
        if (this.buffer.getBytes(bytes, (int)index) != len) {
            throw new IOException("index/length of range");
        }
        return bytes;
    }

    @Override
    public InputStream getInputStream(long index) throws IOException {
        if (index < 0L || index > Integer.MAX_VALUE) {
            throw new IOException("index out of range");
        }
        return new MemBufferProviderInputStream((int)index);
    }

    private class MemBufferProviderInputStream
    extends InputStream {
        private int initialOffset;
        private int offset;

        MemBufferProviderInputStream(int offset) {
            this.offset = offset;
            this.initialOffset = offset;
        }

        @Override
        public int read() throws IOException {
            byte b = MemBufferByteProvider.this.readByte(this.offset++);
            return b & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            byte[] bytes = new byte[len];
            int count = MemBufferByteProvider.this.buffer.getBytes(bytes, this.offset);
            System.arraycopy(bytes, 0, b, off, count);
            this.offset += count;
            return count;
        }

        @Override
        public int available() {
            return (int)MemBufferByteProvider.this.length() - this.offset;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.offset = this.initialOffset;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

