/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff.archive;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.archive.LongNamesMember;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CoffArchiveMemberHeader
implements StructConverter {
    public static final String SLASH = "/";
    public static final String SLASH_SLASH = "//";
    private static final int CAMH_NAME_OFF = 0;
    private static final int CAMH_NAME_LEN = 16;
    private static final int CAMH_DATE_OFF = 16;
    private static final int CAMH_DATE_LEN = 12;
    private static final int CAMH_USERID_OFF = 28;
    private static final int CAMH_USERID_LEN = 6;
    private static final int CAMH_GROUPID_OFF = 34;
    private static final int CAMH_GROUPID_LEN = 6;
    private static final int CAMH_MODE_OFF = 40;
    private static final int CAMH_MODE_LEN = 8;
    private static final int CAMH_SIZE_OFF = 48;
    private static final int CAMH_SIZE_LEN = 10;
    private static final int CAMH_EOH_OFF = 58;
    private static final int CAMH_EOH_LEN = 2;
    private static final String CAMH_EOH_MAGIC = "`\n";
    private static final int CAMH_PAYLOAD_OFF = 60;
    public static final int CAMH_MIN_SIZE = 60;
    private String name;
    private long date;
    private String userId;
    private String groupId;
    private String mode;
    private long size;
    private long payloadOffset = -1L;
    private long memberOffset = -1L;

    /*
     * Unable to fully structure code
     */
    public static CoffArchiveMemberHeader read(BinaryReader reader, LongNamesMember longNames) throws IOException {
        CoffArchiveMemberHeader.align(reader);
        headerOffset = reader.getPointerIndex();
        name = reader.readFixedLenAsciiString(headerOffset + 0L, 16).trim();
        dateStr = reader.readFixedLenAsciiString(headerOffset + 16L, 12).trim();
        userId = reader.readFixedLenAsciiString(headerOffset + 28L, 6).trim();
        groupId = reader.readFixedLenAsciiString(headerOffset + 34L, 6).trim();
        mode = reader.readFixedLenAsciiString(headerOffset + 40L, 8).trim();
        sizeStr = reader.readFixedLenAsciiString(headerOffset + 48L, 10).trim();
        endOfHeader = reader.readFixedLenAsciiString(headerOffset + 58L, 2);
        if (!endOfHeader.equals("`\n")) {
            throw new IOException("Bad EOH magic string: " + endOfHeader);
        }
        payloadOffset = headerOffset + 60L;
        try {
            size = Long.parseLong(sizeStr);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Bad size value: " + sizeStr);
        }
        if (name.startsWith("#1/")) {
            try {
                nameLen = Integer.parseInt(name.substring(3));
                name = StringUtilities.trimTrailingNulls((String)reader.readFixedLenAsciiString(payloadOffset, nameLen));
                size -= (long)nameLen;
                payloadOffset += (long)nameLen;
            }
            catch (NumberFormatException nfe) {
                throw new IOException("Bad name len value: " + name);
            }
        } else if (name.matches("/[0-9]+") && longNames != null) {
            try {
                offset = Long.parseLong(name.substring(1));
                name = longNames.getStringAtOffset(reader.getByteProvider(), offset);
                if (!name.endsWith("/")) ** GOTO lbl38
                name = name.substring(0, name.length() - 1);
            }
            catch (NumberFormatException nfe) {
                throw new IOException("Bad long name offset: " + name);
            }
        } else if (!name.startsWith("/") && name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
lbl38:
        // 6 sources

        date = 0L;
        try {
            if (!dateStr.isEmpty()) {
                date = Long.parseLong(dateStr) * 1000L;
            }
        }
        catch (NumberFormatException nfe) {
            Msg.warn(null, (Object)("COFF Archive: bad date value: [" + dateStr + "] in " + reader.getByteProvider().getName() + " for [" + name + "] at file offset 0x" + Long.toHexString(headerOffset)));
        }
        reader.setPointerIndex(payloadOffset);
        return new CoffArchiveMemberHeader(name, date, userId, groupId, mode, size, payloadOffset, headerOffset);
    }

    private static void align(BinaryReader reader) {
        if (reader.getPointerIndex() % 2L != 0L) {
            reader.setPointerIndex(reader.getPointerIndex() + 1L);
        }
    }

    public CoffArchiveMemberHeader(String name, long date, String userId, String groupId, String mode, long size, long payloadOffset, long memberOffset) {
        this.name = name;
        this.date = date;
        this.userId = userId;
        this.groupId = groupId;
        this.mode = mode;
        this.size = size;
        this.payloadOffset = payloadOffset;
        this.memberOffset = memberOffset;
    }

    public String getName() {
        return this.name;
    }

    public long getDate() {
        return this.date;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getMode() {
        return this.mode;
    }

    public long getSize() {
        return this.size;
    }

    public long getPayloadOffset() {
        return this.payloadOffset;
    }

    public long getFileOffset() {
        return this.memberOffset;
    }

    public boolean isCOFF() {
        return !this.name.equals(SLASH) && !this.name.equals(SLASH_SLASH);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String camh_name = StructConverterUtil.parseName(CoffArchiveMemberHeader.class);
        StructureDataType struct = new StructureDataType(camh_name, 0);
        struct.add(STRING, 16, "name", null);
        struct.add(STRING, 12, "date", null);
        struct.add(STRING, 6, "userID", null);
        struct.add(STRING, 6, "groupID", null);
        struct.add(STRING, 8, "mode", null);
        struct.add(STRING, 10, "size", null);
        struct.add(STRING, 2, "endOfHeader", null);
        return struct;
    }
}

