/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.plugin.exceptionhandlers.gcc.datatype.AbstractLeb128DataType;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;

class AndroidElfRelocationData
extends AbstractLeb128DataType {
    private final long relocationOffset;

    AndroidElfRelocationData(DataTypeManager dtm, long relocationOffset) {
        super("sleb128", true, dtm);
        this.relocationOffset = relocationOffset;
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new AndroidElfRelocationData(dtm, this.relocationOffset);
    }

    public String getMnemonic(Settings settings) {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "Android Packed Relocation Data for ELF";
    }

    public String getDefaultLabelPrefix() {
        return "sleb128";
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return null;
    }

    public Class<?> getValueClass(Settings settings) {
        return Address.class;
    }

    long getRelocationOffset() {
        return this.relocationOffset;
    }
}

