/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.util.HashMap;
import java.util.Map;

public class ElfDynamicType {
    private static Map<Integer, ElfDynamicType> defaultElfDynamicTypeMap = new HashMap<Integer, ElfDynamicType>();
    public static ElfDynamicType DT_NULL = ElfDynamicType.addDefaultDynamicType(0, "DT_NULL", "Marks end of dynamic section", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_NEEDED = ElfDynamicType.addDefaultDynamicType(1, "DT_NEEDED", "Name of needed library", ElfDynamicValueType.STRING);
    public static ElfDynamicType DT_PLTRELSZ = ElfDynamicType.addDefaultDynamicType(2, "DT_PLTRELSZ", "Size in bytes of PLT relocs", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_PLTGOT = ElfDynamicType.addDefaultDynamicType(3, "DT_PLTGOT", "Processor defined value", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_HASH = ElfDynamicType.addDefaultDynamicType(4, "DT_HASH", "Address of symbol hash table", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_STRTAB = ElfDynamicType.addDefaultDynamicType(5, "DT_STRTAB", "Address of string table", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_SYMTAB = ElfDynamicType.addDefaultDynamicType(6, "DT_SYMTAB", "Address of symbol table", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_RELA = ElfDynamicType.addDefaultDynamicType(7, "DT_RELA", "Address of Rela relocs", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_RELASZ = ElfDynamicType.addDefaultDynamicType(8, "DT_RELASZ", "Total size of Rela relocs", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_RELAENT = ElfDynamicType.addDefaultDynamicType(9, "DT_RELAENT", "Size of one Rela reloc", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_STRSZ = ElfDynamicType.addDefaultDynamicType(10, "DT_STRSZ", "Size of string table", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_SYMENT = ElfDynamicType.addDefaultDynamicType(11, "DT_SYMENT", "Size of one symbol table entry", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_INIT = ElfDynamicType.addDefaultDynamicType(12, "DT_INIT", "Address of init function", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_FINI = ElfDynamicType.addDefaultDynamicType(13, "DT_FINI", "Address of termination function", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_SONAME = ElfDynamicType.addDefaultDynamicType(14, "DT_SONAME", "Name of shared object (string ref)", ElfDynamicValueType.STRING);
    public static ElfDynamicType DT_RPATH = ElfDynamicType.addDefaultDynamicType(15, "DT_RPATH", "Library search path", ElfDynamicValueType.STRING);
    public static ElfDynamicType DT_SYMBOLIC = ElfDynamicType.addDefaultDynamicType(16, "DT_SYMBOLIC", "Start symbol search here", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_REL = ElfDynamicType.addDefaultDynamicType(17, "DT_REL", "Address of Rel relocs", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_RELSZ = ElfDynamicType.addDefaultDynamicType(18, "DT_RELSZ", "Total size of Rel relocs", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_RELENT = ElfDynamicType.addDefaultDynamicType(19, "DT_RELENT", "Size of one Rel reloc", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_PLTREL = ElfDynamicType.addDefaultDynamicType(20, "DT_PLTREL", "Type of reloc in PLT", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_DEBUG = ElfDynamicType.addDefaultDynamicType(21, "DT_DEBUG", "For debugging (unspecified)", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_TEXTREL = ElfDynamicType.addDefaultDynamicType(22, "DT_TEXTREL", "Reloc might modify .text", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_JMPREL = ElfDynamicType.addDefaultDynamicType(23, "DT_JMPREL", "Address of PLT relocs", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_BIND_NOW = ElfDynamicType.addDefaultDynamicType(24, "DT_BIND_NOW", "Process relocations of object", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_INIT_ARRAY = ElfDynamicType.addDefaultDynamicType(25, "DT_INIT_ARRAY", "Address of array with addresses of init fct", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_FINI_ARRAY = ElfDynamicType.addDefaultDynamicType(26, "DT_FINI_ARRAY", "Address of array with addresses of fini fct", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_INIT_ARRAYSZ = ElfDynamicType.addDefaultDynamicType(27, "DT_INIT_ARRAYSZ", "Size in bytes of DT_INIT_ARRAY", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_FINI_ARRAYSZ = ElfDynamicType.addDefaultDynamicType(28, "DT_FINI_ARRAYSZ", "Size in bytes of DT_FINI_ARRAY", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_RUNPATH = ElfDynamicType.addDefaultDynamicType(29, "DT_RUNPATH", "Library search path (string ref)", ElfDynamicValueType.STRING);
    public static ElfDynamicType DT_FLAGS = ElfDynamicType.addDefaultDynamicType(30, "DT_FLAGS", "Flags for the object being loaded", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_RELRSZ = ElfDynamicType.addDefaultDynamicType(35, "DT_RELRSZ", "Total size of Relr relocs", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_RELR = ElfDynamicType.addDefaultDynamicType(36, "DT_RELR", "Address of Relr relocs", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_RELRENT = ElfDynamicType.addDefaultDynamicType(37, "DT_RELRENT", "Size of Relr relocation entry", ElfDynamicValueType.VALUE);
    public static final int DF_ORIGIN = 1;
    public static final int DF_SYMBOLIC = 2;
    public static final int DF_TEXTREL = 4;
    public static final int DF_BIND_NOW = 8;
    public static final int DF_STATIC_TLS = 16;
    public static ElfDynamicType DT_PREINIT_ARRAY = ElfDynamicType.addDefaultDynamicType(32, "DT_PREINIT_ARRAY", "Array with addresses of preinit fct", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_PREINIT_ARRAYSZ = ElfDynamicType.addDefaultDynamicType(33, "DT_PREINIT_ARRAYSZ", "Size in bytes of DT_PREINIT_ARRAY", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_ANDROID_REL = ElfDynamicType.addDefaultDynamicType(0x6000000F, "DT_ANDROID_REL", "Address of Rel relocs", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_ANDROID_RELSZ = ElfDynamicType.addDefaultDynamicType(0x60000010, "DT_ANDROID_RELSZ", "Total size of Rel relocs", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_ANDROID_RELA = ElfDynamicType.addDefaultDynamicType(0x60000011, "DT_ANDROID_RELA", "Address of Rela relocs", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_ANDROID_RELASZ = ElfDynamicType.addDefaultDynamicType(1610612754, "DT_ANDROID_RELASZ", "Total size of Rela relocs", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_ANDROID_RELR = ElfDynamicType.addDefaultDynamicType(1879040000, "DT_ANDROID_RELR", "Address of Relr relocs", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_ANDROID_RELRSZ = ElfDynamicType.addDefaultDynamicType(1879040001, "DT_ANDROID_RELRSZ", "Total size of Relr relocs", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_ANDROID_RELRENT = ElfDynamicType.addDefaultDynamicType(1879040003, "DT_ANDROID_RELRENT", "Size of Relr relocation entry", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_GNU_PRELINKED = ElfDynamicType.addDefaultDynamicType(1879047669, "DT_GNU_PRELINKED", "Prelinking timestamp", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_GNU_CONFLICTSZ = ElfDynamicType.addDefaultDynamicType(0x6FFFFDF6, "DT_GNU_CONFLICTSZ", "Size of conflict section", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_GNU_LIBLISTSZ = ElfDynamicType.addDefaultDynamicType(1879047671, "DT_GNU_LIBLISTSZ", "Size of library list", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_CHECKSUM = ElfDynamicType.addDefaultDynamicType(1879047672, "DT_CHECKSUM", "", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_PLTPADSZ = ElfDynamicType.addDefaultDynamicType(1879047673, "DT_PLTPADSZ", "", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_MOVEENT = ElfDynamicType.addDefaultDynamicType(1879047674, "DT_MOVEENT", "", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_MOVESZ = ElfDynamicType.addDefaultDynamicType(1879047675, "DT_MOVESZ", "", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_FEATURE_1 = ElfDynamicType.addDefaultDynamicType(1879047676, "DT_FEATURE_1", "", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_POSFLAG_1 = ElfDynamicType.addDefaultDynamicType(0x6FFFFDFD, "DT_POSFLAG_1", "", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_SYMINSZ = ElfDynamicType.addDefaultDynamicType(1879047678, "DT_SYMINSZ", "", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_SYMINENT = ElfDynamicType.addDefaultDynamicType(0x6FFFFDFF, "DT_SYMINENT", "", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_GNU_HASH = ElfDynamicType.addDefaultDynamicType(1879047925, "DT_GNU_HASH", "GNU-style hash table", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_TLSDESC_PLT = ElfDynamicType.addDefaultDynamicType(0x6FFFFEF6, "DT_TLSDESC_PLT", "", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_TLSDESC_GOT = ElfDynamicType.addDefaultDynamicType(1879047927, "DT_TLSDESC_GOT", "", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_GNU_CONFLICT = ElfDynamicType.addDefaultDynamicType(1879047928, "DT_GNU_CONFLICT", "Start of conflict section", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_GNU_LIBLIST = ElfDynamicType.addDefaultDynamicType(1879047929, "DT_GNU_LIBLIST", "Library list", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_CONFIG = ElfDynamicType.addDefaultDynamicType(1879047930, "DT_CONFIG", "Configuration information", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_DEPAUDIT = ElfDynamicType.addDefaultDynamicType(1879047931, "DT_DEPAUDIT", "Dependency auditing", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_AUDIT = ElfDynamicType.addDefaultDynamicType(1879047932, "DT_AUDIT", "Object auditing", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_PLTPAD = ElfDynamicType.addDefaultDynamicType(1879047933, "DT_PLTPAD", "PLT padding", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_MOVETAB = ElfDynamicType.addDefaultDynamicType(0x6FFFFEFE, "DT_MOVETAB", "Move table", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_SYMINFO = ElfDynamicType.addDefaultDynamicType(0x6FFFFEFF, "DT_SYMINFO", "Syminfo table", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_VERSYM = ElfDynamicType.addDefaultDynamicType(0x6FFFFFF0, "DT_VERSYM", "Address of symbol version table", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_RELACOUNT = ElfDynamicType.addDefaultDynamicType(0x6FFFFFF9, "DT_RELACOUNT", "", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_RELCOUNT = ElfDynamicType.addDefaultDynamicType(0x6FFFFFFA, "DT_RELCOUNT", "", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_FLAGS_1 = ElfDynamicType.addDefaultDynamicType(0x6FFFFFFB, "DT_FLAGS_1", "State flags", ElfDynamicValueType.VALUE);
    public static final int DF_1_NOW = 1;
    public static final int DF_1_GLOBAL = 2;
    public static final int DF_1_GROUP = 4;
    public static final int DF_1_NODELETE = 8;
    public static final int DF_1_LOADFLTR = 16;
    public static final int DF_1_INITFIRST = 32;
    public static final int DF_1_NOOPEN = 64;
    public static final int DF_1_ORIGIN = 128;
    public static final int DF_1_DIRECT = 256;
    public static final int DF_1_INTERPOSE = 1024;
    public static final int DF_1_NODEFLIB = 2048;
    public static ElfDynamicType DT_VERDEF = ElfDynamicType.addDefaultDynamicType(0x6FFFFFFC, "DT_VERDEF", "Address of version definition table", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_VERDEFNUM = ElfDynamicType.addDefaultDynamicType(0x6FFFFFFD, "DT_VERDEFNUM", "Number of version definitions", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_VERNEED = ElfDynamicType.addDefaultDynamicType(0x6FFFFFFE, "DT_VERNEED", "Address of table with needed versions", ElfDynamicValueType.ADDRESS);
    public static ElfDynamicType DT_VERNEEDNUM = ElfDynamicType.addDefaultDynamicType(0x6FFFFFFF, "DT_VERNEEDNUM", "Number of needed versions", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_AUXILIARY = ElfDynamicType.addDefaultDynamicType(0x7FFFFFFD, "DT_AUXILIARY", "Shared object to load before self", ElfDynamicValueType.VALUE);
    public static ElfDynamicType DT_FILTER = ElfDynamicType.addDefaultDynamicType(Integer.MAX_VALUE, "DT_FILTER", "Shared object to get values from", ElfDynamicValueType.VALUE);
    public final int value;
    public final String name;
    public final String description;
    public final ElfDynamicValueType valueType;

    private static ElfDynamicType addDefaultDynamicType(int value, String name, String description, ElfDynamicValueType valueType) {
        try {
            ElfDynamicType type = new ElfDynamicType(value, name, description, valueType);
            ElfDynamicType.addDynamicType(type, defaultElfDynamicTypeMap);
            return type;
        }
        catch (DuplicateNameException e) {
            Msg.error(ElfDynamicType.class, (Object)"ElfDynamicType initialization error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void addDynamicType(ElfDynamicType type, Map<Integer, ElfDynamicType> dynamicTypeMap) throws DuplicateNameException {
        ElfDynamicType conflictType = dynamicTypeMap.get(type.value);
        if (conflictType != null) {
            throw new DuplicateNameException("ElfDynamicType conflict during initialization (" + type.name + " / " + conflictType.name + "), value=0x" + Integer.toHexString(type.value));
        }
        for (ElfDynamicType existingType : dynamicTypeMap.values()) {
            if (!type.name.equalsIgnoreCase(existingType.name)) continue;
            throw new DuplicateNameException("ElfDynamicType conflict during initialization, name=" + type.name);
        }
        dynamicTypeMap.put(type.value, type);
    }

    public ElfDynamicType(int value, String name, String description, ElfDynamicValueType valueType) {
        if (value < 0) {
            throw new IllegalArgumentException("ElfDynamicType value out of range: 0x" + Long.toHexString(value));
        }
        this.value = value;
        this.name = name;
        this.description = description;
        this.valueType = valueType;
    }

    public static void addDefaultTypes(Map<Integer, ElfDynamicType> dynamicTypeMap) {
        dynamicTypeMap.putAll(defaultElfDynamicTypeMap);
    }

    public String toString() {
        return this.name + "(0x" + StringUtilities.pad((String)Integer.toHexString(this.value), (char)'0', (int)8) + ")";
    }

    public static enum ElfDynamicValueType {
        VALUE,
        ADDRESS,
        STRING;

    }
}

