/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DynamicLibrary
implements StructConverter {
    private LoadCommandString name;
    private int timestamp;
    private int current_version;
    private int compatibility_version;

    public static DynamicLibrary createDynamicLibrary(FactoryBundledWithBinaryReader reader, LoadCommand command) throws IOException {
        DynamicLibrary dynamicLibrary = (DynamicLibrary)reader.getFactory().create(DynamicLibrary.class, new Object[0]);
        dynamicLibrary.initDynamicLibrary(reader, command);
        return dynamicLibrary;
    }

    private void initDynamicLibrary(FactoryBundledWithBinaryReader reader, LoadCommand command) throws IOException {
        this.name = LoadCommandString.createLoadCommandString(reader, command);
        this.timestamp = reader.readNextInt();
        this.current_version = reader.readNextInt();
        this.compatibility_version = reader.readNextInt();
    }

    public LoadCommandString getName() {
        return this.name;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getCurrentVersion() {
        return this.current_version;
    }

    public int getCompatibilityVersion() {
        return this.compatibility_version;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dylib", 0);
        struct.add(this.name.toDataType(), "name", null);
        struct.add(DWORD, "timestamp", null);
        struct.add(DWORD, "current_version", null);
        struct.add(DWORD, "compatibility_version", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public String toString() {
        return this.name.toString();
    }
}

