/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.dyld.DyldArchitecture;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheAccelerateInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImageInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImageTextInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheLocalSymbolsInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo1;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo2;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo3;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Pointer64DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheHeader
implements StructConverter {
    private byte[] magic;
    private int mappingOffset;
    private int mappingCount;
    private int imagesOffset;
    private int imagesCount;
    private long dyldBaseAddress;
    private long codeSignatureOffset;
    private long codeSignatureSize;
    private long slideInfoOffset;
    private long slideInfoSize;
    private long localSymbolsOffset;
    private long localSymbolsSize;
    private byte[] uuid;
    private long cacheType;
    private int branchPoolsOffset;
    private int branchPoolsCount;
    private long accelerateInfoAddr;
    private long accelerateInfoSize;
    private long imagesTextOffset;
    private long imagesTextCount;
    private int headerType;
    private BinaryReader reader;
    private long baseAddress;
    private List<DyldCacheMappingInfo> mappingInfoList;
    private List<DyldCacheImageInfo> imageInfoList;
    private DyldCacheSlideInfoCommon slideInfo;
    private DyldCacheLocalSymbolsInfo localSymbolsInfo;
    private List<Long> branchPoolList;
    private DyldCacheAccelerateInfo accelerateInfo;
    private List<DyldCacheImageTextInfo> imageTextInfoList;
    private DyldArchitecture architecture;

    public DyldCacheHeader(BinaryReader reader) throws IOException {
        this.reader = reader;
        this.headerType = 1;
        this.magic = reader.readNextByteArray(16);
        this.mappingOffset = reader.readNextInt();
        this.mappingCount = reader.readNextInt();
        this.imagesOffset = reader.readNextInt();
        this.imagesCount = reader.readNextInt();
        this.dyldBaseAddress = reader.readNextLong();
        if (this.mappingOffset > 40) {
            this.headerType = 2;
            this.codeSignatureOffset = reader.readNextLong();
            this.codeSignatureSize = reader.readNextLong();
            this.slideInfoOffset = reader.readNextLong();
            this.slideInfoSize = reader.readNextLong();
        }
        if (this.mappingOffset > 72) {
            this.headerType = 3;
            this.localSymbolsOffset = reader.readNextLong();
            this.localSymbolsSize = reader.readNextLong();
        }
        if (this.mappingOffset > 88) {
            this.headerType = 4;
            this.uuid = reader.readNextByteArray(16);
        }
        if (this.mappingOffset > 104) {
            this.headerType = 5;
            this.cacheType = reader.readNextLong();
        }
        if (this.mappingOffset > 112) {
            this.headerType = 6;
            this.branchPoolsOffset = reader.readNextInt();
            this.branchPoolsCount = reader.readNextInt();
            this.accelerateInfoAddr = reader.readNextLong();
            this.accelerateInfoSize = reader.readNextLong();
            this.imagesTextOffset = reader.readNextLong();
            this.imagesTextCount = reader.readNextLong();
        }
        this.baseAddress = reader.readLong(this.mappingOffset);
        this.architecture = DyldArchitecture.getArchitecture(new String(this.magic).trim());
        this.mappingInfoList = new ArrayList<DyldCacheMappingInfo>(this.mappingCount);
        this.imageInfoList = new ArrayList<DyldCacheImageInfo>(this.imagesCount);
        this.branchPoolList = new ArrayList<Long>(this.branchPoolsCount);
        this.imageTextInfoList = new ArrayList<DyldCacheImageTextInfo>();
    }

    public void parseFromFile(boolean parseSymbols, MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.headerType >= 1) {
            this.parseMappingInfo(log, monitor);
            this.parseImageInfo(log, monitor);
        }
        if (this.headerType >= 2) {
            this.parseSlideInfo(log, monitor);
        }
        if (this.headerType >= 3 && parseSymbols) {
            this.parseLocalSymbolsInfo(log, monitor);
        }
        if (this.headerType >= 6) {
            this.parseBranchPools(log, monitor);
            this.parseImageTextInfo(log, monitor);
        }
    }

    public void parseFromMemory(Program program, AddressSpace space, MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.headerType >= 6) {
            this.parseAcceleratorInfo(program, space, log, monitor);
        }
    }

    public void markup(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        if (this.headerType >= 1) {
            this.markupHeader(program, space, monitor, log);
            this.markupMappingInfo(program, space, monitor, log);
            this.markupImageInfo(program, space, monitor, log);
        }
        if (this.headerType >= 2) {
            this.markupCodeSignature(program, space, monitor, log);
            this.markupSlideInfo(program, space, monitor, log);
        }
        if (this.headerType >= 3) {
            this.markupLocalSymbolsInfo(program, space, monitor, log);
        }
        if (this.headerType >= 6) {
            this.markupBranchPools(program, space, monitor, log);
            this.markupAcceleratorInfo(program, space, monitor, log);
            this.markupImageTextInfo(program, space, monitor, log);
        }
    }

    public long getBaseAddress() {
        return this.baseAddress;
    }

    public byte[] getMagic() {
        return this.magic;
    }

    public List<DyldCacheMappingInfo> getMappingInfos() {
        return this.mappingInfoList;
    }

    public int getImagesOffset() {
        return this.imagesOffset;
    }

    public int getImagesCount() {
        return this.imagesCount;
    }

    public List<DyldCacheImageInfo> getImageInfos() {
        return this.imageInfoList;
    }

    public DyldCacheLocalSymbolsInfo getLocalSymbolsInfo() {
        return this.localSymbolsInfo;
    }

    public DyldCacheSlideInfoCommon getSlideInfo() {
        return this.slideInfo;
    }

    public long getSlideInfoOffset() {
        return this.slideInfoOffset;
    }

    public long getSlideInfoSize() {
        return this.slideInfoSize;
    }

    public List<Long> getBranchPoolAddresses() {
        return this.branchPoolList;
    }

    public DyldArchitecture getArchitecture() {
        return this.architecture;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_header", 0);
        if (this.headerType >= 1) {
            struct.add((DataType)new ArrayDataType(ASCII, 16, 1), "magic", "e.g. \"dyld_v0    i386\"");
            struct.add(DWORD, "mappingOffset", "file offset to first dyld_cache_mapping_info");
            struct.add(DWORD, "mappingCount", "number of dyld_cache_mapping_info entries");
            struct.add(DWORD, "imagesOffset", "file offset to first dyld_cache_image_info");
            struct.add(DWORD, "imagesCount", "number of dyld_cache_image_info entries");
            struct.add(QWORD, "dyldBaseAddress", "base address of dyld when cache was built");
        }
        if (this.headerType >= 2) {
            struct.add(QWORD, "codeSignatureOffset", "file offset of code signature blob");
            struct.add(QWORD, "codeSignatureSize", "size of code signature blob (zero means to end of file)");
            struct.add(QWORD, "slideInfoOffset", "file offset of kernel slid info");
            struct.add(QWORD, "slideInfoSize", "size of kernel slid info");
        }
        if (this.headerType >= 3) {
            struct.add(QWORD, "localSymbolsOffset", "file offset of where local symbols are stored");
            struct.add(QWORD, "localSymbolsSize", "size of local symbols information");
        }
        if (this.headerType >= 4) {
            struct.add((DataType)new ArrayDataType(BYTE, 16, 1), "uuid", "unique value for each shared cache file");
        }
        if (this.headerType >= 5) {
            struct.add(QWORD, "cacheType", "0 for development, 1 for production");
        }
        if (this.headerType >= 6) {
            struct.add(DWORD, "branchPoolsOffset", "file offset to table of uint64_t pool addresses");
            struct.add(DWORD, "branchPoolsCount", "number of uint64_t entries");
            struct.add(QWORD, "accelerateInfoAddr", "(unslid) address of optimization info");
            struct.add(QWORD, "accelerateInfoSize", "size of optimization info");
            struct.add(QWORD, "imagesTextOffset", "file offset to first dyld_cache_image_text_info");
            struct.add(QWORD, "imagesTextCount", "number of dyld_cache_image_text_info entries");
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    private void parseMappingInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Parsing DYLD mapping info...");
        monitor.initialize((long)this.mappingCount);
        try {
            this.reader.setPointerIndex(this.mappingOffset);
            for (int i = 0; i < this.mappingCount; ++i) {
                this.mappingInfoList.add(new DyldCacheMappingInfo(this.reader));
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_mapping_info.");
        }
    }

    private void parseImageInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.imagesOffset == 0) {
            return;
        }
        monitor.setMessage("Parsing DYLD image info...");
        monitor.initialize((long)this.imagesCount);
        try {
            this.reader.setPointerIndex(this.imagesOffset);
            for (int i = 0; i < this.imagesCount; ++i) {
                this.imageInfoList.add(new DyldCacheImageInfo(this.reader));
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_image_info.");
        }
    }

    private void parseSlideInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.slideInfoOffset == 0L) {
            return;
        }
        monitor.setMessage("Parsing DYLD slide info...");
        monitor.initialize(1L);
        try {
            this.reader.setPointerIndex(this.slideInfoOffset);
            this.slideInfo = new DyldCacheSlideInfoCommon(this.reader);
            this.reader.setPointerIndex(this.slideInfoOffset);
            switch (this.slideInfo.getVersion()) {
                case 1: {
                    this.slideInfo = new DyldCacheSlideInfo1(this.reader);
                    break;
                }
                case 2: {
                    this.slideInfo = new DyldCacheSlideInfo2(this.reader);
                    break;
                }
                case 3: {
                    this.slideInfo = new DyldCacheSlideInfo3(this.reader);
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            monitor.incrementProgress(1L);
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_slide_info.");
        }
    }

    private void parseLocalSymbolsInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.localSymbolsOffset == 0L) {
            return;
        }
        monitor.setMessage("Parsing DYLD local symbols info...");
        monitor.initialize(1L);
        try {
            this.reader.setPointerIndex(this.localSymbolsOffset);
            this.localSymbolsInfo = new DyldCacheLocalSymbolsInfo(this.reader, this.architecture);
            this.localSymbolsInfo.parse(log, monitor);
            monitor.incrementProgress(1L);
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_local_symbols_info.");
        }
    }

    private void parseBranchPools(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.branchPoolsOffset == 0) {
            return;
        }
        monitor.setMessage("Parsing DYLD branch pool addresses...");
        monitor.initialize((long)this.branchPoolsCount);
        try {
            this.reader.setPointerIndex(this.branchPoolsOffset);
            for (int i = 0; i < this.branchPoolsCount; ++i) {
                this.branchPoolList.add(this.reader.readNextLong());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse pool addresses.");
        }
    }

    private void parseImageTextInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.imagesTextOffset == 0L) {
            return;
        }
        monitor.setMessage("Parsing DYLD image text info...");
        monitor.initialize(this.imagesTextCount);
        try {
            this.reader.setPointerIndex(this.imagesTextOffset);
            int i = 0;
            while ((long)i < this.imagesTextCount) {
                this.imageTextInfoList.add(new DyldCacheImageTextInfo(this.reader));
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
                ++i;
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_image_text_info.");
        }
    }

    private void parseAcceleratorInfo(Program program, AddressSpace space, MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.accelerateInfoAddr == 0L) {
            return;
        }
        monitor.setMessage("Parsing DYLD accelerateor info...");
        monitor.initialize(this.imagesTextCount);
        try {
            Address addr = space.getAddress(this.accelerateInfoAddr);
            MemoryByteProvider bytes = new MemoryByteProvider(program.getMemory(), addr);
            BinaryReader memoryReader = new BinaryReader(bytes, !program.getLanguage().isBigEndian());
            this.accelerateInfo = new DyldCacheAccelerateInfo(memoryReader);
            this.accelerateInfo.parse(program, addr, log, monitor);
            monitor.incrementProgress(1L);
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_accelerator_info.");
        }
    }

    private void markupHeader(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD header...");
        monitor.initialize(1L);
        try {
            DataUtilities.createData((Program)program, (Address)program.getImageBase(), (DataType)this.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_header.");
        }
    }

    private void markupMappingInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD mapping info...");
        monitor.initialize((long)this.mappingInfoList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.mappingOffset, program, space);
            for (DyldCacheMappingInfo mappingInfo : this.mappingInfoList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)mappingInfo.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add((long)d.getLength());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_mapping_info.");
        }
    }

    private void markupImageInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD image info...");
        monitor.initialize((long)this.imageInfoList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.imagesOffset, program, space);
            for (DyldCacheImageInfo imageInfo : this.imageInfoList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)imageInfo.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                program.getListing().setComment(addr, 0, imageInfo.getPath());
                addr = addr.add((long)d.getLength());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_image_info.");
        }
    }

    private void markupCodeSignature(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD code signature...");
        monitor.initialize(1L);
        try {
            String size = "0x" + Long.toHexString(this.codeSignatureSize);
            program.getListing().setComment(this.fileOffsetToAddr(this.codeSignatureOffset, program, space), 3, "Code Signature (" + size + " bytes)");
            monitor.incrementProgress(1L);
        }
        catch (IllegalArgumentException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup code signature.");
        }
    }

    private void markupSlideInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD slide info...");
        monitor.initialize(1L);
        try {
            if (this.slideInfo != null) {
                Address addr = this.fileOffsetToAddr(this.slideInfoOffset, program, space);
                DataUtilities.createData((Program)program, (Address)addr, (DataType)this.slideInfo.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_slide_info.");
        }
    }

    private void markupLocalSymbolsInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD local symbols info...");
        monitor.initialize(1L);
        try {
            if (this.localSymbolsInfo != null) {
                Address addr = this.fileOffsetToAddr(this.localSymbolsOffset, program, space);
                DataUtilities.createData((Program)program, (Address)addr, (DataType)this.localSymbolsInfo.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                this.localSymbolsInfo.markup(program, addr, monitor, log);
            }
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_local_symbols_info.");
        }
    }

    private void markupBranchPools(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD branch pool addresses...");
        monitor.initialize((long)this.branchPoolList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.branchPoolsOffset, program, space);
            for (Long element : this.branchPoolList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)Pointer64DataType.dataType, (int)Pointer64DataType.dataType.getLength(), (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add((long)d.getLength());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup branch pool addresses.");
        }
    }

    private void markupAcceleratorInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD accelerator info...");
        monitor.initialize(1L);
        try {
            if (this.accelerateInfo != null) {
                Address addr = space.getAddress(this.accelerateInfoAddr);
                DataUtilities.createData((Program)program, (Address)addr, (DataType)this.accelerateInfo.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                this.accelerateInfo.markup(program, addr, monitor, log);
            }
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_accelerator_info.");
        }
    }

    private void markupImageTextInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD image text info...");
        monitor.initialize((long)this.imageTextInfoList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.imagesTextOffset, program, space);
            for (DyldCacheImageTextInfo imageTextInfo : this.imageTextInfoList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)imageTextInfo.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                program.getListing().setComment(addr, 0, imageTextInfo.getPath());
                addr = addr.add((long)d.getLength());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_image_text_info.");
        }
    }

    private Address fileOffsetToAddr(long offset, Program program, AddressSpace space) {
        for (DyldCacheMappingInfo mappingInfo : this.mappingInfoList) {
            if (offset < mappingInfo.getFileOffset() || offset >= mappingInfo.getFileOffset() + mappingInfo.getSize()) continue;
            return space.getAddress(mappingInfo.getAddress() + (offset - mappingInfo.getFileOffset()));
        }
        AddressSpace fileSpace = program.getAddressFactory().getAddressSpace("FILE");
        if (fileSpace != null) {
            try {
                return fileSpace.getAddress(offset);
            }
            catch (AddressOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }
}

