/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.cli.CliRepresentable;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexTypeDefOrRef;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class CliAbstractSig
extends CliBlob
implements CliRepresentable {
    public static final String PATH = "/PE/CLI/Blobs/Signatures";

    public CliAbstractSig(CliBlob blob) {
        super(blob);
    }

    @Override
    public abstract DataType getContentsDataType();

    @Override
    public abstract String getContentsName();

    @Override
    public abstract String getContentsComment();

    protected abstract String getRepresentationCommon(CliStreamMetadata var1, boolean var2);

    @Override
    public final String getRepresentation() {
        return this.getRepresentationCommon(null, false);
    }

    @Override
    public final String getShortRepresentation() {
        return this.getRepresentationCommon(null, true);
    }

    @Override
    public final String getRepresentation(CliStreamMetadata stream) {
        return this.getRepresentationCommon(stream, false);
    }

    @Override
    public final String getShortRepresentation(CliStreamMetadata stream) {
        return this.getRepresentationCommon(stream, true);
    }

    protected String getRepresentationOf(CliRepresentable obj, CliStreamMetadata stream, boolean isShort) {
        if (isShort) {
            if (stream != null) {
                return obj.getShortRepresentation(stream);
            }
            return obj.getShortRepresentation();
        }
        if (stream != null) {
            return obj.getRepresentation(stream);
        }
        return obj.getRepresentation();
    }

    public static DataType convertTypeCodeToDataType(CliElementType typeCode) {
        switch (typeCode) {
            case ELEMENT_TYPE_VOID: {
                return VoidDataType.dataType;
            }
            case ELEMENT_TYPE_BOOLEAN: {
                return BooleanDataType.dataType;
            }
            case ELEMENT_TYPE_CHAR: {
                return ASCII;
            }
            case ELEMENT_TYPE_I1: 
            case ELEMENT_TYPE_U1: {
                return BYTE;
            }
            case ELEMENT_TYPE_I2: 
            case ELEMENT_TYPE_U2: {
                return WORD;
            }
            case ELEMENT_TYPE_I4: 
            case ELEMENT_TYPE_U4: {
                return DWORD;
            }
            case ELEMENT_TYPE_R4: {
                return FloatDataType.dataType;
            }
            case ELEMENT_TYPE_R8: {
                return QWORD;
            }
            case ELEMENT_TYPE_I8: 
            case ELEMENT_TYPE_U8: {
                return QWORD;
            }
            case ELEMENT_TYPE_I: 
            case ELEMENT_TYPE_U: {
                return DWORD;
            }
            case ELEMENT_TYPE_PTR: {
                return PointerDataType.dataType;
            }
            case ELEMENT_TYPE_FNPTR: {
                return PointerDataType.dataType;
            }
        }
        return null;
    }

    public CliSigType readCliType(BinaryReader reader) throws IOException, InvalidInputException {
        byte typeByte = reader.readNextByte();
        CliElementType typeCode = CliElementType.fromInt(typeByte);
        if (typeCode == null) {
            throw new InvalidInputException("TypeCode not found at reader index " + reader.getPointerIndex() + ". Are you in the right place? (" + typeByte + ")");
        }
        switch (typeCode) {
            case ELEMENT_TYPE_ARRAY: {
                return new CliTypeArray(reader, typeCode);
            }
            case ELEMENT_TYPE_CLASS: {
                return new CliTypeClass(reader, typeCode);
            }
            case ELEMENT_TYPE_FNPTR: {
                return new CliTypeFnPtr(reader, typeCode);
            }
            case ELEMENT_TYPE_GENERICINST: {
                return new CliTypeGenericInst(reader, typeCode);
            }
            case ELEMENT_TYPE_MVAR: 
            case ELEMENT_TYPE_VAR: {
                return new CliTypeVarOrMvar(reader, typeCode);
            }
            case ELEMENT_TYPE_PTR: {
                return new CliTypePtr(reader, typeCode);
            }
            case ELEMENT_TYPE_SZARRAY: {
                return new CliTypeSzArray(reader, typeCode);
            }
            case ELEMENT_TYPE_VALUETYPE: {
                return new CliTypeValueType(reader, typeCode);
            }
        }
        return new CliTypePrimitive(typeCode);
    }

    public class CliNamedArg {
    }

    public class CliElem {
    }

    public class CliFixedArg {
    }

    public class CliCustomAttrib {
    }

    public class CliArrayShape {
        private int rank;
        private int rankBytes;
        private int numSizes;
        private int numSizesBytes;
        private int[] size;
        private int[] sizeBytes;
        private int numLoBounds;
        private int numLoBoundsBytes;
        private int[] loBound;
        private int[] loBoundBytes;

        public CliArrayShape(BinaryReader reader) throws IOException {
            int i;
            long origIndex = reader.getPointerIndex();
            this.rank = CliBlob.decodeCompressedUnsignedInt(reader);
            this.rankBytes = (int)(reader.getPointerIndex() - origIndex);
            origIndex = reader.getPointerIndex();
            this.numSizes = CliBlob.decodeCompressedUnsignedInt(reader);
            this.numSizesBytes = (int)(reader.getPointerIndex() - origIndex);
            origIndex = reader.getPointerIndex();
            this.size = new int[this.numSizes];
            this.sizeBytes = new int[this.numSizes];
            for (i = 0; i < this.numSizes; ++i) {
                this.size[i] = CliBlob.decodeCompressedUnsignedInt(reader);
                this.sizeBytes[i] = (int)(reader.getPointerIndex() - origIndex);
                origIndex = reader.getPointerIndex();
            }
            this.numLoBounds = CliBlob.decodeCompressedUnsignedInt(reader);
            this.numLoBoundsBytes = (int)(reader.getPointerIndex() - origIndex);
            origIndex = reader.getPointerIndex();
            this.loBound = new int[this.numLoBounds];
            this.loBoundBytes = new int[this.numLoBounds];
            for (i = 0; i < this.numLoBounds; ++i) {
                this.loBound[i] = CliBlob.decodeCompressedUnsignedInt(reader);
                this.loBoundBytes[i] = (int)(reader.getPointerIndex() - origIndex);
                origIndex = reader.getPointerIndex();
            }
        }

        public DataType getDefinitionDataType() {
            int i;
            StructureDataType struct = new StructureDataType(new CategoryPath(CliAbstractSig.PATH), "ArrayShape", 0);
            struct.add(CliBlob.getDataTypeForBytes(this.rankBytes), "Rank", "Number of dimensions in array");
            struct.add(CliBlob.getDataTypeForBytes(this.numSizesBytes), "NumSizes", "Number of sizes to follow");
            for (i = 0; i < this.sizeBytes.length; ++i) {
                struct.add(CliBlob.getDataTypeForBytes(this.sizeBytes[i]), "Size" + i, "Coded integer size");
            }
            struct.add(CliBlob.getDataTypeForBytes(this.numLoBoundsBytes), "NumLoBounds", "Number of lower bounds in array");
            for (i = 0; i < this.loBoundBytes.length; ++i) {
                struct.add(CliBlob.getDataTypeForBytes(this.loBoundBytes[i]), "LoBound" + i, "Coded integer lower bound");
            }
            return struct;
        }

        public String getRepresentation() {
            return "ArrayShapeNotYetRepresented";
        }
    }

    public class CliRetType
    extends CliTypeBase {
        public CliRetType(BinaryReader reader) throws IOException, InvalidInputException {
            super(reader, true);
        }
    }

    public class CliParam
    extends CliTypeBase {
        public CliParam(BinaryReader reader) throws IOException, InvalidInputException {
            super(reader, false);
        }
    }

    public class CliTypeBase
    implements CliRepresentable {
        private List<CliCustomMod> customMods = new ArrayList<CliCustomMod>();
        private boolean byRef = false;
        private CliSigType type;
        private boolean isVoidAllowed = false;

        public CliTypeBase(BinaryReader reader, boolean isRetType) throws IOException, InvalidInputException {
            this.isVoidAllowed = isRetType;
            while (CliCustomMod.isCustomMod(reader)) {
                this.customMods.add(new CliCustomMod(reader));
            }
            byte nextByte = reader.peekNextByte();
            if (nextByte == CliElementType.ELEMENT_TYPE_BYREF.id()) {
                this.byRef = true;
                reader.readNextByte();
            }
            this.type = CliAbstractSig.this.readCliType(reader);
        }

        public CliSigType getType() {
            return this.type;
        }

        public List<CliCustomMod> getCustomMods() {
            return this.customMods;
        }

        public boolean isByRef() {
            return this.byRef;
        }

        private String getRepresentationCommon(CliStreamMetadata stream, boolean shortRep) {
            Object rep = "";
            for (CliCustomMod mod : this.customMods) {
                rep = (String)rep + mod.getRepresentation() + "; ";
            }
            if (this.customMods.size() > 0) {
                rep = ((String)rep).substring(0, ((String)rep).length() - 2) + " ";
            }
            if (this.byRef) {
                rep = (String)rep + "byref ";
            }
            rep = (String)rep + CliAbstractSig.this.getRepresentationOf(this.type, stream, shortRep);
            return rep;
        }

        @Override
        public String getRepresentation() {
            return this.getRepresentationCommon(null, false);
        }

        @Override
        public String getRepresentation(CliStreamMetadata stream) {
            return this.getRepresentationCommon(stream, false);
        }

        @Override
        public String getShortRepresentation() {
            return this.getRepresentationCommon(null, true);
        }

        @Override
        public String getShortRepresentation(CliStreamMetadata stream) {
            return this.getRepresentationCommon(stream, true);
        }

        public DataType getDefinitionDataType() {
            StructureDataType struct = new StructureDataType(new CategoryPath(CliAbstractSig.PATH), "Type", 0);
            for (CliCustomMod mod : this.customMods) {
                struct.add(mod.getDefinitionDataType(), "CustomMod", null);
            }
            if (this.byRef) {
                struct.add(StructConverter.BYTE, "BYREF", "By reference");
            }
            struct.add(this.type.getDefinitionDataType(), "Type", null);
            return struct;
        }

        public DataType getExecutionDataType() {
            return this.type.getExecutionDataType();
        }
    }

    public static class CliConstraint {
        private CliElementType constraint;

        public static boolean isConstraint(BinaryReader reader) throws IOException {
            return reader.peekNextByte() == CliElementType.ELEMENT_TYPE_PINNED.id();
        }

        public CliConstraint(BinaryReader reader) throws IOException {
            this.constraint = CliElementType.fromInt(reader.readNextByte());
        }

        public CliElementType getConstraint() {
            return this.constraint;
        }

        public String getRepresentation() {
            if (this.constraint == CliElementType.ELEMENT_TYPE_PINNED) {
                return this.constraint.toString();
            }
            return String.format("Invalid Constraint (%s - %x)", this.constraint.toString(), this.constraint.id());
        }
    }

    public static class CliCustomMod {
        private CliElementType cmod;
        private int typeEncoded;
        private int sizeOfCount;

        public static boolean isCustomMod(BinaryReader reader) throws IOException {
            return reader.peekNextByte() == CliElementType.ELEMENT_TYPE_CMOD_OPT.id() || reader.peekNextByte() == CliElementType.ELEMENT_TYPE_CMOD_REQD.id();
        }

        public CliCustomMod(BinaryReader reader) throws IOException {
            this.cmod = CliElementType.fromInt(reader.readNextByte());
            long origIndex = reader.getPointerIndex();
            this.typeEncoded = CliBlob.decodeCompressedUnsignedInt(reader);
            long endIndex = reader.getPointerIndex();
            this.sizeOfCount = (int)(endIndex - origIndex);
        }

        public CliElementType getCMOD() {
            return this.cmod;
        }

        public int getTypeEncoded() {
            return this.typeEncoded;
        }

        public CliTypeTable getTable() {
            try {
                return CliIndexTypeDefOrRef.getTableName(this.typeEncoded);
            }
            catch (InvalidInputException e) {
                return null;
            }
        }

        public int getRowIndex() {
            return CliIndexTypeDefOrRef.getRowIndex(this.typeEncoded);
        }

        public CliAbstractTableRow getRow(CliStreamMetadata stream) {
            return stream.getTable(this.getTable()).getRow(this.getRowIndex());
        }

        public DataType getDefinitionDataType() {
            StructureDataType struct = new StructureDataType(new CategoryPath(CliAbstractSig.PATH), CliCustomMod.class.getSimpleName(), 0);
            struct.add(StructConverter.BYTE, "CMOD", "CMOD_OPT or CMOD_REQD");
            struct.add(CliBlob.getDataTypeForBytes(this.sizeOfCount), "Type", "TypeDefOrRefOrSpec encoded type");
            return struct;
        }

        public String getRepresentation(CliStreamMetadata stream) {
            return String.format("%s %s", this.cmod.toString(), this.getRow(stream));
        }

        public String getRepresentation() {
            return String.format("%s %x", this.cmod.toString(), this.typeEncoded);
        }
    }

    public class CliTypeValueType
    extends CliSigType {
        private int encodedType;
        private int typeBytes;

        public CliTypeValueType(BinaryReader reader, CliElementType typeCode) throws IOException {
            super(typeCode);
            long origIndex = reader.getPointerIndex();
            this.encodedType = CliBlob.decodeCompressedUnsignedInt(reader);
            long endIndex = reader.getPointerIndex();
            this.typeBytes = (int)(endIndex - origIndex);
        }

        @Override
        public String getRepresentation() {
            return "ValueType " + Integer.toHexString(this.encodedType);
        }

        public String getRepresentation(CliStreamMetadata stream, boolean shortRep) {
            try {
                CliAbstractTableRow row = stream.getTable(CliIndexTypeDefOrRef.getTableName(this.encodedType)).getRow(CliIndexTypeDefOrRef.getRowIndex(this.encodedType));
                return "ValueType " + (shortRep ? row.getShortRepresentation() : row.getRepresentation());
            }
            catch (InvalidInputException e) {
                e.printStackTrace();
                return "";
            }
        }

        @Override
        public String getRepresentation(CliStreamMetadata stream) {
            return this.getRepresentation(stream, false);
        }

        @Override
        public String getShortRepresentation(CliStreamMetadata stream) {
            return this.getRepresentation(stream, true);
        }

        @Override
        public DataType getDefinitionDataType() {
            StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Types"), "ValueType", 0);
            struct.add((DataType)CliTypeCodeDataType.dataType, "ValueType", "ValueType");
            struct.add(CliBlob.getDataTypeForBytes(this.typeBytes), "Type", "TypeDefOrRefOrSpecEncoded");
            return struct;
        }
    }

    public class CliTypeSzArray
    extends CliSigType {
        private List<CliCustomMod> customMods;
        private CliSigType type;

        public CliTypeSzArray(BinaryReader reader, CliElementType typeCode) throws IOException, InvalidInputException {
            super(typeCode);
            this.customMods = new ArrayList<CliCustomMod>();
            while (CliCustomMod.isCustomMod(reader)) {
                this.customMods.add(new CliCustomMod(reader));
            }
            this.type = CliAbstractSig.this.readCliType(reader);
        }

        @Override
        public String getRepresentation(CliStreamMetadata stream) {
            String typeRep = stream == null ? this.type.getRepresentation() : this.type.getRepresentation(stream);
            Object modsRep = "";
            for (CliCustomMod mod : this.customMods) {
                modsRep = (String)modsRep + mod.toString() + ", ";
            }
            if (this.customMods.size() > 0) {
                ((String)modsRep).substring(0, ((String)modsRep).length() - 2);
            }
            return String.format("SzArray %s %s", modsRep, typeRep);
        }

        @Override
        public String getRepresentation() {
            return this.getRepresentation(null);
        }

        @Override
        public DataType getDefinitionDataType() {
            StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Types"), "SzArray", 0);
            struct.add((DataType)CliTypeCodeDataType.dataType, "TypeCode", "SzArray");
            for (CliCustomMod mod : this.customMods) {
                struct.add(mod.getDefinitionDataType());
            }
            struct.add(this.type.getDefinitionDataType(), "Type", "type or void");
            return struct;
        }
    }

    public class CliTypePtr
    extends CliSigType {
        private List<CliCustomMod> customMods;
        private CliElementType typeCode;

        public CliTypePtr(BinaryReader reader, CliElementType typeCode) throws IOException {
            super(typeCode);
            this.customMods = new ArrayList<CliCustomMod>();
            while (CliCustomMod.isCustomMod(reader)) {
                this.customMods.add(new CliCustomMod(reader));
            }
            typeCode = CliElementType.fromInt(reader.readNextByte());
        }

        @Override
        public String getRepresentation() {
            Object modsRep = "";
            for (CliCustomMod mod : this.customMods) {
                modsRep = (String)modsRep + mod.toString() + ", ";
            }
            modsRep = ((String)modsRep).substring(0, ((String)modsRep).length() - 2);
            return String.format("Ptr %s %s", modsRep, this.typeCode.toString());
        }

        @Override
        public DataType getDefinitionDataType() {
            StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Types"), "Ptr", 0);
            struct.add((DataType)CliTypeCodeDataType.dataType, "TypeCode", "Ptr");
            for (CliCustomMod mod : this.customMods) {
                struct.add(mod.getDefinitionDataType());
            }
            struct.add((DataType)CliTypeCodeDataType.dataType, "Type", "type or void");
            return struct;
        }
    }

    public class CliTypeVarOrMvar
    extends CliSigType {
        private int number;
        private int numberBytes;

        public CliTypeVarOrMvar(BinaryReader reader, CliElementType typeCode) throws IOException {
            super(typeCode);
            long origIndex = reader.getPointerIndex();
            this.number = CliBlob.decodeCompressedUnsignedInt(reader);
            long endIndex = reader.getPointerIndex();
            this.numberBytes = (int)(endIndex - origIndex);
        }

        @Override
        public String getRepresentation() {
            return String.format("%s %d", this.baseTypeCode.toString(), this.number);
        }

        @Override
        public DataType getDefinitionDataType() {
            StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Types"), "VarOrMvar", 0);
            struct.add(StructConverter.BYTE, "Type", "Var or Mvar");
            struct.add(CliBlob.getDataTypeForBytes(this.numberBytes), "number", null);
            return struct;
        }
    }

    public class CliTypeGenericInst
    extends CliSigType {
        private CliElementType firstType;
        private int encodedType;
        private int typeSizeBytes;
        private int genArgCount;
        private int countSizeBytes;
        private List<CliSigType> argTypes;

        public CliTypeGenericInst(BinaryReader reader, CliElementType typeCode) throws IOException {
            super(typeCode);
            this.argTypes = new ArrayList<CliSigType>();
            this.firstType = CliElementType.fromInt(reader.readNextByte());
            long origIndex = reader.getPointerIndex();
            this.encodedType = CliBlob.decodeCompressedUnsignedInt(reader);
            this.typeSizeBytes = (int)(reader.getPointerIndex() - origIndex);
            origIndex = reader.getPointerIndex();
            this.genArgCount = CliBlob.decodeCompressedUnsignedInt(reader);
            this.countSizeBytes = (int)(reader.getPointerIndex() - origIndex);
            for (int i = 0; i < this.genArgCount; ++i) {
                try {
                    this.argTypes.add(CliAbstractSig.this.readCliType(reader));
                    continue;
                }
                catch (InvalidInputException e) {
                    e.printStackTrace();
                }
            }
        }

        private String getRepresentation(CliStreamMetadata stream, boolean shortRep) {
            Object argTypesRep = "";
            for (int i = 0; i < this.genArgCount; ++i) {
                argTypesRep = (String)argTypesRep + this.argTypes.get(i).getRepresentation();
                if (i == this.genArgCount - 1) continue;
                argTypesRep = (String)argTypesRep + ", ";
            }
            String typeRep = Integer.toHexString(this.encodedType);
            if (stream != null) {
                try {
                    CliAbstractTableRow row = stream.getTable(CliIndexTypeDefOrRef.getTableName(this.encodedType)).getRow(CliIndexTypeDefOrRef.getRowIndex(this.encodedType));
                    typeRep = shortRep ? row.getShortRepresentation() : row.getRepresentation();
                }
                catch (InvalidInputException e) {
                    e.printStackTrace();
                }
            }
            return String.format("%s %s %d %s", this.firstType.toString(), typeRep, this.genArgCount, argTypesRep);
        }

        @Override
        public String getRepresentation() {
            return this.getRepresentation(null);
        }

        @Override
        public String getRepresentation(CliStreamMetadata stream) {
            return this.getRepresentation(stream, false);
        }

        @Override
        public String getShortRepresentation(CliStreamMetadata stream) {
            return this.getRepresentation(stream, true);
        }

        @Override
        public DataType getDefinitionDataType() {
            StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Types"), "GenericInstType" + this.argTypes.toString(), 0);
            struct.add((DataType)CliTypeCodeDataType.dataType, "GenericInst", "GenericInst");
            struct.add((DataType)CliTypeCodeDataType.dataType, "ClassOrValueType", "Class or ValueType");
            struct.add(CliBlob.getDataTypeForBytes(this.typeSizeBytes), "Type", "TypeDefOrRefOrSpecEncoded");
            struct.add(CliBlob.getDataTypeForBytes(this.countSizeBytes), "GenArgCount", "Number of generics to follow");
            for (CliSigType type : this.argTypes) {
                struct.add(type.getDefinitionDataType(), "Type", "Generic Type");
            }
            return struct;
        }
    }

    public class CliTypeFnPtr
    extends CliSigType {
        private CliAbstractSig sig;
        private boolean isDefSig;

        public CliTypeFnPtr(BinaryReader reader, CliElementType typeCode) {
            super(typeCode);
        }

        @Override
        public String getRepresentation() {
            return "FnPtr " + this.sig.getRepresentation();
        }

        @Override
        public String getShortRepresentation() {
            return "FnPtr " + this.sig.getShortRepresentation();
        }

        @Override
        public DataType getDefinitionDataType() {
            StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Types"), "FnPtr", 0);
            struct.add((DataType)CliTypeCodeDataType.dataType, "FnPtr", "FnPtr");
            struct.add(StructConverter.DWORD, "MethodDefOrRef", "index into blob heap");
            return struct;
        }
    }

    public class CliTypeClass
    extends CliSigType {
        private int encodedType;
        private int typeBytes;

        public CliTypeClass(BinaryReader reader, CliElementType typeCode) throws IOException {
            super(typeCode);
            long origIndex = reader.getPointerIndex();
            this.encodedType = CliBlob.decodeCompressedUnsignedInt(reader);
            this.typeBytes = (int)(reader.getPointerIndex() - origIndex);
        }

        @Override
        public String getRepresentation() {
            return Integer.toHexString(this.encodedType);
        }

        private String getRepresentation(CliStreamMetadata stream, boolean shortRep) {
            try {
                if (stream != null) {
                    CliAbstractTable table = stream.getTable(CliIndexTypeDefOrRef.getTableName(this.encodedType));
                    if (table == null) {
                        return "[ErrorRetrievingTable]";
                    }
                    CliAbstractTableRow row = table.getRow(CliIndexTypeDefOrRef.getRowIndex(this.encodedType));
                    if (row == null) {
                        return "[ErrorRetrievingRow]";
                    }
                    if (shortRep) {
                        return row.getShortRepresentation();
                    }
                    return row.getRepresentation();
                }
                return "[ErrorRepresentingClassReference]";
            }
            catch (InvalidInputException e) {
                e.printStackTrace();
                return "[ErrorRepresentingClassReference]";
            }
        }

        @Override
        public String getRepresentation(CliStreamMetadata stream) {
            return this.getRepresentation(null, false);
        }

        @Override
        public String getShortRepresentation(CliStreamMetadata stream) {
            return this.getRepresentation(stream, true);
        }

        @Override
        public DataType getDefinitionDataType() {
            StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Types"), "Class", 0);
            struct.add((DataType)CliTypeCodeDataType.dataType, "Class", "Class");
            struct.add(CliBlob.getDataTypeForBytes(this.typeBytes), "Type", "TypeDefOrRefOrSpecEncoded");
            return struct;
        }
    }

    public class CliTypeArray
    extends CliSigType {
        private CliSigType arrayType;
        private CliArrayShape arrayShape;

        public CliTypeArray(BinaryReader reader, CliElementType typeCode) throws IOException, InvalidInputException {
            super(typeCode);
            CliElementType valueCode = CliElementType.fromInt(reader.readNextByte());
            switch (valueCode) {
                case ELEMENT_TYPE_VALUETYPE: {
                    this.arrayType = new CliTypeValueType(reader, typeCode);
                    break;
                }
                case ELEMENT_TYPE_CLASS: {
                    this.arrayType = new CliTypeClass(reader, typeCode);
                    break;
                }
                case ELEMENT_TYPE_FNPTR: {
                    this.arrayType = new CliTypeFnPtr(reader, typeCode);
                    break;
                }
                case ELEMENT_TYPE_GENERICINST: {
                    this.arrayType = new CliTypeGenericInst(reader, typeCode);
                    break;
                }
                case ELEMENT_TYPE_MVAR: 
                case ELEMENT_TYPE_VAR: {
                    this.arrayType = new CliTypeVarOrMvar(reader, typeCode);
                    break;
                }
                case ELEMENT_TYPE_PTR: {
                    this.arrayType = new CliTypePtr(reader, typeCode);
                    break;
                }
                case ELEMENT_TYPE_SZARRAY: {
                    this.arrayType = new CliTypeSzArray(reader, typeCode);
                    break;
                }
                case ELEMENT_TYPE_ARRAY: {
                    this.arrayType = new CliTypeArray(reader, typeCode);
                    break;
                }
                default: {
                    this.arrayType = new CliTypePrimitive(valueCode);
                }
            }
            this.arrayShape = new CliArrayShape(reader);
        }

        @Override
        public String getRepresentation() {
            return String.format("Array %s %s", this.arrayType.toString(), this.arrayShape.getRepresentation());
        }

        @Override
        public DataType getDefinitionDataType() {
            StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Types"), "Array", 0);
            struct.add((DataType)CliTypeCodeDataType.dataType, "Array", String.format("Fixed value: 0x%x", CliElementType.ELEMENT_TYPE_ARRAY.id()));
            if (this.arrayType instanceof CliTypePrimitive) {
                struct.add((DataType)CliTypeCodeDataType.dataType, "Type", "Type of array");
            } else {
                struct.add(this.arrayType.getDefinitionDataType(), "ValueType", "Class token");
            }
            struct.add(this.arrayShape.getDefinitionDataType(), "ArrayShape", null);
            return struct;
        }
    }

    public class CliTypePrimitive
    extends CliSigType {
        public CliTypePrimitive(CliElementType typeCode) {
            super(typeCode);
        }

        @Override
        public String getRepresentation() {
            return this.baseTypeCode.toString();
        }

        @Override
        public DataType getDefinitionDataType() {
            return CliTypeCodeDataType.dataType;
        }
    }

    public abstract class CliSigType
    implements CliRepresentable {
        protected CliElementType baseTypeCode;
        public static final String PATH = "/PE/CLI/Types";

        public CliSigType(CliElementType typeCode) {
            this.baseTypeCode = typeCode;
        }

        @Override
        public abstract String getRepresentation();

        @Override
        public String getRepresentation(CliStreamMetadata stream) {
            return this.getRepresentation();
        }

        @Override
        public String getShortRepresentation() {
            return this.getRepresentation();
        }

        @Override
        public String getShortRepresentation(CliStreamMetadata stream) {
            return this.getRepresentation(stream);
        }

        public abstract DataType getDefinitionDataType();

        public DataType getExecutionDataType() {
            return CliAbstractSig.convertTypeCodeToDataType(this.baseTypeCode);
        }
    }

    public static enum CliElementType {
        ELEMENT_TYPE_END(0),
        ELEMENT_TYPE_VOID(1),
        ELEMENT_TYPE_BOOLEAN(2),
        ELEMENT_TYPE_CHAR(3),
        ELEMENT_TYPE_I1(4),
        ELEMENT_TYPE_U1(5),
        ELEMENT_TYPE_I2(6),
        ELEMENT_TYPE_U2(7),
        ELEMENT_TYPE_I4(8),
        ELEMENT_TYPE_U4(9),
        ELEMENT_TYPE_I8(10),
        ELEMENT_TYPE_U8(11),
        ELEMENT_TYPE_R4(12),
        ELEMENT_TYPE_R8(13),
        ELEMENT_TYPE_STRING(14),
        ELEMENT_TYPE_PTR(15),
        ELEMENT_TYPE_BYREF(16),
        ELEMENT_TYPE_VALUETYPE(17),
        ELEMENT_TYPE_CLASS(18),
        ELEMENT_TYPE_VAR(19),
        ELEMENT_TYPE_ARRAY(20),
        ELEMENT_TYPE_GENERICINST(21),
        ELEMENT_TYPE_TYPEDBYREF(22),
        ELEMENT_TYPE_I(24),
        ELEMENT_TYPE_U(25),
        ELEMENT_TYPE_FNPTR(27),
        ELEMENT_TYPE_OBJECT(28),
        ELEMENT_TYPE_SZARRAY(29),
        ELEMENT_TYPE_MVAR(30),
        ELEMENT_TYPE_CMOD_REQD(31),
        ELEMENT_TYPE_CMOD_OPT(32),
        ELEMENT_TYPE_INTERNAL(33),
        ELEMENT_TYPE_MAX(34),
        ELEMENT_TYPE_MODIFIER(64),
        ELEMENT_TYPE_SENTINAL(65),
        ELEMENT_TYPE_PINNED(69);

        private final int id;

        private CliElementType(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static CliElementType fromInt(int id) {
            CliElementType[] values;
            for (CliElementType value : values = CliElementType.values()) {
                if (value.id != id) continue;
                return value;
            }
            return null;
        }
    }

    public static class CliTypeCodeDataType
    extends EnumDataType {
        private static final long serialVersionUID = 1L;
        public static final String PATH = "/PE/CLI/Types";
        public static final CliTypeCodeDataType dataType = new CliTypeCodeDataType();

        public CliTypeCodeDataType() {
            super(new CategoryPath(PATH), "TypeCode", 1);
            for (CliElementType c : CliElementType.values()) {
                this.add(c.toString(), c.id());
            }
        }
    }
}

