/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliSigLocalVar
extends CliAbstractSig {
    public static final int identifier = 7;
    private int sizeOfCount;
    private CliAbstractSig.CliParam[] types;

    public CliSigLocalVar(CliBlob blob) throws IOException {
        super(blob);
        BinaryReader reader = this.getContentsReader();
        byte id = reader.readNextByte();
        if (id != 7) {
            return;
        }
        long origIndex = reader.getPointerIndex();
        int typesCount = CliSigLocalVar.decodeCompressedUnsignedInt(reader);
        this.sizeOfCount = (int)(reader.getPointerIndex() - origIndex);
        this.types = new CliAbstractSig.CliParam[typesCount];
        for (int i = 0; i < typesCount; i = (int)((byte)(i + 1))) {
            try {
                this.types[i] = new CliAbstractSig.CliParam(this, reader);
                continue;
            }
            catch (InvalidInputException e) {
                this.types[i] = null;
                e.printStackTrace();
            }
        }
    }

    public static boolean isLocalVarSig(CliBlob blob) throws IOException {
        return blob.getContentsReader().readNextByte() == 7;
    }

    @Override
    public String getContentsName() {
        return "LocalVarSig";
    }

    @Override
    public String getContentsComment() {
        return "Contains signature for function locals";
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs/Signatures"), this.getName(), 0);
        struct.add(BYTE, "LOCAL_SIG", "Magic, must be 0x07");
        struct.add(CliSigLocalVar.getDataTypeForBytes(this.sizeOfCount), "Count", "Number of types to follow");
        for (CliAbstractSig.CliParam param : this.types) {
            struct.add(param.getDefinitionDataType(), "Type", null);
        }
        return struct;
    }

    @Override
    public String getRepresentationCommon(CliStreamMetadata stream, boolean isShort) {
        Object rep = "";
        for (CliAbstractSig.CliParam param : this.types) {
            rep = (String)rep + this.getRepresentationOf(param, stream, isShort) + ", ";
        }
        if (this.types.length > 0) {
            rep = ((String)rep).substring(0, ((String)rep).length() - 2);
        }
        return rep;
    }
}

