/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.streams;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.CliStreamHeader;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CliStreamStrings
extends CliAbstractStream {
    private List<Integer> stringIndexes = new ArrayList<Integer>();
    private List<Integer> stringSizes = new ArrayList<Integer>();

    public static String getName() {
        return "#Strings";
    }

    public CliStreamStrings(CliStreamHeader header, long offset, int rva, BinaryReader reader) throws IOException {
        super(header, offset, rva, reader);
    }

    @Override
    public boolean parse() throws IOException {
        String str;
        this.reader.setPointerIndex(this.offset);
        this.reader.readNextByte();
        for (int bytesRead = 1; bytesRead < this.header.getSize(); bytesRead += str.length() + 1) {
            str = this.reader.readNextAsciiString();
            this.stringIndexes.add(bytesRead);
            this.stringSizes.add(str.length() + 1);
        }
        return true;
    }

    public String getString(int index) {
        int lastIndex = this.stringIndexes.get(this.stringIndexes.size() - 1);
        int lastSize = this.stringSizes.get(this.stringSizes.size() - 1);
        if (index < 0 || index >= lastIndex + lastSize) {
            return null;
        }
        try {
            return this.reader.readAsciiString(this.offset + (long)index);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Streams"), this.header.getName(), 0);
        struct.add(BYTE, "Reserved", "Always 0");
        for (int i = 0; i < this.stringSizes.size(); ++i) {
            struct.add(UTF8, this.stringSizes.get(i).intValue(), "[" + Integer.toHexString(this.stringIndexes.get(i)) + "]", null);
        }
        return struct;
    }
}

