/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.resource;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ResourceDirectoryStringU
implements StructConverter {
    public static final String NAME = "IMAGE_RESOURCE_DIR_STRING_U";
    private short length;
    private String nameString;

    public ResourceDirectoryStringU(FactoryBundledWithBinaryReader reader, int index) throws IOException {
        this.length = reader.readShort(index);
        this.nameString = reader.readUnicodeString(index + 2, this.length);
    }

    public short getLength() {
        return this.length;
    }

    public String getNameString() {
        return this.nameString;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("IMAGE_RESOURCE_DIR_STRING_U_" + this.length * 2, 0);
        struct.add(WORD, "Length", null);
        struct.add(UTF16, this.length * 2, "NameString", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public String toString() {
        return this.nameString;
    }
}

