/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.app.util.datatype.microsoft.GuidInfo;
import ghidra.app.util.datatype.microsoft.GuidUtil;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.Conv;
import ghidra.util.DataConverter;
import ghidra.util.classfinder.ClassTranslator;

public class GuidDataType
extends BuiltIn {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "GUID";
    private static final EndianSettingsDefinition ENDIAN;
    private static SettingsDefinition[] SETTINGS_DEFS;
    public static final int SIZE = 16;
    public static final String KEY = "GUID_NAME";
    private static String cachedGuidString;
    private static String cachedGuidName;

    public GuidDataType() {
        this(null);
    }

    public GuidDataType(DataTypeManager dtm) {
        super(null, NAME, dtm);
    }

    public String getMnemonic(Settings settings) {
        return NAME;
    }

    public int getLength() {
        return 16;
    }

    public boolean isDynamicallySized() {
        return false;
    }

    public String getDescription() {
        return NAME;
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.getString(buf, settings);
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.getString(buf, settings);
    }

    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return SETTINGS_DEFS;
    }

    protected String getString(MemBuffer buf, Settings settings) {
        int i;
        Object guidName = settings.getValue(KEY);
        String delim = "-";
        byte[] bytes = new byte[16];
        long[] data = new long[4];
        boolean isBigEndian = ENDIAN.isBigEndian(settings, buf);
        DataConverter conv = DataConverter.getInstance((boolean)isBigEndian);
        if (buf.getBytes(bytes, 0) != bytes.length) {
            if (guidName != null) {
                return (String)guidName;
            }
            return "??";
        }
        for (int i2 = 0; i2 < data.length; ++i2) {
            data[i2] = 0xFFFFFFFFL & (long)conv.getInt(bytes, i2 * 4);
            conv.getBytes((int)data[i2], bytes, i2 * 4);
        }
        String retVal = Conv.toHexString((int)((int)data[0])) + delim;
        retVal = retVal + Conv.toHexString((short)((short)data[1])) + delim;
        retVal = retVal + Conv.toHexString((short)((short)(data[1] >> 16))) + delim;
        for (i = 0; i < 4; ++i) {
            retVal = retVal + Conv.toHexString((byte)((byte)(data[2] >> i * 8)));
            if (i != 1) continue;
            retVal = retVal + delim;
        }
        for (i = 0; i < 4; ++i) {
            retVal = retVal + Conv.toHexString((byte)((byte)(data[3] >> i * 8)));
        }
        if (guidName == null) {
            guidName = this.getGuidName(retVal);
        }
        if (guidName != null) {
            return guidName + " " + retVal;
        }
        return retVal;
    }

    private String getGuidName(String guidString) {
        if (guidString.equals(cachedGuidString)) {
            return cachedGuidName;
        }
        cachedGuidString = guidString;
        GuidInfo guidInfo = GuidUtil.getKnownGuid(guidString);
        cachedGuidName = guidInfo != null ? guidInfo.getName() : null;
        return cachedGuidName;
    }

    public String getDefaultLabelPrefix() {
        return NAME;
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new GuidDataType(dtm);
    }

    static {
        ClassTranslator.put((String)"ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin.dataTypes.GuidDataType", (String)GuidDataType.class.getName());
        ClassTranslator.put((String)"ghidra.app.util.bin.format.microsoft.GuidDataType", (String)GuidDataType.class.getName());
        ENDIAN = EndianSettingsDefinition.DEF;
        SETTINGS_DEFS = new SettingsDefinition[]{ENDIAN};
    }
}

