/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledFunctionIndirect;
import ghidra.app.util.demangler.DemangledFunctionPointer;
import ghidra.app.util.demangler.DemangledFunctionReference;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.VoidDataType;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDemangledFunctionDefinitionDataType
extends DemangledDataType {
    protected static final String DEFAULT_NAME_PREFIX = "FuncDef";
    protected static final String EMPTY_STRING = "";
    protected static int ID = 0;
    protected DemangledDataType returnType;
    protected String callingConvention;
    protected List<DemangledDataType> parameters = new ArrayList<DemangledDataType>();
    protected String modifier;
    protected boolean isConstPointer;
    protected String parentName;
    protected boolean isTrailingPointer64;
    protected boolean isTrailingUnaligned;
    protected boolean isTrailingRestrict;
    protected boolean displayFunctionPointerParens = true;

    AbstractDemangledFunctionDefinitionDataType(String mangled, String originalDemangled) {
        super(mangled, originalDemangled, DEFAULT_NAME_PREFIX + AbstractDemangledFunctionDefinitionDataType.nextId());
    }

    private static synchronized int nextId() {
        return ID++;
    }

    protected abstract String getTypeString();

    @Override
    public String getSignature() {
        return this.toSignature(null);
    }

    public void setReturnType(DemangledDataType returnType) {
        this.returnType = returnType;
    }

    public DemangledDataType getReturnType() {
        return this.returnType;
    }

    public void setCallingConvention(String callingConvention) {
        this.callingConvention = callingConvention;
    }

    public String getCallingConvention() {
        return this.callingConvention;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public boolean isConstPointer() {
        return this.isConstPointer;
    }

    public void setConstPointer() {
        this.isConstPointer = true;
    }

    public boolean isTrailingPointer64() {
        return this.isTrailingPointer64;
    }

    public void setTrailingPointer64() {
        this.isTrailingPointer64 = true;
    }

    public boolean isTrailingUnaligned() {
        return this.isTrailingUnaligned;
    }

    public void setTrailingUnaligned() {
        this.isTrailingUnaligned = true;
    }

    public boolean isTrailingRestrict() {
        return this.isTrailingRestrict;
    }

    public void setTrailingRestrict() {
        this.isTrailingRestrict = true;
    }

    public void setDisplayFunctionPointerParens(boolean b) {
        this.displayFunctionPointerParens = b;
    }

    public void addParameter(DemangledDataType parameter) {
        this.parameters.add(parameter);
    }

    public List<DemangledDataType> getParameters() {
        return new ArrayList<DemangledDataType>(this.parameters);
    }

    public String toSignature(String name) {
        StringBuilder buffer = new StringBuilder();
        StringBuilder buffer1 = new StringBuilder();
        String s = this.getConventionPointerNameString(name);
        if (s.contains(" ") || s.isEmpty()) {
            this.addFunctionPointerParens(buffer1, s);
        } else {
            buffer1.append(s);
        }
        buffer1.append('(');
        for (int i = 0; i < this.parameters.size(); ++i) {
            buffer1.append(this.parameters.get(i).getSignature());
            if (i >= this.parameters.size() - 1) continue;
            buffer1.append(',');
        }
        buffer1.append(')');
        if (this.returnType instanceof DemangledFunctionPointer) {
            DemangledFunctionPointer dfp = (DemangledFunctionPointer)this.returnType;
            buffer.append(dfp.toSignature(buffer1.toString())).append(' ');
        } else if (this.returnType instanceof DemangledFunctionReference) {
            DemangledFunctionReference dfr = (DemangledFunctionReference)this.returnType;
            buffer.append(dfr.toSignature(buffer1.toString())).append(' ');
        } else if (this.returnType instanceof DemangledFunctionIndirect) {
            DemangledFunctionIndirect dfi = (DemangledFunctionIndirect)this.returnType;
            buffer.append(dfi.toSignature(buffer1.toString())).append(' ');
        } else {
            buffer.append(this.returnType.getSignature()).append(' ');
            buffer.append((CharSequence)buffer1);
        }
        if (this.isConst()) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("const");
        }
        if (this.isVolatile()) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("volatile");
        }
        if (this.isTrailingUnaligned) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("__unaligned");
        }
        if (this.isTrailingPointer64) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("__ptr64");
        }
        if (this.isTrailingRestrict) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("__restrict");
        }
        return buffer.toString();
    }

    protected String getConventionPointerNameString(String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.callingConvention == null ? EMPTY_STRING : this.callingConvention);
        int pointerLevels = this.getPointerLevels();
        if (pointerLevels > 0) {
            if (this.callingConvention != null) {
                buffer.append(' ');
            }
            this.addParentName(buffer);
            for (int i = 0; i < pointerLevels; ++i) {
                buffer.append(this.getTypeString());
            }
        }
        if (this.modifier != null && this.modifier.length() != 0) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append(this.modifier);
        }
        if (this.isConstPointer) {
            buffer.append("const");
        }
        if (this.isPointer64()) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("__ptr64");
        }
        if (name != null) {
            if (buffer.length() > 2 && buffer.charAt(buffer.length() - 1) != ' ') {
                buffer.append(' ');
            }
            buffer.append(name);
        }
        return buffer.toString();
    }

    protected void addFunctionPointerParens(StringBuilder buffer, String s) {
        if (!this.displayFunctionPointerParens) {
            return;
        }
        buffer.append('(').append(s).append(')');
    }

    protected void addParentName(StringBuilder buffer) {
        char lastChar;
        if (this.parentName == null) {
            return;
        }
        if (this.parentName.startsWith(DEFAULT_NAME_PREFIX)) {
            return;
        }
        if (buffer.length() > 2 && ' ' != (lastChar = buffer.charAt(buffer.length() - 1))) {
            buffer.append(' ');
        }
        buffer.append(this.parentName).append("::");
    }

    @Override
    public DataType getDataType(DataTypeManager dataTypeManager) {
        DataType dt;
        FunctionDefinitionDataType fddt = new FunctionDefinitionDataType(this.getName());
        if (this.returnType != null) {
            fddt.setReturnType(this.returnType.getDataType(dataTypeManager));
        }
        if (this.parameters.size() != 1 || !(this.parameters.get(0).getDataType(dataTypeManager) instanceof VoidDataType)) {
            ParameterDefinition[] params = new ParameterDefinition[this.parameters.size()];
            for (int i = 0; i < this.parameters.size(); ++i) {
                params[i] = new ParameterDefinitionImpl(null, this.parameters.get(i).getDataType(dataTypeManager), null);
            }
            fddt.setArguments(params);
        }
        if ((dt = DemangledDataType.findDataType(dataTypeManager, this.namespace, this.getName())) == null || !(dt instanceof FunctionDefinitionDataType)) {
            dt = fddt;
        }
        return new PointerDataType(dt, dataTypeManager);
    }
}

