/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.importer;

import ghidra.app.util.importer.LoadSpecChooser;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderMap;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.util.Msg;
import java.util.Collection;
import util.CollectionUtils;

public class LcsHintLoadSpecChooser
implements LoadSpecChooser {
    private final LanguageID languageID;
    private final CompilerSpecID compilerSpecID;

    public LcsHintLoadSpecChooser(Language language, CompilerSpec compilerSpec) {
        this.languageID = language.getLanguageID();
        this.compilerSpecID = compilerSpec == null ? language.getDefaultCompilerSpec().getCompilerSpecID() : compilerSpec.getCompilerSpecID();
    }

    @Override
    public LoadSpec choose(LoaderMap loaderMap) {
        Loader loader = loaderMap.keySet().stream().findFirst().orElse(null);
        if (loader == null) {
            return null;
        }
        Collection loadSpecs = (Collection)loaderMap.get(loader);
        for (LoadSpec loadSpec : loadSpecs) {
            LanguageCompilerSpecPair lcsPair = loadSpec.getLanguageCompilerSpec();
            if (!lcsPair.languageID.equals((Object)this.languageID) || this.compilerSpecID != null && !lcsPair.compilerSpecID.equals((Object)this.compilerSpecID)) continue;
            return loadSpec;
        }
        LoadSpec anyLoadSpec = (LoadSpec)CollectionUtils.any((Collection)loadSpecs);
        LanguageCompilerSpecPair customLcsPair = new LanguageCompilerSpecPair(this.languageID, this.compilerSpecID);
        LoadSpec customLoadSpec = new LoadSpec(loader, anyLoadSpec.getDesiredImageBase(), customLcsPair, false);
        Msg.warn((Object)this, (Object)("Using unknown opinion: " + loader.getName() + ", " + customLcsPair));
        return customLoadSpec;
    }
}

