/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.app.util.bin.format.macho.CpuTypes;
import ghidra.app.util.bin.format.macho.MachConstants;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.prelink.PrelinkMap;
import ghidra.app.util.bin.format.ubi.FatArch;
import ghidra.app.util.bin.format.ubi.FatHeader;
import ghidra.app.util.bin.format.ubi.UbiException;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.MachoPrelinkProgramBuilder;
import ghidra.app.util.opinion.MachoPrelinkUtils;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.framework.model.DomainFolder;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.listing.Program;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MachoLoader
extends AbstractLibrarySupportLoader {
    public static final String MACH_O_NAME = "Mac OS X Mach-O";
    private static final long MIN_BYTE_LENGTH = 4L;

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 4L) {
            return loadSpecs;
        }
        byte[] magicBytes = provider.readBytes(0L, 4L);
        if (!MachConstants.isMagic(LittleEndianDataConverter.INSTANCE.getInt(magicBytes))) {
            return loadSpecs;
        }
        try {
            MachHeader machHeader = MachHeader.createMachHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, provider);
            String magic = CpuTypes.getMagicString(machHeader.getCpuType(), machHeader.getCpuSubType());
            List<QueryResult> results = QueryOpinionService.query(this.getName(), magic, null);
            for (QueryResult result : results) {
                loadSpecs.add(new LoadSpec((Loader)this, machHeader.getImageBase(), result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, machHeader.getImageBase(), true));
            }
        }
        catch (MachException machException) {
            // empty catch block
        }
        return loadSpecs;
    }

    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException {
        try {
            FileBytes fileBytes = MemoryBlockUtils.createFileBytes(program, provider, monitor);
            List<PrelinkMap> prelinkList = MachoPrelinkUtils.parsePrelinkXml(provider, monitor);
            if (!prelinkList.isEmpty()) {
                MachoPrelinkProgramBuilder.buildProgram(program, provider, fileBytes, prelinkList, log, monitor);
            } else {
                MachoProgramBuilder.buildProgram(program, provider, fileBytes, log, monitor);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public String getName() {
        return MACH_O_NAME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean importLibrary(String libName, DomainFolder libFolder, File libFile, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, Set<String> unprocessedLibs, List<Program> programList, TaskMonitor monitor) throws CancelledException, IOException {
        if (!libFile.isFile()) {
            return false;
        }
        try (RandomAccessByteProvider provider = new RandomAccessByteProvider(libFile);){
            FatHeader header = FatHeader.createFatHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, provider);
            List<FatArch> architectures = header.getArchitectures();
            if (architectures.isEmpty()) {
                log.appendMsg("WARNING! No archives found in the UBI: " + libFile);
                boolean bl = false;
                return bl;
            }
            Iterator<FatArch> iterator = architectures.iterator();
            while (iterator.hasNext()) {
                FatArch architecture = iterator.next();
                try (ByteProviderWrapper bp = new ByteProviderWrapper(provider, architecture.getOffset(), architecture.getSize());){
                    if (!super.importLibrary(libName, libFolder, libFile, bp, loadSpec, options, log, consumer, unprocessedLibs, programList, monitor)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return super.importLibrary(libName, libFolder, libFile, loadSpec, options, log, consumer, unprocessedLibs, programList, monitor);
        }
        catch (MachException | UbiException exception) {
            // empty catch block
        }
        return super.importLibrary(libName, libFolder, libFile, loadSpec, options, log, consumer, unprocessedLibs, programList, monitor);
    }
}

