/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.continues.GenericFactory;
import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.MachHeaderFileTypes;
import ghidra.app.util.bin.format.macho.MachHeaderFlags;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.ScatteredRelocationInfo;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.DyldInfoCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicLibrary;
import ghidra.app.util.bin.format.macho.commands.DynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicLinkerCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicSymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.EntryPointCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.commands.PreboundDynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.RunPathCommand;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.commands.SubClientCommand;
import ghidra.app.util.bin.format.macho.commands.SubFrameworkCommand;
import ghidra.app.util.bin.format.macho.commands.SubLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.SubUmbrellaCommand;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.UnsupportedLoadCommand;
import ghidra.app.util.bin.format.macho.commands.dyld.BindProcessor;
import ghidra.app.util.bin.format.macho.commands.dyld.ClassicBindProcessor;
import ghidra.app.util.bin.format.macho.commands.dyld.ClassicLazyBindProcessor;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.importer.MessageLogContinuesFactory;
import ghidra.framework.options.Options;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MachoProgramBuilder {
    public static final String BLOCK_SOURCE_NAME = "Mach-O Loader";
    protected MachHeader machoHeader;
    protected Program program;
    protected ByteProvider provider;
    protected FileBytes fileBytes;
    protected MessageLog log;
    protected TaskMonitor monitor;
    protected Memory memory;
    protected Listing listing;
    protected AddressSpace space;

    protected MachoProgramBuilder(Program program, ByteProvider provider, FileBytes fileBytes, MessageLog log, TaskMonitor monitor) {
        this.program = program;
        this.provider = provider;
        this.fileBytes = fileBytes;
        this.log = log;
        this.monitor = monitor;
        this.memory = program.getMemory();
        this.listing = program.getListing();
        this.space = program.getAddressFactory().getDefaultAddressSpace();
    }

    public static void buildProgram(Program program, ByteProvider provider, FileBytes fileBytes, MessageLog log, TaskMonitor monitor) throws Exception {
        MachoProgramBuilder machoProgramBuilder = new MachoProgramBuilder(program, provider, fileBytes, log, monitor);
        machoProgramBuilder.build();
    }

    protected void build() throws Exception {
        this.monitor.setMessage("Completing Mach-O header parsing...");
        this.monitor.setCancelEnabled(false);
        this.machoHeader = MachHeader.createMachHeader((GenericFactory)MessageLogContinuesFactory.create((MessageLog)this.log), this.provider);
        this.machoHeader.parse();
        Address headerAddr = null;
        for (SegmentCommand segment : this.machoHeader.getAllSegments()) {
            if (segment.getFileOffset() != 0L || segment.getFileSize() <= 0L) continue;
            headerAddr = this.space.getAddress(segment.getVMaddress());
            break;
        }
        this.monitor.setCancelEnabled(true);
        this.setImageBase();
        this.processEntryPoint();
        this.processMemoryBlocks(this.machoHeader, this.provider.getName(), true, true);
        this.processUnsupportedLoadCommands();
        this.processSymbolTables();
        this.processIndirectSymbols();
        this.setRelocatableProperty();
        this.processLibraries();
        this.processProgramDescription();
        this.renameObjMsgSendRtpSymbol();
        this.processUndefinedSymbols();
        this.processAbsoluteSymbols();
        this.processDyldInfo();
        this.markupHeaders(this.machoHeader, headerAddr);
        this.markupSections();
        this.processProgramVars();
        this.loadSectionRelocations();
        this.loadExternalRelocations();
        this.loadLocalRelocations();
    }

    private void setImageBase() throws Exception {
        Address imageBaseAddr = null;
        for (SegmentCommand segment : this.machoHeader.getAllSegments()) {
            if (segment.getFileSize() <= 0L) continue;
            Address segmentAddr = this.space.getAddress(segment.getVMaddress());
            if (imageBaseAddr == null) {
                imageBaseAddr = segmentAddr;
                continue;
            }
            if (segmentAddr.compareTo((Object)imageBaseAddr) >= 0) continue;
            imageBaseAddr = segmentAddr;
        }
        if (imageBaseAddr != null) {
            this.program.setImageBase(imageBaseAddr, true);
        } else {
            this.program.setImageBase(this.space.getAddress(0L), true);
        }
    }

    private void processEntryPoint() throws Exception {
        long pointer;
        ThreadCommand threadCommand;
        SegmentCommand segment;
        long offset;
        this.monitor.setMessage("Processing entry point...");
        Address entryPointAddr = null;
        EntryPointCommand entryPointCommand = this.machoHeader.getFirstLoadCommand(EntryPointCommand.class);
        if (entryPointCommand != null && (offset = entryPointCommand.getEntryOffset()) > 0L && (segment = this.machoHeader.getSegment("__TEXT")) != null) {
            entryPointAddr = this.space.getAddress(segment.getVMaddress()).add(offset);
        }
        if (entryPointAddr == null && (threadCommand = this.machoHeader.getFirstLoadCommand(ThreadCommand.class)) != null && (pointer = threadCommand.getInitialInstructionPointer()) != -1L) {
            entryPointAddr = this.space.getAddress(pointer);
        }
        if (entryPointAddr != null) {
            this.program.getSymbolTable().createLabel(entryPointAddr, "entry", SourceType.IMPORTED);
            this.program.getSymbolTable().addExternalEntryPoint(entryPointAddr);
            this.createOneByteFunction("entry", entryPointAddr);
        } else {
            this.log.appendMsg("Unable to determine entry point.");
        }
    }

    protected void processMemoryBlocks(MachHeader header, String source, boolean processSections, boolean allowZeroAddr) throws Exception {
        this.monitor.setMessage("Processing memory blocks for " + source + "...");
        if (header.getFileType() == 9) {
            return;
        }
        for (SegmentCommand segment : header.getAllSegments()) {
            if (this.monitor.isCancelled()) break;
            if (segment.getFileSize() > 0L && (allowZeroAddr || segment.getVMaddress() != 0L)) {
                if (this.createMemoryBlock(segment.getSegmentName(), this.space.getAddress(segment.getVMaddress()), segment.getFileOffset(), segment.getFileSize(), segment.getSegmentName(), source, segment.isRead(), segment.isWrite(), segment.isExecute(), false) == null) {
                    this.log.appendMsg(String.format("Failed to create block: %s 0x%x 0x%x", segment.getSegmentName(), segment.getVMaddress(), segment.getVMsize()));
                }
                if (segment.getVMsize() <= segment.getFileSize() || this.createMemoryBlock(segment.getSegmentName(), this.space.getAddress(segment.getVMaddress()).add(segment.getFileSize()), 0L, segment.getVMsize() - segment.getFileSize(), segment.getSegmentName(), source, segment.isRead(), segment.isWrite(), segment.isExecute(), true) != null) continue;
                this.log.appendMsg(String.format("Failed to create block: %s 0x%x 0x%x", segment.getSegmentName(), segment.getVMaddress(), segment.getVMsize()));
                continue;
            }
            this.log.appendMsg("Skipping segment: " + segment.getSegmentName() + " (" + source + ")");
        }
        if (processSections) {
            for (Section section : header.getAllSections()) {
                if (this.monitor.isCancelled()) break;
                if (section.getSize() > 0L && (allowZeroAddr || section.getAddress() != 0L)) {
                    if (this.createMemoryBlock(section.getSectionName(), this.space.getAddress(section.getAddress()), section.getOffset(), section.getSize(), section.getSegmentName(), source, section.isRead(), section.isWrite(), section.isExecute(), section.getType() == 1) != null) continue;
                    this.log.appendMsg(String.format("Failed to create block: %s.%s 0x%x 0x%x %s", section.getSegmentName(), section.getSectionName(), section.getAddress(), section.getSize(), source));
                    continue;
                }
                this.log.appendMsg("Skipping section: " + section.getSegmentName() + "." + section.getSectionName() + " (" + source + ")");
            }
        }
    }

    private MemoryBlock createMemoryBlock(String name, Address start, long dataOffset, long dataLength, String comment, String source, boolean r, boolean w, boolean x, boolean zeroFill) throws Exception {
        if (!this.program.getLanguageID().getIdAsString().startsWith("x86") && (start.getOffset() & 0xFFF000000000L) != 0L) {
            start = this.space.getAddress(start.getOffset() | 0xFFFF000000000000L);
        }
        ArrayList<MemoryBlock> intersectingBlocks = new ArrayList<MemoryBlock>();
        AddressSet range = new AddressSet(start, start.add(dataLength - 1L));
        for (MemoryBlock block : this.memory.getBlocks()) {
            if (!range.intersects(block.getStart(), block.getEnd())) continue;
            intersectingBlocks.add(block);
        }
        if (intersectingBlocks.isEmpty()) {
            if (zeroFill) {
                return MemoryBlockUtils.createUninitializedBlock(this.program, false, name, start, dataLength, comment, source, r, w, x, this.log);
            }
            return MemoryBlockUtils.createInitializedBlock(this.program, false, name, start, this.fileBytes, dataOffset, dataLength, comment, source, r, w, x, this.log);
        }
        MemoryBlock startingBlock = (MemoryBlock)intersectingBlocks.get(0);
        if (start.compareTo((Object)startingBlock.getStart()) > 0) {
            this.memory.split(startingBlock, start);
        }
        MemoryBlock endingBlock = (MemoryBlock)intersectingBlocks.get(intersectingBlocks.size() - 1);
        if (start.add(dataLength - 1L).compareTo((Object)endingBlock.getEnd()) < 0) {
            this.memory.split(endingBlock, start.add(dataLength));
            MemoryBlock newEndingBlock = this.memory.getBlock(start.add(dataLength));
            newEndingBlock.setName(endingBlock.getName());
            newEndingBlock.setSourceName(endingBlock.getSourceName());
            newEndingBlock.setComment(endingBlock.getComment());
        }
        for (MemoryBlock block : this.memory.getBlocks()) {
            if (!range.intersects(block.getStart(), block.getEnd())) continue;
            block.setName(name);
            block.setPermissions(r, w, x);
            block.setSourceName(source);
            block.setComment(comment);
        }
        return this.memory.getBlock(start);
    }

    private void processUnsupportedLoadCommands() throws Exception {
        this.monitor.setMessage("Processing unsupported load commands...");
        for (LoadCommand loadCommand : this.machoHeader.getLoadCommands(UnsupportedLoadCommand.class)) {
            this.log.appendMsg(loadCommand.getCommandName());
        }
    }

    private void processSymbolTables() throws Exception {
        this.monitor.setMessage("Processing symbol tables...");
        List<SymbolTableCommand> commands = this.machoHeader.getLoadCommands(SymbolTableCommand.class);
        for (SymbolTableCommand symbolTableCommand : commands) {
            List<NList> symbols = symbolTableCommand.getSymbols();
            for (NList symbol : symbols) {
                String string;
                if (this.monitor.isCancelled()) {
                    return;
                }
                if (symbol.isTypePreboundUndefined() || symbol.isLazyBind()) continue;
                Address addr = this.space.getAddress(symbol.getValue());
                if (symbol.isSymbolicDebugging() || symbol.isTypeAbsolute() || symbol.isTypeUndefined()) continue;
                if (symbol.isExternal() || symbol.isPrivateExternal()) {
                    this.program.getSymbolTable().addExternalEntryPoint(addr);
                }
                if ((string = symbol.getString()).length() == 0) continue;
                string = SymbolUtilities.replaceInvalidChars((String)string, (boolean)true);
                if (symbol.isThumbSymbol()) {
                    this.markAsThumb(addr);
                }
                if (this.program.getSymbolTable().getGlobalSymbol(string, addr) != null) continue;
                try {
                    this.program.getSymbolTable().createLabel(addr, string, SourceType.IMPORTED);
                }
                catch (Exception e) {
                    this.log.appendMsg("Unable to create symbol: " + e.getMessage());
                }
            }
        }
    }

    private void processIndirectSymbols() throws Exception {
        this.monitor.setMessage("Processing indirect symbols...");
        SymbolTableCommand symbolTableCommand = this.machoHeader.getFirstLoadCommand(SymbolTableCommand.class);
        DynamicSymbolTableCommand dynamicCommand = this.machoHeader.getFirstLoadCommand(DynamicSymbolTableCommand.class);
        if (dynamicCommand == null) {
            return;
        }
        int[] indirectSymbols = dynamicCommand.getIndirectSymbols();
        if (indirectSymbols.length == 0) {
            return;
        }
        int[] sectionTypes = new int[]{6, 7, 8};
        List<Section> sections = this.getSectionsWithTypes(sectionTypes);
        for (Section section : sections) {
            if (this.monitor.isCancelled()) {
                return;
            }
            if (section.getSize() == 0L) continue;
            Namespace namespace = this.createNamespaceForSection(section);
            int indirectSymbolTableIndex = section.getReserved1();
            int symbolSize = this.machoHeader.getAddressSize();
            if (section.getType() == 8) {
                symbolSize = section.getReserved2();
            }
            int nSymbols = (int)section.getSize() / symbolSize;
            Address startAddr = this.space.getAddress(section.getAddress());
            for (int i = indirectSymbolTableIndex; i < indirectSymbolTableIndex + nSymbols && !this.monitor.isCancelled(); ++i) {
                String name;
                int symbolIndex = indirectSymbols[i];
                NList symbol = symbolTableCommand.getSymbolAt(symbolIndex);
                if (symbol != null && (name = this.generateValidName(symbol.getString())) != null && name.length() > 0) {
                    try {
                        this.program.getSymbolTable().createLabel(startAddr, name, namespace, SourceType.IMPORTED);
                    }
                    catch (Exception e) {
                        this.log.appendMsg("Unable to create indirect symbol " + name);
                        this.log.appendException((Throwable)e);
                    }
                }
                startAddr = startAddr.add((long)symbolSize);
            }
        }
    }

    private void setRelocatableProperty() {
        Options props = this.program.getOptions("Program Information");
        switch (this.machoHeader.getFileType()) {
            case 2: {
                props.setBoolean("Relocatable", false);
                break;
            }
            default: {
                props.setBoolean("Relocatable", true);
            }
        }
    }

    private void processLibraries() {
        this.monitor.setMessage("Processing libraries...");
        List<LoadCommand> commands = this.machoHeader.getLoadCommands();
        for (LoadCommand command : commands) {
            if (this.monitor.isCancelled()) {
                return;
            }
            if (command instanceof DynamicLibraryCommand) {
                DynamicLibraryCommand dylibCommand = (DynamicLibraryCommand)command;
                DynamicLibrary dylib = dylibCommand.getDynamicLibrary();
                this.addLibrary(dylib.getName().getString());
                continue;
            }
            if (command instanceof SubLibraryCommand) {
                SubLibraryCommand sublibCommand = (SubLibraryCommand)command;
                this.addLibrary(sublibCommand.getSubLibraryName().getString());
                continue;
            }
            if (!(command instanceof PreboundDynamicLibraryCommand)) continue;
            PreboundDynamicLibraryCommand pbdlCommand = (PreboundDynamicLibraryCommand)command;
            this.addLibrary(pbdlCommand.getLibraryName());
        }
    }

    private void processProgramDescription() {
        Options props = this.program.getOptions("Program Information");
        props.setString("Mach-O File Type", MachHeaderFileTypes.getFileTypeName(this.machoHeader.getFileType()));
        props.setString("Mach-O File Type Description", MachHeaderFileTypes.getFileTypeDescription(this.machoHeader.getFileType()));
        List<String> flags = MachHeaderFlags.getFlags(this.machoHeader.getFlags());
        for (int i = 0; i < flags.size(); ++i) {
            props.setString("Mach-O Flag " + i, flags.get(i));
        }
        List<SubUmbrellaCommand> umbrellas = this.machoHeader.getLoadCommands(SubUmbrellaCommand.class);
        for (int i = 0; i < umbrellas.size(); ++i) {
            props.setString("Mach-O Sub-umbrella " + i, umbrellas.get(i).getSubUmbrellaFrameworkName().getString());
        }
        List<SubFrameworkCommand> frameworks = this.machoHeader.getLoadCommands(SubFrameworkCommand.class);
        for (int i = 0; i < frameworks.size(); ++i) {
            props.setString("Mach-O Sub-framework " + i, frameworks.get(i).getUmbrellaFrameworkName().getString());
        }
    }

    protected void renameObjMsgSendRtpSymbol() throws DuplicateNameException, InvalidInputException {
        Address address = this.space.getAddress(0xFFFEFF00L);
        Symbol symbol = this.program.getSymbolTable().getPrimarySymbol(address);
        if (symbol != null && symbol.isDynamic()) {
            symbol.setName("_objc_msgSend_rtp", SourceType.IMPORTED);
        } else {
            this.program.getSymbolTable().createLabel(address, "_objc_msgSend_rtp", SourceType.IMPORTED);
        }
    }

    private void processUndefinedSymbols() throws Exception {
        this.monitor.setMessage("Processing undefined symbols...");
        ArrayList<NList> undefinedSymbols = new ArrayList<NList>();
        List<LoadCommand> commands = this.machoHeader.getLoadCommands();
        for (LoadCommand command : commands) {
            if (this.monitor.isCancelled()) {
                return;
            }
            if (!(command instanceof SymbolTableCommand)) continue;
            SymbolTableCommand symbolTableCommand = (SymbolTableCommand)command;
            List<NList> symbols = symbolTableCommand.getSymbols();
            for (NList symbol : symbols) {
                List globalSymbols;
                if (this.monitor.isCancelled()) {
                    return;
                }
                if (symbol.isSymbolicDebugging() || !symbol.isTypeUndefined() || !(globalSymbols = this.program.getSymbolTable().getLabelOrFunctionSymbols(symbol.getString(), null)).isEmpty()) continue;
                undefinedSymbols.add(symbol);
            }
        }
        if (undefinedSymbols.size() == 0) {
            return;
        }
        Address start = this.getAddress();
        try {
            MemoryBlock block = this.memory.createUninitializedBlock("EXTERNAL", start, (long)(undefinedSymbols.size() * this.machoHeader.getAddressSize()), false);
            block.setWrite(true);
            block.setSourceName(BLOCK_SOURCE_NAME);
            block.setComment("NOTE: This block is artificial and is used to make relocations work correctly");
        }
        catch (Exception e) {
            this.log.appendMsg("Unable to create undefined memory block: " + e.getMessage());
        }
        for (NList symbol : undefinedSymbols) {
            if (this.monitor.isCancelled()) {
                return;
            }
            try {
                String name = this.generateValidName(symbol.getString());
                if (name != null && name.length() > 0) {
                    this.program.getSymbolTable().createLabel(start, name, SourceType.IMPORTED);
                }
            }
            catch (Exception e) {
                this.log.appendMsg("Unable to create undefined symbol: " + e.getMessage());
            }
            start = start.add((long)this.machoHeader.getAddressSize());
        }
    }

    private void processAbsoluteSymbols() throws Exception {
        this.monitor.setMessage("Processing absolute symbols...");
        ArrayList<NList> absoluteSymbols = new ArrayList<NList>();
        List<LoadCommand> commands = this.machoHeader.getLoadCommands();
        for (LoadCommand command : commands) {
            if (this.monitor.isCancelled()) {
                return;
            }
            if (!(command instanceof SymbolTableCommand)) continue;
            SymbolTableCommand symbolTableCommand = (SymbolTableCommand)command;
            List<NList> symbols = symbolTableCommand.getSymbols();
            for (NList symbol : symbols) {
                if (this.monitor.isCancelled()) {
                    return;
                }
                if (symbol.isSymbolicDebugging() || !symbol.isTypeAbsolute()) continue;
                absoluteSymbols.add(symbol);
            }
        }
        if (absoluteSymbols.size() == 0) {
            return;
        }
        Address start = this.getAddress();
        try {
            this.memory.createUninitializedBlock("ABSOLUTE", start, (long)(absoluteSymbols.size() * this.machoHeader.getAddressSize()), false);
        }
        catch (Exception e) {
            this.log.appendMsg("Unable to create absolute memory block: " + e.getMessage());
        }
        for (NList symbol : absoluteSymbols) {
            try {
                String name = this.generateValidName(symbol.getString());
                if (name != null && name.length() > 0) {
                    this.program.getSymbolTable().createLabel(start, name, SourceType.IMPORTED);
                }
            }
            catch (Exception e) {
                this.log.appendMsg("Unable to create absolute symbol: " + e.getMessage());
            }
            start = start.add((long)this.machoHeader.getAddressSize());
        }
    }

    private void processDyldInfo() {
        List<DyldInfoCommand> commands = this.machoHeader.getLoadCommands(DyldInfoCommand.class);
        for (DyldInfoCommand command : commands) {
            if (command.getBindSize() <= 0) continue;
            BindProcessor processor = new BindProcessor(this.program, this.machoHeader, this.provider, command);
            try {
                processor.process(this.monitor);
            }
            catch (Exception e) {
                this.log.appendMsg(e.getMessage());
            }
        }
        if (commands.size() == 0) {
            ClassicBindProcessor classicBindProcess = new ClassicBindProcessor(this.machoHeader, this.program);
            try {
                classicBindProcess.process(this.monitor);
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
            }
            ClassicLazyBindProcessor classicLazyBindProcess = new ClassicLazyBindProcessor(this.machoHeader, this.program);
            try {
                classicLazyBindProcess.process(this.monitor);
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
            }
        }
    }

    protected void markupHeaders(MachHeader header, Address headerAddr) throws Exception {
        this.monitor.setMessage("Processing header markup...");
        if (headerAddr == null) {
            return;
        }
        try {
            DataUtilities.createData((Program)this.program, (Address)headerAddr, (DataType)header.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            for (LoadCommand loadCommand : header.getLoadCommands()) {
                if (this.monitor.isCancelled()) break;
                Address loadCommandAddr = headerAddr.add(loadCommand.getStartIndex() - header.getStartIndexInProvider());
                DataType loadCommandDataType = loadCommand.toDataType();
                DataUtilities.createData((Program)this.program, (Address)loadCommandAddr, (DataType)loadCommandDataType, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                if (loadCommand instanceof SegmentCommand) {
                    SegmentCommand segmentCommand = (SegmentCommand)loadCommand;
                    this.listing.setComment(loadCommandAddr, 0, segmentCommand.getSegmentName());
                    int sectionOffset = loadCommandDataType.getLength();
                    for (Section section : segmentCommand.getSections()) {
                        DataType sectionDataType = section.toDataType();
                        Address sectionAddr = loadCommandAddr.add((long)sectionOffset);
                        DataUtilities.createData((Program)this.program, (Address)sectionAddr, (DataType)sectionDataType, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                        this.listing.setComment(sectionAddr, 0, section.getSegmentName() + "." + section.getSectionName());
                        sectionOffset += sectionDataType.getLength();
                    }
                    continue;
                }
                if (loadCommand instanceof DynamicLinkerCommand) {
                    DynamicLinkerCommand dynamicLinkerCommand = (DynamicLinkerCommand)loadCommand;
                    LoadCommandString name = dynamicLinkerCommand.getLoadCommandString();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof DynamicLibraryCommand) {
                    DynamicLibraryCommand dynamicLibraryCommand = (DynamicLibraryCommand)loadCommand;
                    LoadCommandString name = dynamicLibraryCommand.getDynamicLibrary().getName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof RunPathCommand) {
                    RunPathCommand runPathCommand = (RunPathCommand)loadCommand;
                    LoadCommandString path = runPathCommand.getPath();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)path.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - path.getOffset()), (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof SubFrameworkCommand) {
                    SubFrameworkCommand subFrameworkCommand = (SubFrameworkCommand)loadCommand;
                    LoadCommandString name = subFrameworkCommand.getUmbrellaFrameworkName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof SubClientCommand) {
                    SubClientCommand subClientCommand = (SubClientCommand)loadCommand;
                    LoadCommandString name = subClientCommand.getClientName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof SubLibraryCommand) {
                    SubLibraryCommand subLibraryCommand = (SubLibraryCommand)loadCommand;
                    LoadCommandString name = subLibraryCommand.getSubLibraryName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (!(loadCommand instanceof SubUmbrellaCommand)) continue;
                SubUmbrellaCommand subUmbrellaCommand = (SubUmbrellaCommand)loadCommand;
                LoadCommandString name = subUmbrellaCommand.getSubUmbrellaFrameworkName();
                DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
        }
        catch (CodeUnitInsertionException e) {
            this.log.appendMsg("Error laying down header structures " + e);
        }
    }

    private void markupSections() throws Exception {
        this.monitor.setMessage("Processing section markup...");
        if (this.machoHeader.getFileType() == 9) {
            return;
        }
        block0: for (SegmentCommand segment : this.machoHeader.getAllSegments()) {
            if (this.monitor.isCancelled()) break;
            if (segment.isAppleProtected()) {
                String msg = "Warning:  " + this.program.getName() + " contains encrypted segment: " + segment.getSegmentName();
                this.log.appendMsg(msg);
                Msg.showWarn((Object)this, null, (String)"Encrypted Binary", (Object)msg);
                continue;
            }
            List<Section> sections = segment.getSections();
            for (Section section : sections) {
                MemoryBlock block;
                if (this.monitor.isCancelled()) continue block0;
                if (section.getSize() == 0L || (block = this.getMemoryBlock(section)) == null) continue;
                if (section.getType() == 2) {
                    this.markupBlock(block, (DataType)new TerminatedStringDataType());
                } else if (section.getType() == 3) {
                    this.markupBlock(block, (DataType)new FloatDataType());
                } else if (section.getType() == 4) {
                    this.markupBlock(block, (DataType)new DoubleDataType());
                } else if (section.getType() == 5) {
                    this.markupBlock(block, (DataType)new PointerDataType());
                } else if (section.getType() == 6 || section.getType() == 7) {
                    this.markupBlock(block, (DataType)new PointerDataType());
                } else if (section.getType() != 8 || section.isExecute()) {
                    // empty if block
                }
                if (section.getType() != 7) continue;
                AddressSet set = new AddressSet(block.getStart(), block.getEnd());
                this.processLazyPointerSection((AddressSetView)set);
            }
        }
    }

    private void processProgramVars() {
        if (this.program.getLanguage().getProcessor() == Processor.findOrPossiblyCreateProcessor((String)"PowerPC")) {
            return;
        }
        SymbolTable symbolTable = this.program.getSymbolTable();
        int defaultPointerSize = this.program.getDefaultPointerSize();
        QWordDataType intDataType = defaultPointerSize == 8 ? new QWordDataType() : new DWordDataType();
        Pointer intPointerDataType = PointerDataType.getPointer((DataType)intDataType, (int)defaultPointerSize);
        Pointer voidPointerDatatype = PointerDataType.getPointer((DataType)new VoidDataType(), (int)defaultPointerSize);
        Pointer charPointerX1DataType = PointerDataType.getPointer((DataType)new CharDataType(), (int)defaultPointerSize);
        Pointer charPointerX2DataType = PointerDataType.getPointer((DataType)charPointerX1DataType, (int)defaultPointerSize);
        Pointer charPointerX3DataType = PointerDataType.getPointer((DataType)charPointerX2DataType, (int)defaultPointerSize);
        StructureDataType structure = new StructureDataType("__program_vars", 0);
        structure.add((DataType)voidPointerDatatype, "mh", "pointer to __mh_execute_header");
        structure.add((DataType)intPointerDataType, "NXArgcPtr", "pointer to argc");
        structure.add((DataType)charPointerX3DataType, "NXArgvPtr", "pointer to argv");
        structure.add((DataType)charPointerX3DataType, "environPtr", "pointer to environment");
        structure.add((DataType)charPointerX2DataType, "__prognamePtr", "pointer to program name");
        Namespace namespace = this.createNamespace("__program_vars");
        List<Section> sections = this.machoHeader.getAllSections();
        for (Section section : sections) {
            if (!section.getSectionName().equals("__program_vars")) continue;
            MemoryBlock memoryBlock = this.getMemoryBlock(section);
            try {
                this.listing.createData(memoryBlock.getStart(), (DataType)structure);
                Data data = this.listing.getDataAt(memoryBlock.getStart());
                Data mhData = data.getComponent(0);
                if (symbolTable.getSymbol("__mh_execute_header", mhData.getAddress(0), namespace) == null) {
                    symbolTable.createLabel(mhData.getAddress(0), "__mh_execute_header", namespace, SourceType.IMPORTED);
                }
                Data argcData = data.getComponent(1);
                symbolTable.createLabel(argcData.getAddress(0), "NXArgc", namespace, SourceType.IMPORTED);
                this.listing.createData(argcData.getAddress(0), (DataType)intDataType);
                Data argvData = data.getComponent(2);
                symbolTable.createLabel(argvData.getAddress(0), "NXArgv", namespace, SourceType.IMPORTED);
                this.listing.createData(argvData.getAddress(0), (DataType)charPointerX2DataType);
                Data environData = data.getComponent(3);
                symbolTable.createLabel(environData.getAddress(0), "environ", namespace, SourceType.IMPORTED);
                this.listing.createData(environData.getAddress(0), (DataType)charPointerX2DataType);
                Data prognameData = data.getComponent(4);
                symbolTable.createLabel(prognameData.getAddress(0), "__progname", namespace, SourceType.IMPORTED);
                this.listing.createData(prognameData.getAddress(0), (DataType)charPointerX1DataType);
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSectionRelocations() {
        this.monitor.setMessage("Processing relocation table...");
        List<Section> sections = this.machoHeader.getAllSections();
        Iterator<Section> iterator = sections.iterator();
        block2: while (iterator.hasNext()) {
            Section section = iterator.next();
            if (this.monitor.isCancelled()) {
                return;
            }
            List<RelocationInfo> relocations = section.getRelocations();
            Iterator<RelocationInfo> iterator2 = relocations.iterator();
            while (true) {
                boolean handled;
                RelocationInfo relocation;
                block11: {
                    if (!iterator2.hasNext()) continue block2;
                    relocation = iterator2.next();
                    if (this.monitor.isCancelled()) {
                        return;
                    }
                    handled = false;
                    try {
                        if (this.machoHeader.getCpuType() == 7 || this.machoHeader.getCpuType() == 0x1000007) {
                            this.processSectionRelocation_x86(section, relocation);
                            handled = true;
                            break block11;
                        }
                        if (this.machoHeader.getCpuType() == 18) {
                            handled = true;
                        } else if (this.machoHeader.getCpuType() != 12) {
                            // empty if block
                        }
                    }
                    catch (Exception e) {
                        this.log.appendMsg("Error loading section relocations: " + e.getMessage());
                    }
                }
                this.addToRelocationTable(section, relocation, handled);
            }
            break;
        }
        return;
    }

    private void loadExternalRelocations() {
        this.monitor.setMessage("Processing external relocations...");
        List<DynamicSymbolTableCommand> commands = this.machoHeader.getLoadCommands(DynamicSymbolTableCommand.class);
        block0: for (DynamicSymbolTableCommand command : commands) {
            if (this.monitor.isCancelled()) break;
            List<RelocationInfo> relocs = command.getExternalRelocations();
            for (RelocationInfo reloc : relocs) {
                if (this.monitor.isCancelled()) continue block0;
                this.loadRelocation(3003, reloc);
            }
        }
    }

    private void loadLocalRelocations() {
        this.monitor.setMessage("Processing local relocations...");
        List<DynamicSymbolTableCommand> commands = this.machoHeader.getLoadCommands(DynamicSymbolTableCommand.class);
        for (DynamicSymbolTableCommand command : commands) {
            if (this.monitor.isCancelled()) {
                return;
            }
            List<RelocationInfo> relocs = command.getLocalRelocations();
            for (RelocationInfo reloc : relocs) {
                if (this.monitor.isCancelled()) {
                    return;
                }
                this.loadRelocation(3276, reloc);
            }
        }
    }

    private Address getRelocationBaseAddress() {
        List<SegmentCommand> segments = this.machoHeader.getAllSegments();
        if (segments.isEmpty()) {
            return this.space.getAddress(-1L);
        }
        long relocBase = segments.get(0).getVMaddress();
        if ((this.machoHeader.getFlags() & 0x20) != 0) {
            for (SegmentCommand segment : segments) {
                if (this.monitor.isCancelled()) {
                    return this.space.getAddress(-1L);
                }
                if (!segment.isRead() || !segment.isWrite()) continue;
                relocBase = segment.getVMaddress();
                break;
            }
        }
        return this.space.getAddress(relocBase);
    }

    private void loadRelocation(int relocationType, RelocationInfo relocation) {
        Address baseAddr = this.getRelocationBaseAddress();
        Address relocationAddress = null;
        try {
            relocationAddress = baseAddr.add((long)relocation.getAddress() & 0xFFFFFFFFL);
        }
        catch (AddressOutOfBoundsException e) {
            relocationAddress = baseAddr.getNewAddress((long)relocation.getAddress() & 0xFFFFFFFFL);
        }
        byte[] originalRelocationBytes = this.getOriginalRelocationBytes(relocation, relocationAddress);
        this.program.getRelocationTable().add(relocationAddress, relocationType, relocation.toValues(), originalRelocationBytes, null);
    }

    private void addLibrary(String library) {
        library = library.replaceAll(" ", "_");
        try {
            this.program.getExternalManager().addExternalLibraryName(library, SourceType.IMPORTED);
        }
        catch (DuplicateNameException duplicateNameException) {
        }
        catch (Exception e) {
            this.log.appendMsg("Unable to add external library name: " + e.getMessage());
        }
    }

    private Address getAddress() {
        Address maxAddress = this.program.getMaxAddress();
        if (maxAddress == null) {
            return this.space.getAddress(4096L);
        }
        long maxAddr = maxAddress.getOffset();
        long remainder = maxAddr % 4096L;
        return maxAddress.getNewAddress(maxAddr + 4096L - remainder);
    }

    private MemoryBlock getMemoryBlock(Section section) {
        Address blockAddress = this.space.getAddress(section.getAddress());
        return this.memory.getBlock(blockAddress);
    }

    private void markupBlock(MemoryBlock block, DataType datatype) throws Exception {
        Address address = block.getStart();
        while (!this.monitor.isCancelled() && address.compareTo((Object)block.getEnd()) <= 0) {
            int length;
            try {
                this.listing.createData(address, datatype);
                length = this.listing.getDataAt(address).getLength();
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
                return;
            }
            if (datatype instanceof Pointer) {
                this.fixupThumbPointers(address);
            }
            address = address.add((long)length);
        }
    }

    private void fixupThumbPointers(Address address) throws AddressOverflowException {
        Data data = this.listing.getDefinedDataAt(address);
        if (data == null) {
            return;
        }
        Object value = data.getValue();
        if (!(value instanceof Address)) {
            return;
        }
        Address pointerAddress = (Address)value;
        if (pointerAddress.getOffset() % 2L == 0L) {
            return;
        }
        MemoryBlock pointerBlock = this.memory.getBlock(pointerAddress);
        if (pointerBlock == null) {
            return;
        }
        if (!pointerBlock.isExecute()) {
            return;
        }
        Reference[] refs = data.getReferencesFrom();
        ReferenceManager referenceManager = this.program.getReferenceManager();
        for (Reference ref : refs) {
            if (this.monitor.isCancelled()) break;
            if (!ref.getToAddress().equals((Object)pointerAddress)) continue;
            referenceManager.delete(ref);
            Address thumbAddress = ref.getToAddress().subtract(1L);
            referenceManager.addMemoryReference(ref.getFromAddress(), thumbAddress, ref.getReferenceType(), ref.getSource(), ref.getOperandIndex());
            try {
                this.markAsThumb(thumbAddress);
            }
            catch (ContextChangeException contextChangeException) {
                // empty catch block
            }
        }
    }

    private void markAsThumb(Address address) throws ContextChangeException, AddressOverflowException {
        if (!this.program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)"ARM"))) {
            return;
        }
        if ((address.getOffset() & 1L) == 1L) {
            address = address.subtractNoWrap(1L);
        }
        Register tModeRegister = this.program.getLanguage().getRegister("TMode");
        this.program.getProgramContext().setValue(tModeRegister, address, address, BigInteger.ONE);
        this.createOneByteFunction(null, address);
    }

    private void processLazyPointerSection(AddressSetView set) {
        DataIterator dataIterator = this.listing.getData(set, true);
        block2: while (dataIterator.hasNext() && !this.monitor.isCancelled()) {
            Reference[] references;
            Data data = dataIterator.next();
            for (Reference reference : references = data.getReferencesFrom()) {
                if (this.monitor.isCancelled()) continue block2;
                Symbol fromSymbol = this.program.getSymbolTable().getPrimarySymbol(reference.getFromAddress());
                try {
                    MemoryBlock memoryBlock = this.memory.getBlock(reference.getToAddress());
                    Namespace namespace = this.createNamespace(memoryBlock.getName());
                    this.program.getSymbolTable().createLabel(reference.getToAddress(), fromSymbol.getName(), namespace, SourceType.IMPORTED);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private Namespace createNamespaceForSection(Section section) {
        return this.createNamespace(section.getSectionName());
    }

    private Namespace createNamespace(String namespaceName) {
        try {
            return this.program.getSymbolTable().createNameSpace(this.program.getGlobalNamespace(), namespaceName, SourceType.IMPORTED);
        }
        catch (DuplicateNameException | InvalidInputException e) {
            Namespace namespace = this.program.getSymbolTable().getNamespace(namespaceName, this.program.getGlobalNamespace());
            if (namespace != null) {
                return namespace;
            }
            this.log.appendMsg("Unable to create namespace: " + namespaceName);
            this.log.appendException(e);
            return this.program.getGlobalNamespace();
        }
    }

    private String generateValidName(String name) {
        return SymbolUtilities.replaceInvalidChars((String)name, (boolean)true);
    }

    private List<Section> getSectionsWithTypes(int[] sectionTypes) {
        ArrayList<Section> list = new ArrayList<Section>();
        List<Section> sections = this.machoHeader.getAllSections();
        block0: for (Section section : sections) {
            if (this.monitor.isCancelled()) break;
            for (int sectionType : sectionTypes) {
                if (this.monitor.isCancelled()) continue block0;
                if (section.getType() != sectionType) continue;
                list.add(section);
            }
        }
        return list;
    }

    void createOneByteFunction(String name, Address address) {
        FunctionManager functionMgr = this.program.getFunctionManager();
        if (functionMgr.getFunctionAt(address) != null) {
            return;
        }
        try {
            functionMgr.createFunction(name, address, (AddressSetView)new AddressSet(address), SourceType.IMPORTED);
        }
        catch (InvalidInputException invalidInputException) {
        }
        catch (OverlappingFunctionException overlappingFunctionException) {
            // empty catch block
        }
    }

    private void processSectionRelocation_x86(Section relocationSection, RelocationInfo relocation) {
        DataConverter dc = this.getDataConverter();
        MemoryBlock memoryBlock = this.getMemoryBlock(relocationSection);
        Address relocationAddress = memoryBlock.getStart().add((long)relocation.getAddress());
        int relocationSize = (int)Math.pow(2.0, Math.min(2, relocation.getLength()));
        Address destinationAddress = memoryBlock.getStart().getNewAddress(0L);
        byte[] originalRelocationBytes = this.getOriginalRelocationBytes(relocation, relocationAddress);
        if (relocation instanceof ScatteredRelocationInfo) {
            Address relocationBase = this.getRelocationBaseAddress();
            relocationAddress = relocationBase.add((long)relocation.getAddress());
        } else if (relocation.isExternal()) {
            int symbolIndex = relocation.getSymbolIndex();
            NList nList = this.machoHeader.getFirstLoadCommand(SymbolTableCommand.class).getSymbolAt(symbolIndex);
            Symbol symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)this.program, (String)nList.getString(), err -> this.log.error("Macho", err));
            if (relocation.isPcRelocated()) {
                destinationAddress = symbol.getAddress().subtractWrap(relocationAddress.getOffset()).subtractWrap(4L);
                if (this.machoHeader.getCpuType() == 0x1000007) {
                    destinationAddress = destinationAddress.add((long)dc.getInt(originalRelocationBytes));
                }
            } else {
                destinationAddress = symbol.getAddress();
            }
        } else {
            int originalRelocationValue = dc.getInt(originalRelocationBytes);
            int sectionIndex = relocation.getSymbolIndex();
            Section section = this.machoHeader.getAllSections().get(sectionIndex - 1);
            long difference = (long)originalRelocationValue - section.getAddress();
            destinationAddress = this.space.getAddress(section.getAddress() + difference);
        }
        byte[] destinationBytes = new byte[originalRelocationBytes.length];
        try {
            dc.getBytes((int)destinationAddress.getOffset(), destinationBytes);
            this.memory.setBytes(relocationAddress, destinationBytes, 0, relocationSize);
        }
        catch (Exception e) {
            this.log.appendMsg("Unable to process relocation at " + relocationAddress + ": " + e.getMessage());
        }
    }

    private DataConverter getDataConverter() {
        DataConverter dc = DataConverter.getInstance((boolean)this.program.getLanguage().isBigEndian());
        return dc;
    }

    private void addToRelocationTable(Section relocationSection, RelocationInfo relocation, boolean handled) {
        MemoryBlock memoryBlock = this.getMemoryBlock(relocationSection);
        Address relocationAddress = memoryBlock.getStart().add((long)relocation.getAddress());
        byte[] originalRelocationBytes = this.getOriginalRelocationBytes(relocation, relocationAddress);
        this.program.getRelocationTable().add(relocationAddress, 2730, relocation.toValues(), originalRelocationBytes, null);
        if (!handled) {
            BookmarkManager bookmarkManager = this.program.getBookmarkManager();
            bookmarkManager.setBookmark(relocationAddress, "Error", "Relocations", "Unhandled relocation");
        }
    }

    private byte[] getOriginalRelocationBytes(RelocationInfo relocation, Address relocationAddress) {
        int relocationSize = (int)Math.pow(2.0, Math.min(2, relocation.getLength()));
        byte[] originalRelocationBytes = new byte[relocationSize];
        try {
            this.memory.getBytes(relocationAddress, originalRelocationBytes);
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return originalRelocationBytes;
    }
}

