/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcode;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeAttributedString;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.template.ConstTpl;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.plugin.processors.sleigh.template.VarnodeTpl;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import java.awt.Color;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PcodeFormatter {
    private static String EOL = System.getProperty("line.separator");
    private int maxDisplayLines = 0;
    private boolean displayRawPcode = false;
    private FontMetrics metrics;
    private Color addressColor = OptionsGui.ADDRESS.getDefaultColor();
    private Color registerColor = OptionsGui.REGISTERS.getDefaultColor();
    private Color scalarColor = OptionsGui.CONSTANT.getDefaultColor();
    private Color localColor = OptionsGui.LABELS_LOCAL.getDefaultColor();
    AttributedString SPACE;
    AttributedString EQUALS;
    AttributedString COMMA;
    AttributedString LEFT_PAREN;
    AttributedString RIGHT_PAREN;
    AttributedString LEFT_BRACKET;
    AttributedString RIGHT_BRACKET;
    AttributedString STAR;
    AttributedString COLON;
    AttributedString QUOTE;

    public PcodeFormatter() {
        this.initPunctuation();
    }

    public void setColor(Color addressColor, Color registerColor, Color scalarColor, Color localColor) {
        this.addressColor = addressColor;
        this.registerColor = registerColor;
        this.scalarColor = scalarColor;
        this.localColor = localColor;
    }

    public void setFontMetrics(FontMetrics metrics) {
        this.metrics = metrics;
        this.initPunctuation();
    }

    public void setOptions(int maxDisplayLines, boolean displayRawPcode) {
        this.maxDisplayLines = maxDisplayLines;
        this.displayRawPcode = displayRawPcode;
    }

    private void initPunctuation() {
        this.SPACE = new AttributedString(" ", Color.BLUE, this.metrics);
        this.EQUALS = new AttributedString(" = ", Color.BLUE, this.metrics);
        this.COMMA = new AttributedString(",", Color.BLUE, this.metrics);
        this.LEFT_PAREN = new AttributedString("(", Color.BLUE, this.metrics);
        this.RIGHT_PAREN = new AttributedString(")", Color.BLUE, this.metrics);
        this.LEFT_BRACKET = new AttributedString("[", Color.BLUE, this.metrics);
        this.RIGHT_BRACKET = new AttributedString("]", Color.BLUE, this.metrics);
        this.STAR = new AttributedString("*", Color.BLUE, this.metrics);
        this.COLON = new AttributedString(":", Color.BLUE, this.metrics);
        this.QUOTE = new AttributedString("\"", Color.BLUE, this.metrics);
    }

    public String toString(Program program, PcodeOp[] pcodeOps) {
        return this.toString(program, this.getPcodeOpTemplates(program.getAddressFactory(), pcodeOps));
    }

    public List<AttributedString> toAttributedStrings(Program program, PcodeOp[] pcodeOps) {
        return this.toAttributedStrings(program, this.getPcodeOpTemplates(program.getAddressFactory(), pcodeOps));
    }

    public String toString(Program program, OpTpl[] pcodeOpTemplates) {
        boolean indent = this.hasLabel(pcodeOpTemplates);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < pcodeOpTemplates.length && (this.maxDisplayLines <= 0 || i < this.maxDisplayLines); ++i) {
            AttributedString line = this.formatOpTpl(program, pcodeOpTemplates[i], indent);
            if (buf.length() != 0) {
                buf.append(EOL);
            }
            buf.append(line.toString());
        }
        return buf.toString();
    }

    public List<AttributedString> toAttributedStrings(Program program, OpTpl[] pcodeOpTemplates) {
        boolean indent = this.hasLabel(pcodeOpTemplates);
        ArrayList<AttributedString> list = new ArrayList<AttributedString>();
        for (int i = 0; i < pcodeOpTemplates.length && (this.maxDisplayLines <= 0 || i < this.maxDisplayLines); ++i) {
            list.add(this.formatOpTpl(program, pcodeOpTemplates[i], indent));
        }
        return list;
    }

    private AttributedString formatOpTpl(Program program, OpTpl op, boolean indent) {
        ArrayList<AttributedString> lineList = new ArrayList<AttributedString>();
        int opcode = op.getOpcode();
        if (65 == opcode) {
            String label = "<" + op.getInput()[0].getOffset().getReal() + ">";
            lineList.add(new AttributedString(label, Color.BLUE, this.metrics));
            return new CompositeAttributedString(lineList);
        }
        if (indent) {
            lineList.add(this.SPACE);
            lineList.add(this.SPACE);
        }
        if (opcode >= 73) {
            throw new RuntimeException("Unsupported opcode encountered: " + opcode);
        }
        VarnodeTpl output = op.getOutput();
        if (output != null) {
            this.formatVarnodeTpl(program, opcode, -1, output, lineList);
            lineList.add(this.EQUALS);
        }
        Color color = opcode == 0 ? Color.RED : Color.BLUE.darker();
        lineList.add(new AttributedString(PcodeOp.getMnemonic((int)opcode), color, this.metrics));
        VarnodeTpl[] inputs = op.getInput();
        for (int i = 0; i < inputs.length; ++i) {
            if (i > 0) {
                lineList.add(this.COMMA);
            }
            lineList.add(this.SPACE);
            if (i == 0) {
                if (!this.displayRawPcode) {
                    if (opcode == 2 || opcode == 3) {
                        this.formatMemoryInput(program, inputs[0], inputs[1], lineList);
                        ++i;
                        continue;
                    }
                    if (opcode == 9) {
                        this.formatCallOtherName(program.getLanguage(), inputs[0], lineList);
                        continue;
                    }
                }
                if ((opcode == 4 || opcode == 5) && this.formatLabelInput(inputs[i], lineList)) continue;
            }
            this.formatVarnodeTpl(program, opcode, i, inputs[i], lineList);
        }
        return new CompositeAttributedString(lineList);
    }

    private void formatVarnodeTpl(Program program, int opcode, int opIndex, VarnodeTpl vTpl, List<AttributedString> lineList) {
        ConstTpl space = vTpl.getSpace();
        ConstTpl offset = vTpl.getOffset();
        ConstTpl size = vTpl.getSize();
        if (space.getType() == 4) {
            if (offset.getType() == 2) {
                lineList.add(new AttributedString("inst_start", this.localColor, this.metrics));
            } else if (offset.getType() == 3) {
                lineList.add(new AttributedString("inst_next", this.localColor, this.metrics));
            } else {
                this.formatAddress(program, null, offset, size, lineList);
            }
        } else if (space.getType() == 6) {
            if (this.displayRawPcode && offset.getType() == 0 && size.getType() == 0) {
                this.formatRaw(space.getSpaceId(), offset, size, lineList);
            } else if (space.isConstSpace()) {
                this.formatConstant(offset, size, lineList);
            } else if (space.isUniqueSpace()) {
                this.formatUnique(offset, size, lineList);
            } else {
                this.formatAddress(program, space.getSpaceId(), offset, size, lineList);
            }
        } else {
            throw new RuntimeException("Unsupported space template type: " + space.getType());
        }
    }

    private void formatRaw(AddressSpace space, ConstTpl offset, ConstTpl size, List<AttributedString> lineList) {
        String str = "(" + space.getName() + ", 0x" + Long.toHexString(offset.getReal()) + ", " + size.getReal() + ")";
        lineList.add(new AttributedString(str, Color.BLUE, this.metrics));
    }

    private void formatUnique(ConstTpl offset, ConstTpl size, List<AttributedString> lineList) {
        if (offset.getType() != 0) {
            throw new RuntimeException("Unsupported unique offset type: " + offset.getType());
        }
        if (size.getType() != 0) {
            throw new RuntimeException("Unsupported unique size type: " + size.getType());
        }
        lineList.add(new AttributedString("$U" + Long.toHexString(offset.getReal()), this.localColor, this.metrics));
        this.formatSize(size, lineList);
    }

    private void formatAddress(Program program, AddressSpace addrSpace, ConstTpl offset, ConstTpl size, List<AttributedString> lineList) {
        if (offset.getType() != 0) {
            throw new RuntimeException("Unsupported address offset type: " + offset.getType());
        }
        long offsetValue = offset.getReal();
        if (addrSpace == null) {
            lineList.add(this.STAR);
            lineList.add(new AttributedString("0x" + Long.toHexString(offsetValue), this.addressColor, this.metrics));
            if (size.getType() != 5) {
                this.formatSize(size, lineList);
            }
            return;
        }
        int sizeValue = (int)size.getReal();
        Register reg = program.getRegister(addrSpace.getAddress(offsetValue), sizeValue);
        if (reg != null) {
            lineList.add(new AttributedString(reg.getName(), this.registerColor, this.metrics));
            if (reg.getMinimumByteSize() > sizeValue) {
                lineList.add(this.COLON);
                lineList.add(new AttributedString(Integer.toString(sizeValue), this.scalarColor, this.metrics));
            }
            return;
        }
        lineList.add(this.STAR);
        lineList.add(this.LEFT_BRACKET);
        lineList.add(new AttributedString(addrSpace.getName(), Color.BLUE, this.metrics));
        lineList.add(this.RIGHT_BRACKET);
        long wordOffset = offsetValue / (long)addrSpace.getAddressableUnitSize();
        long offcut = offsetValue % (long)addrSpace.getAddressableUnitSize();
        String str = "0x" + Long.toHexString(wordOffset);
        if (offcut != 0L) {
            str = str + "." + offset;
        }
        lineList.add(new AttributedString(str, this.addressColor, this.metrics));
        this.formatSize(size, lineList);
    }

    private void formatConstant(ConstTpl offset, ConstTpl size, List<AttributedString> lineList) {
        if (offset.getType() != 0) {
            throw new RuntimeException("Unsupported constant offset type: " + offset.getType());
        }
        long value = offset.getReal();
        Object valStr = value >= -64L && value <= 64L ? Long.toString(value) : "0x" + Long.toHexString(value);
        lineList.add(new AttributedString((String)valStr, this.scalarColor, this.metrics));
        this.formatSize(size, lineList);
    }

    private void formatSize(ConstTpl size, List<AttributedString> lineList) {
        if (size.getType() != 0) {
            throw new RuntimeException("Unsupported address size type: " + size.getType());
        }
        if (size.getReal() != 0L) {
            lineList.add(this.COLON);
            lineList.add(new AttributedString(Long.toString(size.getReal()), this.scalarColor, this.metrics));
        }
    }

    private void formatCallOtherName(Language language, VarnodeTpl input0, List<AttributedString> lineList) {
        if (!input0.getSpace().isConstSpace() || input0.getOffset().getType() != 0) {
            throw new RuntimeException("Expected constant input[0] for CALLOTHER pcode op");
        }
        if (!(language instanceof SleighLanguage)) {
            throw new RuntimeException("Expected Sleigh language for CALLOTHER op");
        }
        int id = (int)input0.getOffset().getReal();
        String psuedoOp = ((SleighLanguage)language).getUserDefinedOpName(id);
        if (psuedoOp == null) {
            Msg.error(PcodeFormatter.class, (Object)("Psuedo-op index not found: " + id));
            psuedoOp = "unknown";
        }
        lineList.add(this.QUOTE);
        lineList.add(new AttributedString(psuedoOp, Color.BLUE, this.metrics));
        lineList.add(this.QUOTE);
    }

    private boolean formatLabelInput(VarnodeTpl input0, List<AttributedString> lineList) {
        if (input0.getSpace().isConstSpace() && input0.getOffset().getType() == 7) {
            String label = "<" + input0.getOffset().getReal() + ">";
            lineList.add(new AttributedString(label, Color.BLUE, this.metrics));
            return true;
        }
        return false;
    }

    private void formatMemoryInput(Program program, VarnodeTpl input0, VarnodeTpl input1, List<AttributedString> lineList) {
        String spaceName;
        if (!input0.getSpace().isConstSpace() || input0.getOffset().getType() != 0) {
            throw new RuntimeException("Expected constant input[0] for LOAD/STORE pcode op");
        }
        int id = (int)input0.getOffset().getReal();
        AddressSpace space = program.getAddressFactory().getAddressSpace(id);
        if (space == null) {
            Msg.error(PcodeFormatter.class, (Object)("Address space id not found: " + id));
            spaceName = "unknown";
        } else {
            spaceName = space.getName();
        }
        lineList.add(new AttributedString(spaceName, Color.BLUE, this.metrics));
        lineList.add(this.LEFT_PAREN);
        this.formatVarnodeTpl(program, -1, 1, input1, lineList);
        lineList.add(this.RIGHT_PAREN);
    }

    private boolean hasLabel(OpTpl[] pcodeOpTemplates) {
        for (OpTpl op : pcodeOpTemplates) {
            if (65 != op.getOpcode()) continue;
            return true;
        }
        return false;
    }

    public OpTpl[] getPcodeOpTemplates(AddressFactory addrFactory, PcodeOp[] pcodeOps) {
        ArrayList<OpTpl> list = new ArrayList<OpTpl>();
        HashMap<Integer, Integer> labelMap = new HashMap<Integer, Integer>();
        for (PcodeOp pcodeOp : pcodeOps) {
            int opcode = pcodeOp.getOpcode();
            VarnodeTpl outputTpl = null;
            Varnode v = pcodeOp.getOutput();
            if (v != null) {
                outputTpl = this.getVarnodeTpl(addrFactory, v);
            }
            Varnode[] inputs = pcodeOp.getInputs();
            VarnodeTpl[] inputTpls = new VarnodeTpl[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                Varnode input = inputs[i];
                if (i == 0 && (opcode == 4 || opcode == 5) && input.isConstant()) {
                    int labelIndex;
                    int labelOffset = pcodeOp.getSeqnum().getTime() + (int)input.getOffset();
                    if (labelMap.containsKey(labelOffset)) {
                        labelIndex = (Integer)labelMap.get(labelOffset);
                    } else {
                        labelIndex = labelMap.size();
                        labelMap.put(labelOffset, labelIndex);
                    }
                    ConstTpl offsetTpl = new ConstTpl(7, (long)labelIndex);
                    ConstTpl spaceTpl = new ConstTpl(addrFactory.getConstantSpace());
                    ConstTpl sizeTpl = new ConstTpl(0, 8L);
                    inputTpls[i] = new VarnodeTpl(spaceTpl, offsetTpl, sizeTpl);
                    continue;
                }
                inputTpls[i] = this.getVarnodeTpl(addrFactory, input);
            }
            list.add(new OpTpl(opcode, outputTpl, inputTpls));
        }
        ArrayList offsetList = new ArrayList(labelMap.keySet());
        Collections.sort(offsetList);
        for (int i = offsetList.size() - 1; i >= 0; --i) {
            int labelOffset = (Integer)offsetList.get(i);
            int labelIndex = (Integer)labelMap.get(labelOffset);
            OpTpl labelTpl = this.getLabelOpTemplate(addrFactory, labelIndex);
            list.add(labelOffset, labelTpl);
        }
        OpTpl[] opTemplates = new OpTpl[list.size()];
        list.toArray(opTemplates);
        return opTemplates;
    }

    private OpTpl getLabelOpTemplate(AddressFactory addrFactory, int labelIndex) {
        ConstTpl offsetTpl = new ConstTpl(0, (long)labelIndex);
        ConstTpl spaceTpl = new ConstTpl(addrFactory.getConstantSpace());
        ConstTpl sizeTpl = new ConstTpl(0, 8L);
        VarnodeTpl input = new VarnodeTpl(spaceTpl, offsetTpl, sizeTpl);
        return new OpTpl(65, null, new VarnodeTpl[]{input});
    }

    private VarnodeTpl getVarnodeTpl(AddressFactory addrFactory, Varnode v) {
        ConstTpl offsetTpl = new ConstTpl(0, v.getOffset());
        AddressSpace addressSpace = addrFactory.getAddressSpace(v.getSpace());
        if (addressSpace == null) {
            throw new IllegalArgumentException("Unknown varnode space ID: " + v.getSpace());
        }
        ConstTpl spaceTpl = new ConstTpl(addressSpace);
        ConstTpl sizeTpl = new ConstTpl(0, (long)v.getSize());
        return new VarnodeTpl(spaceTpl, offsetTpl, sizeTpl);
    }
}

