/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem.factory;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.app.util.bin.SynchronizedByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemProbeConflictResolver;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.FileSystemInfoRec;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryFull;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryIgnore;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryWithFile;
import ghidra.formats.gfilesystem.factory.GFileSystemProbe;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeFull;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeWithFile;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FileSystemFactoryMgr {
    private int largestBytesRequired = 0;
    private List<FileSystemInfoRec> sortedFactories = new ArrayList<FileSystemInfoRec>();
    private Map<String, FileSystemInfoRec> fsByType = new HashMap<String, FileSystemInfoRec>();

    public static FileSystemFactoryMgr getInstance() {
        return Singleton.instance;
    }

    private FileSystemFactoryMgr() {
        for (Class fsClass : ClassSearcher.getClasses(GFileSystem.class)) {
            this.addFactory(fsClass);
        }
        Collections.sort(this.sortedFactories, FileSystemInfoRec.BY_PRIORITY);
    }

    private void addFactory(Class<? extends GFileSystem> fsClass) {
        FileSystemInfoRec fsir = FileSystemInfoRec.fromClass(fsClass);
        if (fsir == null) {
            Msg.error((Object)this, (Object)("No valid FileSystemInfo found for " + fsClass.getName()));
            return;
        }
        if (this.fsByType.containsKey(fsir.getType())) {
            FileSystemInfoRec prevFSI = this.fsByType.get(fsir.getType());
            Msg.error((Object)this, (Object)("GFileSystem type '" + fsir.getType() + "' registered more than one time: " + fsClass.getName() + ", " + prevFSI.getFSClass().getName() + ", ommitting second instance."));
            return;
        }
        if (fsir.getFactory() instanceof GFileSystemFactoryIgnore) {
            return;
        }
        if (fsir.getFactory() instanceof GFileSystemProbeBytesOnly) {
            GFileSystemProbeBytesOnly pbo = (GFileSystemProbeBytesOnly)((Object)fsir.getFactory());
            if (pbo.getBytesRequired() > 65536) {
                Msg.error((Object)this, (Object)("GFileSystemProbeBytesOnly for " + fsClass.getName() + " specifies too large value for bytes_required: " + pbo.getBytesRequired() + ", skipping this probe."));
            } else {
                this.largestBytesRequired = Math.max(this.largestBytesRequired, pbo.getBytesRequired());
            }
        }
        this.fsByType.put(fsir.getType(), fsir);
        this.sortedFactories.add(fsir);
    }

    public List<String> getAllFilesystemNames() {
        return this.fsByType.keySet().stream().map(fsType -> this.fsByType.get(fsType).getDescription()).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
    }

    public String getFileSystemType(Class<? extends GFileSystem> fsClass) {
        FileSystemInfo fsi = fsClass.getAnnotation(FileSystemInfo.class);
        return fsi != null && this.fsByType.get(fsi.type()) != null ? fsi.type() : null;
    }

    public GFileSystem mountFileSystem(String fsType, FSRL containerFSRL, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        FileSystemInfoRec fsir = this.fsByType.get(fsType);
        if (fsir == null) {
            throw new IOException("Unknown file system type " + fsType);
        }
        GFileSystem result = this.mountUsingFactory(fsir, containerFSRL, containerFile, null, containerFSRL.makeNested(fsType), fsService, monitor);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GFileSystem mountUsingFactory(FileSystemInfoRec fsir, FSRL containerFSRL, File containerFile, ByteProvider byteProvider, FSRLRoot targetFSRL, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        GFileSystem result = null;
        boolean bpTaken = false;
        try {
            if (fsir.getFactory() instanceof GFileSystemFactoryFull) {
                byteProvider = byteProvider == null ? this.makeBP(containerFile, containerFSRL) : byteProvider;
                bpTaken = true;
                result = (GFileSystem)((GFileSystemFactoryFull)fsir.getFactory()).create(containerFSRL, targetFSRL, byteProvider, containerFile, fsService, monitor);
            } else if (fsir.getFactory() instanceof GFileSystemFactoryWithFile) {
                result = (GFileSystem)((GFileSystemFactoryWithFile)fsir.getFactory()).create(containerFSRL, targetFSRL, containerFile, fsService, monitor);
            }
        }
        finally {
            if (byteProvider != null && !bpTaken) {
                byteProvider.close();
            }
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(FSRL containerFSRL, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        int pboByteCount = Math.min((int)Math.min(containerFile.length(), 65536L), this.largestBytesRequired);
        try (RandomAccessByteProvider bp = new RandomAccessByteProvider(containerFile, containerFSRL);){
            byte[] startBytes = bp.readBytes(0L, pboByteCount);
            for (FileSystemInfoRec fsir : this.sortedFactories) {
                block12: {
                    GFileSystemProbe factoryProbe;
                    block11: {
                        block10: {
                            if (!(fsir.getFactory() instanceof GFileSystemProbeBytesOnly) || (factoryProbe = (GFileSystemProbeBytesOnly)((Object)fsir.getFactory())).getBytesRequired() > startBytes.length || !factoryProbe.probeStartBytes(containerFSRL, startBytes)) break block10;
                            boolean bl = true;
                            {
                                catch (IOException e) {
                                    Msg.trace((Object)this, (Object)("File system probe error for " + fsir.getDescription() + " with " + containerFSRL), (Throwable)e);
                                    continue;
                                }
                            }
                            bp.close();
                            return bl;
                        }
                        if (!(fsir.getFactory() instanceof GFileSystemProbeWithFile) || !(factoryProbe = (GFileSystemProbeWithFile)((Object)fsir.getFactory())).probe(containerFSRL, containerFile, fsService, monitor)) break block11;
                        boolean bl = true;
                        bp.close();
                        return bl;
                    }
                    if (!(fsir.getFactory() instanceof GFileSystemProbeFull) || !(factoryProbe = (GFileSystemProbeFull)((Object)fsir.getFactory())).probe(containerFSRL, bp, containerFile, fsService, monitor)) break block12;
                    boolean bl = true;
                    bp.close();
                    return bl;
                }
            }
        }
        return false;
    }

    public GFileSystem probe(FSRL containerFSRL, File containerFile, FileSystemService fsService, FileSystemProbeConflictResolver conflictResolver, TaskMonitor monitor) throws IOException, CancelledException {
        return this.probe(containerFSRL, containerFile, fsService, conflictResolver, Integer.MIN_VALUE, monitor);
    }

    private ByteProvider makeBP(File containerFile, FSRL containerFSRL) throws IOException {
        return new SynchronizedByteProvider(new RandomAccessByteProvider(containerFile, containerFSRL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GFileSystem probe(FSRL containerFSRL, File containerFile, FileSystemService fsService, FileSystemProbeConflictResolver conflictResolver, int priorityFilter, TaskMonitor monitor) throws IOException, CancelledException {
        conflictResolver = conflictResolver == null ? FileSystemProbeConflictResolver.CHOOSEFIRST : conflictResolver;
        try (ByteProvider probeBP = this.makeBP(containerFile, containerFSRL);){
            int pboByteCount = Math.min((int)Math.min(containerFile.length(), 65536L), this.largestBytesRequired);
            byte[] startBytes = probeBP.readBytes(0L, pboByteCount);
            ArrayList<FileSystemInfoRec> probeMatches = new ArrayList<FileSystemInfoRec>();
            for (FileSystemInfoRec fsir2 : this.sortedFactories) {
                try {
                    GFileSystemProbe factoryProbe;
                    if (fsir2.getPriority() < priorityFilter) break;
                    if (fsir2.getFactory() instanceof GFileSystemProbeBytesOnly && (factoryProbe = (GFileSystemProbeBytesOnly)((Object)fsir2.getFactory())).getBytesRequired() <= startBytes.length && factoryProbe.probeStartBytes(containerFSRL, startBytes)) {
                        probeMatches.add(fsir2);
                        continue;
                    }
                    if (fsir2.getFactory() instanceof GFileSystemProbeWithFile && (factoryProbe = (GFileSystemProbeWithFile)((Object)fsir2.getFactory())).probe(containerFSRL, containerFile, fsService, monitor)) {
                        probeMatches.add(fsir2);
                        continue;
                    }
                    if (!(fsir2.getFactory() instanceof GFileSystemProbeFull) || !(factoryProbe = (GFileSystemProbeFull)((Object)fsir2.getFactory())).probe(containerFSRL, probeBP, containerFile, fsService, monitor)) continue;
                    probeMatches.add(fsir2);
                }
                catch (IOException e) {
                    Msg.trace((Object)this, (Object)("File system probe error for " + fsir2.getDescription() + " with " + containerFSRL), (Throwable)e);
                }
            }
            monitor.setMessage("Choosing filesystem");
            FileSystemInfoRec fsir = conflictResolver.resolveFSIR(probeMatches);
            if (fsir == null) {
                FileSystemInfoRec fsir2;
                fsir2 = null;
                return fsir2;
            }
            ByteProvider mountBP = probeBP;
            probeBP = null;
            GFileSystem fs = this.mountUsingFactory(fsir, containerFSRL, containerFile, mountBP, containerFSRL.makeNested(fsir.getType()), fsService, monitor);
            monitor.setMessage("Found file system " + fs.getDescription());
            GFileSystem gFileSystem = fs;
            return gFileSystem;
        }
    }

    private static class Singleton {
        private static final FileSystemFactoryMgr instance = new FileSystemFactoryMgr();

        private Singleton() {
        }
    }
}

