/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderMap;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.plugin.importer.ImporterDialog;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskLauncher;
import java.util.List;

public class AddToProgramDialog
extends ImporterDialog {
    private Program addToProgram;

    protected AddToProgramDialog(PluginTool tool, FSRL fsrl, LoaderMap loaderMap, ByteProvider byteProvider, Program addToProgram) {
        super("Add To Program:  " + fsrl.getPath(), tool, loaderMap, byteProvider, null);
        this.addToProgram = addToProgram;
        this.folderNameTextField.setText(this.getFolderName(addToProgram));
        this.filenameTextField.setText(addToProgram.getName());
        this.setSelectedLanguage(this.getLanguageSpec());
        this.languageTextField.setEnabled(false);
        this.folderNameTextField.setEnabled(false);
        this.folderButton.setEnabled(false);
        this.languageButton.setEnabled(false);
        this.filenameTextField.setEnabled(false);
        this.validateFormInput();
    }

    @Override
    protected boolean validateFormInput() {
        this.setOkEnabled(false);
        this.optionsButton.setEnabled(false);
        Loader loader = this.getSelectedLoader();
        if (loader == null) {
            this.setStatusText("Please select a format.");
            return false;
        }
        if (!loader.supportsLoadIntoProgram()) {
            this.setStatusText(loader.getName() + " does not support add to program.");
            return false;
        }
        this.optionsButton.setEnabled(true);
        LoadSpec loadSpec = this.getSelectedLoadSpec(loader);
        String result = loader.validateOptions(this.byteProvider, loadSpec, this.getOptions(loadSpec), this.addToProgram);
        if (result != null) {
            this.setStatusText(result);
            return false;
        }
        this.setStatusText("");
        this.setOkEnabled(true);
        return true;
    }

    @Override
    protected boolean isSupported(Loader loader) {
        return loader.supportsLoadIntoProgram();
    }

    @Override
    protected void selectedLoaderChanged() {
        this.options = null;
        this.validateFormInput();
    }

    @Override
    protected void okCallback() {
        Loader selectedLoader = this.getSelectedLoader();
        LoadSpec selectedLoadSpec = this.getSelectedLoadSpec(selectedLoader);
        if (this.options == null) {
            this.options = selectedLoader.getDefaultOptions(this.byteProvider, selectedLoadSpec, null, true);
        }
        TaskLauncher.launchNonModal((String)"Import File", monitor -> ImporterUtilities.addContentToProgram(this.tool, this.addToProgram, this.fsrl, selectedLoadSpec, this.options, monitor));
        this.close();
    }

    @Override
    protected List<Option> getOptions(LoadSpec loadSpec) {
        if (this.options != null) {
            return this.options;
        }
        return loadSpec.getLoader().getDefaultOptions(this.byteProvider, loadSpec, (DomainObject)this.addToProgram, true);
    }

    LanguageCompilerSpecPair getLanguageSpec() {
        LanguageID languageId = this.addToProgram.getLanguageID();
        CompilerSpecID compilerSpecId = this.addToProgram.getCompilerSpec().getCompilerSpecID();
        return new LanguageCompilerSpecPair(languageId, compilerSpecId);
    }

    private String getFolderName(Program program) {
        DomainFile domainFile = program.getDomainFile();
        DomainFolder parent = domainFile.getParent();
        if (parent == null) {
            return "";
        }
        return parent.toString();
    }
}

