/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.analyzer;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.dex.analyzer.DexAnalysisState;
import ghidra.file.formats.android.dex.format.AccessFlags;
import ghidra.file.formats.android.dex.format.AnnotationItem;
import ghidra.file.formats.android.dex.format.AnnotationOffsetItem;
import ghidra.file.formats.android.dex.format.AnnotationSetItem;
import ghidra.file.formats.android.dex.format.AnnotationSetReferenceItem;
import ghidra.file.formats.android.dex.format.AnnotationSetReferenceList;
import ghidra.file.formats.android.dex.format.AnnotationsDirectoryItem;
import ghidra.file.formats.android.dex.format.ClassDataItem;
import ghidra.file.formats.android.dex.format.ClassDefItem;
import ghidra.file.formats.android.dex.format.CodeItem;
import ghidra.file.formats.android.dex.format.DebugInfoItem;
import ghidra.file.formats.android.dex.format.DexConstants;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.EncodedArrayItem;
import ghidra.file.formats.android.dex.format.EncodedCatchHandler;
import ghidra.file.formats.android.dex.format.EncodedCatchHandlerList;
import ghidra.file.formats.android.dex.format.EncodedField;
import ghidra.file.formats.android.dex.format.EncodedMethod;
import ghidra.file.formats.android.dex.format.FieldAnnotation;
import ghidra.file.formats.android.dex.format.FieldIDItem;
import ghidra.file.formats.android.dex.format.MapItem;
import ghidra.file.formats.android.dex.format.MapItemTypeCodes;
import ghidra.file.formats.android.dex.format.MapList;
import ghidra.file.formats.android.dex.format.MethodAnnotation;
import ghidra.file.formats.android.dex.format.MethodIDItem;
import ghidra.file.formats.android.dex.format.ParameterAnnotation;
import ghidra.file.formats.android.dex.format.PrototypesIDItem;
import ghidra.file.formats.android.dex.format.StringDataItem;
import ghidra.file.formats.android.dex.format.StringIDItem;
import ghidra.file.formats.android.dex.format.TryItem;
import ghidra.file.formats.android.dex.format.TypeIDItem;
import ghidra.file.formats.android.dex.format.TypeItem;
import ghidra.file.formats.android.dex.format.TypeList;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.lang.BasicCompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DexHeaderFormatAnalyzer
extends FileFormatAnalyzer {
    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        Address startAddress = this.toAddr(program, 0L);
        if (this.getDataAt(program, startAddress) != null) {
            log.appendMsg("data already exists.");
            return true;
        }
        Memory memory = program.getMemory();
        MemoryBlock block = memory.getBlock(startAddress);
        block.setRead(true);
        block.setWrite(false);
        block.setExecute(false);
        DexAnalysisState analysisState = DexAnalysisState.getState(program);
        DexHeader header = analysisState.getHeader();
        this.processHeader(program, header);
        this.createInitialFragments(program, header, monitor);
        BasicCompilerSpec.enableJavaLanguageDecompilation((Program)program);
        this.createNamespaces(program, header, monitor, log);
        this.processMap(program, header, monitor, log);
        this.processStrings(program, header, monitor, log);
        this.processTypes(program, header, monitor, log);
        this.processPrototypes(program, header, monitor, log);
        this.processFields(program, header, monitor, log);
        this.processMethods(program, header, monitor, log);
        this.processClassDefs(program, header, monitor, log);
        this.createProgramDataTypes(program, header, monitor, log);
        this.createMethods(program, header, monitor, log);
        monitor.setMessage("DEX: cleaning up tree");
        this.removeEmptyFragments(program);
        return true;
    }

    public boolean canAnalyze(Program program) {
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), program.getMinAddress());
        return DexConstants.isDexFile((ByteProvider)provider);
    }

    @Override
    public AnalyzerType getAnalysisType() {
        return AnalyzerType.BYTE_ANALYZER;
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Android DEX Header Format";
    }

    public String getName() {
        return "Android DEX Header Format";
    }

    @Override
    public AnalysisPriority getPriority() {
        return new AnalysisPriority(0);
    }

    public boolean isPrototype() {
        return false;
    }

    private void createNamespaces(Program program, DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: creating namespaces");
        monitor.setMaximum((long)header.getClassDefsIdsSize());
        monitor.setProgress(0L);
        for (ClassDefItem item : header.getClassDefs()) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            String className = DexUtil.convertTypeIndexToString(header, item.getClassIndex());
            Namespace classNameSpace = DexUtil.createNameSpaceFromMangledClassName(program, className);
            if (classNameSpace != null) continue;
            log.appendMsg("Failed to create namespace: " + className);
        }
    }

    private void createMethods(Program program, DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: creating methods");
        monitor.setMaximum((long)header.getClassDefsIdsSize());
        monitor.setProgress(0L);
        for (ClassDefItem item : header.getClassDefs()) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            ClassDataItem classDataItem = item.getClassDataItem();
            if (classDataItem == null) continue;
            this.createMethods(program, header, item, classDataItem.getDirectMethods(), monitor, log);
            this.createMethods(program, header, item, classDataItem.getVirtualMethods(), monitor, log);
        }
    }

    private void createMethods(Program program, DexHeader header, ClassDefItem item, List<EncodedMethod> methods, TaskMonitor monitor, MessageLog log) throws Exception {
        String className = DexUtil.convertTypeIndexToString(header, item.getClassIndex());
        Namespace classNameSpace = DexUtil.createNameSpaceFromMangledClassName(program, className);
        if (classNameSpace == null) {
            log.appendMsg("No namespace: Skipping methods for " + className);
            return;
        }
        for (int i = 0; i < methods.size(); ++i) {
            CodeItem codeItem;
            monitor.checkCanceled();
            EncodedMethod encodedMethod = methods.get(i);
            MethodIDItem methodID = header.getMethods().get(encodedMethod.getMethodIndex());
            String methodName = DexUtil.convertToString(header, methodID.getNameIndex());
            if ((0x10000 & encodedMethod.getAccessFlags()) != 0) {
                methodName = classNameSpace.getName();
            }
            if ((codeItem = encodedMethod.getCodeItem()) == null) continue;
            Address methodAddress = this.toAddr(program, 0x50000000L + (long)encodedMethod.getCodeOffset());
            this.createMethodSymbol(program, methodAddress, methodName, classNameSpace, log);
            this.createMethodComment(program, methodAddress, header, item, methodID, encodedMethod, codeItem, monitor);
            this.disassembleMethod(program, header, className, encodedMethod.isStatic(), methodAddress, methodID, codeItem, monitor, log);
        }
    }

    private Symbol createMethodSymbol(Program program, Address methodAddress, String methodName, Namespace classNameSpace, MessageLog log) {
        program.getSymbolTable().addExternalEntryPoint(methodAddress);
        try {
            return program.getSymbolTable().createLabel(methodAddress, methodName, classNameSpace, SourceType.ANALYSIS);
        }
        catch (InvalidInputException e) {
            log.appendException((Throwable)e);
            return null;
        }
    }

    private void createMethodComment(Program program, Address methodAddress, DexHeader header, ClassDefItem item, MethodIDItem methodID, EncodedMethod encodedMethod, CodeItem codeItem, TaskMonitor monitor) throws CancelledException {
        String methodSignature = DexUtil.convertPrototypeIndexToString(header, methodID.getProtoIndex());
        StringBuilder commentBuilder = new StringBuilder();
        commentBuilder.append(item.toString(header, -1, monitor) + "\n");
        commentBuilder.append("Method Signature: " + methodSignature + "\n");
        commentBuilder.append("Method Access Flags:\n");
        commentBuilder.append(AccessFlags.toString(encodedMethod.getAccessFlags()) + "\n");
        if (codeItem != null) {
            commentBuilder.append("Method Register Size: " + codeItem.getRegistersSize() + "\n");
            commentBuilder.append("Method Incoming Size: " + codeItem.getIncomingSize() + "\n");
            commentBuilder.append("Method Outgoing Size: " + codeItem.getOutgoingSize() + "\n");
            commentBuilder.append("Method Debug Info Offset: 0x" + Integer.toHexString(codeItem.getDebugInfoOffset()) + "\n");
        }
        commentBuilder.append("Method ID Offset: 0x" + Long.toHexString(methodID.getFileOffset()) + "\n");
        this.setPlateComment(program, methodAddress, commentBuilder.toString());
    }

    private void disassembleMethod(Program program, DexHeader header, String className, boolean isStatic, Address methodAddress, MethodIDItem methodID, CodeItem codeItem, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Language language = program.getLanguage();
        DisassembleCommand dCommand = new DisassembleCommand(methodAddress, null, true);
        dCommand.applyTo((DomainObject)program);
        Function method = this.createFunction(program, methodAddress);
        if (method == null) {
            log.appendMsg("Failed to create method at " + methodAddress);
            return;
        }
        int registerIndex = codeItem.getRegistersSize() - codeItem.getIncomingSize();
        for (int i = 0; i < registerIndex; ++i) {
            DataType localDataType = null;
            Register localRegister = language.getRegister("v" + i);
            try {
                LocalVariableImpl local = new LocalVariableImpl("local_" + i, 0, localDataType, localRegister, program);
                method.addLocalVariable((Variable)local, SourceType.ANALYSIS);
                continue;
            }
            catch (Exception e) {
                log.appendException((Throwable)e);
            }
        }
        ReturnParameterImpl returnVar = null;
        ArrayList<ParameterImpl> paramList = new ArrayList<ParameterImpl>();
        int prototypeIndex = methodID.getProtoIndex() & 0xFFFF;
        PrototypesIDItem prototype = header.getPrototypes().get(prototypeIndex);
        try {
            TypeList parameters;
            String returnTypeString = DexUtil.convertTypeIndexToString(header, prototype.getReturnTypeIndex());
            DataType returnDataType = DexUtil.toDataType((DataTypeManager)program.getDataTypeManager(), returnTypeString);
            returnVar = new ReturnParameterImpl(returnDataType, program);
            if (!isStatic) {
                String classString = DexUtil.convertTypeIndexToString(header, methodID.getClassIndex());
                DataType thisDataType = DexUtil.toDataType((DataTypeManager)program.getDataTypeManager(), classString);
                String parameterName = "this";
                ParameterImpl param = new ParameterImpl(parameterName, thisDataType, program);
                paramList.add(param);
            }
            if ((parameters = prototype.getParameters()) != null) {
                for (TypeItem parameterTypeItem : parameters.getItems()) {
                    monitor.checkCanceled();
                    String parameterTypeString = DexUtil.convertTypeIndexToString(header, parameterTypeItem.getType());
                    DataType parameterDataType = DexUtil.toDataType((DataTypeManager)program.getDataTypeManager(), parameterTypeString);
                    Object parameterName = this.getParameterName(header, codeItem, paramList.size() - (isStatic ? 0 : 1));
                    if (parameterName == null) {
                        parameterName = "p" + paramList.size();
                    }
                    ParameterImpl param = new ParameterImpl((String)parameterName, parameterDataType, program);
                    paramList.add(param);
                }
            }
            method.updateFunction("__stdcall", (Variable)returnVar, paramList, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.ANALYSIS);
        }
        catch (InvalidInputException ex) {
            log.appendException((Throwable)ex);
        }
        catch (DuplicateNameException ex) {
            log.appendException((Throwable)ex);
        }
    }

    private String getParameterName(DexHeader header, CodeItem codeItem, int parameterOrdinal) {
        try {
            DebugInfoItem debugInfo = codeItem.getDebugInfo();
            int[] debugParameterNames = debugInfo.getParameterNames();
            List<StringIDItem> strings = header.getStrings();
            StringIDItem stringIDItem = strings.get(debugParameterNames[parameterOrdinal]);
            StringDataItem stringDataItem = stringIDItem.getStringDataItem();
            return stringDataItem.getString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void processHeader(Program program, DexHeader header) throws Exception {
        Address headerAddress = this.toAddr(program, 0L);
        DataType headerDataType = header.toDataType();
        this.createData(program, headerAddress, headerDataType);
        this.createFragment(program, "header", headerAddress, headerAddress.add((long)headerDataType.getLength()));
    }

    private void processClassDefs(Program program, DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: processing class definitions");
        monitor.setMaximum((long)header.getClassDefsIdsSize());
        monitor.setProgress(0L);
        Address address = this.toAddr(program, header.getClassDefsIdsOffset());
        int index = 0;
        for (ClassDefItem item : header.getClassDefs()) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            DataType dataType = item.toDataType();
            this.createData(program, address, dataType);
            this.createFragment(program, "classes", address, address.add((long)dataType.getLength()));
            this.createClassDefSymbol(program, header, item, address);
            this.processClassInterfaces(program, header, item, monitor);
            this.processClassAnnotations(program, item, monitor, log);
            this.processClassDataItem(program, header, item, monitor);
            this.processClassStaticValues(program, header, item, monitor);
            this.setPlateComment(program, address, item.toString(header, index, monitor));
            address = address.add((long)dataType.getLength());
            ++index;
        }
    }

    private void createProgramDataTypes(Program program, DexHeader header, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("DEX: creating program datatypes");
        monitor.setMaximum((long)header.getTypeIdsSize());
        monitor.setProgress(0L);
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        int curGroup = -1;
        CategoryPath handlePath = null;
        List<TypeIDItem> types = header.getTypes();
        for (int typeID = 0; typeID < header.getTypeIdsSize(); ++typeID) {
            TypeIDItem item = types.get(typeID);
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            String name = DexUtil.convertToString(header, item.getDescriptorIndex());
            String[] path = DexUtil.convertClassStringToPathArray("classes/", name);
            if (path == null) continue;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < path.length - 1; ++i) {
                builder.append('/');
                builder.append(path[i]);
            }
            CategoryPath catPath = new CategoryPath(builder.toString());
            TypedefDataType dataType = new TypedefDataType(catPath, path[path.length - 1], (DataType)DWordDataType.dataType);
            dataType = dtm.resolve((DataType)dataType, DataTypeConflictHandler.DEFAULT_HANDLER);
            if (typeID / 100 != curGroup) {
                curGroup = typeID / 100;
                builder = new StringBuilder();
                builder.append("/handles/");
                builder.append("group").append(curGroup);
                handlePath = new CategoryPath(builder.toString());
            }
            TypedefDataType handleType = new TypedefDataType(handlePath, "type" + typeID, (DataType)dataType);
            dtm.resolve((DataType)handleType, DataTypeConflictHandler.DEFAULT_HANDLER);
        }
    }

    private void createClassDefSymbol(Program program, DexHeader header, ClassDefItem item, Address address) {
        String className = DexUtil.convertTypeIndexToString(header, item.getClassIndex());
        SymbolTable symbolTable = program.getSymbolTable();
        try {
            Namespace nameSpace = DexUtil.createNameSpaceFromMangledClassName(program, className);
            if (nameSpace != null) {
                symbolTable.createLabel(address, "__classdef__", nameSpace, SourceType.ANALYSIS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processClassStaticValues(Program program, DexHeader header, ClassDefItem item, TaskMonitor monitor) throws DuplicateNameException, IOException, Exception {
        if (item.getStaticValuesOffset() > 0) {
            EncodedArrayItem staticValues = item.getStaticValues();
            Address staticAddress = this.toAddr(program, item.getStaticValuesOffset());
            DataType staticDataType = staticValues.toDataType();
            this.createData(program, staticAddress, staticDataType);
            this.createFragment(program, "class_static_values", staticAddress, staticAddress.add((long)staticDataType.getLength()));
            StringBuilder builder = new StringBuilder();
            builder.append("Class: " + DexUtil.convertTypeIndexToString(header, item.getClassIndex()) + "\n\n");
            builder.append("Static Values:\n");
            for (byte b : staticValues.getArray().getValues()) {
                builder.append(Integer.toHexString(b & 0xFF) + " ");
            }
            this.setPlateComment(program, staticAddress, builder.toString());
        }
    }

    private void processClassDataItem(Program program, DexHeader header, ClassDefItem item, TaskMonitor monitor) throws DuplicateNameException, IOException, Exception {
        if (item.getClassDataOffset() > 0) {
            ClassDataItem classDataItem = item.getClassDataItem();
            Address classDataAddress = this.toAddr(program, item.getClassDataOffset());
            DataType classDataDataType = classDataItem.toDataType();
            this.createData(program, classDataAddress, classDataDataType);
            this.createFragment(program, "class_data", classDataAddress, classDataAddress.add((long)classDataDataType.getLength()));
            StringBuilder builder = new StringBuilder();
            builder.append("Class: " + DexUtil.convertTypeIndexToString(header, item.getClassIndex()) + "\n\n");
            builder.append("Static Fields:   " + classDataItem.getStaticFieldsSize() + "\n");
            builder.append("Instance Fields: " + classDataItem.getInstanceFieldsSize() + "\n");
            builder.append("Direct Methods:  " + classDataItem.getDirectMethodsSize() + "\n");
            builder.append("Virtual Methods: " + classDataItem.getVirtualMethodsSize() + "\n");
            this.processEncodedFields(program, header, classDataItem.getStaticFields(), monitor);
            this.processEncodedFields(program, header, classDataItem.getInstancesFields(), monitor);
            this.processEncodedMethods(program, header, item, classDataItem.getDirectMethods(), monitor);
            this.processEncodedMethods(program, header, item, classDataItem.getVirtualMethods(), monitor);
            this.setPlateComment(program, classDataAddress, builder.toString());
        }
    }

    private void processEncodedFields(Program program, DexHeader header, List<EncodedField> instanceFields, TaskMonitor monitor) throws Exception {
        int index = 0;
        for (int i = 0; i < instanceFields.size(); ++i) {
            monitor.checkCanceled();
            EncodedField field = instanceFields.get(i);
            int diff = field.getFieldIndexDifference();
            index = i == 0 ? diff : (index += diff);
            FieldIDItem fieldID = header.getFields().get(index);
            StringBuilder builder = new StringBuilder();
            builder.append(DexUtil.convertToString(header, fieldID.getNameIndex()) + "\n");
            builder.append(AccessFlags.toString(field.getAccessFlags()) + "\n");
            builder.append("\n");
            Address address = this.toAddr(program, field.getFileOffset());
            DataType dataType = field.toDataType();
            this.createData(program, address, dataType);
            this.setPlateComment(program, address, builder.toString());
            this.createFragment(program, "encoded_fields", address, address.add((long)dataType.getLength()));
        }
    }

    private void processEncodedMethods(Program program, DexHeader header, ClassDefItem item, List<EncodedMethod> methods, TaskMonitor monitor) throws Exception {
        for (int i = 0; i < methods.size(); ++i) {
            monitor.checkCanceled();
            EncodedMethod method = methods.get(i);
            MethodIDItem methodID = header.getMethods().get(method.getMethodIndex());
            StringBuilder builder = new StringBuilder();
            builder.append("Method Name: " + DexUtil.convertToString(header, methodID.getNameIndex()) + "\n");
            builder.append("Method Offset: 0x" + Long.toHexString(methodID.getFileOffset()) + "\n");
            builder.append("Method Flags:\n");
            builder.append(AccessFlags.toString(method.getAccessFlags()) + "\n");
            builder.append("Code Offset: 0x" + Integer.toHexString(method.getCodeOffset()) + "\n");
            builder.append("\n");
            Address address = this.toAddr(program, method.getFileOffset());
            DataType dataType = method.toDataType();
            this.createData(program, address, dataType);
            this.setPlateComment(program, address, builder.toString());
            this.createFragment(program, "encoded_methods", address, address.add((long)dataType.getLength()));
            this.processCodeItem(program, header, item, method, methodID);
        }
    }

    private void processCodeItem(Program program, DexHeader header, ClassDefItem item, EncodedMethod method, MethodIDItem methodID) throws DuplicateNameException, IOException, Exception {
        if (method.getCodeOffset() > 0) {
            Address codeAddress = this.toAddr(program, method.getCodeOffset());
            StringBuilder builder = new StringBuilder();
            builder.append(DexUtil.convertTypeIndexToString(header, item.getClassIndex()) + " " + DexUtil.convertToString(header, methodID.getNameIndex()) + "\n");
            this.setPlateComment(program, codeAddress, builder.toString());
            CodeItem codeItem = method.getCodeItem();
            DataType codeItemDataType = codeItem.toDataType();
            try {
                this.createData(program, codeAddress, codeItemDataType);
                int codeItemDataTypeLength = codeItemDataType.getLength();
                this.createFragment(program, "code_item", codeAddress, codeAddress.add((long)codeItemDataTypeLength));
                Address tempAddress = codeAddress.add((long)codeItemDataTypeLength);
                tempAddress = this.processCodeItemTrys(program, tempAddress, codeItem);
                this.processCodeItemHandlers(program, codeItem, tempAddress);
            }
            catch (Exception codeItemDataTypeLength) {
                // empty catch block
            }
            if (codeItem.getDebugInfoOffset() > 0) {
                Address debugAddress = this.toAddr(program, codeItem.getDebugInfoOffset());
                DebugInfoItem debug = codeItem.getDebugInfo();
                DataType debugDataType = debug.toDataType();
                this.createData(program, debugAddress, debugDataType);
                this.createFragment(program, "debug_info", debugAddress, debugAddress.add((long)debugDataType.getLength()));
            }
        }
    }

    private void processCodeItemHandlers(Program program, CodeItem codeItem, Address tempAddress) throws DuplicateNameException, IOException, Exception {
        EncodedCatchHandlerList handlerList = codeItem.getHandlerList();
        if (handlerList == null) {
            return;
        }
        DataType handlerDataType = handlerList.toDataType();
        this.createData(program, tempAddress, handlerDataType);
        this.createFragment(program, "handlers", tempAddress, tempAddress.add((long)handlerDataType.getLength()));
        tempAddress = tempAddress.add((long)handlerDataType.getLength());
        for (EncodedCatchHandler handler : handlerList.getHandlers()) {
            DataType dataType = handler.toDataType();
            this.createData(program, tempAddress, dataType);
            this.createFragment(program, "handlers", tempAddress, tempAddress.add((long)dataType.getLength()));
            tempAddress = tempAddress.add((long)dataType.getLength());
        }
    }

    private Address processCodeItemTrys(Program program, Address codeAddress, CodeItem codeItem) throws DuplicateNameException, IOException, Exception {
        Address tempAddress = codeAddress;
        for (TryItem tryItem : codeItem.getTries()) {
            DataType dataType = tryItem.toDataType();
            this.createData(program, tempAddress, dataType);
            this.createFragment(program, "try", tempAddress, tempAddress.add((long)dataType.getLength()));
            tempAddress = tempAddress.add((long)dataType.getLength());
        }
        return tempAddress;
    }

    private void processClassAnnotations(Program program, ClassDefItem item, TaskMonitor monitor, MessageLog log) throws DuplicateNameException, IOException, Exception, CancelledException {
        if (item.getAnnotationsOffset() > 0) {
            DataType setItemDataType;
            AnnotationSetItem setItem;
            AnnotationsDirectoryItem annotationsDirectoryItem = item.getAnnotationsDirectoryItem();
            Address annotationsAddress = this.toAddr(program, item.getAnnotationsOffset());
            DataType annotationsDataType = annotationsDirectoryItem.toDataType();
            this.createData(program, annotationsAddress, annotationsDataType);
            this.createFragment(program, "annotations", annotationsAddress, annotationsAddress.add((long)annotationsDataType.getLength()));
            if (annotationsDirectoryItem.getClassAnnotationsOffset() > 0) {
                Address classAddress = this.toAddr(program, annotationsDirectoryItem.getClassAnnotationsOffset());
                AnnotationSetItem setItem2 = annotationsDirectoryItem.getClassAnnotations();
                DataType setItemDataType2 = setItem2.toDataType();
                this.createData(program, classAddress, setItemDataType2);
                this.createFragment(program, "class_annotations", classAddress, classAddress.add((long)setItemDataType2.getLength()));
                this.processAnnotationSetItem(program, setItem2, monitor, log);
            }
            for (FieldAnnotation field : annotationsDirectoryItem.getFieldAnnotations()) {
                monitor.checkCanceled();
                Address fieldAddress = this.toAddr(program, field.getAnnotationsOffset());
                setItem = field.getAnnotationSetItem();
                setItemDataType = setItem.toDataType();
                this.createData(program, fieldAddress, setItemDataType);
                this.createFragment(program, "annotation_fields", fieldAddress, fieldAddress.add((long)setItemDataType.getLength()));
                this.processAnnotationSetItem(program, setItem, monitor, log);
            }
            for (MethodAnnotation method : annotationsDirectoryItem.getMethodAnnotations()) {
                monitor.checkCanceled();
                Address methodAddress = this.toAddr(program, method.getAnnotationsOffset());
                setItem = method.getAnnotationSetItem();
                setItemDataType = setItem.toDataType();
                this.createData(program, methodAddress, setItemDataType);
                this.createFragment(program, "annotation_methods", methodAddress, methodAddress.add((long)setItemDataType.getLength()));
                this.processAnnotationSetItem(program, setItem, monitor, log);
            }
            for (ParameterAnnotation parameter : annotationsDirectoryItem.getParameterAnnotations()) {
                monitor.checkCanceled();
                Address parameterAddress = this.toAddr(program, parameter.getAnnotationsOffset());
                AnnotationSetReferenceList annotationSetReferenceList = parameter.getAnnotationSetReferenceList();
                DataType listDataType = annotationSetReferenceList.toDataType();
                this.createData(program, parameterAddress, listDataType);
                this.createFragment(program, "annotation_parameters", parameterAddress, parameterAddress.add((long)listDataType.getLength()));
                for (AnnotationSetReferenceItem refItem : annotationSetReferenceList.getItems()) {
                    AnnotationItem annotationItem = refItem.getItem();
                    if (annotationItem == null) continue;
                    int annotationsItemOffset = refItem.getAnnotationsOffset();
                    Address annotationItemAddress = this.toAddr(program, annotationsItemOffset);
                    DataType annotationItemDataType = annotationItem.toDataType();
                    this.createData(program, annotationItemAddress, annotationItemDataType);
                    this.createFragment(program, "annotation_item", annotationItemAddress, annotationItemAddress.add((long)annotationItemDataType.getLength()));
                }
            }
        }
    }

    private void processClassInterfaces(Program program, DexHeader header, ClassDefItem item, TaskMonitor monitor) throws Exception {
        if (item.getInterfacesOffset() > 0) {
            TypeList interfaces = item.getInterfaces();
            Address interfaceAddress = this.toAddr(program, item.getInterfacesOffset());
            DataType interfaceDataType = interfaces.toDataType();
            this.createData(program, interfaceAddress, interfaceDataType);
            this.createFragment(program, "interfaces", interfaceAddress, interfaceAddress.add((long)interfaceDataType.getLength()));
            StringBuilder builder = new StringBuilder();
            builder.append("Class: " + DexUtil.convertTypeIndexToString(header, item.getClassIndex()) + "\n\n");
            builder.append("Implements:\n");
            for (TypeItem interfaceItem : interfaces.getItems()) {
                monitor.checkCanceled();
                builder.append("\t" + DexUtil.convertTypeIndexToString(header, interfaceItem.getType()) + "\n");
            }
            this.setPlateComment(program, interfaceAddress, builder.toString());
        }
    }

    private void processAnnotationSetItem(Program program, AnnotationSetItem setItem, TaskMonitor monitor, MessageLog log) {
        try {
            for (AnnotationOffsetItem offsetItem : setItem.getItems()) {
                monitor.checkCanceled();
                Address aAddress = this.toAddr(program, offsetItem.getAnnotationsOffset());
                AnnotationItem aItem = offsetItem.getItem();
                DataType aDataType = aItem.toDataType();
                this.createData(program, aAddress, aDataType);
                this.createFragment(program, "annotation_items", aAddress, aAddress.add((long)aDataType.getLength()));
            }
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
        }
    }

    private void processMethods(Program program, DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: processing methods");
        monitor.setMaximum((long)header.getMethodIdsSize());
        monitor.setProgress(0L);
        Address address = this.toAddr(program, header.getMethodIdsOffset());
        int methodIndex = 0;
        for (MethodIDItem item : header.getMethods()) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            DataType dataType = item.toDataType();
            this.createData(program, address, dataType);
            this.createFragment(program, "methods", address, address.add((long)dataType.getLength()));
            StringBuilder builder = new StringBuilder();
            builder.append("Method Index: 0x" + Integer.toHexString(methodIndex) + "\n");
            builder.append("Class: " + DexUtil.convertTypeIndexToString(header, item.getClassIndex()) + "\n");
            builder.append("Prototype: " + DexUtil.convertPrototypeIndexToString(header, item.getProtoIndex()) + "\n");
            builder.append("Name: " + DexUtil.convertToString(header, item.getNameIndex()) + "\n");
            this.setPlateComment(program, address, builder.toString());
            Address methodIndexAddress = DexUtil.toLookupAddress(program, methodIndex);
            if (program.getMemory().getInt(methodIndexAddress) == -1) {
                Address externalAddress;
                Symbol methodSymbol;
                String methodName = DexUtil.convertToString(header, item.getNameIndex());
                String className = DexUtil.convertTypeIndexToString(header, item.getClassIndex());
                Namespace classNameSpace = DexUtil.createNameSpaceFromMangledClassName(program, className);
                if (classNameSpace != null && (methodSymbol = this.createMethodSymbol(program, externalAddress = DexUtil.toLookupAddress(program, methodIndex), methodName, classNameSpace, log)) != null) {
                    String externalName = methodSymbol.getName(true);
                    program.getReferenceManager().addExternalReference(methodIndexAddress, "EXTERNAL.dex", externalName, null, SourceType.ANALYSIS, 0, RefType.DATA);
                }
            }
            this.createData(program, methodIndexAddress, (DataType)new PointerDataType());
            ++methodIndex;
            address = address.add((long)dataType.getLength());
        }
    }

    private void processFields(Program program, DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: processing fields");
        monitor.setMaximum((long)header.getFieldIdsSize());
        monitor.setProgress(0L);
        Address address = this.toAddr(program, header.getFieldIdsOffset());
        int index = 0;
        for (FieldIDItem item : header.getFields()) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            DataType dataType = item.toDataType();
            this.createData(program, address, dataType);
            this.createFragment(program, "fields", address, address.add((long)dataType.getLength()));
            StringBuilder builder = new StringBuilder();
            builder.append("Field Index: 0x" + Integer.toHexString(index) + "\n");
            builder.append("Class: " + DexUtil.convertTypeIndexToString(header, item.getClassIndex()) + "\n");
            builder.append("Type: " + DexUtil.convertTypeIndexToString(header, item.getTypeIndex()) + "\n");
            builder.append("Name: " + DexUtil.convertToString(header, item.getNameIndex()) + "\n");
            this.setPlateComment(program, address, builder.toString());
            ++index;
            address = address.add((long)dataType.getLength());
        }
    }

    private void processPrototypes(Program program, DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: processing prototypes");
        monitor.setMaximum((long)header.getProtoIdsSize());
        monitor.setProgress(0L);
        Address address = this.toAddr(program, header.getProtoIdsOffset());
        int index = 0;
        for (PrototypesIDItem item : header.getPrototypes()) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            DataType dataType = item.toDataType();
            this.createData(program, address, dataType);
            this.createFragment(program, "prototypes", address, address.add((long)dataType.getLength()));
            StringBuilder builder = new StringBuilder();
            builder.append("Prototype Index: 0x" + Integer.toHexString(index) + "\n");
            builder.append("Shorty: " + DexUtil.convertToString(header, item.getShortyIndex()) + "\n");
            builder.append("Return Type: " + DexUtil.convertTypeIndexToString(header, item.getReturnTypeIndex()) + "\n");
            if (item.getParametersOffset() > 0) {
                builder.append("Parameters: \n");
                TypeList parameters = item.getParameters();
                for (TypeItem parameter : parameters.getItems()) {
                    monitor.checkCanceled();
                    builder.append(DexUtil.convertTypeIndexToString(header, parameter.getType()) + " ");
                }
                DataType parametersDT = parameters.toDataType();
                Address parametersAddress = this.toAddr(program, item.getParametersOffset());
                this.createData(program, parametersAddress, parametersDT);
            }
            this.setPlateComment(program, address, builder.toString());
            ++index;
            address = address.add((long)dataType.getLength());
        }
    }

    private void processTypes(Program program, DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: processing types");
        monitor.setMaximum((long)header.getTypeIdsSize());
        monitor.setProgress(0L);
        Address address = this.toAddr(program, header.getTypeIdsOffset());
        int index = 0;
        for (TypeIDItem item : header.getTypes()) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            DataType dataType = item.toDataType();
            this.createData(program, address, dataType);
            this.createFragment(program, "types", address, address.add((long)dataType.getLength()));
            StringBuilder builder = new StringBuilder();
            builder.append("Type Index: 0x" + Integer.toHexString(index) + "\n");
            builder.append("\t->" + DexUtil.convertToString(header, item.getDescriptorIndex()));
            this.setPlateComment(program, address, builder.toString());
            ++index;
            address = address.add((long)dataType.getLength());
        }
    }

    private void processMap(Program program, DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        MapList mapList = header.getMapList();
        if (mapList == null) {
            return;
        }
        monitor.setMessage("DEX: processing map");
        monitor.setMaximum((long)mapList.getSize());
        monitor.setProgress(0L);
        Address mapListAddress = this.toAddr(program, header.getMapOffset());
        DataType mapListDataType = mapList.toDataType();
        this.createData(program, mapListAddress, mapListDataType);
        this.createFragment(program, "map", mapListAddress, mapListAddress.add((long)mapListDataType.getLength()));
        StringBuilder builder = new StringBuilder();
        for (MapItem item : header.getMapList().getItems()) {
            monitor.checkCanceled();
            builder.append(MapItemTypeCodes.toString(item.getType()) + "\n");
        }
        this.setPlateComment(program, mapListAddress, builder.toString());
    }

    private void createInitialFragments(Program program, DexHeader header, TaskMonitor monitor) throws Exception {
        monitor.setMessage("DEX: creating fragments");
        if (header.getDataSize() > 0) {
            Address start = this.toAddr(program, header.getDataOffset());
            Address end = start.add((long)header.getDataSize());
            this.createFragment(program, "data", start, end);
        }
    }

    private void processStrings(Program program, DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: processing strings");
        monitor.setMaximum((long)header.getStringIdsSize());
        monitor.setProgress(0L);
        Address address = this.toAddr(program, header.getStringIdsOffset());
        int index = 0;
        for (StringIDItem item : header.getStrings()) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            Address stringDataAddress = this.toAddr(program, item.getStringDataOffset());
            StringDataItem stringDataItem = item.getStringDataItem();
            String string = stringDataItem.getString();
            try {
                DataType stringDataType = stringDataItem.toDataType();
                this.createData(program, stringDataAddress, stringDataType);
                this.setPlateComment(program, stringDataAddress, Integer.toHexString(index) + "\n\n" + string);
                this.createFragment(program, "string_data", stringDataAddress, stringDataAddress.add((long)stringDataType.getLength()));
                this.createStringSymbol(program, stringDataAddress, string, "strings");
            }
            catch (DuplicateNameException e) {
                log.appendException((Throwable)e);
            }
            catch (InvalidInputException e) {
                log.appendException((Throwable)e);
            }
            DataType dataType = item.toDataType();
            try {
                this.createData(program, address, dataType);
                this.createFragment(program, "strings", address, address.add((long)dataType.getLength()));
                this.setPlateComment(program, address, "String Index: 0x" + Integer.toHexString(index) + "\n\n" + string);
                this.createStringSymbol(program, address, string, "string_data");
            }
            catch (DuplicateNameException e) {
                log.appendException((Throwable)e);
            }
            catch (InvalidInputException e) {
                log.appendException((Throwable)e);
            }
            ++index;
            address = address.add((long)dataType.getLength());
        }
    }

    private void createStringSymbol(Program program, Address address, String string, String namespace) {
        SymbolTable symbolTable = program.getSymbolTable();
        if (string.length() > 0) {
            Namespace nameSpace = DexUtil.getOrCreateNameSpace(program, namespace);
            String symbolName = SymbolUtilities.replaceInvalidChars((String)string, (boolean)true);
            if (symbolName.length() > 2000) {
                symbolName = symbolName.substring(0, 1980);
            }
            try {
                symbolTable.createLabel(address, symbolName, nameSpace, SourceType.ANALYSIS);
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
    }
}

