/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImageInfo;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.file.formats.ios.dyldcache.FixupMacho32bitArmOffsets;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FileSystemInfo(type="dyldcachev1", description="iOS DYLD Cache Version 1", factory=GFileSystemBaseFactory.class)
public class DyldCacheFileSystem
extends GFileSystemBase {
    private DyldCacheHeader header;
    private Map<GFile, DyldCacheImageInfo> map = new HashMap<GFile, DyldCacheImageInfo>();

    public DyldCacheFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public void close() throws IOException {
        this.map.clear();
        super.close();
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException {
        DyldCacheImageInfo data = this.map.get(file);
        if (data == null) {
            return null;
        }
        long machHeaderStartIndexInProvider = data.getAddress() - this.header.getBaseAddress();
        try {
            FixupMacho32bitArmOffsets fixer = new FixupMacho32bitArmOffsets();
            return fixer.fix(file, machHeaderStartIndexInProvider, this.provider, monitor);
        }
        catch (MachException e) {
            throw new IOException("Invalid Mach-O header detected at 0x" + Long.toHexString(machHeaderStartIndexInProvider));
        }
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || directory.equals(this.root)) {
            ArrayList<GFile> roots = new ArrayList<GFile>();
            for (GFile file : this.map.keySet()) {
                if (file.getParentFile() != this.root && !file.getParentFile().equals(this.root)) continue;
                roots.add(file);
            }
            return roots;
        }
        ArrayList<GFile> tmp = new ArrayList<GFile>();
        for (GFile file : this.map.keySet()) {
            if (file.getParentFile() == null || !file.getParentFile().equals(directory)) continue;
            tmp.add(file);
        }
        return tmp;
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        return DyldCacheUtils.isDyldCache((ByteProvider)this.provider);
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        monitor.setMessage("Opening DYLD cache...");
        BinaryReader reader = new BinaryReader(this.provider, true);
        this.header = new DyldCacheHeader(reader);
        this.header.parseFromFile(false, new MessageLog(), monitor);
        List dataList = this.header.getImageInfos();
        monitor.initialize((long)dataList.size());
        for (DyldCacheImageInfo data : dataList) {
            if (monitor.isCancelled()) break;
            monitor.incrementProgress(1L);
            GFileImpl file = GFileImpl.fromPathString((GFileSystem)this, (GFile)this.root, (String)data.getPath(), null, (boolean)false, (long)0L);
            this.storeFile((GFile)file, data);
            file.setLength(this.provider.length() - (data.getAddress() - this.header.getBaseAddress()));
        }
    }

    private void storeFile(GFile file, DyldCacheImageInfo data) {
        if (file == null) {
            return;
        }
        if (file.equals(this.root)) {
            return;
        }
        if (!this.map.containsKey(file) || this.map.get(file) == null) {
            this.map.put(file, data);
        }
        GFile parentFile = file.getParentFile();
        this.storeFile(parentFile, null);
    }
}

