/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.iso9660;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.iso9660.ISO9660Constants;
import ghidra.file.formats.iso9660.ISO9660Directory;
import ghidra.file.formats.iso9660.ISO9660Header;
import ghidra.file.formats.iso9660.ISO9660VolumeDescriptor;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FileSystemInfo(type="iso9660", description="ISO 9660", factory=GFileSystemBaseFactory.class)
public class ISO9660FileSystem
extends GFileSystemBase {
    private static final long SIGNATURE_ADDRESS_0x8001 = 32769L;
    private static final long SIGNATURE_ADDRESS_0x8801 = 34817L;
    private static final long SIGNATURE_ADDRESS_0x9001 = 36865L;
    private boolean foundAt0x8001 = false;
    private boolean foundAt0x8801 = false;
    private boolean foundAt0x9001 = false;
    private boolean lookedAtRoot = false;
    private short logicalBlockSize;
    private ISO9660Header header;
    private Map<GFile, ISO9660Directory> fileToDirectoryMap = new HashMap<GFile, ISO9660Directory>();

    public ISO9660FileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        int magicLen = ISO9660Constants.MAGIC_BYTES.length;
        byte[] signatureArray = new byte[magicLen];
        signatureArray = this.provider.readBytes(32769L, (long)magicLen);
        if (Arrays.equals(signatureArray, ISO9660Constants.MAGIC_BYTES)) {
            this.foundAt0x8001 = true;
            return true;
        }
        signatureArray = this.provider.readBytes(34817L, (long)magicLen);
        if (Arrays.equals(signatureArray, ISO9660Constants.MAGIC_BYTES)) {
            this.foundAt0x8801 = true;
            return true;
        }
        signatureArray = this.provider.readBytes(36865L, (long)magicLen);
        if (Arrays.equals(signatureArray, ISO9660Constants.MAGIC_BYTES)) {
            this.foundAt0x9001 = true;
            return true;
        }
        return false;
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        BinaryReader reader = new BinaryReader(this.provider, true);
        if (this.foundAt0x8001) {
            reader.setPointerIndex(32768);
        } else if (this.foundAt0x8801) {
            reader.setPointerIndex(34816);
        } else if (this.foundAt0x9001) {
            reader.setPointerIndex(36864);
        } else {
            throw new IOException("Cannot find index of ISO9660 Header");
        }
        this.header = new ISO9660Header(reader);
        ISO9660VolumeDescriptor pvd = this.header.getPrimaryVolumeDescriptor();
        this.logicalBlockSize = pvd.getLogicalBlockSizeBE();
        ISO9660Directory rootDir = this.header.getPrimaryDirectory();
        ArrayList<ISO9660Directory> topLevel = this.createDirectoryList(reader, rootDir, pvd.getLogicalBlockSizeLE(), monitor);
        try {
            this.createDirectories(reader, topLevel, pvd.getLogicalBlockSizeLE(), monitor);
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), null, (String)"Directory Creation Error", (Object)"Failed to create archive directories");
        }
    }

    public void close() throws IOException {
        super.close();
        this.header = null;
        this.fileToDirectoryMap.clear();
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || directory.equals(this.root)) {
            ArrayList<GFile> roots = new ArrayList<GFile>();
            for (GFile file : this.fileToDirectoryMap.keySet()) {
                if (file.getParentFile() != this.root && !file.getParentFile().equals(this.root)) continue;
                roots.add(file);
            }
            return roots;
        }
        ArrayList<GFile> tmp = new ArrayList<GFile>();
        for (GFile file : this.fileToDirectoryMap.keySet()) {
            if (file.getParentFile() == null || !file.getParentFile().equals(directory)) continue;
            tmp.add(file);
        }
        return tmp;
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        ISO9660Directory dir = this.fileToDirectoryMap.get(file);
        if (dir != null) {
            return dir.toString();
        }
        return null;
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException, CryptoException {
        ISO9660Directory dir = this.fileToDirectoryMap.get(file);
        InputStream inputStream = dir.getDataBytes(this.provider, this.logicalBlockSize);
        return inputStream;
    }

    private ArrayList<ISO9660Directory> createDirectoryList(BinaryReader reader, ISO9660Directory parentDir, long blockSize, TaskMonitor monitor) throws IOException {
        long dirIndex;
        ArrayList<ISO9660Directory> directoryList = new ArrayList<ISO9660Directory>();
        ISO9660Directory childDir = null;
        long endIndex = dirIndex + (long)parentDir.getDataLengthLE();
        for (dirIndex = (long)parentDir.getLocationOfExtentLE() * blockSize; dirIndex < endIndex; dirIndex += (long)childDir.getDirectoryRecordLength()) {
            reader.setPointerIndex(dirIndex);
            if (reader.peekNextByte() != 0) {
                if (!this.lookedAtRoot) {
                    childDir = new ISO9660Directory(reader);
                    this.addAndStoreDirectory(monitor, directoryList, childDir);
                    continue;
                }
                if (parentDir.getName() == null) continue;
                childDir = new ISO9660Directory(reader, parentDir);
                this.addAndStoreDirectory(monitor, directoryList, childDir);
                continue;
            }
            this.readWhileZero(reader, endIndex);
            if (reader.getPointerIndex() >= endIndex) continue;
            if (!this.lookedAtRoot) {
                childDir = new ISO9660Directory(reader);
                this.addAndStoreDirectory(monitor, directoryList, childDir);
                dirIndex = childDir.getVolumeIndex();
                continue;
            }
            if (parentDir.getName() == null) continue;
            childDir = new ISO9660Directory(reader, parentDir);
            this.addAndStoreDirectory(monitor, directoryList, childDir);
            dirIndex = childDir.getVolumeIndex();
        }
        this.lookedAtRoot = true;
        return directoryList;
    }

    private void readWhileZero(BinaryReader reader, long endIndex) throws IOException {
        while (reader.peekNextByte() == 0 && reader.getPointerIndex() < endIndex) {
            reader.readNextByte();
        }
    }

    private void addAndStoreDirectory(TaskMonitor monitor, ArrayList<ISO9660Directory> directoryList, ISO9660Directory childDir) {
        directoryList.add(childDir);
        if (childDir.getName() != null) {
            this.storeDirectory(childDir, monitor);
        }
    }

    private void createDirectories(BinaryReader reader, List<ISO9660Directory> directoryList, long blockSize, TaskMonitor monitor) throws DuplicateNameException, Exception {
        for (ISO9660Directory dir : directoryList) {
            if (!dir.isDirectoryFlagSet() || dir.getName() == null) continue;
            ArrayList<ISO9660Directory> dirs = this.createDirectoryList(reader, dir, blockSize, monitor);
            this.createDirectories(reader, dirs, blockSize, monitor);
        }
    }

    private void storeDirectory(ISO9660Directory directory, TaskMonitor monitor) {
        String dirName = directory.getName();
        boolean isDirectory = directory.isDirectoryFlagSet();
        int length = directory.getDataLengthLE();
        GFileImpl gFile = null;
        if (!this.lookedAtRoot) {
            gFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)dirName, (boolean)isDirectory, (long)length, null);
            this.storeFile((GFile)gFile, directory);
        } else {
            String parentDirName = directory.getParentDirectory().getName();
            for (GFile currGFile : this.fileToDirectoryMap.keySet()) {
                if (!parentDirName.equals(currGFile.getName())) continue;
                gFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)currGFile, (String)dirName, (boolean)isDirectory, (long)length, null);
                this.storeFile((GFile)gFile, directory);
                break;
            }
        }
    }

    private void storeFile(GFile file, ISO9660Directory directory) {
        if (file == null) {
            return;
        }
        if (file.equals(this.root)) {
            return;
        }
        if (!this.fileToDirectoryMap.containsKey(file) || this.fileToDirectoryMap.get(file) == null) {
            this.fileToDirectoryMap.put(file, directory);
        }
        GFile parentFile = file.getParentFile();
        this.storeFile(parentFile, null);
    }
}

